/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import java.util.Stack;
import org.rajawali3d.curves.ICurve3D;
import org.rajawali3d.math.vector.Vector3;

public class CompoundCurve3D
implements ICurve3D {
    protected static final double DELTA = 1.0E-6;
    protected Stack<ICurve3D> mCurves = new Stack();
    protected int mNumCurves;
    protected ICurve3D mCurrentCurve;

    public void addCurve(ICurve3D curve) {
        this.mCurves.add(curve);
        ++this.mNumCurves;
    }

    @Override
    public void calculatePoint(Vector3 point, double t) {
        int currentIndex = (int)Math.floor((t == 1.0 ? t - 1.0E-6 : t) * (double)this.mNumCurves);
        this.mCurrentCurve = (ICurve3D)this.mCurves.get(currentIndex);
        double tdivnum = t * (double)this.mNumCurves - (double)currentIndex;
        this.mCurrentCurve.calculatePoint(point, tdivnum);
    }

    public int getNumCurves() {
        return this.mCurves.size();
    }

    @Override
    public Vector3 getCurrentTangent() {
        if (this.mCurrentCurve == null) {
            return null;
        }
        return this.mCurrentCurve.getCurrentTangent();
    }

    @Override
    public void setCalculateTangents(boolean calculateTangents) {
    }
}

