/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.curves.ICurve3D;
import org.rajawali3d.math.vector.Vector3;

public class CatmullRomCurve3D
implements ICurve3D {
    protected static final int EPSILON = 36;
    protected static final double DELTA = 1.0E-5;
    protected List<Vector3> mPoints;
    protected int mNumPoints;
    protected int mSelectedIndex = -1;
    protected Vector3 mCurrentTangent;
    protected Vector3 mCurrentPoint;
    protected boolean mCalculateTangents;
    protected double[] mSegmentLengths;
    protected boolean mIsClosed;
    private Vector3 mTempNext = new Vector3();
    private Vector3 mTempPrevLen = new Vector3();
    private Vector3 mTempPointLen = new Vector3();

    public CatmullRomCurve3D() {
        this.mPoints = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mCurrentTangent = new Vector3();
        this.mCurrentPoint = new Vector3();
    }

    public void addPoint(Vector3 point) {
        this.mPoints.add(point);
        ++this.mNumPoints;
    }

    public int getNumPoints() {
        return this.mNumPoints;
    }

    public List<Vector3> getPoints() {
        return this.mPoints;
    }

    public Vector3 getPoint(int index) {
        return this.mPoints.get(index);
    }

    @Override
    public void calculatePoint(Vector3 result, double t) {
        if (this.mCalculateTangents) {
            double prevt = t == 0.0 ? t + 1.0E-5 : t - 1.0E-5;
            double nextt = t == 1.0 ? t - 1.0E-5 : t + 1.0E-5;
            this.p(this.mCurrentTangent, prevt);
            this.p(this.mTempNext, nextt);
            this.mCurrentTangent.subtract(this.mTempNext);
            this.mCurrentTangent.multiply(0.5);
            this.mCurrentTangent.normalize();
        }
        this.p(result, t);
    }

    @Override
    public Vector3 getCurrentTangent() {
        return this.mCurrentTangent;
    }

    public int selectPoint(Vector3 point) {
        double minDist = Double.MAX_VALUE;
        this.mSelectedIndex = -1;
        for (int i = 0; i < this.mNumPoints; ++i) {
            Vector3 p = this.mPoints.get(i);
            double distance = this.pow2(p.x - point.x) + this.pow2(p.y - point.y) + this.pow2(p.z - point.z);
            if (!(distance < minDist) || !(distance < 36.0)) continue;
            minDist = distance;
            this.mSelectedIndex = i;
        }
        return this.mSelectedIndex;
    }

    @Override
    public void setCalculateTangents(boolean calculateTangents) {
        this.mCalculateTangents = calculateTangents;
    }

    protected double b(int i, double t) {
        switch (i) {
            case -2: {
                return ((-t + 2.0) * t - 1.0) * t / 2.0;
            }
            case -1: {
                return ((3.0 * t - 5.0) * t * t + 2.0) / 2.0;
            }
            case 0: {
                return ((-3.0 * t + 4.0) * t + 1.0) * t / 2.0;
            }
            case 1: {
                return (t - 1.0) * t * t / 2.0;
            }
        }
        return 0.0;
    }

    private void p(Vector3 result, double t) {
        if (t < 0.0) {
            t = 1.0 + t;
        }
        int end = this.mIsClosed ? 0 : 3;
        int start = this.mIsClosed ? 0 : 2;
        int currentIndex = start + (int)Math.floor((t == 1.0 ? t - 1.0E-5 : t) * (double)(this.mNumPoints - end));
        double tdivnum = t * (double)(this.mNumPoints - end) - (double)(currentIndex - start);
        this.mCurrentPoint.setAll(0.0, 0.0, 0.0);
        if (!this.mIsClosed) {
            currentIndex = Math.max(currentIndex, 2);
            currentIndex = Math.min(currentIndex, this.mPoints.size() - 2);
        }
        for (int j = -2; j <= 1; ++j) {
            int index;
            double b = this.b(j, tdivnum);
            int n = index = this.mIsClosed ? (currentIndex + j + 1) % this.mNumPoints : currentIndex + j;
            if (index < 0) {
                index = this.mNumPoints - index - 2;
            }
            Vector3 p = this.mPoints.get(index);
            this.mCurrentPoint.x += b * p.x;
            this.mCurrentPoint.y += b * p.y;
            this.mCurrentPoint.z += b * p.z;
        }
        result.setAll(this.mCurrentPoint);
    }

    protected double pow2(double value) {
        return value * value;
    }

    public void isClosedCurve(boolean closed) {
        this.mIsClosed = closed;
    }

    public boolean isClosedCurve() {
        return this.mIsClosed;
    }

    public double getLength(int segments) {
        double totalLength = 0.0;
        this.mSegmentLengths = new double[segments + 1];
        this.mSegmentLengths[0] = 0.0;
        this.calculatePoint(this.mTempPrevLen, 0.0);
        for (int i = 1; i <= segments; ++i) {
            double t = (double)i / (double)segments;
            this.calculatePoint(this.mTempPointLen, t);
            double dist = this.mTempPrevLen.distanceTo(this.mTempPointLen);
            totalLength += dist;
            this.mSegmentLengths[i] = dist;
            this.mTempPrevLen.setAll(this.mTempPointLen);
        }
        return totalLength;
    }

    public void reparametrizeForUniformDistribution(int resolution) {
        double curveLength = this.getLength(resolution * 100);
        double segmentDistance = curveLength / (double)resolution;
        double numSegments = this.mSegmentLengths.length;
        List<Vector3> newPoints = Collections.synchronizedList(new CopyOnWriteArrayList());
        newPoints.add(this.mPoints.get(0));
        Vector3 point = new Vector3();
        this.calculatePoint(point, 0.0);
        newPoints.add(point);
        double currentLength = 0.0;
        int i = 1;
        while ((double)i < numSegments) {
            if ((currentLength += this.mSegmentLengths[i]) >= segmentDistance) {
                point = new Vector3();
                this.calculatePoint(point, (double)i / (numSegments - 1.0));
                newPoints.add(point);
                currentLength = 0.0;
            }
            ++i;
        }
        point = new Vector3();
        this.calculatePoint(point, 1.0);
        newPoints.add(point);
        newPoints.add(this.mPoints.get(this.mPoints.size() - 1));
        Vector3 controlPoint = Vector3.subtractAndCreate(this.mPoints.get(1), this.mPoints.get(0));
        double oldDistance = this.mPoints.get(1).distanceTo(this.mPoints.get(2));
        double newDistance = ((Vector3)newPoints.get(1)).distanceTo((Vector3)newPoints.get(2));
        controlPoint.multiply(newDistance / oldDistance);
        newPoints.set(0, Vector3.subtractAndCreate(this.mPoints.get(1), controlPoint));
        controlPoint = Vector3.subtractAndCreate(this.mPoints.get(this.mPoints.size() - 2), this.mPoints.get(this.mPoints.size() - 1));
        oldDistance = this.mPoints.get(this.mPoints.size() - 2).distanceTo(this.mPoints.get(this.mPoints.size() - 3));
        newDistance = ((Vector3)newPoints.get(newPoints.size() - 2)).distanceTo((Vector3)newPoints.get(newPoints.size() - 3));
        controlPoint.multiply(newDistance / oldDistance);
        newPoints.set(newPoints.size() - 1, Vector3.subtractAndCreate(this.mPoints.get(this.mPoints.size() - 2), controlPoint));
        this.mPoints = newPoints;
        this.mNumPoints = this.mPoints.size();
    }
}

