/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import org.rajawali3d.curves.ASpiral3D;
import org.rajawali3d.math.vector.Vector3;

public class ArchimedeanSpiral3D
extends ASpiral3D {
    private final double mInvDensity;

    public ArchimedeanSpiral3D(double scale, double density, Vector3 start, Vector3 normal, boolean spiralIn) {
        super(density, start, normal, spiralIn);
        this.a = scale;
        this.mInvDensity = 1.0 / this.mDensity;
        this.mThetaOffset = this.mSpiralIn ? this.calculateThetaForRadius(this.mStart.length()) : this.mRotation.getXAxis().angle(this.mStart);
    }

    @Override
    public void calculatePoint(Vector3 result, double theta) {
        double angle;
        double d = angle = this.mSpiralIn ? this.mThetaOffset - theta : theta + this.mThetaOffset;
        if (angle == 0.0) {
            angle = 1.0E-9;
        }
        double r = this.a * Math.pow(angle, this.mInvDensity);
        this.mRotation.fromAngleAxis(this.mUp, Math.toDegrees(angle));
        this.mScratch.setAll(this.mRotation.multiply(this.mStart)).normalize();
        result.setAll(this.mScratch.multiply(r));
        if (this.mCalculateTangents) {
            this.mCurrentTangent.crossAndSet(this.mUp, this.mScratch);
        }
    }

    @Override
    public double calculateThetaForRadius(double r) {
        return Math.pow(10.0, this.mDensity * Math.log10(r / this.a));
    }
}

