/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.curves;

import org.rajawali3d.curves.ICurve3D;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;

public abstract class ASpiral3D
implements ICurve3D {
    protected final Vector3 mScratch = new Vector3();
    protected final Quaternion mRotation;
    protected final Vector3 mStart;
    protected final Vector3 mUp;
    protected final double mDensity;
    protected final boolean mSpiralIn;
    protected Vector3 mCurrentTangent;
    protected boolean mCalculateTangents;
    protected double a;
    protected double mThetaOffset;

    public ASpiral3D(double density, Vector3 start, Vector3 normal, boolean spiralIn) {
        this.mSpiralIn = spiralIn;
        this.mDensity = density;
        this.mStart = Vector3.subtractAndCreate(start, Vector3.ZERO);
        this.mUp = normal.clone();
        this.mCalculateTangents = false;
        this.mCurrentTangent = Vector3.crossAndCreate(this.mStart, this.mUp);
        this.mRotation = new Quaternion(this.mUp, 0.0);
    }

    public abstract double calculateThetaForRadius(double var1);

    public void calculatePointDegrees(Vector3 result, double theta) {
        this.calculatePoint(result, Math.toRadians(this.mSpiralIn ? this.mThetaOffset - theta : theta + this.mThetaOffset));
    }

    @Override
    public Vector3 getCurrentTangent() {
        return this.mCurrentTangent;
    }

    @Override
    public void setCalculateTangents(boolean calculateTangents) {
        this.mCalculateTangents = calculateTangents;
    }
}

