/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.cameras;

import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.Plane;
import org.rajawali3d.math.vector.Vector3;

public class Frustum {
    private final Plane[] mPlanes = new Plane[6];
    private Vector3 mPoint1 = new Vector3();
    private Vector3 mPoint2 = new Vector3();

    public Frustum() {
        for (int i = 0; i < 6; ++i) {
            this.mPlanes[i] = new Plane();
        }
    }

    public void update(Matrix4 inverseProjectionView) {
        float[] m = inverseProjectionView.getFloatValues();
        this.mPlanes[0].setComponents(m[3] - m[0], m[7] - m[4], m[11] - m[8], m[15] - m[12]);
        this.mPlanes[1].setComponents(m[3] + m[0], m[7] + m[4], m[11] + m[8], m[15] + m[12]);
        this.mPlanes[2].setComponents(m[3] + m[1], m[7] + m[5], m[11] + m[9], m[15] + m[13]);
        this.mPlanes[3].setComponents(m[3] - m[1], m[7] - m[5], m[11] - m[9], m[15] - m[13]);
        this.mPlanes[4].setComponents(m[3] - m[2], m[7] - m[6], m[11] - m[10], m[15] - m[14]);
        this.mPlanes[5].setComponents(m[3] + m[2], m[7] + m[6], m[11] + m[10], m[15] + m[14]);
        this.mPlanes[0].normalize();
        this.mPlanes[1].normalize();
        this.mPlanes[2].normalize();
        this.mPlanes[3].normalize();
        this.mPlanes[4].normalize();
        this.mPlanes[5].normalize();
    }

    public boolean sphereInFrustum(Vector3 center, double radius) {
        for (int i = 0; i < 6; ++i) {
            double distance = this.mPlanes[i].getDistanceTo(center);
            if (!(distance < -radius)) continue;
            return false;
        }
        return true;
    }

    public boolean boundsInFrustum(BoundingBox bounds) {
        for (int i = 0; i < 6; ++i) {
            Plane p = this.mPlanes[i];
            this.mPoint1.x = p.getNormal().x > 0.0 ? bounds.getMin().x : bounds.getMax().x;
            this.mPoint2.x = p.getNormal().x > 0.0 ? bounds.getMax().x : bounds.getMin().x;
            this.mPoint1.y = p.getNormal().y > 0.0 ? bounds.getMin().y : bounds.getMax().y;
            this.mPoint2.y = p.getNormal().y > 0.0 ? bounds.getMax().y : bounds.getMin().y;
            this.mPoint1.z = p.getNormal().z > 0.0 ? bounds.getMin().z : bounds.getMax().z;
            this.mPoint2.z = p.getNormal().z > 0.0 ? bounds.getMax().z : bounds.getMin().z;
            double distance1 = p.getDistanceTo(this.mPoint1);
            double distance2 = p.getDistanceTo(this.mPoint2);
            if (!(distance1 < 0.0) || !(distance2 < 0.0)) continue;
            return false;
        }
        return true;
    }

    public boolean pointInFrustum(Vector3 point) {
        for (int i = 0; i < 6; ++i) {
            double distance = this.mPlanes[i].getDistanceTo(point);
            if (!(distance < 0.0)) continue;
            return false;
        }
        return true;
    }
}

