/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.cameras;

import org.rajawali3d.ATransformable3D;
import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.bounds.IBoundingVolume;
import org.rajawali3d.cameras.Frustum;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;

public class Camera
extends ATransformable3D {
    protected final Object mFrustumLock = new Object();
    protected final Matrix4 mViewMatrix = new Matrix4();
    protected final Matrix4 mProjMatrix = new Matrix4();
    protected final Matrix4 mScratchMatrix = new Matrix4();
    protected double mNearPlane = 1.0;
    protected double mFarPlane = 120.0;
    protected double mFieldOfView = 45.0;
    protected int mLastWidth;
    protected int mLastHeight;
    protected boolean mCameraDirty = true;
    protected Frustum mFrustum;
    protected BoundingBox mBoundingBox = new BoundingBox();
    protected Vector3[] mFrustumCorners;
    protected Quaternion mLocalOrientation = Quaternion.getIdentity();
    protected boolean mIsInitialized;

    public Camera() {
        this.mIsCamera = true;
        this.mFrustum = new Frustum();
        this.mFrustumCorners = new Vector3[8];
        for (int i = 0; i < 8; ++i) {
            this.mFrustumCorners[i] = new Vector3();
        }
    }

    @Override
    public boolean onRecalculateModelMatrix(Matrix4 parentMatrix) {
        super.onRecalculateModelMatrix(parentMatrix);
        this.mMMatrix.rotate(this.mLocalOrientation);
        return true;
    }

    public void setCameraOrientation(Quaternion quaternion) {
        this.mLocalOrientation.setAll(quaternion);
    }

    public void setCameraYaw(double angle) {
        this.mLocalOrientation.fromEuler(angle, this.mLocalOrientation.getRotationX(), this.mLocalOrientation.getRotationZ());
    }

    public void setCameraPitch(double angle) {
        this.mLocalOrientation.fromEuler(this.mLocalOrientation.getRotationY(), angle, this.mLocalOrientation.getRotationZ());
    }

    public void setCameraRoll(double angle) {
        this.mLocalOrientation.fromEuler(this.mLocalOrientation.getRotationY(), this.mLocalOrientation.getRotationX(), angle);
    }

    public void resetCameraOrientation() {
        this.mLocalOrientation.identity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix4 getViewMatrix() {
        Object object = this.mFrustumLock;
        synchronized (object) {
            this.mTmpOrientation.setAll(this.mOrientation);
            this.mTmpOrientation.inverse();
            double[] matrix = this.mViewMatrix.getDoubleValues();
            double x2 = this.mTmpOrientation.x * this.mTmpOrientation.x;
            double y2 = this.mTmpOrientation.y * this.mTmpOrientation.y;
            double z2 = this.mTmpOrientation.z * this.mTmpOrientation.z;
            double xy = this.mTmpOrientation.x * this.mTmpOrientation.y;
            double xz = this.mTmpOrientation.x * this.mTmpOrientation.z;
            double yz = this.mTmpOrientation.y * this.mTmpOrientation.z;
            double wx = this.mTmpOrientation.w * this.mTmpOrientation.x;
            double wy = this.mTmpOrientation.w * this.mTmpOrientation.y;
            double wz = this.mTmpOrientation.w * this.mTmpOrientation.z;
            matrix[0] = 1.0 - 2.0 * (y2 + z2);
            matrix[1] = 2.0 * (xy - wz);
            matrix[2] = 2.0 * (xz + wy);
            matrix[3] = 0.0;
            matrix[4] = 2.0 * (xy + wz);
            matrix[5] = 1.0 - 2.0 * (x2 + z2);
            matrix[6] = 2.0 * (yz - wx);
            matrix[7] = 0.0;
            matrix[8] = 2.0 * (xz - wy);
            matrix[9] = 2.0 * (yz + wx);
            matrix[10] = 1.0 - 2.0 * (x2 + y2);
            matrix[11] = 0.0;
            matrix[12] = -this.mPosition.x * matrix[0] + -this.mPosition.y * matrix[4] + -this.mPosition.z * matrix[8];
            matrix[13] = -this.mPosition.x * matrix[1] + -this.mPosition.y * matrix[5] + -this.mPosition.z * matrix[9];
            matrix[14] = -this.mPosition.x * matrix[2] + -this.mPosition.y * matrix[6] + -this.mPosition.z * matrix[10];
            matrix[15] = 1.0;
            this.mTmpOrientation.setAll(this.mLocalOrientation).inverse();
            this.mViewMatrix.leftMultiply(this.mTmpOrientation.toRotationMatrix(this.mScratchMatrix));
            return this.mViewMatrix;
        }
    }

    public void getFrustumCorners(Vector3[] points) {
        this.getFrustumCorners(points, false);
    }

    public void getFrustumCorners(Vector3[] points, boolean transformed) {
        this.getFrustumCorners(points, transformed, false);
    }

    public void getFrustumCorners(Vector3[] points, boolean transformed, boolean inverse) {
        if (this.mCameraDirty) {
            double aspect = (double)this.mLastWidth / (double)this.mLastHeight;
            double nearHeight = 2.0 * Math.tan(this.mFieldOfView / 2.0) * this.mNearPlane;
            double nearWidth = nearHeight * aspect;
            double farHeight = 2.0 * Math.tan(this.mFieldOfView / 2.0) * this.mFarPlane;
            double farWidth = farHeight * aspect;
            this.mFrustumCorners[0].setAll(nearWidth / -2.0, nearHeight / 2.0, this.mNearPlane);
            this.mFrustumCorners[1].setAll(nearWidth / 2.0, nearHeight / 2.0, this.mNearPlane);
            this.mFrustumCorners[2].setAll(nearWidth / 2.0, nearHeight / -2.0, this.mNearPlane);
            this.mFrustumCorners[3].setAll(nearWidth / -2.0, nearHeight / -2.0, this.mNearPlane);
            this.mFrustumCorners[4].setAll(farWidth / -2.0, farHeight / 2.0, this.mFarPlane);
            this.mFrustumCorners[5].setAll(farWidth / 2.0, farHeight / 2.0, this.mFarPlane);
            this.mFrustumCorners[6].setAll(farWidth / 2.0, farHeight / -2.0, this.mFarPlane);
            this.mFrustumCorners[7].setAll(farWidth / -2.0, farHeight / -2.0, this.mFarPlane);
            this.mCameraDirty = false;
        }
        if (transformed) {
            this.mMMatrix.identity();
            if (inverse) {
                this.mMMatrix.scale(-1.0);
            }
            this.mMMatrix.translate(this.mPosition).rotate(this.mOrientation);
        }
        for (int i = 0; i < 8; ++i) {
            points[i].setAll(this.mFrustumCorners[i]);
            if (!transformed) continue;
            points[i].multiply(this.mMMatrix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFrustum(Matrix4 invVPMatrix) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            this.mFrustum.update(invVPMatrix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frustum getFrustum() {
        Object object = this.mFrustumLock;
        synchronized (object) {
            return this.mFrustum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectionMatrix(Matrix4 matrix) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            this.mProjMatrix.setAll(matrix);
            this.mIsInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectionMatrix(int width, int height) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            if (this.mLastWidth != width || this.mLastHeight != height) {
                this.mCameraDirty = true;
            }
            this.mLastWidth = width;
            this.mLastHeight = height;
            double ratio = (double)width / (double)height;
            this.mProjMatrix.setToPerspective(this.mNearPlane, this.mFarPlane, this.mFieldOfView, ratio);
            this.mIsInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectionMatrix(double fieldOfView, int width, int height) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            this.mFieldOfView = fieldOfView;
            this.setProjectionMatrix(width, height);
        }
    }

    public void updatePerspective(double left, double right, double bottom, double top) {
        this.updatePerspective(left + right, bottom + top);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePerspective(double fovX, double fovY) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            double ratio = fovX / fovY;
            this.mFieldOfView = fovX;
            this.mProjMatrix.setToPerspective(this.mNearPlane, this.mFarPlane, fovX, ratio);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix4 getProjectionMatrix() {
        Object object = this.mFrustumLock;
        synchronized (object) {
            return this.mProjMatrix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getNearPlane() {
        Object object = this.mFrustumLock;
        synchronized (object) {
            return this.mNearPlane;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNearPlane(double nearPlane) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            this.mNearPlane = nearPlane;
            this.mCameraDirty = true;
            this.setProjectionMatrix(this.mLastWidth, this.mLastHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFarPlane() {
        Object object = this.mFrustumLock;
        synchronized (object) {
            return this.mFarPlane;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFarPlane(double farPlane) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            this.mFarPlane = farPlane;
            this.mCameraDirty = true;
            this.setProjectionMatrix(this.mLastWidth, this.mLastHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFieldOfView() {
        Object object = this.mFrustumLock;
        synchronized (object) {
            return this.mFieldOfView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFieldOfView(double fieldOfView) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            this.mFieldOfView = fieldOfView;
            this.mCameraDirty = true;
            this.setProjectionMatrix(this.mLastWidth, this.mLastHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.mFrustumLock;
        synchronized (object) {
            return this.mIsInitialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBoundingVolume getTransformedBoundingVolume() {
        Object object = this.mFrustumLock;
        synchronized (object) {
            return this.mBoundingBox;
        }
    }

    public Camera clone() {
        Camera cam = new Camera();
        cam.setFarPlane(this.mFarPlane);
        cam.setFieldOfView(this.mFieldOfView);
        cam.setGraphNode(this.mGraphNode, this.mInsideGraph);
        cam.setLookAt(this.mLookAt.clone());
        cam.setNearPlane(this.mNearPlane);
        cam.setOrientation(this.mOrientation.clone());
        cam.setPosition(this.mPosition.clone());
        cam.setProjectionMatrix(this.mLastWidth, this.mLastHeight);
        return cam;
    }
}

