/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.cameras;

import android.app.Activity;
import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import org.rajawali3d.Object3D;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.math.MathUtil;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector2;
import org.rajawali3d.math.vector.Vector3;

public class ArcballCamera
extends Camera {
    private Context mContext;
    private ScaleGestureDetector mScaleDetector;
    private View.OnTouchListener mGestureListener;
    private GestureDetector mDetector;
    private View mView;
    private boolean mIsRotating;
    private boolean mIsScaling;
    private Vector3 mCameraStartPos;
    private Vector3 mPrevSphereCoord;
    private Vector3 mCurrSphereCoord;
    private Vector2 mPrevScreenCoord;
    private Vector2 mCurrScreenCoord;
    private Quaternion mStartOrientation;
    private Quaternion mCurrentOrientation;
    private Object3D mEmpty;
    private Object3D mTarget;
    private Matrix4 mScratchMatrix;
    private Vector3 mScratchVector;
    private double mStartFOV;

    public ArcballCamera(Context context, View view) {
        this(context, view, null);
    }

    public ArcballCamera(Context context, View view, Object3D target) {
        this.mContext = context;
        this.mTarget = target;
        this.mView = view;
        this.initialize();
        this.addListeners();
    }

    private void initialize() {
        this.mStartFOV = this.mFieldOfView;
        this.mLookAtEnabled = true;
        this.setLookAt(0.0, 0.0, 0.0);
        this.mEmpty = new Object3D();
        this.mScratchMatrix = new Matrix4();
        this.mScratchVector = new Vector3();
        this.mCameraStartPos = new Vector3();
        this.mPrevSphereCoord = new Vector3();
        this.mCurrSphereCoord = new Vector3();
        this.mPrevScreenCoord = new Vector2();
        this.mCurrScreenCoord = new Vector2();
        this.mStartOrientation = new Quaternion();
        this.mCurrentOrientation = new Quaternion();
    }

    @Override
    public void setProjectionMatrix(int width, int height) {
        super.setProjectionMatrix(width, height);
    }

    private void mapToSphere(float x, float y, Vector3 out) {
        float lengthSquared = x * x + y * y;
        if (lengthSquared > 1.0f) {
            out.setAll(x, y, 0.0);
            out.normalize();
        } else {
            out.setAll(x, y, Math.sqrt(1.0f - lengthSquared));
        }
    }

    private void mapToScreen(float x, float y, Vector2 out) {
        out.setX((2.0f * x - (float)this.mLastWidth) / (float)this.mLastWidth);
        out.setY(-(2.0f * y - (float)this.mLastHeight) / (float)this.mLastHeight);
    }

    private void startRotation(float x, float y) {
        this.mapToScreen(x, y, this.mPrevScreenCoord);
        this.mCurrScreenCoord.setAll(this.mPrevScreenCoord.getX(), this.mPrevScreenCoord.getY());
        this.mIsRotating = true;
    }

    private void updateRotation(float x, float y) {
        this.mapToScreen(x, y, this.mCurrScreenCoord);
        this.applyRotation();
    }

    private void endRotation() {
        this.mStartOrientation.multiply(this.mCurrentOrientation);
    }

    private void applyRotation() {
        if (this.mIsRotating) {
            this.mapToSphere((float)this.mPrevScreenCoord.getX(), (float)this.mPrevScreenCoord.getY(), this.mPrevSphereCoord);
            this.mapToSphere((float)this.mCurrScreenCoord.getX(), (float)this.mCurrScreenCoord.getY(), this.mCurrSphereCoord);
            Vector3 rotationAxis = this.mPrevSphereCoord.clone();
            rotationAxis.cross(this.mCurrSphereCoord);
            rotationAxis.normalize();
            double rotationAngle = Math.acos(Math.min(1.0, this.mPrevSphereCoord.dot(this.mCurrSphereCoord)));
            this.mCurrentOrientation.fromAngleAxis(rotationAxis, MathUtil.radiansToDegrees(rotationAngle));
            this.mCurrentOrientation.normalize();
            Quaternion q = new Quaternion(this.mStartOrientation);
            q.multiply(this.mCurrentOrientation);
            this.mEmpty.setOrientation(q);
        }
    }

    @Override
    public Matrix4 getViewMatrix() {
        Matrix4 m = super.getViewMatrix();
        if (this.mTarget != null) {
            this.mScratchMatrix.identity();
            this.mScratchMatrix.translate(this.mTarget.getPosition());
            m.multiply(this.mScratchMatrix);
        }
        this.mScratchMatrix.identity();
        this.mScratchMatrix.rotate(this.mEmpty.getOrientation());
        m.multiply(this.mScratchMatrix);
        if (this.mTarget != null) {
            this.mScratchVector.setAll(this.mTarget.getPosition());
            this.mScratchVector.inverse();
            this.mScratchMatrix.identity();
            this.mScratchMatrix.translate(this.mScratchVector);
            m.multiply(this.mScratchMatrix);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFieldOfView(double fieldOfView) {
        Object object = this.mFrustumLock;
        synchronized (object) {
            this.mStartFOV = fieldOfView;
            super.setFieldOfView(fieldOfView);
        }
    }

    private void addListeners() {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ArcballCamera.this.mDetector = new GestureDetector(ArcballCamera.this.mContext, (GestureDetector.OnGestureListener)new GestureListener());
                ArcballCamera.this.mScaleDetector = new ScaleGestureDetector(ArcballCamera.this.mContext, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
                ArcballCamera.this.mGestureListener = new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        ArcballCamera.this.mScaleDetector.onTouchEvent(event);
                        if (!ArcballCamera.this.mIsScaling) {
                            ArcballCamera.this.mDetector.onTouchEvent(event);
                            if (event.getAction() == 1 && ArcballCamera.this.mIsRotating) {
                                ArcballCamera.this.endRotation();
                                ArcballCamera.this.mIsRotating = false;
                            }
                        }
                        return true;
                    }
                };
                ArcballCamera.this.mView.setOnTouchListener(ArcballCamera.this.mGestureListener);
            }
        });
    }

    public void setTarget(Object3D target) {
        this.mTarget = target;
        this.setLookAt(this.mTarget.getPosition());
    }

    public Object3D getTarget() {
        return this.mTarget;
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            double fov = Math.max(30.0, Math.min(100.0, ArcballCamera.this.mStartFOV * (1.0 / (double)detector.getScaleFactor())));
            ArcballCamera.this.setFieldOfView(fov);
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            ArcballCamera.this.mIsScaling = true;
            ArcballCamera.this.mIsRotating = false;
            return super.onScaleBegin(detector);
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            ArcballCamera.this.mIsRotating = false;
            ArcballCamera.this.mIsScaling = false;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onScroll(MotionEvent event1, MotionEvent event2, float distanceX, float distanceY) {
            if (!ArcballCamera.this.mIsRotating) {
                ArcballCamera.this.startRotation(event2.getX(), event2.getY());
                return false;
            }
            ArcballCamera.this.mIsRotating = true;
            ArcballCamera.this.updateRotation(event2.getX(), event2.getY());
            return false;
        }
    }
}

