/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.bounds;

import java.nio.FloatBuffer;
import org.rajawali3d.Geometry3D;
import org.rajawali3d.Object3D;
import org.rajawali3d.bounds.IBoundingVolume;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.primitives.Sphere;

public class BoundingSphere
implements IBoundingVolume {
    protected Geometry3D mGeometry;
    protected double mRadius;
    protected final Vector3 mPosition;
    protected Sphere mVisualSphere;
    protected final Matrix4 mTmpMatrix = new Matrix4();
    protected final Vector3 mTmpPos;
    protected double mDist;
    protected double mMinDist;
    protected double mScale;
    protected final double[] mScaleValues;
    protected int mBoundingColor = -256;

    public BoundingSphere() {
        this.mPosition = new Vector3();
        this.mTmpPos = new Vector3();
        this.mScaleValues = new double[3];
    }

    public BoundingSphere(Geometry3D geometry) {
        this();
        this.mGeometry = geometry;
        this.calculateBounds(this.mGeometry);
    }

    @Override
    public Object3D getVisual() {
        return this.mVisualSphere;
    }

    @Override
    public void setBoundingColor(int color) {
        this.mBoundingColor = color;
    }

    @Override
    public int getBoundingColor() {
        return this.mBoundingColor;
    }

    @Override
    public void drawBoundingVolume(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix, Matrix4 mMatrix) {
        if (this.mVisualSphere == null) {
            this.mVisualSphere = new Sphere(1.0f, 8, 8);
            Material material = new Material();
            this.mVisualSphere.setMaterial(material);
            this.mVisualSphere.setColor(-256);
            this.mVisualSphere.setDrawingMode(2);
            this.mVisualSphere.setDoubleSided(true);
        }
        this.mVisualSphere.setPosition(this.mPosition);
        this.mVisualSphere.setScale(this.mRadius * this.mScale);
        this.mVisualSphere.render(camera, vpMatrix, projMatrix, vMatrix, this.mTmpMatrix, null);
    }

    @Override
    public void transform(Matrix4 matrix) {
        this.mPosition.setAll(0.0, 0.0, 0.0);
        this.mPosition.multiply(matrix);
        matrix.getScaling(this.mTmpPos);
        this.mScale = this.mTmpPos.x > this.mTmpPos.y ? this.mTmpPos.x : this.mTmpPos.y;
        this.mScale = this.mScale > this.mTmpPos.z ? this.mScale : this.mTmpPos.z;
    }

    @Override
    public void calculateBounds(Geometry3D geometry) {
        double radius = 0.0;
        double maxRadius = 0.0;
        Vector3 vertex = new Vector3();
        FloatBuffer vertices = geometry.getVertices();
        vertices.rewind();
        while (vertices.hasRemaining()) {
            vertex.x = vertices.get();
            vertex.y = vertices.get();
            vertex.z = vertices.get();
            radius = vertex.length();
            if (!(radius > maxRadius)) continue;
            maxRadius = radius;
        }
        this.mRadius = maxRadius;
    }

    public double getRadius() {
        return this.mRadius;
    }

    public double getScaledRadius() {
        return this.mRadius * this.mScale;
    }

    public Vector3 getPosition() {
        return this.mPosition;
    }

    public double getScale() {
        return this.mScale;
    }

    public String toString() {
        return "BoundingSphere radius: " + Double.toString(this.getScaledRadius());
    }

    @Override
    public boolean intersectsWith(IBoundingVolume boundingVolume) {
        if (!(boundingVolume instanceof BoundingSphere)) {
            return false;
        }
        BoundingSphere boundingSphere = (BoundingSphere)boundingVolume;
        this.mTmpPos.setAll(this.mPosition);
        this.mTmpPos.subtract(boundingSphere.getPosition());
        this.mDist = this.mTmpPos.x * this.mTmpPos.x + this.mTmpPos.y * this.mTmpPos.y + this.mTmpPos.z * this.mTmpPos.z;
        this.mMinDist = this.mRadius * this.mScale + boundingSphere.getRadius() * boundingSphere.getScale();
        return this.mDist < this.mMinDist * this.mMinDist;
    }
}

