/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.bounds;

import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.rajawali3d.Geometry3D;
import org.rajawali3d.Object3D;
import org.rajawali3d.bounds.IBoundingVolume;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.primitives.Cube;

public class BoundingBox
implements IBoundingVolume {
    protected Geometry3D mGeometry;
    protected final Vector3 mMin;
    protected final Vector3 mTransformedMin;
    protected final Vector3 mMax;
    protected final Vector3 mTransformedMax;
    protected final Vector3 mTmpMin;
    protected final Vector3 mTmpMax;
    protected final Vector3[] mPoints;
    protected final Vector3[] mTmp;
    protected int mI;
    protected Cube mVisualBox;
    protected final Matrix4 mTmpMatrix = new Matrix4();
    protected AtomicInteger mBoundingColor = new AtomicInteger(-256);

    public BoundingBox() {
        this(new Vector3[8]);
    }

    public BoundingBox(Vector3 min, Vector3 max) {
        this();
        this.mMin.setAll(min.x, min.y, min.z);
        this.mMax.setAll(max.x, max.y, max.z);
        this.calculatePoints();
    }

    public BoundingBox(Vector3[] points) {
        this.mTransformedMin = new Vector3();
        this.mTransformedMax = new Vector3();
        this.mTmpMin = new Vector3();
        this.mTmpMax = new Vector3();
        this.mPoints = new Vector3[8];
        this.mTmp = new Vector3[8];
        this.mMin = new Vector3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.mMax = new Vector3(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (int i = 0; i < 8; ++i) {
            if (points[i] != null) {
                Vector3 p = points[i];
                if (p.x < this.mMin.x) {
                    this.mMin.x = p.x;
                }
                if (p.y < this.mMin.y) {
                    this.mMin.y = p.y;
                }
                if (p.z < this.mMin.z) {
                    this.mMin.z = p.z;
                }
                if (p.x > this.mMax.x) {
                    this.mMax.x = p.x;
                }
                if (p.y > this.mMax.y) {
                    this.mMax.y = p.y;
                }
                if (p.z > this.mMax.z) {
                    this.mMax.z = p.z;
                }
            }
            this.mPoints[i] = points[i] == null ? new Vector3() : points[i].clone();
            this.mTmp[i] = new Vector3();
        }
    }

    public BoundingBox(Geometry3D geometry) {
        this();
        this.mGeometry = geometry;
        this.calculateBounds(this.mGeometry);
    }

    public void copyPoints(Vector3[] pts) {
        Vector3 min = this.mMin;
        Vector3 max = this.mMax;
        pts[0].setAll(min.x, min.y, min.z);
        pts[1].setAll(min.x, min.y, max.z);
        pts[2].setAll(max.x, min.y, max.z);
        pts[3].setAll(max.x, min.y, min.z);
        pts[4].setAll(min.x, max.y, min.z);
        pts[5].setAll(min.x, max.y, max.z);
        pts[6].setAll(max.x, max.y, max.z);
        pts[7].setAll(max.x, max.y, min.z);
    }

    @Override
    public void drawBoundingVolume(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix, Matrix4 mMatrix) {
        if (this.mVisualBox == null) {
            this.mVisualBox = new Cube(1.0f);
            Material material = new Material();
            this.mVisualBox.setMaterial(material);
            this.mVisualBox.setColor(this.mBoundingColor.get());
            this.mVisualBox.setDrawingMode(2);
            this.mVisualBox.setDoubleSided(true);
        }
        this.mVisualBox.setScale(Math.abs(this.mTransformedMax.x - this.mTransformedMin.x), Math.abs(this.mTransformedMax.y - this.mTransformedMin.y), Math.abs(this.mTransformedMax.z - this.mTransformedMin.z));
        this.mVisualBox.setPosition(this.mTransformedMin.x + (this.mTransformedMax.x - this.mTransformedMin.x) * 0.5, this.mTransformedMin.y + (this.mTransformedMax.y - this.mTransformedMin.y) * 0.5, this.mTransformedMin.z + (this.mTransformedMax.z - this.mTransformedMin.z) * 0.5);
        this.mVisualBox.render(camera, vpMatrix, projMatrix, vMatrix, this.mTmpMatrix, null);
    }

    @Override
    public Object3D getVisual() {
        return this.mVisualBox;
    }

    @Override
    public void setBoundingColor(int color) {
        this.mBoundingColor.set(color);
        if (this.mVisualBox != null) {
            this.mVisualBox.setColor(color);
        }
    }

    @Override
    public int getBoundingColor() {
        return this.mBoundingColor.get();
    }

    @Override
    public void calculateBounds(Geometry3D geometry) {
        this.mMin.setAll(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.mMax.setAll(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        FloatBuffer vertices = geometry.getVertices();
        if (vertices != null) {
            this.calculateMinMaxVertices(vertices, this.mMin, this.mMax);
            this.calculatePoints();
        }
    }

    private void calculateMinMaxVertices(FloatBuffer vertices, Vector3 mMin, Vector3 mMax) {
        if (vertices == null) {
            return;
        }
        vertices.rewind();
        Vector3 vertex = new Vector3();
        while (vertices.hasRemaining()) {
            vertex.x = vertices.get();
            vertex.y = vertices.get();
            vertex.z = vertices.get();
            if (vertex.x < mMin.x) {
                mMin.x = vertex.x;
            }
            if (vertex.y < mMin.y) {
                mMin.y = vertex.y;
            }
            if (vertex.z < mMin.z) {
                mMin.z = vertex.z;
            }
            if (vertex.x > mMax.x) {
                mMax.x = vertex.x;
            }
            if (vertex.y > mMax.y) {
                mMax.y = vertex.y;
            }
            if (!(vertex.z > mMax.z)) continue;
            mMax.z = vertex.z;
        }
    }

    public void calculatePoints() {
        this.mPoints[0].setAll(this.mMin.x, this.mMin.y, this.mMin.z);
        this.mPoints[1].setAll(this.mMin.x, this.mMin.y, this.mMax.z);
        this.mPoints[2].setAll(this.mMax.x, this.mMin.y, this.mMax.z);
        this.mPoints[3].setAll(this.mMax.x, this.mMin.y, this.mMin.z);
        this.mPoints[4].setAll(this.mMin.x, this.mMax.y, this.mMin.z);
        this.mPoints[5].setAll(this.mMin.x, this.mMax.y, this.mMax.z);
        this.mPoints[6].setAll(this.mMax.x, this.mMax.y, this.mMax.z);
        this.mPoints[7].setAll(this.mMax.x, this.mMax.y, this.mMin.z);
    }

    @Override
    public void transform(Matrix4 matrix) {
        this.mTransformedMin.setAll(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.mTransformedMax.setAll(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        this.mI = 0;
        while (this.mI < 8) {
            Vector3 o = this.mPoints[this.mI];
            Vector3 d = this.mTmp[this.mI];
            d.setAll(o);
            d.multiply(matrix);
            if (d.x < this.mTransformedMin.x) {
                this.mTransformedMin.x = d.x;
            }
            if (d.y < this.mTransformedMin.y) {
                this.mTransformedMin.y = d.y;
            }
            if (d.z < this.mTransformedMin.z) {
                this.mTransformedMin.z = d.z;
            }
            if (d.x > this.mTransformedMax.x) {
                this.mTransformedMax.x = d.x;
            }
            if (d.y > this.mTransformedMax.y) {
                this.mTransformedMax.y = d.y;
            }
            if (d.z > this.mTransformedMax.z) {
                this.mTransformedMax.z = d.z;
            }
            ++this.mI;
        }
    }

    public Vector3 getMin() {
        return this.mMin;
    }

    public void setMin(Vector3 min) {
        this.mMin.setAll(min);
    }

    public Vector3 getMax() {
        return this.mMax;
    }

    public void setMax(Vector3 max) {
        this.mMax.setAll(max);
    }

    public Vector3 getTransformedMin() {
        return this.mTransformedMin;
    }

    public Vector3 getTransformedMax() {
        return this.mTransformedMax;
    }

    @Override
    public boolean intersectsWith(IBoundingVolume boundingVolume) {
        if (!(boundingVolume instanceof BoundingBox)) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)boundingVolume;
        Vector3 otherMin = boundingBox.getTransformedMin();
        Vector3 otherMax = boundingBox.getTransformedMax();
        Vector3 min = this.mTransformedMin;
        Vector3 max = this.mTransformedMax;
        return min.x < otherMax.x && max.x > otherMin.x && min.y < otherMax.y && max.y > otherMin.y && min.z < otherMax.z && max.z > otherMin.z;
    }

    public String toString() {
        return "BoundingBox min: " + this.mTransformedMin + " max: " + this.mTransformedMax;
    }
}

