/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation.mesh;

import android.os.SystemClock;
import org.rajawali3d.Geometry3D;
import org.rajawali3d.animation.mesh.AAnimationObject3D;
import org.rajawali3d.animation.mesh.IAnimationFrame;
import org.rajawali3d.animation.mesh.VertexAnimationFrame;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.IMaterialPlugin;
import org.rajawali3d.materials.plugins.VertexAnimationMaterialPlugin;

public class VertexAnimationObject3D
extends AAnimationObject3D {
    private VertexAnimationMaterialPlugin mMaterialPlugin;

    @Override
    public void setShaderParams(Camera camera) {
        super.setShaderParams(camera);
        long now = SystemClock.uptimeMillis();
        if (this.isPlaying()) {
            this.mInterpolation += (double)((now - this.mStartTime) * (long)this.mFps) / 1000.0;
            this.mCurrentFrameIndex += (int)this.mInterpolation;
            if (this.mCurrentFrameIndex > this.mEndFrameIndex) {
                if (this.mLoop) {
                    this.mCurrentFrameIndex -= this.mStartFrameIndex;
                    this.mCurrentFrameIndex %= this.mEndFrameIndex - this.mStartFrameIndex;
                    this.mCurrentFrameIndex += this.mStartFrameIndex;
                } else {
                    this.mCurrentFrameIndex = this.mEndFrameIndex;
                    this.pause();
                }
            }
            this.mInterpolation -= (double)((int)this.mInterpolation);
        }
        Geometry3D currentGeometry = ((VertexAnimationFrame)this.mFrames.get(this.mCurrentFrameIndex)).getGeometry();
        if (this.mGeometry.getVertexBufferInfo() != currentGeometry.getVertexBufferInfo()) {
            this.mGeometry.setVertexBufferInfo(currentGeometry.getVertexBufferInfo());
            this.mGeometry.setNormalBufferInfo(currentGeometry.getNormalBufferInfo());
        }
        Geometry3D nextGeometry = currentGeometry;
        int nextFrame = this.mCurrentFrameIndex + 1;
        if (nextFrame > this.mEndFrameIndex) {
            nextFrame = this.mLoop ? this.mStartFrameIndex : this.mEndFrameIndex;
        }
        if (nextFrame >= 0 && nextFrame < this.mNumFrames) {
            nextGeometry = ((IAnimationFrame)this.mFrames.get(nextFrame)).getGeometry();
        }
        this.mMaterialPlugin.setInterpolation(this.mInterpolation);
        this.mMaterialPlugin.setNextFrameVertices(nextGeometry.getVertexBufferInfo().bufferHandle);
        this.mMaterialPlugin.setNextFrameNormals(nextGeometry.getNormalBufferInfo().bufferHandle);
        this.mStartTime = now;
    }

    @Override
    public void reload() {
        for (int i = 0; i < this.mNumFrames; ++i) {
            ((IAnimationFrame)this.mFrames.get(i)).getGeometry().reload();
        }
        super.reload();
    }

    @Override
    public void setMaterial(Material material) {
        super.setMaterial(material);
        IMaterialPlugin plugin = material.getPlugin(VertexAnimationMaterialPlugin.class);
        if (plugin == null) {
            this.mMaterialPlugin = new VertexAnimationMaterialPlugin();
            material.addPlugin(this.mMaterialPlugin);
        } else {
            this.mMaterialPlugin = (VertexAnimationMaterialPlugin)plugin;
        }
    }

    @Override
    public VertexAnimationObject3D clone(boolean copyMaterial) {
        VertexAnimationObject3D clone = new VertexAnimationObject3D();
        clone.getGeometry().copyFromGeometry3D(this.mGeometry);
        clone.isContainer(this.mIsContainerOnly);
        clone.setMaterial(this.mMaterial);
        for (int i = 0; i < this.mNumFrames; ++i) {
            clone.addFrame(this.getFrame(i));
        }
        clone.setRotation(this.getOrientation());
        clone.setScale(this.getScale());
        clone.setFps(this.mFps);
        clone.mElementsBufferType = 5125;
        return clone;
    }

    @Override
    public VertexAnimationObject3D clone() {
        return this.clone(true);
    }
}

