/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation.mesh;

import org.rajawali3d.Geometry3D;
import org.rajawali3d.animation.mesh.IAnimationFrame;
import org.rajawali3d.math.vector.Vector3;

public class VertexAnimationFrame
implements IAnimationFrame {
    protected Geometry3D mGeometry = new Geometry3D();
    protected String mName;
    protected float[] mVertices;

    @Override
    public Geometry3D getGeometry() {
        return this.mGeometry;
    }

    @Override
    public void setGeometry(Geometry3D geometry) {
        this.mGeometry = geometry;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    public float[] calculateNormals(int[] indices) {
        int id3;
        int id2;
        int id1;
        float[] vertices = new float[this.mGeometry.getVertices().capacity()];
        this.mGeometry.getVertices().get(vertices).position(0);
        float[] faceNormals = new float[indices.length];
        float[] vertNormals = new float[vertices.length];
        int numIndices = indices.length;
        int numVertices = vertices.length;
        Vector3 v1 = new Vector3();
        Vector3 v2 = new Vector3();
        Vector3 v3 = new Vector3();
        Vector3 normal = new Vector3();
        for (int i = 0; i < numIndices; i += 3) {
            id1 = indices[i];
            id2 = indices[i + 1];
            id3 = indices[i + 2];
            int vid1 = id1 * 3;
            int vid2 = id2 * 3;
            int vid3 = id3 * 3;
            v1.setAll(vertices[vid1], vertices[vid1 + 1], vertices[vid1 + 2]);
            v2.setAll(vertices[vid2], vertices[vid2 + 1], vertices[vid2 + 2]);
            v3.setAll(vertices[vid3], vertices[vid3 + 1], vertices[vid3 + 2]);
            Vector3 vector1 = Vector3.subtractAndCreate(v2, v1);
            Vector3 vector2 = Vector3.subtractAndCreate(v3, v1);
            normal = Vector3.crossAndCreate(vector1, vector2);
            normal.normalize();
            faceNormals[i] = (float)normal.x;
            faceNormals[i + 1] = (float)normal.y;
            faceNormals[i + 2] = (float)normal.z;
        }
        Vector3 vertexNormal = new Vector3();
        for (int i = 0; i < numVertices; i += 3) {
            int vIndex = i / 3;
            vertexNormal.setAll(0.0, 0.0, 0.0);
            for (int j = 0; j < numIndices; j += 3) {
                id1 = indices[j];
                id2 = indices[j + 1];
                id3 = indices[j + 2];
                if (id1 != vIndex && id2 != vIndex && id3 != vIndex) continue;
                vertexNormal.add(faceNormals[j], faceNormals[j + 1], faceNormals[j + 2]);
            }
            vertexNormal.normalize();
            vertNormals[i] = (float)vertexNormal.x;
            vertNormals[i + 1] = (float)vertexNormal.y;
            vertNormals[i + 2] = (float)vertexNormal.z;
        }
        faceNormals = null;
        v1 = null;
        v2 = null;
        v3 = null;
        return vertNormals;
    }
}

