/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation.mesh;

import java.util.ArrayList;
import org.rajawali3d.animation.mesh.IAnimationSequence;
import org.rajawali3d.animation.mesh.SkeletalAnimationFrame;
import org.rajawali3d.animation.mesh.SkeletalAnimationObject3D;

public class SkeletalAnimationSequence
implements IAnimationSequence {
    private SkeletalAnimationFrame[] mFrames;
    private double[] mFrameData;
    private String mName;
    private int mNumFrames;
    private int mFrameRate;

    public SkeletalAnimationSequence(String name) {
        this.mName = name;
    }

    public void setFrames(SkeletalAnimationFrame[] frames) {
        this.mFrames = frames;
        this.mNumFrames = frames.length;
    }

    public SkeletalAnimationFrame[] getFrames() {
        return this.mFrames;
    }

    public SkeletalAnimationFrame getFrame(int index) {
        return this.mFrames[index];
    }

    public void setFrameData(double[] frameData) {
        this.mFrameData = frameData;
    }

    public double[] getFrameData() {
        return this.mFrameData;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setNumFrames(int numFrames) {
        this.mNumFrames = numFrames;
    }

    public int getNumFrames() {
        return this.mNumFrames;
    }

    public void setFrameRate(int frameRate) {
        this.mFrameRate = frameRate;
    }

    public int getFrameRate() {
        return this.mFrameRate;
    }

    public void blendWith(SkeletalAnimationSequence otherSequence, double blendFactor) throws SkeletalAnimationObject3D.SkeletalAnimationException {
        int numFrames = Math.max(this.mNumFrames, otherSequence.getNumFrames());
        ArrayList<SkeletalAnimationFrame> newFrames = new ArrayList<SkeletalAnimationFrame>();
        for (int i = 0; i < numFrames && i < otherSequence.getNumFrames(); ++i) {
            if (i >= this.mNumFrames) {
                newFrames.add(otherSequence.getFrame(i));
                continue;
            }
            SkeletalAnimationFrame thisFrame = this.getFrame(i);
            SkeletalAnimationFrame otherFrame = otherSequence.getFrame(i);
            SkeletalAnimationFrame newFrame = new SkeletalAnimationFrame();
            int numJoints = thisFrame.getSkeleton().getJoints().length;
            if (numJoints != otherFrame.getSkeleton().getJoints().length) {
                throw new SkeletalAnimationObject3D.SkeletalAnimationException("The animation sequences you want to blend have different skeletons.");
            }
            SkeletalAnimationFrame.SkeletonJoint[] newJoints = new SkeletalAnimationFrame.SkeletonJoint[numJoints];
            for (int j = 0; j < numJoints; ++j) {
                SkeletalAnimationFrame.SkeletonJoint thisJoint = thisFrame.getSkeleton().getJoint(j);
                SkeletalAnimationFrame.SkeletonJoint otherJoint = otherFrame.getSkeleton().getJoint(j);
                SkeletalAnimationFrame.SkeletonJoint newJoint = new SkeletalAnimationFrame.SkeletonJoint();
                newJoint.copyAllFrom(thisJoint);
                newJoint.getPosition().lerpAndSet(thisJoint.getPosition(), otherJoint.getPosition(), blendFactor);
                newJoint.getOrientation().slerp(thisJoint.getOrientation(), otherJoint.getOrientation(), blendFactor);
                newJoints[j] = newJoint;
            }
            newFrame.getSkeleton().setJoints(newJoints);
            newFrames.add(newFrame);
        }
        this.mFrames = newFrames.toArray(new SkeletalAnimationFrame[0]);
        this.mNumFrames = newFrames.size();
        newFrames.clear();
    }
}

