/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation.mesh;

import android.opengl.GLES20;
import android.os.SystemClock;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import org.rajawali3d.BufferInfo;
import org.rajawali3d.Geometry3D;
import org.rajawali3d.Object3D;
import org.rajawali3d.animation.mesh.AAnimationObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationChildObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationFrame;
import org.rajawali3d.animation.mesh.SkeletalAnimationSequence;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.Matrix;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.util.RajLog;

public class SkeletalAnimationObject3D
extends AAnimationObject3D {
    private SkeletalAnimationFrame.SkeletonJoint[] mJoints;
    private SkeletalAnimationFrame.SkeletonJoint mTmpJoint1;
    private SkeletalAnimationFrame.SkeletonJoint mTmpJoint2;
    private SkeletalAnimationSequence[] mSequences;
    private SkeletalAnimationSequence mSequence;
    private SkeletalAnimationSequence mNextSequence;
    private double mTransitionDuration;
    private double mTransitionStartTime;
    private Interpolator mTransitionInterpolator;
    private int mCurrentTransitionFrameIndex;
    public double[][] mInverseBindPoseMatrix;
    public double[] uBoneMatrix;
    private double[] mBoneTranslation = new double[16];
    private double[] mBoneRotation = new double[16];
    private double[] mBoneMatrix = new double[16];
    private double[] mResultMatrix = new double[16];
    public BufferInfo mBoneMatricesBufferInfo = new BufferInfo();
    private static final int DOUBLE_SIZE_BYTES = 8;
    protected DoubleBuffer mBoneMatrices;

    public SkeletalAnimationObject3D() {
        this.mTmpJoint1 = new SkeletalAnimationFrame.SkeletonJoint();
        this.mTmpJoint2 = new SkeletalAnimationFrame.SkeletonJoint();
    }

    public void setBindPoseMatrices(double[] bp) {
        this.uBoneMatrix = bp;
        this.mInverseBindPoseMatrix = new double[bp.length / 16][16];
        for (int i = 0; i < this.mInverseBindPoseMatrix.length; ++i) {
            Matrix.invertM(this.mInverseBindPoseMatrix[i], 0, bp, i * 16);
        }
    }

    public void setInverseBindPoseMatrices(double[][] invbp) {
        this.uBoneMatrix = new double[invbp.length * 16];
        this.mInverseBindPoseMatrix = invbp;
        for (int i = 0; i < invbp.length; ++i) {
            Matrix.invertM(this.uBoneMatrix, i * 16, invbp[i], 0);
        }
    }

    public void setAllBindPoseMatrices(double[] bp, double[][] invbp) {
        this.mInverseBindPoseMatrix = invbp;
        this.uBoneMatrix = bp;
    }

    public void setJointsWithBindPoseMatrices(SkeletalAnimationFrame.SkeletonJoint[] joints) {
        double[] bp = new double[joints.length * 16];
        for (int i = 0; i < joints.length; ++i) {
            System.arraycopy(joints[i].getMatrix(), 0, bp, i * 16, 16);
        }
        this.setBindPoseMatrices(bp);
        this.setJoints(joints);
    }

    public void setJointsWithInverseBindPoseMatrices(SkeletalAnimationFrame.SkeletonJoint[] joints) {
        double[][] invbp = new double[joints.length][];
        for (int i = 0; i < joints.length; ++i) {
            invbp[i] = Arrays.copyOf(joints[i].getMatrix(), 16);
        }
        this.setInverseBindPoseMatrices(invbp);
        this.setJoints(joints);
    }

    public void setJoints(SkeletalAnimationFrame.SkeletonJoint[] joints) {
        if (joints == null) {
            return;
        }
        this.mJoints = joints;
        if (this.mBoneMatrices == null) {
            this.mBoneMatrices = ByteBuffer.allocateDirect(joints.length * 8 * 16).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        } else {
            this.mBoneMatrices.clear();
        }
        this.mBoneMatrices.put(this.uBoneMatrix);
        this.mBoneMatrices.position(0);
        this.mBoneMatricesBufferInfo.buffer = this.mBoneMatrices;
        this.mGeometry.addBuffer(this.mBoneMatricesBufferInfo, Geometry3D.BufferType.FLOAT_BUFFER, 34962);
    }

    public SkeletalAnimationFrame.SkeletonJoint getJoint(int index) {
        return this.mJoints[index];
    }

    public SkeletalAnimationFrame.SkeletonJoint[] getJoints() {
        return this.mJoints;
    }

    public void setAnimationSequences(SkeletalAnimationSequence[] sequences) {
        this.mSequences = sequences;
    }

    public void setAnimationSequence(SkeletalAnimationSequence sequence) {
        this.mSequence = sequence;
        if (sequence != null && sequence.getFrames() != null) {
            this.mNumFrames = sequence.getFrames().length;
            for (Object3D child : this.mChildren) {
                if (!(child instanceof SkeletalAnimationChildObject3D)) continue;
                ((SkeletalAnimationChildObject3D)child).setAnimationSequence(sequence);
            }
        }
    }

    public boolean setAnimationSequence(String name) {
        SkeletalAnimationSequence sequence = this.getAnimationSequence(name);
        if (sequence == null) {
            return false;
        }
        this.setAnimationSequence(sequence);
        return true;
    }

    public boolean setAnimationSequence(int index) {
        SkeletalAnimationSequence sequence = this.getAnimationSequence(index);
        if (sequence == null) {
            return false;
        }
        this.setAnimationSequence(sequence);
        return true;
    }

    public void transitionToAnimationSequence(SkeletalAnimationSequence sequence, int duration) {
        this.transitionToAnimationSequence(sequence, duration, (Interpolator)new LinearInterpolator());
    }

    public void transitionToAnimationSequence(SkeletalAnimationSequence sequence, int duration, Interpolator interpolator) {
        this.mNextSequence = sequence;
        this.mTransitionDuration = duration;
        this.mTransitionInterpolator = interpolator;
        this.mTransitionStartTime = SystemClock.uptimeMillis();
        this.mCurrentTransitionFrameIndex = 0;
    }

    public boolean transitionToAnimationSequence(String name, int duration) {
        return this.transitionToAnimationSequence(name, duration, (Interpolator)new LinearInterpolator());
    }

    public boolean transitionToAnimationSequence(String name, int duration, Interpolator interpolator) {
        SkeletalAnimationSequence sequence = this.getAnimationSequence(name);
        if (sequence == null) {
            return false;
        }
        this.transitionToAnimationSequence(sequence, duration, interpolator);
        return true;
    }

    public boolean transitionToAnimationSequence(int index, int duration) {
        return this.transitionToAnimationSequence(index, duration, (Interpolator)new LinearInterpolator());
    }

    public boolean transitionToAnimationSequence(int index, int duration, Interpolator interpolator) {
        SkeletalAnimationSequence sequence = this.getAnimationSequence(index);
        if (sequence == null) {
            return false;
        }
        this.transitionToAnimationSequence(sequence, duration, interpolator);
        return true;
    }

    public SkeletalAnimationSequence[] getAnimationSequences() {
        return this.mSequences;
    }

    public SkeletalAnimationSequence getAnimationSequence(int index) {
        if (this.mSequences == null || index < 0 || index >= this.mSequences.length) {
            return null;
        }
        return this.mSequences[index];
    }

    public SkeletalAnimationSequence getAnimationSequence(String name) {
        if (this.mSequences == null) {
            return null;
        }
        for (SkeletalAnimationSequence seq : this.mSequences) {
            if (seq.getName() == null || !seq.getName().equals(name)) continue;
            return seq;
        }
        return null;
    }

    public SkeletalAnimationSequence getAnimationSequence() {
        return this.mSequence;
    }

    @Override
    public void setShaderParams(Camera camera) {
        if (!this.mIsPlaying) {
            return;
        }
        this.mBoneMatrices.clear();
        this.mBoneMatrices.position(0);
        long currentTime = SystemClock.uptimeMillis();
        SkeletalAnimationFrame currentFrame = this.mSequence.getFrame(this.mCurrentFrameIndex);
        SkeletalAnimationFrame nextFrame = this.mSequence.getFrame((this.mCurrentFrameIndex + 1) % this.mSequence.getNumFrames());
        this.mInterpolation += (double)((long)this.mFps * (currentTime - this.mStartTime)) / 1000.0;
        boolean isTransitioning = this.mNextSequence != null;
        double transitionInterpolation = 0.0;
        if (isTransitioning) {
            transitionInterpolation = this.mTransitionInterpolator.getInterpolation((float)(((double)currentTime - this.mTransitionStartTime) / this.mTransitionDuration));
        }
        for (int i = 0; i < this.mJoints.length; ++i) {
            SkeletalAnimationFrame.SkeletonJoint joint = this.getJoint(i);
            SkeletalAnimationFrame.SkeletonJoint fromJoint = currentFrame.getSkeleton().getJoint(i);
            SkeletalAnimationFrame.SkeletonJoint toJoint = nextFrame.getSkeleton().getJoint(i);
            joint.setParentIndex(fromJoint.getParentIndex());
            joint.getPosition().lerpAndSet(fromJoint.getPosition(), toJoint.getPosition(), this.mInterpolation);
            joint.getOrientation().slerp(fromJoint.getOrientation(), toJoint.getOrientation(), this.mInterpolation);
            if (isTransitioning) {
                SkeletalAnimationFrame currentTransFrame = this.mNextSequence.getFrame(this.mCurrentTransitionFrameIndex % this.mNextSequence.getNumFrames());
                SkeletalAnimationFrame nextTransFrame = this.mNextSequence.getFrame((this.mCurrentTransitionFrameIndex + 1) % this.mNextSequence.getNumFrames());
                fromJoint = currentTransFrame.getSkeleton().getJoint(i);
                toJoint = nextTransFrame.getSkeleton().getJoint(i);
                this.mTmpJoint1.getPosition().lerpAndSet(fromJoint.getPosition(), toJoint.getPosition(), this.mInterpolation);
                this.mTmpJoint1.getOrientation().slerp(fromJoint.getOrientation(), toJoint.getOrientation(), this.mInterpolation);
                this.mTmpJoint2.getPosition().lerpAndSet(joint.getPosition(), this.mTmpJoint1.getPosition(), transitionInterpolation);
                this.mTmpJoint2.getOrientation().slerp(joint.getOrientation(), this.mTmpJoint1.getOrientation(), transitionInterpolation);
                joint.getPosition().setAll(this.mTmpJoint2.getPosition());
                joint.getOrientation().setAll(this.mTmpJoint2.getOrientation());
            }
            Matrix.setIdentityM(this.mBoneTranslation, 0);
            Matrix.setIdentityM(this.mBoneRotation, 0);
            Matrix.setIdentityM(this.mBoneMatrix, 0);
            Matrix.setIdentityM(this.mResultMatrix, 0);
            Vector3 jointPos = joint.getPosition();
            Matrix.translateM(this.mBoneTranslation, 0, jointPos.x, jointPos.y, jointPos.z);
            joint.getOrientation().toRotationMatrix(this.mBoneRotation);
            Matrix.multiplyMM(this.mBoneMatrix, 0, this.mBoneTranslation, 0, this.mBoneRotation, 0);
            Matrix.multiplyMM(this.mResultMatrix, 0, this.mBoneMatrix, 0, this.mInverseBindPoseMatrix[i], 0);
            joint.setMatrix(this.mResultMatrix);
            int index = 16 * i;
            for (int j = 0; j < 16; ++j) {
                this.uBoneMatrix[index + j] = this.mResultMatrix[j];
                this.mBoneMatrices.put(this.mResultMatrix[j]);
            }
        }
        if (isTransitioning && transitionInterpolation >= (double)0.99f) {
            isTransitioning = false;
            this.mCurrentFrameIndex = this.mCurrentTransitionFrameIndex;
            this.mSequence = this.mNextSequence;
            this.mNextSequence = null;
        }
        this.mGeometry.changeBufferData(this.mBoneMatricesBufferInfo, this.mBoneMatrices, 0);
        if (this.mInterpolation >= 1.0) {
            this.mInterpolation = 0.0;
            ++this.mCurrentFrameIndex;
            if (this.mCurrentFrameIndex >= this.mSequence.getNumFrames()) {
                this.mCurrentFrameIndex = 0;
            }
            if (isTransitioning) {
                ++this.mCurrentTransitionFrameIndex;
                if (this.mCurrentTransitionFrameIndex >= this.mNextSequence.getNumFrames()) {
                    this.mCurrentTransitionFrameIndex = 0;
                }
            }
        }
        this.mStartTime = currentTime;
    }

    @Override
    public void play() {
        if (this.mSequence == null) {
            RajLog.e("[BoneAnimationObject3D.play()] Cannot play animation. No sequence was set.");
            return;
        }
        super.play();
        for (Object3D child : this.mChildren) {
            if (!(child instanceof AAnimationObject3D)) continue;
            ((AAnimationObject3D)child).play();
        }
    }

    @Override
    public void render(Camera camera, Matrix4 projMatrix, Matrix4 vMatrix, Matrix4 parentMatrix, Material sceneMaterial) {
        this.setShaderParams(camera);
        super.render(camera, projMatrix, vMatrix, parentMatrix, sceneMaterial);
    }

    @Override
    public void reload() {
        super.reload();
    }

    @Override
    public void destroy() {
        int[] buffers = new int[1];
        if (this.mBoneMatricesBufferInfo != null) {
            buffers[0] = this.mBoneMatricesBufferInfo.bufferHandle;
        }
        GLES20.glDeleteBuffers((int)buffers.length, (int[])buffers, (int)0);
        if (this.mBoneMatrices != null) {
            this.mBoneMatrices.clear();
        }
        this.mBoneMatrices = null;
        if (this.mBoneMatricesBufferInfo != null && this.mBoneMatricesBufferInfo.buffer != null) {
            this.mBoneMatricesBufferInfo.buffer.clear();
            this.mBoneMatricesBufferInfo.buffer = null;
        }
        super.destroy();
    }

    @Override
    public SkeletalAnimationObject3D clone(boolean copyMaterial) {
        return this.clone(copyMaterial, true);
    }

    @Override
    public SkeletalAnimationObject3D clone(boolean copyMaterial, boolean cloneChildren) {
        SkeletalAnimationObject3D clone = new SkeletalAnimationObject3D();
        clone.setRotation(this.getOrientation());
        clone.setPosition(this.getPosition());
        clone.setScale(this.getScale());
        clone.getGeometry().copyFromGeometry3D(this.mGeometry);
        clone.isContainer(this.mIsContainerOnly);
        clone.setMaterial(this.mMaterial);
        clone.mElementsBufferType = 5125;
        clone.mTransparent = this.mTransparent;
        clone.mEnableBlending = this.mEnableBlending;
        clone.mBlendFuncSFactor = this.mBlendFuncSFactor;
        clone.mBlendFuncDFactor = this.mBlendFuncDFactor;
        clone.mEnableDepthTest = this.mEnableDepthTest;
        clone.mEnableDepthMask = this.mEnableDepthMask;
        clone.setFrames(this.mFrames);
        clone.setFps(this.mFps);
        clone.uBoneMatrix = this.uBoneMatrix;
        clone.mInverseBindPoseMatrix = this.mInverseBindPoseMatrix;
        clone.setJoints(this.mJoints);
        if (!cloneChildren) {
            return clone;
        }
        for (Object3D child : this.mChildren) {
            if (child.getClass() != SkeletalAnimationChildObject3D.class) continue;
            SkeletalAnimationChildObject3D scoclone = (SkeletalAnimationChildObject3D)child.clone(copyMaterial, cloneChildren);
            scoclone.setSkeleton(clone);
            clone.addChild(scoclone);
        }
        return clone;
    }

    public static class SkeletalAnimationException
    extends Exception {
        private static final long serialVersionUID = -5569720011630317581L;

        public SkeletalAnimationException() {
        }

        public SkeletalAnimationException(String msg) {
            super(msg);
        }

        public SkeletalAnimationException(Throwable throwable) {
            super(throwable);
        }

        public SkeletalAnimationException(String msg, Throwable throwable) {
            super(msg, throwable);
        }
    }
}

