/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation.mesh;

import org.rajawali3d.Geometry3D;
import org.rajawali3d.animation.mesh.IAnimationFrame;
import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;

public class SkeletalAnimationFrame
implements IAnimationFrame {
    private String mName;
    private BoundingBox mBounds = new BoundingBox();
    private Skeleton mSkeleton = new Skeleton();
    private int mFrameIndex;

    @Override
    public Geometry3D getGeometry() {
        return null;
    }

    @Override
    public void setGeometry(Geometry3D geometry) {
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    public void setBounds(Vector3 min, Vector3 max) {
        this.mBounds.setMin(min);
        this.mBounds.setMax(max);
    }

    public BoundingBox getBoundingBox() {
        return this.mBounds;
    }

    public void setFrameIndex(int index) {
        this.mFrameIndex = index;
    }

    public int getFrameIndex() {
        return this.mFrameIndex;
    }

    public Skeleton getSkeleton() {
        return this.mSkeleton;
    }

    public static class Skeleton {
        private SkeletonJoint[] mJoints;

        public void setJoints(SkeletonJoint[] joints) {
            this.mJoints = joints;
        }

        public SkeletonJoint getJoint(int index) {
            return this.mJoints[index];
        }

        public void setJoint(int index, SkeletonJoint joint) {
            this.mJoints[index] = joint;
        }

        public SkeletonJoint[] getJoints() {
            return this.mJoints;
        }
    }

    public static class SkeletonJoint {
        private String mName;
        private int mParentIndex;
        private int mIndex;
        private int mStartIndex;
        private int mFlags;
        private Vector3 mPosition;
        private Quaternion mOrientation;
        private double[] mMatrix;

        public SkeletonJoint() {
            this.mPosition = new Vector3();
            this.mOrientation = new Quaternion();
            this.mMatrix = new double[16];
        }

        public SkeletonJoint(SkeletonJoint other) {
            this.mPosition = other.getPosition().clone();
            this.mOrientation = other.getOrientation().clone();
        }

        public void setName(String name) {
            this.mName = name;
        }

        public String getName() {
            return this.mName;
        }

        public void setParentIndex(int parentIndex) {
            this.mParentIndex = parentIndex;
        }

        public int getParentIndex() {
            return this.mParentIndex;
        }

        public void setPosition(double x, double y, double z) {
            this.mPosition.setAll(x, y, z);
        }

        public void setPosition(Vector3 position) {
            this.mPosition.x = position.x;
            this.mPosition.y = position.y;
            this.mPosition.z = position.z;
        }

        public Vector3 getPosition() {
            return this.mPosition;
        }

        public void setOrientation(double x, double y, double z) {
            this.mOrientation.setAll(1.0, x, y, z);
            this.mOrientation.computeW();
        }

        public void setOrientation(double w, double x, double y, double z) {
            this.mOrientation.setAll(w, x, y, z);
        }

        public Quaternion getOrientation() {
            return this.mOrientation;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("index: ").append(this.mIndex);
            sb.append(", name: ").append(this.mName);
            sb.append(", parentIndex: ").append(this.mParentIndex);
            sb.append(", startIndex: ").append(this.mStartIndex);
            sb.append(", flags: ").append(this.mFlags);
            return sb.toString();
        }

        public int getStartIndex() {
            return this.mStartIndex;
        }

        public void setStartIndex(int startIndex) {
            this.mStartIndex = startIndex;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public void setFlags(int flags) {
            this.mFlags = flags;
        }

        public double[] getMatrix() {
            return this.mMatrix;
        }

        public void setMatrix(double[] values) {
            System.arraycopy(values, 0, this.mMatrix, 0, 16);
        }

        public void setIndex(int index) {
            this.mIndex = index;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public void copyAllFrom(SkeletonJoint otherJoint) {
            this.mFlags = otherJoint.getFlags();
            this.mIndex = otherJoint.getIndex();
            if (otherJoint.getMatrix() != null) {
                this.mMatrix = (double[])otherJoint.getMatrix().clone();
            }
            this.mName = otherJoint.getName();
            this.mOrientation = otherJoint.getOrientation().clone();
            this.mParentIndex = otherJoint.getParentIndex();
            this.mPosition = otherJoint.getPosition().clone();
            this.mStartIndex = otherJoint.getStartIndex();
        }
    }
}

