/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation.mesh;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.rajawali3d.BufferInfo;
import org.rajawali3d.Geometry3D;
import org.rajawali3d.Object3D;
import org.rajawali3d.animation.mesh.AAnimationObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationObject3D;
import org.rajawali3d.animation.mesh.SkeletalAnimationSequence;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.materials.plugins.SkeletalAnimationMaterialPlugin;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector2;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.util.RajLog;

public class SkeletalAnimationChildObject3D
extends AAnimationObject3D {
    public static final int MAX_WEIGHTS_PER_VERTEX = 8;
    public SkeletalAnimationObject3D mSkeleton = null;
    private SkeletalAnimationSequence mSequence;
    public float[] boneWeights1;
    public float[] boneIndexes1;
    public float[] boneWeights2;
    public float[] boneIndexes2;
    private BufferInfo mboneWeights1BufferInfo = new BufferInfo();
    private BufferInfo mboneIndexes1BufferInfo = new BufferInfo();
    private BufferInfo mboneWeights2BufferInfo = new BufferInfo();
    private BufferInfo mboneIndexes2BufferInfo = new BufferInfo();
    protected FloatBuffer mboneWeights1;
    protected FloatBuffer mboneIndexes1;
    protected FloatBuffer mboneWeights2;
    protected FloatBuffer mboneIndexes2;
    protected int mMaxBoneWeightsPerVertex;
    private int mNumVertices;
    private BoneVertex[] mVertices;
    private BoneWeight[] mWeights;
    private SkeletalAnimationMaterialPlugin mMaterialPlugin;
    private boolean mInverseZScale = false;

    @Override
    public void calculateModelMatrix(Matrix4 parentMatrix) {
        super.calculateModelMatrix(parentMatrix);
        if (this.mInverseZScale) {
            this.mMMatrix.scale(1.0, 1.0, -1.0);
        }
    }

    @Override
    public void setShaderParams(Camera camera) {
        super.setShaderParams(camera);
        if (this.mMaterialPlugin == null) {
            this.mMaterialPlugin = (SkeletalAnimationMaterialPlugin)this.mMaterial.getPlugin(SkeletalAnimationMaterialPlugin.class);
        }
        this.mMaterialPlugin.setBone1Indices(this.mboneIndexes1BufferInfo.bufferHandle);
        this.mMaterialPlugin.setBone1Weights(this.mboneWeights1BufferInfo.bufferHandle);
        if (this.mMaxBoneWeightsPerVertex > 4) {
            this.mMaterialPlugin.setBone2Indices(this.mboneIndexes2BufferInfo.bufferHandle);
            this.mMaterialPlugin.setBone2Weights(this.mboneWeights2BufferInfo.bufferHandle);
        }
        this.mMaterialPlugin.setBoneMatrix(this.mSkeleton.uBoneMatrix);
    }

    public void setSkeleton(Object3D skeleton) {
        if (!(skeleton instanceof SkeletalAnimationObject3D)) {
            throw new RuntimeException("Skeleton must be of type AnimationSkeleton!");
        }
        this.mSkeleton = (SkeletalAnimationObject3D)skeleton;
    }

    public int getNumJoints() {
        return this.mSkeleton == null || this.mSkeleton.getJoints() == null ? 0 : this.mSkeleton.getJoints().length;
    }

    public void setSkeletonMeshData(BoneVertex[] vertices, BoneWeight[] weights) {
        this.setSkeletonMeshData(vertices.length, vertices, weights.length, weights);
    }

    public void setSkeletonMeshData(int numVertices, BoneVertex[] vertices, int numWeights, BoneWeight[] weights) {
        this.mNumVertices = numVertices;
        this.mVertices = vertices;
        this.mWeights = weights;
        this.prepareBoneWeightsAndIndices();
        this.mboneIndexes1 = this.alocateBuffer(this.mboneIndexes1, this.boneIndexes1);
        this.mboneWeights1 = this.alocateBuffer(this.mboneWeights1, this.boneWeights1);
        this.mboneIndexes1BufferInfo.buffer = this.mboneIndexes1;
        this.mboneWeights1BufferInfo.buffer = this.mboneWeights1;
        this.mGeometry.addBuffer(this.mboneIndexes1BufferInfo, Geometry3D.BufferType.FLOAT_BUFFER, 34962);
        this.mGeometry.addBuffer(this.mboneWeights1BufferInfo, Geometry3D.BufferType.FLOAT_BUFFER, 34962);
        if (this.mMaxBoneWeightsPerVertex > 4) {
            this.mboneIndexes2 = this.alocateBuffer(this.mboneIndexes2, this.boneIndexes2);
            this.mboneWeights2 = this.alocateBuffer(this.mboneWeights2, this.boneWeights2);
            this.mboneIndexes2BufferInfo.buffer = this.mboneIndexes2;
            this.mboneWeights2BufferInfo.buffer = this.mboneWeights2;
            this.mGeometry.addBuffer(this.mboneIndexes2BufferInfo, Geometry3D.BufferType.FLOAT_BUFFER, 34962);
            this.mGeometry.addBuffer(this.mboneWeights2BufferInfo, Geometry3D.BufferType.FLOAT_BUFFER, 34962);
        }
    }

    private FloatBuffer alocateBuffer(FloatBuffer buffer, float[] data) {
        if (buffer == null) {
            buffer = ByteBuffer.allocateDirect(data.length * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            buffer.put(data);
            buffer.position(0);
        } else {
            buffer.put(data);
        }
        return buffer;
    }

    @Override
    public void play() {
        if (this.mSequence == null) {
            RajLog.e("[BoneAnimationObject3D.play()] Cannot play animation. No sequence was set.");
            return;
        }
        super.play();
        for (Object3D child : this.mChildren) {
            if (!(child instanceof AAnimationObject3D)) continue;
            ((AAnimationObject3D)child).play();
        }
    }

    public void setAnimationSequence(SkeletalAnimationSequence sequence) {
        this.mSequence = sequence;
        if (sequence != null && sequence.getFrames() != null) {
            this.mNumFrames = sequence.getFrames().length;
            for (Object3D child : this.mChildren) {
                if (!(child instanceof SkeletalAnimationChildObject3D)) continue;
                ((SkeletalAnimationChildObject3D)child).setAnimationSequence(sequence);
            }
        }
    }

    public void prepareBoneWeightsAndIndices() {
        int weightStep = 4;
        this.boneWeights1 = new float[this.mNumVertices * 4];
        this.boneIndexes1 = new float[this.mNumVertices * 4];
        this.boneWeights2 = new float[this.mNumVertices * 4];
        this.boneIndexes2 = new float[this.mNumVertices * 4];
        for (int i = 0; i < this.mNumVertices; ++i) {
            BoneVertex vert = this.mVertices[i];
            for (int j = 0; j < vert.numWeights; ++j) {
                BoneWeight weight = this.mWeights[vert.weightIndex + j];
                if (j < 4) {
                    this.boneWeights1[weightStep * i + j] = weight.weightValue;
                    this.boneIndexes1[weightStep * i + j] = weight.jointIndex;
                    continue;
                }
                int jj = j % 4;
                this.boneWeights2[weightStep * i + jj] = weight.weightValue;
                this.boneIndexes2[weightStep * i + jj] = weight.jointIndex;
            }
        }
    }

    public void setMaxBoneWeightsPerVertex(int maxBoneWeightsPerVertex) throws SkeletalAnimationObject3D.SkeletalAnimationException {
        this.mMaxBoneWeightsPerVertex = maxBoneWeightsPerVertex;
        if (this.mMaxBoneWeightsPerVertex > 8) {
            throw new SkeletalAnimationObject3D.SkeletalAnimationException("A maximum of 8 weights per vertex is allowed. Your model uses more then 8.");
        }
    }

    public int getMaxBoneWeightsPerVertex() {
        return this.mMaxBoneWeightsPerVertex;
    }

    public void setInverseZScale(boolean value) {
        this.mInverseZScale = value;
    }

    @Override
    public void setData(float[] vertices, float[] normals, float[] textureCoords, float[] colors, int[] indices, boolean createVBOs) {
        this.setData(vertices, 35040, normals, 35040, textureCoords, 35044, colors, 35044, indices, 35044, createVBOs);
    }

    @Override
    public SkeletalAnimationChildObject3D clone(boolean copyMaterial, boolean cloneChildren) {
        SkeletalAnimationChildObject3D clone = new SkeletalAnimationChildObject3D();
        clone.setRotation(this.getOrientation());
        clone.setPosition(this.getPosition());
        clone.setScale(this.getScale());
        clone.getGeometry().copyFromGeometry3D(this.mGeometry);
        clone.isContainer(this.mIsContainerOnly);
        clone.setMaterial(this.mMaterial);
        clone.mElementsBufferType = 5125;
        clone.mTransparent = this.mTransparent;
        clone.mEnableBlending = this.mEnableBlending;
        clone.mBlendFuncSFactor = this.mBlendFuncSFactor;
        clone.mBlendFuncDFactor = this.mBlendFuncDFactor;
        clone.mEnableDepthTest = this.mEnableDepthTest;
        clone.mEnableDepthMask = this.mEnableDepthMask;
        clone.setAnimationSequence(this.mSequence);
        clone.setSkeleton(this.mSkeleton);
        try {
            clone.setMaxBoneWeightsPerVertex(this.mMaxBoneWeightsPerVertex);
        }
        catch (SkeletalAnimationObject3D.SkeletalAnimationException e) {
            e.printStackTrace();
        }
        clone.setSkeletonMeshData(this.mNumVertices, this.mVertices, 0, this.mWeights);
        clone.setInverseZScale(this.mInverseZScale);
        return clone;
    }

    public static class BoneWeight {
        public int jointIndex;
        public float weightValue;
        public Vector3 position = new Vector3();
    }

    public static class BoneVertex {
        public Vector2 textureCoordinate = new Vector2();
        public Vector3 normal = new Vector3();
        public int weightIndex;
        public int numWeights;
    }
}

