/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation.mesh;

import android.os.SystemClock;
import java.util.Stack;
import org.rajawali3d.Object3D;
import org.rajawali3d.animation.mesh.IAnimationFrame;
import org.rajawali3d.util.RajLog;

public abstract class AAnimationObject3D
extends Object3D {
    protected Stack<IAnimationFrame> mFrames = new Stack();
    protected int mNumFrames;
    protected int mCurrentFrameIndex;
    protected long mStartTime;
    protected boolean mIsPlaying;
    protected double mInterpolation;
    protected String mCurrentFrameName;
    protected int mStartFrameIndex = -1;
    protected int mEndFrameIndex = -1;
    protected boolean mLoop = false;
    protected int mFps = 30;

    public void setCurrentFrame(int frame) {
        this.mCurrentFrameIndex = frame;
    }

    public int getCurrentFrame() {
        return this.mCurrentFrameIndex;
    }

    public void addFrame(IAnimationFrame frame) {
        this.mFrames.add(frame);
        ++this.mNumFrames;
    }

    public int getNumFrames() {
        return this.mNumFrames;
    }

    public IAnimationFrame getFrame(int index) {
        return (IAnimationFrame)this.mFrames.get(index);
    }

    public void setFrames(Stack<IAnimationFrame> frames) {
        this.mFrames = frames;
        frames.trimToSize();
        this.mNumFrames = frames.capacity();
    }

    public void setFrames(IAnimationFrame[] frames) {
        Stack<IAnimationFrame> f = new Stack<IAnimationFrame>();
        for (int i = 0; i < frames.length; ++i) {
            f.add(frames[i]);
        }
        this.setFrames(f);
    }

    public void play() {
        this.play(null);
    }

    public void play(boolean loop) {
        this.play();
        this.mLoop = loop;
    }

    public void play(String name) {
        int start = this.mStartFrameIndex;
        int end = this.mEndFrameIndex;
        if (name != null) {
            start = -1;
            end = -1;
            for (int i = 0; i < this.mNumFrames; ++i) {
                if (((IAnimationFrame)this.mFrames.get(i)).getName().equals(name)) {
                    if (start < 0) {
                        start = i;
                    }
                    end = i;
                    continue;
                }
                if (end >= 0) break;
            }
            if (start < 0) {
                RajLog.e("Frame '" + name + "' not found");
            }
        }
        if (start < 0 || end < 0) {
            start = 0;
            end = this.mNumFrames - 1;
        }
        if (!this.isPlaying() || start > this.mCurrentFrameIndex || this.mCurrentFrameIndex > end) {
            this.mCurrentFrameIndex = start;
        }
        this.mStartFrameIndex = start;
        this.mEndFrameIndex = end;
        this.mStartTime = SystemClock.uptimeMillis();
        this.mIsPlaying = true;
    }

    public void play(String name, boolean loop) {
        this.play(name);
        this.mLoop = loop;
    }

    public void stop() {
        this.mIsPlaying = false;
        this.mCurrentFrameIndex = 0;
        this.mStartFrameIndex = -1;
        this.mEndFrameIndex = -1;
        this.mInterpolation = 0.0;
    }

    public void pause() {
        this.mIsPlaying = false;
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public int getFps() {
        return this.mFps;
    }

    public void setFps(int fps) {
        this.mFps = fps;
    }

    @Override
    public void reload() {
        super.reload();
        this.mStartTime = SystemClock.uptimeMillis();
    }
}

