/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import org.rajawali3d.animation.Animation3D;
import org.rajawali3d.math.vector.Vector3;

public class TranslateAnimation3D
extends Animation3D {
    protected final Vector3 mMultipliedPosition;
    protected final Vector3 mAddedPosition;
    protected final Vector3 mFromPosition = new Vector3();
    protected Vector3 mToPosition;
    protected Vector3 mDiffPosition;

    public TranslateAnimation3D(Vector3 toPosition) {
        this.mMultipliedPosition = new Vector3();
        this.mAddedPosition = new Vector3();
        this.mToPosition = new Vector3(toPosition);
    }

    public TranslateAnimation3D(Vector3 fromPosition, Vector3 toPosition) {
        this(toPosition);
        this.mFromPosition.setAll(fromPosition);
    }

    @Override
    protected void eventStart() {
        if (this.isFirstStart()) {
            this.mFromPosition.setAll(this.mTransformable3D.getPosition());
        }
        super.eventStart();
    }

    @Override
    protected void applyTransformation() {
        if (this.mDiffPosition == null) {
            this.mDiffPosition = Vector3.subtractAndCreate(this.mToPosition, this.mFromPosition);
        }
        this.mMultipliedPosition.scaleAndSet(this.mDiffPosition, this.mInterpolatedTime);
        this.mAddedPosition.addAndSet(this.mFromPosition, this.mMultipliedPosition);
        this.mTransformable3D.setPosition(this.mAddedPosition);
    }
}

