/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import org.rajawali3d.animation.Animation3D;
import org.rajawali3d.curves.ICurve3D;
import org.rajawali3d.math.vector.Vector3;

public class SplineTranslateAnimation3D
extends Animation3D {
    protected final Vector3 mTempPoint1;
    protected final Vector3 mTempPoint2;
    protected boolean mOrientToPath;
    protected ICurve3D mSplinePath;
    protected double mLookatDelta;

    public SplineTranslateAnimation3D(ICurve3D splinePath) {
        this.mSplinePath = splinePath;
        this.mTempPoint1 = new Vector3();
        this.mTempPoint2 = new Vector3();
    }

    @Override
    protected void applyTransformation() {
        this.mSplinePath.calculatePoint(this.mTempPoint1, this.mInterpolatedTime);
        this.mTransformable3D.setPosition(this.mTempPoint1);
        if (this.mOrientToPath) {
            this.mSplinePath.calculatePoint(this.mTempPoint2, this.mInterpolatedTime + this.mLookatDelta * (double)(this.mIsReversing ? -1 : 1));
            this.mTransformable3D.setLookAt(this.mTempPoint2);
        }
    }

    public boolean getOrientToPath() {
        return this.mOrientToPath;
    }

    public void setOrientToPath(boolean orientToPath) {
        if (this.mSplinePath == null) {
            throw new RuntimeException("You must set a spline path before orientation to path is possible.");
        }
        this.mOrientToPath = orientToPath;
        this.mSplinePath.setCalculateTangents(orientToPath);
    }

    @Override
    public void setDurationMilliseconds(long duration) {
        super.setDurationMilliseconds(duration);
        this.mLookatDelta = 300.0f / (float)duration;
    }
}

