/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import org.rajawali3d.animation.Animation3D;
import org.rajawali3d.math.MathUtil;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;

public class SlerpAnimation3D
extends Animation3D {
    protected final Quaternion mFrom;
    protected final Quaternion mTo;
    protected final Vector3 mForwardVec = Vector3.getAxisVector(Vector3.Axis.Z);
    protected final Vector3 mTmpVec;
    protected final Vector3 mTmpQuatVector;
    protected final Quaternion mTmpQuat;
    protected final double[] mRotationMatrix;
    protected final double mDistance;

    public SlerpAnimation3D(Vector3 from, Vector3 to) {
        this.mFrom = this.quaternionFromVector(from.clone());
        this.mTo = this.quaternionFromVector(to.clone());
        this.mTmpVec = new Vector3();
        this.mTmpQuatVector = new Vector3();
        this.mTmpQuat = new Quaternion();
        this.mDistance = from.length();
        this.mRotationMatrix = new double[16];
    }

    @Override
    protected void applyTransformation() {
        this.mTmpQuat.slerp(this.mFrom, this.mTo, this.mInterpolatedTime);
        this.mTmpVec.setAll(this.mForwardVec);
        this.mTmpQuat.toRotationMatrix(this.mRotationMatrix);
        this.mTmpVec.multiply(this.mRotationMatrix);
        this.mTmpVec.multiply(this.mDistance);
        this.mTransformable3D.setPosition(this.mTmpVec);
    }

    protected Quaternion quaternionFromVector(Vector3 vec) {
        vec.normalize();
        double angle = MathUtil.radiansToDegrees(Math.acos(Vector3.dot(this.mForwardVec, vec)));
        Quaternion q = new Quaternion();
        q.fromAngleAxis(this.mTmpQuatVector.crossAndSet(this.mForwardVec, vec), angle);
        return q;
    }
}

