/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import org.rajawali3d.animation.Animation3D;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;

public class RotateOnAxisAnimation
extends Animation3D {
    protected final Quaternion mQuat;
    protected final Quaternion mQuatFrom;
    protected final Vector3 mRotationAxis;
    protected double mDegreesToRotate;
    protected double mRotateFrom;
    protected double mRotationAngle;

    protected RotateOnAxisAnimation(Vector3 axis) {
        this.mRotationAxis = axis;
        this.mQuat = new Quaternion();
        this.mQuatFrom = new Quaternion();
    }

    public RotateOnAxisAnimation(Vector3.Axis axis, double degreesToRotate) {
        this(axis, 0.0, degreesToRotate);
    }

    public RotateOnAxisAnimation(Vector3.Axis axis, double rotateFrom, double degreesToRotate) {
        this(Vector3.getAxisVector(axis), rotateFrom, degreesToRotate);
    }

    public RotateOnAxisAnimation(Vector3 axis, double degreesToRotate) {
        this(axis, 0.0, degreesToRotate);
    }

    public RotateOnAxisAnimation(Vector3 axis, double rotateFrom, double degreesToRotate) {
        this(axis);
        this.mQuatFrom.fromAngleAxis(axis, rotateFrom);
        this.mRotateFrom = rotateFrom;
        this.mDegreesToRotate = degreesToRotate;
    }

    @Override
    public void eventStart() {
        if (this.isFirstStart()) {
            this.mTransformable3D.getOrientation(this.mQuatFrom);
        }
        super.eventStart();
    }

    @Override
    protected void applyTransformation() {
        this.mRotationAngle = this.mRotateFrom + this.mInterpolatedTime * this.mDegreesToRotate;
        this.mQuat.fromAngleAxis(this.mRotationAxis, this.mRotationAngle);
        this.mQuat.multiply(this.mQuatFrom);
        this.mTransformable3D.setOrientation(this.mQuat);
    }
}

