/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import org.rajawali3d.animation.Animation3D;
import org.rajawali3d.math.vector.Vector3;

public class RotateAroundAnimation3D
extends Animation3D {
    protected Vector3 mCenter;
    protected double mDistance;
    protected Vector3.Axis mAxis;

    public RotateAroundAnimation3D(Vector3 center, Vector3.Axis axis, double distance) {
        this.mCenter = center;
        this.mDistance = distance;
        this.mAxis = axis;
    }

    @Override
    protected void applyTransformation() {
        double radians = 360.0 * this.mInterpolatedTime * (Math.PI / 180);
        double cosVal = Math.cos(radians) * this.mDistance;
        double sinVal = Math.sin(radians) * this.mDistance;
        switch (this.mAxis) {
            case Z: {
                this.mTransformable3D.setX(this.mCenter.x + cosVal);
                this.mTransformable3D.setY(this.mCenter.y + sinVal);
                break;
            }
            case X: {
                this.mTransformable3D.setX(this.mCenter.x + cosVal);
                this.mTransformable3D.setZ(this.mCenter.z + sinVal);
                break;
            }
            case Y: {
                this.mTransformable3D.setY(this.mCenter.x + cosVal);
                this.mTransformable3D.setZ(this.mCenter.z + sinVal);
            }
        }
    }
}

