/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import org.rajawali3d.animation.Animation3D;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;

public class RotateAnimation3D
extends Animation3D {
    protected double mRotateX;
    protected double mRotateY;
    protected double mRotateZ;
    protected Quaternion mQuat = Quaternion.getIdentity();
    protected Quaternion mQuatFrom = new Quaternion();

    public RotateAnimation3D(double xRotate, double yRotate, double zRotate) {
        this.mRotateX = xRotate;
        this.mRotateY = yRotate;
        this.mRotateZ = zRotate;
        this.mQuat.multiply(new Quaternion().fromAngleAxis(Vector3.getAxisVector(Vector3.Axis.Y), yRotate));
        this.mQuat.multiply(new Quaternion().fromAngleAxis(Vector3.getAxisVector(Vector3.Axis.Z), zRotate));
        this.mQuat.multiply(new Quaternion().fromAngleAxis(Vector3.getAxisVector(Vector3.Axis.X), xRotate));
    }

    public RotateAnimation3D(Vector3 rotate) {
        this(rotate.x, rotate.y, rotate.z);
    }

    @Override
    public void eventStart() {
        if (this.isFirstStart()) {
            this.mTransformable3D.getOrientation(this.mQuatFrom);
        }
        super.eventStart();
    }

    @Override
    protected void applyTransformation() {
        Quaternion orientation = new Quaternion().slerp(this.mQuatFrom, this.mQuat, this.mInterpolatedTime, false);
        this.mTransformable3D.setOrientation(orientation);
    }
}

