/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import org.rajawali3d.animation.Animation3D;
import org.rajawali3d.math.vector.Vector3;

public class EllipticalOrbitAnimation3D
extends Animation3D {
    protected Vector3 mFocalPoint;
    protected Vector3 mPeriapsis;
    protected Vector3 mNormal;
    protected double mEccentricity;
    protected OrbitDirection mDirection;
    protected double mAngle;
    protected Vector3 mScratch1 = new Vector3();
    protected Vector3 mScratch2 = new Vector3();
    protected Vector3 mScratch3 = new Vector3();

    public EllipticalOrbitAnimation3D(Vector3 focalPoint, Vector3 periapsis, Vector3 normal, double eccentricity, OrbitDirection direction) {
        this.mFocalPoint = focalPoint;
        this.mPeriapsis = periapsis;
        this.mNormal = normal.clone();
        this.mEccentricity = eccentricity;
        this.mDirection = direction;
        this.mAngle = 360.0;
    }

    public EllipticalOrbitAnimation3D(Vector3 focalPoint, Vector3 periapsis, Vector3 normal, double eccentricity, double angle, OrbitDirection direction) {
        this.mFocalPoint = focalPoint;
        this.mPeriapsis = periapsis;
        this.mNormal = normal.clone();
        this.mEccentricity = eccentricity;
        this.mDirection = direction;
        this.mAngle = angle;
    }

    public EllipticalOrbitAnimation3D(Vector3 focalPoint, Vector3 periapsis, Vector3 normal, double eccentricity, double angle) {
        this.mFocalPoint = focalPoint;
        this.mPeriapsis = periapsis;
        this.mNormal = normal.clone();
        this.mEccentricity = eccentricity;
        this.mAngle = angle;
        this.mDirection = this.mAngle < 0.0 ? OrbitDirection.CLOCKWISE : OrbitDirection.COUNTERCLOCKWISE;
        this.mAngle = Math.abs(this.mAngle);
    }

    public EllipticalOrbitAnimation3D(Vector3 focalPoint, Vector3 periapsis, double eccentricity, OrbitDirection direction) {
        this(focalPoint, periapsis, Vector3.getAxisVector(Vector3.Axis.Y), eccentricity, direction);
    }

    public EllipticalOrbitAnimation3D(Vector3 focalPoint, Vector3 periapsis, double eccentricity, double angle) {
        this(focalPoint, periapsis, Vector3.getAxisVector(Vector3.Axis.Y), eccentricity, angle);
    }

    public EllipticalOrbitAnimation3D(Vector3 focalPoint, Vector3 periapsis, double eccentricity, double angle, OrbitDirection direction) {
        this(focalPoint, periapsis, Vector3.getAxisVector(Vector3.Axis.Y), eccentricity, angle, direction);
    }

    public EllipticalOrbitAnimation3D(Vector3 focalPoint, Vector3 periapsis, double eccentricity, Vector3.Axis axis, double angle) {
        this(focalPoint, periapsis, Vector3.getAxisVector(axis), eccentricity, angle);
    }

    public EllipticalOrbitAnimation3D(Vector3 focalPoint, Vector3 periapsis, double eccentricity, double angle, Vector3.Axis axis, OrbitDirection direction) {
        this(focalPoint, periapsis, Vector3.getAxisVector(axis), eccentricity, angle, direction);
    }

    @Override
    protected void applyTransformation() {
        double uAz;
        double uAy;
        double angle = (double)(this.mDirection == OrbitDirection.CLOCKWISE ? -1 : 1) * this.mAngle * this.mInterpolatedTime * (Math.PI / 180);
        double periapsisRadius = this.mPeriapsis.distanceTo(this.mFocalPoint);
        double apoapsisRadius = periapsisRadius * (1.0 + this.mEccentricity) / (1.0 - this.mEccentricity);
        double uAx = (double)(Math.round(this.mFocalPoint.x * 1.0E8) - Math.round(this.mPeriapsis.x * 1.0E8)) / 1.0E8;
        double mod = Math.sqrt(uAx * uAx + (uAy = (double)(Math.round(this.mFocalPoint.y * 1.0E8) - Math.round(this.mPeriapsis.y * 1.0E8)) / 1.0E8) * uAy + (uAz = (double)(Math.round(this.mFocalPoint.z * 1.0E8) - Math.round(this.mPeriapsis.z * 1.0E8)) / 1.0E8) * uAz);
        if (mod != 0.0 && mod != 1.0) {
            mod = 1.0 / mod;
            uAx *= mod;
            uAy *= mod;
            uAz *= mod;
        }
        double apoapsisDir_x = (double)Math.round(uAx * apoapsisRadius * 1.0E8) / 1.0E8;
        double apoapsisDir_y = (double)Math.round(uAy * apoapsisRadius * 1.0E8) / 1.0E8;
        double apoapsisDir_z = (double)Math.round(uAz * apoapsisRadius * 1.0E8) / 1.0E8;
        double apoapsisPos_x = (double)Math.round((apoapsisDir_x + this.mFocalPoint.x) * 1.0E8) / 1.0E8;
        double apoapsisPos_y = (double)Math.round((apoapsisDir_y + this.mFocalPoint.y) * 1.0E8) / 1.0E8;
        double apoapsisPos_z = (double)Math.round((apoapsisDir_z + this.mFocalPoint.z) * 1.0E8) / 1.0E8;
        double center_x = (double)Math.round((this.mPeriapsis.x + apoapsisPos_x) / 2.0 * 1.0E8) / 1.0E8;
        double center_y = (double)Math.round((this.mPeriapsis.y + apoapsisPos_y) / 2.0 * 1.0E8) / 1.0E8;
        double center_z = (double)Math.round((this.mPeriapsis.z + apoapsisPos_z) / 2.0 * 1.0E8) / 1.0E8;
        double b = Math.sqrt(periapsisRadius * apoapsisRadius);
        double semimajorAxis_x = (double)Math.round((this.mPeriapsis.x - center_x) * 1.0E8) / 1.0E8;
        double semimajorAxis_y = (double)Math.round((this.mPeriapsis.y - center_y) * 1.0E8) / 1.0E8;
        double semimajorAxis_z = (double)Math.round((this.mPeriapsis.z - center_z) * 1.0E8) / 1.0E8;
        double unitSemiMajorAxis_x = semimajorAxis_x;
        double unitSemiMajorAxis_y = semimajorAxis_y;
        double unitSemiMajorAxis_z = semimajorAxis_z;
        mod = Math.sqrt(semimajorAxis_x * semimajorAxis_x + semimajorAxis_y * semimajorAxis_y + semimajorAxis_z * semimajorAxis_z);
        if (mod != 0.0 && mod != 1.0) {
            mod = 1.0 / mod;
            unitSemiMajorAxis_x *= mod;
            unitSemiMajorAxis_y *= mod;
            unitSemiMajorAxis_z *= mod;
        }
        Vector3 unitNormal = this.mNormal.clone();
        unitNormal.normalize();
        double uNx = (double)Math.round(unitNormal.x * 1.0E8) / 1.0E8;
        double uNy = (double)Math.round(unitNormal.y * 1.0E8) / 1.0E8;
        double uNz = (double)Math.round(unitNormal.z * 1.0E8) / 1.0E8;
        double normalCenter_x = center_x + uNx;
        double normalCenter_y = center_y + uNy;
        double normalCenter_z = center_z + uNz;
        mod = Math.sqrt(normalCenter_x * normalCenter_x + normalCenter_y * normalCenter_y + normalCenter_z * normalCenter_z);
        if (mod != 0.0 && mod != 1.0) {
            mod = 1.0 / mod;
            normalCenter_x *= mod;
            normalCenter_y *= mod;
            normalCenter_z *= mod;
        }
        this.mScratch1.setAll(unitSemiMajorAxis_x, unitSemiMajorAxis_y, unitSemiMajorAxis_z);
        this.mScratch2.setAll(normalCenter_x, normalCenter_y, normalCenter_z);
        Vector3 semiminorAxis = this.mScratch3.crossAndSet(this.mScratch1, this.mScratch2);
        semiminorAxis.multiply(b);
        double x = center_x + Math.cos(angle) * semimajorAxis_x + Math.sin(angle) * semiminorAxis.x;
        double y = center_y + Math.cos(angle) * semimajorAxis_y + Math.sin(angle) * semiminorAxis.y;
        double z = center_z + Math.cos(angle) * semimajorAxis_z + Math.sin(angle) * semiminorAxis.z;
        this.mTransformable3D.setPosition(x, y, z);
    }

    public static enum OrbitDirection {
        CLOCKWISE,
        COUNTERCLOCKWISE;

    }
}

