/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import android.graphics.Color;
import org.rajawali3d.ATransformable3D;
import org.rajawali3d.Object3D;
import org.rajawali3d.animation.Animation3D;

public class ColorAnimation3D
extends Animation3D {
    protected final float[] mAddedColor = new float[3];
    protected final float[] mFromColor = new float[3];
    protected final float[] mMultipliedColor = new float[3];
    protected final float[] mToColor = new float[3];
    protected final float[] mDiffColor;
    protected final int mDiffAlpha;
    protected final int mFromAlpha;
    protected final int mToAlpha;
    protected int mMultipliedAlpha;

    public ColorAnimation3D(int fromColor, int toColor) {
        Color.colorToHSV((int)fromColor, (float[])this.mFromColor);
        Color.colorToHSV((int)toColor, (float[])this.mToColor);
        this.mFromAlpha = fromColor >>> 24;
        this.mToAlpha = toColor >>> 24;
        this.mDiffColor = new float[3];
        this.mDiffColor[0] = this.mToColor[0] - this.mFromColor[0];
        this.mDiffColor[1] = this.mToColor[1] - this.mFromColor[1];
        this.mDiffColor[2] = this.mToColor[2] - this.mFromColor[2];
        this.mDiffAlpha = this.mToAlpha - this.mFromAlpha;
    }

    @Override
    public void setTransformable3D(ATransformable3D transformable3D) {
        super.setTransformable3D(transformable3D);
        if (!(transformable3D instanceof Object3D)) {
            throw new RuntimeException("ColorAnimation3D requires the passed transformable3D to be an instance of " + Object3D.class.getSimpleName());
        }
    }

    @Override
    protected void applyTransformation() {
        this.mMultipliedColor[0] = this.mDiffColor[0] * (float)this.mInterpolatedTime;
        this.mMultipliedColor[1] = this.mDiffColor[1] * (float)this.mInterpolatedTime;
        this.mMultipliedColor[2] = this.mDiffColor[2] * (float)this.mInterpolatedTime;
        this.mMultipliedAlpha = (int)((float)this.mDiffAlpha * (float)this.mInterpolatedTime);
        this.mAddedColor[0] = this.mFromColor[0] + this.mMultipliedColor[0];
        this.mAddedColor[1] = this.mFromColor[1] + this.mMultipliedColor[1];
        this.mAddedColor[2] = this.mFromColor[2] + this.mMultipliedColor[2];
        ((Object3D)this.mTransformable3D).setColor(Color.HSVToColor((int)(this.mMultipliedAlpha + this.mFromAlpha), (float[])this.mAddedColor));
    }
}

