/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.ATransformable3D;
import org.rajawali3d.animation.Animation3D;
import org.rajawali3d.curves.ASpiral3D;
import org.rajawali3d.math.vector.Vector3;

public class CoalesceAnimation3D
extends Animation3D {
    private final List<CoalesceConfig> mCoalesceObjects = Collections.synchronizedList(new CopyOnWriteArrayList());
    private final List<Double> mThetaRanges = Collections.synchronizedList(new CopyOnWriteArrayList());

    public CoalesceAnimation3D(CoalesceConfig rootConfig) {
        this.mTransformable3D = rootConfig.object;
        this.mCoalesceObjects.add(rootConfig);
        this.mThetaRanges.add(rootConfig.spiral.calculateThetaForRadius(rootConfig.endProximity));
    }

    public void addCoalescingObject(CoalesceConfig object) {
        this.mCoalesceObjects.add(object);
        this.mThetaRanges.add(object.spiral.calculateThetaForRadius(object.endProximity));
    }

    public void addCoalescingGroup(List<CoalesceConfig> objects) {
        for (CoalesceConfig config : objects) {
            this.mCoalesceObjects.add(config);
            this.mThetaRanges.add(config.spiral.calculateThetaForRadius(config.endProximity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void applyTransformation() {
        List<CoalesceConfig> list = this.mCoalesceObjects;
        synchronized (list) {
            List<Double> list2 = this.mThetaRanges;
            synchronized (list2) {
                int j = this.mCoalesceObjects.size();
                for (int i = 0; i < j; ++i) {
                    CoalesceConfig config = this.mCoalesceObjects.get(i);
                    double theta = this.mThetaRanges.get(i) * this.mInterpolatedTime;
                    config.spiral.calculatePoint(config.object.getPosition(), theta);
                    config.object.getPosition().add(config.coalesceAroundPoint);
                }
            }
        }
    }

    public static class CoalesceConfig {
        public final ATransformable3D object;
        public final ATransformable3D coalesceAroundObject;
        public final Vector3 coalesceAroundPoint;
        public final double endProximity;
        public final ASpiral3D spiral;

        public CoalesceConfig(ASpiral3D spiral, ATransformable3D object, ATransformable3D coalesceAround, double endProximity) {
            this.spiral = spiral;
            this.object = object;
            this.coalesceAroundObject = coalesceAround;
            this.coalesceAroundPoint = this.coalesceAroundObject.getPosition();
            this.endProximity = endProximity;
        }

        public CoalesceConfig(ASpiral3D spiral, ATransformable3D object, Vector3 coalesceAround, double endProximity) {
            this.spiral = spiral;
            this.object = object;
            this.coalesceAroundObject = null;
            this.coalesceAroundPoint = coalesceAround;
            this.endProximity = endProximity;
        }
    }
}

