/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import org.rajawali3d.animation.Animation;
import org.rajawali3d.animation.AnimationGroup;
import org.rajawali3d.animation.Playable;

public class AnimationQueue
extends AnimationGroup {
    protected int mCurrentAnimation = 0;

    @Override
    public void update(double deltaTime) {
        if (!this.isPlaying()) {
            return;
        }
        if (this.mCurrentAnimation == -1 || this.mCurrentAnimation == this.mAnimations.size()) {
            switch (this.mRepeatMode) {
                case NONE: {
                    this.setState(Playable.State.ENDED);
                    this.eventEnd();
                    return;
                }
                case REVERSE_INFINITE: {
                    this.reverseAll();
                    this.reset();
                    this.play();
                    this.eventRepeat();
                    this.mCurrentAnimation = this.mIsReversing ? this.mAnimations.size() - 1 : 0;
                    return;
                }
                case INFINITE: {
                    this.reset();
                    this.play();
                    this.eventRepeat();
                    return;
                }
                case RESTART: {
                    if (this.mRepeatCount > this.mNumRepeat) {
                        ++this.mNumRepeat;
                        this.reset();
                        this.play();
                        this.eventRepeat();
                    } else {
                        this.eventEnd();
                    }
                    return;
                }
                case REVERSE: {
                    if (this.mRepeatCount > this.mNumRepeat) {
                        this.reverseAll();
                        ++this.mNumRepeat;
                        this.reset();
                        this.play();
                        this.eventRepeat();
                        this.mCurrentAnimation = this.mIsReversing ? this.mAnimations.size() - 1 : 0;
                    } else {
                        this.eventEnd();
                    }
                    return;
                }
            }
            throw new UnsupportedOperationException(this.mRepeatMode.toString());
        }
        Animation anim = (Animation)this.mAnimations.get(this.mCurrentAnimation);
        if (anim.isPlaying()) {
            anim.update(deltaTime);
        } else if (anim.isEnded()) {
            this.mCurrentAnimation += this.mIsReversing ? -1 : 1;
            this.update(deltaTime);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mCurrentAnimation = 0;
    }
}

