/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import java.util.ArrayList;
import java.util.List;
import org.rajawali3d.animation.Animation;
import org.rajawali3d.animation.Playable;

public class AnimationGroup
extends Animation {
    protected final List<Animation> mAnimations = new ArrayList<Animation>();

    @Override
    public void update(double deltaTime) {
        if (!this.isPlaying()) {
            return;
        }
        boolean stillPlaying = false;
        int j = this.mAnimations.size();
        for (int i = 0; i < j; ++i) {
            Animation anim = this.mAnimations.get(i);
            anim.update(deltaTime);
            if (stillPlaying || !anim.isPlaying()) continue;
            stillPlaying = true;
        }
        if (!stillPlaying) {
            this.setState(Playable.State.ENDED);
        }
        if (this.isEnded()) {
            switch (this.mRepeatMode) {
                case NONE: {
                    this.setState(Playable.State.ENDED);
                    this.eventEnd();
                    return;
                }
                case REVERSE_INFINITE: {
                    this.reverseAll();
                    this.reset();
                    this.play();
                    this.eventRepeat();
                    return;
                }
                case INFINITE: {
                    this.reset();
                    this.play();
                    this.eventRepeat();
                    return;
                }
                case RESTART: {
                    if (this.mRepeatCount > this.mNumRepeat) {
                        ++this.mNumRepeat;
                        this.reset();
                        this.play();
                        this.eventRepeat();
                    } else {
                        this.eventEnd();
                    }
                    return;
                }
                case REVERSE: {
                    if (this.mRepeatCount > this.mNumRepeat) {
                        this.reverseAll();
                        ++this.mNumRepeat;
                        this.reset();
                        this.play();
                        this.eventRepeat();
                    } else {
                        this.eventEnd();
                    }
                    return;
                }
            }
            throw new UnsupportedOperationException(this.mRepeatMode.toString());
        }
    }

    @Override
    protected void applyTransformation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void play() {
        super.play();
        int j = this.mAnimations.size();
        for (int i = 0; i < j; ++i) {
            this.mAnimations.get(i).play();
        }
    }

    @Override
    public void pause() {
        super.pause();
        int j = this.mAnimations.size();
        for (int i = 0; i < j; ++i) {
            this.mAnimations.get(i).pause();
        }
    }

    @Override
    public void reset() {
        super.reset();
        int j = this.mAnimations.size();
        for (int i = 0; i < j; ++i) {
            Animation anim = this.mAnimations.get(i);
            anim.reset();
            anim.mNumRepeat = 0;
        }
    }

    public void addAnimation(Animation animation) {
        this.mAnimations.add(animation);
    }

    protected void reverseAll() {
        this.mIsReversing = !this.mIsReversing;
        int j = this.mAnimations.size();
        for (int i = 0; i < j; ++i) {
            Animation anim = this.mAnimations.get(i);
            anim.mIsReversing = !anim.mIsReversing;
        }
    }
}

