/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.animation;

import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import java.util.List;
import org.rajawali3d.animation.IAnimationListener;
import org.rajawali3d.animation.Playable;

public abstract class Animation
extends Playable {
    protected final List<IAnimationListener> mAnimationListeners;
    protected int mRepeatCount;
    protected double mDelay;
    protected double mDuration;
    protected double mStartTime;
    protected Interpolator mInterpolator;
    protected RepeatMode mRepeatMode = RepeatMode.NONE;
    protected boolean mIsReversing;
    protected double mDelayCount;
    protected double mElapsedTime;
    protected double mInterpolatedTime;
    protected int mNumRepeat;
    protected boolean mIsStarted;
    private boolean mIsFirstStart = true;

    public Animation() {
        this.mAnimationListeners = new ArrayList<IAnimationListener>();
        this.mInterpolator = new LinearInterpolator();
        this.mRepeatMode = RepeatMode.NONE;
    }

    protected abstract void applyTransformation();

    @Override
    public void reset() {
        super.reset();
        this.setState(Playable.State.PAUSED);
        this.mElapsedTime = 0.0;
        this.mIsStarted = false;
        this.mDelayCount = 0.0;
    }

    public double getDelayDelta() {
        return this.mDelay;
    }

    public long getDelayMilliseconds() {
        return (long)(this.mDelay * 1000.0);
    }

    public double getDurationDelta() {
        return this.mDuration;
    }

    public long getDurationMilliseconds() {
        return (long)(this.mDuration * 1000.0);
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public RepeatMode getRepeatMode() {
        return this.mRepeatMode;
    }

    public void setDelayDelta(double delay) {
        this.mDelay = delay;
    }

    public void setDelayMilliseconds(long delay) {
        this.mDelay = (double)delay / 1000.0;
    }

    public void setDurationDelta(double duration) {
        this.mDuration = duration;
    }

    public void setDurationMilliseconds(long duration) {
        this.mDuration = (double)duration / 1000.0;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setRepeatCount(int repeatCount) {
        this.mRepeatCount = repeatCount;
    }

    public void setRepeatMode(RepeatMode repeatMode) {
        this.mRepeatMode = repeatMode;
    }

    public void setStartTime(double startTime) {
        if (!(startTime < this.mDuration)) {
            throw new RuntimeException("Animation start time must be less the duration.");
        }
        this.mStartTime = startTime;
    }

    public void setStartTime(long startTime) {
        this.setStartTime((double)startTime / 1000.0);
    }

    public void update(double deltaTime) {
        if (this.isPaused()) {
            return;
        }
        if (this.mDelayCount < this.mDelay) {
            this.mDelayCount += deltaTime;
            return;
        }
        if (!this.mIsStarted) {
            this.mIsStarted = true;
            this.mElapsedTime = this.mStartTime;
            this.eventStart();
        }
        this.mElapsedTime += deltaTime;
        double interpolatedTime = this.mInterpolator.getInterpolation((float)(this.mElapsedTime / this.mDuration));
        double d = interpolatedTime > 1.0 ? 1.0 : (this.mInterpolatedTime = interpolatedTime < 0.0 ? 0.0 : interpolatedTime);
        if (this.mIsReversing) {
            this.mInterpolatedTime = 1.0 - this.mInterpolatedTime;
        }
        this.applyTransformation();
        this.eventUpdate(this.mInterpolatedTime);
        if (this.mElapsedTime >= this.mDuration && !this.isEnded()) {
            this.setState(Playable.State.ENDED);
            switch (this.mRepeatMode) {
                case NONE: {
                    this.eventEnd();
                    return;
                }
                case REVERSE_INFINITE: {
                    this.mIsReversing = !this.mIsReversing;
                }
                case INFINITE: {
                    this.mElapsedTime -= this.mDuration;
                    this.play();
                    this.eventRepeat();
                    break;
                }
                case RESTART: {
                    if (this.mRepeatCount > this.mNumRepeat) {
                        ++this.mNumRepeat;
                        this.reset();
                        this.play();
                        this.eventRepeat();
                        break;
                    }
                    this.eventEnd();
                    return;
                }
                case REVERSE: {
                    if (this.mRepeatCount > this.mNumRepeat) {
                        this.mIsReversing = !this.mIsReversing;
                        ++this.mNumRepeat;
                        this.reset();
                        this.play();
                        this.eventRepeat();
                        break;
                    }
                    this.eventEnd();
                    return;
                }
                default: {
                    throw new UnsupportedOperationException(this.mRepeatMode.toString());
                }
            }
        }
    }

    public boolean isFirstStart() {
        return this.mIsFirstStart;
    }

    public boolean registerListener(IAnimationListener animationListener) {
        if (this.isPlaying()) {
            throw new RuntimeException("Listeners can only be added and removed when the animation is not playing.");
        }
        if (!this.mAnimationListeners.contains(animationListener)) {
            return this.mAnimationListeners.add(animationListener);
        }
        return false;
    }

    public boolean unregisterListener(IAnimationListener animationListener) {
        if (this.isPlaying()) {
            throw new RuntimeException("Listeners can only be added and removed when the animation is not playing.");
        }
        return this.mAnimationListeners.remove(animationListener);
    }

    protected void eventEnd() {
        int j = this.mAnimationListeners.size();
        for (int i = 0; i < j; ++i) {
            this.mAnimationListeners.get(i).onAnimationEnd(this);
        }
    }

    protected void eventRepeat() {
        int j = this.mAnimationListeners.size();
        for (int i = 0; i < j; ++i) {
            this.mAnimationListeners.get(i).onAnimationRepeat(this);
        }
    }

    protected void eventStart() {
        this.mIsFirstStart = false;
        int j = this.mAnimationListeners.size();
        for (int i = 0; i < j; ++i) {
            this.mAnimationListeners.get(i).onAnimationStart(this);
        }
    }

    protected void eventUpdate(double interpolatedTime) {
        int j = this.mAnimationListeners.size();
        for (int i = 0; i < j; ++i) {
            this.mAnimationListeners.get(i).onAnimationUpdate(this, interpolatedTime);
        }
    }

    public double getInterpolatedTime() {
        return this.mInterpolatedTime;
    }

    public static enum RepeatMode {
        NONE,
        INFINITE,
        RESTART,
        REVERSE,
        REVERSE_INFINITE;

    }
}

