/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d;

import org.rajawali3d.math.vector.Vector3;

public final class WorldParameters {
    private static final Vector3 TEMP_VECTOR = new Vector3();
    public static final Vector3 RIGHT_AXIS = Vector3.X.clone();
    public static final Vector3 NEG_RIGHT_AXIS = Vector3.NEG_X.clone();
    public static final Vector3 UP_AXIS = Vector3.Y.clone();
    public static final Vector3 NEG_UP_AXIS = Vector3.NEG_Y.clone();
    public static final Vector3 FORWARD_AXIS = Vector3.Z.clone();
    public static final Vector3 NEG_FORWARD_AXIS = Vector3.NEG_Z.clone();

    public static void setWorldAxes(Vector3 right, Vector3 up, Vector3 forward) {
        TEMP_VECTOR.crossAndSet(right, up);
        if (!TEMP_VECTOR.equals(forward, 1.0E-6)) {
            throw new IllegalArgumentException("World axes must be orthogonal.");
        }
        RIGHT_AXIS.setAll(right);
        NEG_RIGHT_AXIS.setAll(RIGHT_AXIS).inverse();
        UP_AXIS.setAll(up);
        NEG_UP_AXIS.setAll(UP_AXIS).inverse();
        FORWARD_AXIS.setAll(forward);
        NEG_FORWARD_AXIS.setAll(FORWARD_AXIS).inverse();
    }
}

