/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d;

import android.graphics.Color;
import android.opengl.GLES20;
import android.support.annotation.NonNull;
import android.util.Log;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.ATransformable3D;
import org.rajawali3d.BufferInfo;
import org.rajawali3d.Geometry3D;
import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.bounds.IBoundingVolume;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.MaterialManager;
import org.rajawali3d.materials.textures.TextureAtlas;
import org.rajawali3d.materials.textures.TexturePacker;
import org.rajawali3d.math.Matrix;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.util.GLU;
import org.rajawali3d.util.RajLog;
import org.rajawali3d.visitors.INode;
import org.rajawali3d.visitors.INodeVisitor;

public class Object3D
extends ATransformable3D
implements Comparable<Object3D>,
INode {
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public static final int ALPHA = 3;
    public static final int UNPICKABLE = -1;
    protected final Matrix4 mMVPMatrix = new Matrix4();
    protected final Matrix4 mMVMatrix = new Matrix4();
    protected final Matrix4 mInverseViewMatrix = new Matrix4();
    protected Matrix4 mPMatrix;
    protected Matrix4 mParentMatrix;
    protected final Matrix4 mRotationMatrix = new Matrix4();
    protected float[] mColor;
    protected Material mMaterial;
    protected Geometry3D mGeometry;
    protected Object3D mParent;
    protected List<Object3D> mChildren = Collections.synchronizedList(new CopyOnWriteArrayList());
    protected String mName;
    protected boolean mDoubleSided = false;
    protected boolean mBackSided = false;
    protected boolean mTransparent = false;
    protected boolean mForcedDepth = false;
    protected boolean mHasCubemapTexture = false;
    protected boolean mIsVisible = true;
    protected boolean mShowBoundingVolume = false;
    protected boolean mOverrideMaterialColor = false;
    protected int mDrawingMode = 4;
    protected int mElementsBufferType = 5125;
    protected boolean mIsContainerOnly = true;
    protected int mPickingIndex;
    protected float[] mPickingColor;
    protected boolean mFrustumTest = false;
    protected boolean mIsInFrustum;
    protected boolean mRenderChildrenAsBatch = false;
    protected boolean mIsPartOfBatch = false;
    protected boolean mManageMaterial = true;
    protected boolean mEnableBlending = false;
    protected int mBlendFuncSFactor;
    protected int mBlendFuncDFactor;
    protected boolean mEnableDepthTest = true;
    protected boolean mEnableDepthMask = true;
    protected volatile boolean mIsDestroyed = false;

    public Object3D() {
        this.mGeometry = new Geometry3D();
        this.mColor = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
        this.mPickingColor = new float[4];
        this.setPickingColor(-1);
    }

    public Object3D(String name) {
        this();
        this.mName = name;
    }

    public void setData(BufferInfo vertexBufferInfo, BufferInfo normalBufferInfo, float[] textureCoords, float[] colors, int[] indices, boolean createVBOs) {
        this.mGeometry.setData(vertexBufferInfo, normalBufferInfo, textureCoords, colors, indices, createVBOs);
        this.mIsContainerOnly = false;
        this.mElementsBufferType = 5125;
    }

    public void setData(float[] vertices, float[] normals, float[] textureCoords, float[] colors, int[] indices, boolean createVBOs) {
        this.setData(vertices, 35044, normals, 35044, textureCoords, 35044, colors, 35044, indices, 35044, createVBOs);
    }

    public void setData(float[] vertices, int verticesUsage, float[] normals, int normalsUsage, float[] textureCoords, int textureCoordsUsage, float[] colors, int colorsUsage, int[] indices, int indicesUsage, boolean createVBOs) {
        this.mGeometry.setData(vertices, verticesUsage, normals, normalsUsage, textureCoords, textureCoordsUsage, colors, colorsUsage, indices, indicesUsage, createVBOs);
        this.mIsContainerOnly = false;
        this.mElementsBufferType = 5125;
    }

    protected void preRender() {
        this.mGeometry.validateBuffers();
    }

    public void render(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix, Material sceneMaterial) {
        this.render(camera, vpMatrix, projMatrix, vMatrix, null, sceneMaterial);
    }

    public void render(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix, Matrix4 parentMatrix, Material sceneMaterial) {
        if (this.isDestroyed() || !this.mIsVisible && !this.mRenderChildrenAsBatch || this.isZeroScale()) {
            return;
        }
        if (parentMatrix != null) {
            if (this.mParentMatrix == null) {
                this.mParentMatrix = new Matrix4();
            }
            this.mParentMatrix.setAll(parentMatrix);
        }
        Material material = sceneMaterial == null ? this.mMaterial : sceneMaterial;
        this.preRender();
        boolean modelMatrixWasRecalculated = this.onRecalculateModelMatrix(parentMatrix);
        this.mMVMatrix.setAll(vMatrix).multiply(this.mMMatrix);
        this.mInverseViewMatrix.setAll(vMatrix).inverse();
        this.mMVPMatrix.setAll(vpMatrix).multiply(this.mMMatrix);
        if (this.mGeometry.hasBoundingBox()) {
            this.getBoundingBox().transform(this.getModelMatrix());
        }
        if (this.mGeometry.hasBoundingSphere()) {
            this.mGeometry.getBoundingSphere().transform(this.getModelMatrix());
        }
        this.mIsInFrustum = true;
        if (this.mFrustumTest && this.mGeometry.hasBoundingBox()) {
            BoundingBox bbox = this.getBoundingBox();
            if (!camera.getFrustum().boundsInFrustum(bbox)) {
                this.mIsInFrustum = false;
            }
        }
        if (!this.mIsContainerOnly && this.mIsInFrustum) {
            this.mPMatrix = projMatrix;
            if (this.mDoubleSided) {
                GLES20.glDisable((int)2884);
            } else {
                GLES20.glEnable((int)2884);
                if (this.mBackSided) {
                    GLES20.glCullFace((int)1028);
                } else {
                    GLES20.glCullFace((int)1029);
                    GLES20.glFrontFace((int)2305);
                }
            }
            if (this.mEnableBlending) {
                GLES20.glEnable((int)3042);
                GLES20.glBlendFunc((int)this.mBlendFuncSFactor, (int)this.mBlendFuncDFactor);
            }
            if (!this.mEnableDepthTest) {
                GLES20.glDisable((int)2929);
            } else {
                GLES20.glEnable((int)2929);
                GLES20.glDepthFunc((int)513);
            }
            GLES20.glDepthMask((boolean)this.mEnableDepthMask);
            if (!this.mIsPartOfBatch) {
                if (material == null) {
                    RajLog.e("[" + this.getClass().getName() + "] This object can't render because there's no material attached to it.");
                    if (this.mEnableBlending) {
                        GLES20.glDisable((int)3042);
                    }
                    if (this.mDoubleSided) {
                        GLES20.glEnable((int)2884);
                    } else if (this.mBackSided) {
                        GLES20.glCullFace((int)1029);
                    }
                    if (!this.mEnableDepthTest) {
                        GLES20.glEnable((int)2929);
                        GLES20.glDepthFunc((int)513);
                    }
                    return;
                }
                material.useProgram();
                this.setShaderParams(camera);
                material.bindTextures();
                if (this.mGeometry.hasTextureCoordinates()) {
                    material.setTextureCoords(this.mGeometry.getTexCoordBufferInfo());
                }
                if (this.mGeometry.hasNormals()) {
                    material.setNormals(this.mGeometry.getNormalBufferInfo());
                }
                if (this.mMaterial.usingVertexColors()) {
                    material.setVertexColors(this.mGeometry.getColorBufferInfo());
                }
                material.setVertices(this.mGeometry.getVertexBufferInfo());
            }
            material.setCurrentObject(this);
            if (this.mOverrideMaterialColor) {
                material.setColor(this.mColor);
            }
            material.applyParams();
            GLES20.glBindBuffer((int)34962, (int)0);
            material.setMVPMatrix(this.mMVPMatrix);
            material.setModelMatrix(this.mMMatrix);
            material.setInverseViewMatrix(this.mInverseViewMatrix);
            material.setModelViewMatrix(this.mMVMatrix);
            if (this.mIsVisible) {
                int bufferType = this.mGeometry.getIndexBufferInfo().bufferType == Geometry3D.BufferType.SHORT_BUFFER ? 5123 : 5125;
                GLES20.glBindBuffer((int)34963, (int)this.mGeometry.getIndexBufferInfo().bufferHandle);
                GLES20.glDrawElements((int)this.mDrawingMode, (int)this.mGeometry.getNumIndices(), (int)bufferType, (int)0);
                GLES20.glBindBuffer((int)34963, (int)0);
            }
            if (!this.mIsPartOfBatch && !this.mRenderChildrenAsBatch && sceneMaterial == null) {
                material.unbindTextures();
            }
            material.unsetCurrentObject(this);
            if (this.mEnableBlending) {
                GLES20.glDisable((int)3042);
            }
            if (this.mDoubleSided) {
                GLES20.glEnable((int)2884);
            } else if (this.mBackSided) {
                GLES20.glCullFace((int)1029);
            }
            if (!this.mEnableDepthTest) {
                GLES20.glEnable((int)2929);
                GLES20.glDepthFunc((int)513);
            }
        }
        if (this.mShowBoundingVolume) {
            if (this.mGeometry.hasBoundingBox()) {
                this.getBoundingBox().drawBoundingVolume(camera, vpMatrix, projMatrix, vMatrix, this.mMMatrix);
            }
            if (this.mGeometry.hasBoundingSphere()) {
                this.mGeometry.getBoundingSphere().drawBoundingVolume(camera, vpMatrix, projMatrix, vMatrix, this.mMMatrix);
            }
        }
        int j = this.mChildren.size();
        for (int i = 0; i < j; ++i) {
            Object3D child = this.mChildren.get(i);
            if (this.mRenderChildrenAsBatch || this.mIsPartOfBatch) {
                child.setPartOfBatch(true);
            }
            if (modelMatrixWasRecalculated) {
                child.markModelMatrixDirty();
            }
            child.render(camera, vpMatrix, projMatrix, vMatrix, this.mMMatrix, sceneMaterial);
        }
        if (this.mRenderChildrenAsBatch && sceneMaterial == null) {
            material.unbindTextures();
        }
    }

    public BoundingBox getBoundingBox() {
        if (this.getNumChildren() > 0 && !this.mGeometry.hasBoundingBox()) {
            Vector3 min = new Vector3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            Vector3 max = new Vector3(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
            for (int i = 0; i < this.getNumChildren(); ++i) {
                Object3D child = this.getChildAt(i);
                this.updateMaxMinCoords(min, max, child);
            }
            if (this.mGeometry.getVertices() != null) {
                this.updateMaxMinCoords(min, max, this);
            }
            this.mGeometry.setBoundingBox(new BoundingBox(min, max));
        }
        return this.mGeometry.getBoundingBox();
    }

    private void updateMaxMinCoords(Vector3 min, Vector3 max, Object3D child) {
        Vector3 maxVertex = child.getBoundingBox().getMax();
        if (maxVertex.x > max.x) {
            max.x = maxVertex.x;
        }
        if (maxVertex.y > max.y) {
            max.y = maxVertex.y;
        }
        if (maxVertex.z > max.z) {
            max.z = maxVertex.z;
        }
        Vector3 minVertex = child.getBoundingBox().getMin();
        if (minVertex.x < min.x) {
            min.x = minVertex.x;
        }
        if (minVertex.y < min.y) {
            min.y = minVertex.y;
        }
        if (minVertex.z < min.z) {
            min.z = minVertex.z;
        }
    }

    public void renderColorPicking(Camera camera, Material pickingMaterial) {
        if (this.isDestroyed() || !this.mIsVisible && !this.mRenderChildrenAsBatch || this.isZeroScale()) {
            return;
        }
        this.mIsInFrustum = true;
        if (this.mFrustumTest && this.mGeometry.hasBoundingBox()) {
            BoundingBox bbox = this.getBoundingBox();
            if (!camera.getFrustum().boundsInFrustum(bbox)) {
                this.mIsInFrustum = false;
            }
        }
        if (!this.mIsContainerOnly && this.mIsInFrustum && this.mIsVisible) {
            if (this.mDoubleSided) {
                GLES20.glDisable((int)2884);
            } else {
                GLES20.glEnable((int)2884);
                if (this.mBackSided) {
                    GLES20.glCullFace((int)1028);
                } else {
                    GLES20.glCullFace((int)1029);
                    GLES20.glFrontFace((int)2305);
                }
            }
            if (!this.mEnableDepthTest) {
                GLES20.glDisable((int)2929);
            } else {
                GLES20.glEnable((int)2929);
                GLES20.glDepthFunc((int)513);
            }
            GLES20.glDepthMask((boolean)this.mEnableDepthMask);
            pickingMaterial.useProgram();
            pickingMaterial.setVertices(this.mGeometry.getVertexBufferInfo());
            pickingMaterial.setColor(this.mPickingColor);
            pickingMaterial.applyParams();
            GLES20.glBindBuffer((int)34962, (int)0);
            pickingMaterial.setMVPMatrix(this.mMVPMatrix);
            pickingMaterial.setModelMatrix(this.mMMatrix);
            pickingMaterial.setInverseViewMatrix(this.mInverseViewMatrix);
            pickingMaterial.setModelViewMatrix(this.mMVMatrix);
            int bufferType = this.mGeometry.getIndexBufferInfo().bufferType == Geometry3D.BufferType.SHORT_BUFFER ? 5123 : 5125;
            GLES20.glBindBuffer((int)34963, (int)this.mGeometry.getIndexBufferInfo().bufferHandle);
            GLES20.glDrawElements((int)this.mDrawingMode, (int)this.mGeometry.getNumIndices(), (int)bufferType, (int)0);
            GLES20.glBindBuffer((int)34963, (int)0);
            if (this.mDoubleSided) {
                GLES20.glEnable((int)2884);
            } else if (this.mBackSided) {
                GLES20.glCullFace((int)1029);
            }
        }
        int j = this.mChildren.size();
        for (int i = 0; i < j; ++i) {
            this.mChildren.get(i).renderColorPicking(camera, pickingMaterial);
        }
    }

    protected void setShaderParams(Camera camera) {
    }

    protected void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            RajLog.e(op + ": glError " + error + " in class " + this.getClass().getName());
            throw new RuntimeException(op + ": glError " + error);
        }
    }

    public void reload() {
        if (!this.mIsContainerOnly) {
            this.mGeometry.reload();
        }
        int j = this.mChildren.size();
        for (int i = 0; i < j; ++i) {
            this.mChildren.get(i).reload();
        }
        if (this.mGeometry.hasBoundingBox() && this.getBoundingBox().getVisual() != null) {
            this.getBoundingBox().getVisual().reload();
        }
        if (this.mGeometry.hasBoundingSphere() && this.mGeometry.getBoundingSphere().getVisual() != null) {
            this.mGeometry.getBoundingSphere().getVisual().reload();
        }
    }

    public boolean hasBoundingVolume() {
        return this.mGeometry.hasBoundingBox() || this.mGeometry.hasBoundingSphere();
    }

    public void isContainer(boolean isContainer) {
        this.mIsContainerOnly = isContainer;
    }

    public boolean isContainer() {
        return this.mIsContainerOnly;
    }

    public void setScreenCoordinates(double x, double y, int viewportWidth, int viewportHeight, double eyeZ) {
        double[] r1 = new double[16];
        int[] viewport = new int[]{0, 0, viewportWidth, viewportHeight};
        double[] modelMatrix = new double[16];
        Matrix.setIdentityM(modelMatrix, 0);
        GLU.gluUnProject(x, (double)viewportHeight - y, 0.0, modelMatrix, 0, this.mPMatrix.getDoubleValues(), 0, viewport, 0, r1, 0);
        this.setPosition(r1[0] * eyeZ, r1[1] * -eyeZ, 0.0);
    }

    public boolean isDoubleSided() {
        return this.mDoubleSided;
    }

    public boolean isBackSided() {
        return this.mBackSided;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setDoubleSided(boolean doubleSided) {
        this.mDoubleSided = doubleSided;
    }

    public void setBackSided(boolean backSided) {
        this.mBackSided = backSided;
    }

    public boolean isTransparent() {
        return this.mTransparent;
    }

    public void setTransparent(boolean value) {
        this.mTransparent = value;
        this.mEnableBlending = value;
        this.setBlendFunc(770, 771);
        this.mEnableDepthMask = !value;
    }

    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    public int getDrawingMode() {
        return this.mDrawingMode;
    }

    public void setDrawingMode(int drawingMode) {
        this.mDrawingMode = drawingMode;
    }

    @Override
    public int compareTo(Object3D another) {
        if (this.mForcedDepth) {
            return -1;
        }
        if (this.mPosition.z < another.getZ()) {
            return 1;
        }
        if (this.mPosition.z > another.getZ()) {
            return -1;
        }
        return 0;
    }

    public void addChild(Object3D child) {
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        this.mChildren.add(child);
        child.setParent(this);
        child.mParentMatrix = new Matrix4();
        child.ensureModelMatrix();
        if (this.mRenderChildrenAsBatch) {
            child.setPartOfBatch(true);
        }
    }

    private void ensureModelMatrix() {
        Log.d((String)this.getName(), (String)"Ensuring model matrix.");
        if (this.mParent != null) {
            this.mParent.ensureModelMatrix();
            this.mParentMatrix.setAll(this.mParent.mMMatrix);
            this.onRecalculateModelMatrix(this.mParent.mMMatrix);
        } else {
            this.onRecalculateModelMatrix(null);
        }
    }

    public boolean removeChild(Object3D child) {
        return this.mChildren.remove(child);
    }

    public Object3D getParent() {
        return this.mParent;
    }

    private void setParent(@NonNull Object3D parent) {
        this.mParent = parent;
    }

    public int getNumTriangles() {
        int triangleCount = 0;
        int j = this.getNumChildren();
        for (int i = 0; i < j; ++i) {
            Object3D child = this.getChildAt(i);
            if (child.getGeometry() == null || child.getGeometry().getVertices() == null || !child.isVisible()) continue;
            if (child.getNumChildren() > 0) {
                triangleCount += child.getNumTriangles();
                continue;
            }
            triangleCount += child.getGeometry().getVertices().limit() / 9;
        }
        return triangleCount;
    }

    public int getNumObjects() {
        int objectCount = 0;
        int j = this.getNumChildren();
        for (int i = 0; i < j; ++i) {
            Object3D child = this.getChildAt(i);
            if (child.getGeometry() == null || child.getGeometry().getVertices() == null || !child.isVisible()) continue;
            if (child.getNumChildren() > 0) {
                objectCount += child.getNumObjects() + 1;
                continue;
            }
            ++objectCount;
        }
        return objectCount;
    }

    public int getNumChildren() {
        return this.mChildren.size();
    }

    public Object3D getChildAt(int index) {
        return this.mChildren.get(index);
    }

    public Object3D getChildByName(String name) {
        int j = this.mChildren.size();
        for (int i = 0; i < j; ++i) {
            if (!this.mChildren.get(i).getName().equals(name)) continue;
            return this.mChildren.get(i);
        }
        return null;
    }

    public Geometry3D getGeometry() {
        return this.mGeometry;
    }

    public Material getMaterial() {
        return this.mMaterial;
    }

    public void setMaterial(Material material) {
        if (material == null) {
            return;
        }
        MaterialManager.getInstance().addMaterial(material);
        this.mMaterial = material;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isForcedDepth() {
        return this.mForcedDepth;
    }

    public void setForcedDepth(boolean forcedDepth) {
        this.mForcedDepth = forcedDepth;
    }

    protected void cloneTo(Object3D clone, boolean copyMaterial) {
        clone.setName(this.mName);
        clone.getGeometry().copyFromGeometry3D(this.mGeometry);
        clone.isContainer(this.mIsContainerOnly);
        if (copyMaterial) {
            clone.setMaterial(this.mMaterial);
        }
        clone.mElementsBufferType = 5125;
        clone.mTransparent = this.mTransparent;
        clone.mEnableBlending = this.mEnableBlending;
        clone.mBlendFuncSFactor = this.mBlendFuncSFactor;
        clone.mBlendFuncDFactor = this.mBlendFuncDFactor;
        clone.mEnableDepthTest = this.mEnableDepthTest;
        clone.mEnableDepthMask = this.mEnableDepthMask;
    }

    public Object3D clone(boolean copyMaterial, boolean cloneChildren) {
        Object3D clone = new Object3D();
        this.cloneTo(clone, copyMaterial);
        clone.setOrientation(this.mOrientation);
        clone.setScale(this.getScale());
        if (cloneChildren) {
            int childCount = this.getNumChildren();
            for (int i = 0; i < childCount; ++i) {
                clone.addChild(this.getChildAt(i).clone(copyMaterial, cloneChildren));
            }
        }
        return clone;
    }

    public Object3D clone(boolean copyMaterial) {
        return this.clone(copyMaterial, false);
    }

    public Object3D clone() {
        return this.clone(true);
    }

    public void setVisible(boolean visible) {
        this.mIsVisible = visible;
    }

    public void setAlpha(int alpha) {
        this.mColor[3] = (float)alpha / 255.0f;
    }

    public void setAlpha(float alpha) {
        this.mColor[3] = alpha;
    }

    public void setColor(int color) {
        this.mColor[0] = (float)Color.red((int)color) / 255.0f;
        this.mColor[1] = (float)Color.green((int)color) / 255.0f;
        this.mColor[2] = (float)Color.blue((int)color) / 255.0f;
        this.mColor[3] = (float)Color.alpha((int)color) / 255.0f;
        this.mOverrideMaterialColor = true;
    }

    public void setColor(Vector3 color) {
        this.setColor(Color.rgb((int)((int)(color.x * 255.0)), (int)((int)(color.y * 255.0)), (int)((int)(color.z * 255.0))));
    }

    public void setPickingColor(int colorIndex) {
        this.mPickingIndex = colorIndex;
        this.mPickingColor[0] = (float)Color.red((int)colorIndex) / 255.0f;
        this.mPickingColor[1] = (float)Color.green((int)colorIndex) / 255.0f;
        this.mPickingColor[2] = (float)Color.blue((int)colorIndex) / 255.0f;
        this.mPickingColor[3] = (float)Color.alpha((int)colorIndex) / 255.0f;
    }

    public boolean isPickingEnabled() {
        return this.mPickingIndex != -1;
    }

    public void setShowBoundingVolume(boolean showBoundingVolume) {
        if (showBoundingVolume) {
            this.getBoundingBox();
        }
        this.mShowBoundingVolume = showBoundingVolume;
    }

    public void setFrustumTest(boolean value) {
        this.mFrustumTest = value;
    }

    @Override
    public void accept(INodeVisitor visitor) {
        visitor.apply(this);
    }

    public boolean isInFrustum() {
        return this.mIsInFrustum;
    }

    public boolean getRenderChildrenAsBatch() {
        return this.mRenderChildrenAsBatch;
    }

    public void setRenderChildrenAsBatch(boolean renderChildrenAsBatch) {
        this.mRenderChildrenAsBatch = renderChildrenAsBatch;
    }

    public boolean isPartOfBatch() {
        return this.mIsPartOfBatch;
    }

    public void setPartOfBatch(boolean isPartOfBatch) {
        this.mIsPartOfBatch = isPartOfBatch;
    }

    public void setBlendingEnabled(boolean value) {
        this.mEnableBlending = value;
    }

    public boolean isBlendingEnabled() {
        return this.mEnableBlending;
    }

    public void setBlendFunc(int sFactor, int dFactor) {
        this.mBlendFuncSFactor = sFactor;
        this.mBlendFuncDFactor = dFactor;
    }

    public void setDepthTestEnabled(boolean value) {
        this.mEnableDepthTest = value;
    }

    public boolean isDepthTestEnabled() {
        return this.mEnableDepthTest;
    }

    public void setDepthMaskEnabled(boolean value) {
        this.mEnableDepthMask = value;
    }

    public boolean isDepthMaskEnabled() {
        return this.mEnableDepthMask;
    }

    public Vector3 getWorldPosition() {
        if (this.mParentMatrix == null) {
            return this.mPosition;
        }
        Vector3 worldPos = this.mPosition.clone();
        worldPos.multiply(this.mParentMatrix);
        return worldPos;
    }

    public Matrix4 getModelViewProjectionMatrix() {
        return this.mMVPMatrix;
    }

    public Matrix4 getInverseViewMatrix() {
        return this.mInverseViewMatrix;
    }

    public Matrix4 getModelViewMatrix() {
        return this.mMVMatrix;
    }

    public void setAtlasTile(String tileName, TextureAtlas atlas) {
        TexturePacker.Tile tile = atlas.getTileNamed(tileName);
        FloatBuffer fb = this.getGeometry().getTextureCoords();
        for (int i = 0; i < fb.capacity(); ++i) {
            double uvIn = fb.get(i);
            double uvOut = i % 2 == 0 ? uvIn * (double)((float)tile.width / atlas.getWidth()) + (double)((float)tile.x / atlas.getWidth()) : uvIn * (double)((float)tile.height / atlas.getHeight()) + (double)((float)tile.y / atlas.getHeight());
            fb.put(i, (float)uvOut);
        }
        this.mGeometry.changeBufferData(this.mGeometry.getTexCoordBufferInfo(), fb, 0);
    }

    public void destroy() {
        this.mIsDestroyed = true;
        this.mGeometry.destroy();
        this.mMaterial = null;
        this.mGeometry = null;
        int j = this.mChildren.size();
        for (int i = 0; i < j; ++i) {
            this.mChildren.get(i).destroy();
        }
        this.mChildren.clear();
    }

    @Override
    public IBoundingVolume getTransformedBoundingVolume() {
        BoundingBox volume = null;
        volume = this.getBoundingBox();
        this.calculateModelMatrix(null);
        volume.transform(this.mMMatrix);
        return volume;
    }
}

