/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d;

import android.graphics.Color;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.rajawali3d.BufferInfo;
import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.bounds.BoundingSphere;
import org.rajawali3d.math.vector.Vector3;

public class Geometry3D {
    public static final int FLOAT_SIZE_BYTES = 4;
    public static final int INT_SIZE_BYTES = 4;
    public static final int SHORT_SIZE_BYTES = 2;
    public static final int BYTE_SIZE_BYTES = 1;
    public static final int VERTEX_BUFFER_KEY = 0;
    public static final int NORMAL_BUFFER_KEY = 1;
    public static final int TEXTURE_BUFFER_KEY = 2;
    public static final int COLOR_BUFFER_KEY = 3;
    public static final int INDEX_BUFFER_KEY = 4;
    protected final ArrayList<BufferInfo> mBuffers = new ArrayList(8);
    protected int mNumIndices;
    protected int mNumVertices;
    protected Geometry3D mOriginalGeometry;
    protected boolean mHaveCreatedBuffers = false;
    protected BoundingBox mBoundingBox;
    protected BoundingSphere mBoundingSphere;
    protected boolean mHasNormals;
    protected boolean mHasTextureCoordinates;

    public Geometry3D() {
        this.mBuffers.add(new BufferInfo());
        this.mBuffers.add(new BufferInfo());
        this.mBuffers.add(new BufferInfo());
        this.mBuffers.add(new BufferInfo());
        this.mBuffers.add(new BufferInfo());
        this.mBuffers.get((int)0).rajawaliHandle = 0;
        this.mBuffers.get((int)0).bufferType = BufferType.FLOAT_BUFFER;
        this.mBuffers.get((int)0).target = 34962;
        this.mBuffers.get((int)1).rajawaliHandle = 1;
        this.mBuffers.get((int)1).bufferType = BufferType.FLOAT_BUFFER;
        this.mBuffers.get((int)1).target = 34962;
        this.mBuffers.get((int)2).rajawaliHandle = 2;
        this.mBuffers.get((int)2).bufferType = BufferType.FLOAT_BUFFER;
        this.mBuffers.get((int)2).target = 34962;
        this.mBuffers.get((int)3).rajawaliHandle = 3;
        this.mBuffers.get((int)3).bufferType = BufferType.FLOAT_BUFFER;
        this.mBuffers.get((int)3).target = 34962;
        this.mBuffers.get((int)4).rajawaliHandle = 4;
        this.mBuffers.get((int)4).bufferType = BufferType.INT_BUFFER;
        this.mBuffers.get((int)4).target = 34963;
    }

    public static float[] concatAllFloat(float[] ... arrays) {
        int totalLength = 0;
        int subArrayCount = arrays.length;
        for (int i = 0; i < subArrayCount; ++i) {
            totalLength += arrays[i].length;
        }
        float[] result = Arrays.copyOf(arrays[0], totalLength);
        int offset = arrays[0].length;
        for (int i = 1; i < subArrayCount; ++i) {
            System.arraycopy(arrays[i], 0, result, offset, arrays[i].length);
            offset += arrays[i].length;
        }
        return result;
    }

    public static int[] concatAllInt(int[] ... arrays) {
        int totalLength = 0;
        int subArrayCount = arrays.length;
        for (int i = 0; i < subArrayCount; ++i) {
            totalLength += arrays[i].length;
        }
        int[] result = Arrays.copyOf(arrays[0], totalLength);
        int offset = arrays[0].length;
        for (int i = 1; i < subArrayCount; ++i) {
            System.arraycopy(arrays[i], 0, result, offset, arrays[i].length);
            offset += arrays[i].length;
        }
        return result;
    }

    public static float[] getFloatArrayFromBuffer(FloatBuffer buffer) {
        float[] array = new float[]{};
        if (buffer != null) {
            if (buffer.hasArray()) {
                array = buffer.array();
            } else {
                buffer.rewind();
                array = new float[buffer.capacity()];
                buffer.get(array);
            }
        }
        return array;
    }

    public static int[] getIntArrayFromBuffer(Buffer buffer) {
        int[] array = new int[]{};
        if (buffer != null) {
            if (buffer.hasArray()) {
                array = (int[])buffer.array();
            } else {
                buffer.rewind();
                array = new int[buffer.capacity()];
                if (buffer instanceof IntBuffer) {
                    ((IntBuffer)buffer).get(array);
                } else if (buffer instanceof ShortBuffer) {
                    int count = 0;
                    while (buffer.hasRemaining()) {
                        array[count] = ((ShortBuffer)buffer).get();
                        ++count;
                    }
                }
            }
        }
        return array;
    }

    public void copyFromGeometry3D(Geometry3D geom) {
        this.mNumIndices = geom.getNumIndices();
        this.mNumVertices = geom.getNumVertices();
        this.mBuffers.add(0, geom.getVertexBufferInfo());
        this.mBuffers.add(1, geom.getNormalBufferInfo());
        this.mBuffers.add(2, geom.getTexCoordBufferInfo());
        if (this.mBuffers.get((int)3).buffer == null) {
            this.mBuffers.add(3, geom.getColorBufferInfo());
        }
        this.mBuffers.add(4, geom.getIndexBufferInfo());
        this.mOriginalGeometry = geom;
        this.mHasNormals = geom.hasNormals();
        this.mHasTextureCoordinates = geom.hasTextureCoordinates();
    }

    public void addFromGeometry3D(Vector3 offset, Geometry3D geometry, boolean createVBOs) {
        float[] newVertices = null;
        float[] newNormals = null;
        float[] newColors = null;
        float[] newTextureCoords = null;
        int[] newIntIndices = null;
        float[] mVerticesArray = null;
        float[] mNormalsArray = null;
        float[] mColorsArray = null;
        float[] mTextureCoordsArray = null;
        int[] mIndicesArray = null;
        mVerticesArray = Geometry3D.getFloatArrayFromBuffer((FloatBuffer)this.mBuffers.get((int)0).buffer);
        mNormalsArray = Geometry3D.getFloatArrayFromBuffer((FloatBuffer)this.mBuffers.get((int)1).buffer);
        mColorsArray = Geometry3D.getFloatArrayFromBuffer((FloatBuffer)this.mBuffers.get((int)3).buffer);
        mTextureCoordsArray = Geometry3D.getFloatArrayFromBuffer((FloatBuffer)this.mBuffers.get((int)2).buffer);
        mIndicesArray = Geometry3D.getIntArrayFromBuffer(this.mBuffers.get((int)4).buffer);
        int axis = 0;
        float[] addVertices = Geometry3D.getFloatArrayFromBuffer(geometry.getVertices());
        if (offset != null) {
            int j = addVertices.length;
            for (int i = 0; i < j; ++i) {
                switch (axis) {
                    case 0: {
                        int n = i;
                        addVertices[n] = (float)((double)addVertices[n] + offset.x);
                        break;
                    }
                    case 1: {
                        int n = i;
                        addVertices[n] = (float)((double)addVertices[n] + offset.y);
                        break;
                    }
                    case 2: {
                        int n = i;
                        addVertices[n] = (float)((double)addVertices[n] + offset.z);
                    }
                }
                if (++axis <= 2) continue;
                axis = 0;
            }
        }
        float[] addNormals = Geometry3D.getFloatArrayFromBuffer(geometry.getNormals());
        float[] addColors = Geometry3D.getFloatArrayFromBuffer(geometry.getColors());
        float[] addTextureCoords = Geometry3D.getFloatArrayFromBuffer(geometry.getTextureCoords());
        int[] addIndices = Geometry3D.getIntArrayFromBuffer(geometry.getIndices());
        int index_offset = 0;
        if (mVerticesArray != null) {
            index_offset = mVerticesArray.length / 3;
        }
        if (addIndices != null) {
            int i = 0;
            int j = addIndices.length;
            while (i < j) {
                int n = i++;
                addIndices[n] = addIndices[n] + index_offset;
            }
        }
        newVertices = Geometry3D.concatAllFloat(mVerticesArray, addVertices);
        newNormals = Geometry3D.concatAllFloat(mNormalsArray, addNormals);
        newColors = Geometry3D.concatAllFloat(mColorsArray, addColors);
        newTextureCoords = Geometry3D.concatAllFloat(mTextureCoordsArray, addTextureCoords);
        newIntIndices = Geometry3D.concatAllInt(mIndicesArray, addIndices);
        this.setVertices(newVertices, true);
        this.setNormals(newNormals, true);
        this.setTextureCoords(newTextureCoords, true);
        this.setColors(newColors, true);
        this.setIndices(newIntIndices, true);
        if (createVBOs) {
            this.createBuffers();
        }
    }

    public void setData(BufferInfo vertexBufferInfo, BufferInfo normalBufferInfo, float[] textureCoords, float[] colors, int[] indices, boolean createVBOs) {
        if (textureCoords == null || textureCoords.length == 0) {
            textureCoords = new float[this.mNumVertices / 3 * 2];
        }
        this.setTextureCoords(textureCoords);
        if (colors == null || colors.length == 0) {
            this.setColors(-16777216 + (int)(Math.random() * 1.6777215E7));
        } else {
            this.setColors(colors);
        }
        this.setIndices(indices);
        this.mBuffers.add(0, vertexBufferInfo);
        this.mBuffers.add(1, normalBufferInfo);
        this.mOriginalGeometry = null;
        if (createVBOs) {
            this.createBuffers();
        }
    }

    public void setData(float[] vertices, float[] normals, float[] textureCoords, float[] colors, int[] indices, boolean createVBOs) {
        this.setData(vertices, 35044, normals, 35044, textureCoords, 35044, colors, 35044, indices, 35044, createVBOs);
    }

    public void setData(float[] vertices, int verticesUsage, float[] normals, int normalsUsage, float[] textureCoords, int textureCoordsUsage, float[] colors, int colorsUsage, int[] indices, int indicesUsage, boolean createVBOs) {
        this.mBuffers.get((int)0).usage = verticesUsage;
        this.mBuffers.get((int)1).usage = normalsUsage;
        this.mBuffers.get((int)2).usage = textureCoordsUsage;
        this.mBuffers.get((int)3).usage = colorsUsage;
        this.mBuffers.get((int)4).usage = indicesUsage;
        this.setVertices(vertices);
        if (normals != null) {
            this.setNormals(normals);
        }
        if (textureCoords == null || textureCoords.length == 0) {
            textureCoords = new float[vertices.length / 3 * 2];
        }
        this.setTextureCoords(textureCoords);
        if (colors != null && colors.length > 0) {
            this.setColors(colors);
        }
        this.setIndices(indices);
        if (createVBOs) {
            this.createBuffers();
        }
    }

    public void createBuffers() {
        for (BufferInfo info : this.mBuffers) {
            if (info.buffer != null) {
                if (info.buffer instanceof FloatBuffer) {
                    ((FloatBuffer)info.buffer).compact().position(0);
                } else if (info.buffer instanceof IntBuffer) {
                    ((IntBuffer)info.buffer).compact().position(0);
                } else if (info.buffer instanceof ShortBuffer) {
                    ((ShortBuffer)info.buffer).compact().position(0);
                } else if (info.buffer instanceof ByteBuffer) {
                    ((ByteBuffer)info.buffer).compact().position(0);
                } else if (info.buffer instanceof DoubleBuffer) {
                    ((DoubleBuffer)info.buffer).compact().position(0);
                } else if (info.buffer instanceof LongBuffer) {
                    ((LongBuffer)info.buffer).compact().position(0);
                } else if (info.buffer instanceof CharBuffer) {
                    ((CharBuffer)info.buffer).compact().position(0);
                }
            }
            this.createBuffer(info);
        }
        GLES20.glBindBuffer((int)34963, (int)0);
        GLES20.glBindBuffer((int)34962, (int)0);
        this.mHaveCreatedBuffers = true;
    }

    public void reload() {
        if (this.mOriginalGeometry != null) {
            if (!this.mOriginalGeometry.isValid()) {
                this.mOriginalGeometry.reload();
            }
            this.copyFromGeometry3D(this.mOriginalGeometry);
        }
        this.createBuffers();
    }

    public boolean isValid() {
        return GLES20.glIsBuffer((int)this.mBuffers.get((int)0).bufferHandle);
    }

    public void createVertexAndNormalBuffersOnly() {
        ((FloatBuffer)this.mBuffers.get((int)0).buffer).compact().position(0);
        ((FloatBuffer)this.mBuffers.get((int)1).buffer).compact().position(0);
        this.createBuffer(this.mBuffers.get(0), BufferType.FLOAT_BUFFER, 34962);
        this.createBuffer(this.mBuffers.get(1), BufferType.FLOAT_BUFFER, 34962);
        GLES20.glBindBuffer((int)34963, (int)0);
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    public void createBuffer(BufferInfo bufferInfo, BufferType type, int target) {
        this.createBuffer(bufferInfo, type, target, bufferInfo.usage);
    }

    public void createBuffer(BufferInfo bufferInfo, BufferType type, int target, int usage) {
        int byteSize = 4;
        if (type == BufferType.SHORT_BUFFER) {
            byteSize = 2;
        } else if (type == BufferType.BYTE_BUFFER) {
            byteSize = 1;
        } else if (type == BufferType.INT_BUFFER) {
            byteSize = 4;
        }
        bufferInfo.byteSize = byteSize;
        int[] buff = new int[1];
        GLES20.glGenBuffers((int)1, (int[])buff, (int)0);
        int handle = buff[0];
        Buffer buffer = bufferInfo.buffer;
        if (buffer != null) {
            buffer.rewind();
            GLES20.glBindBuffer((int)target, (int)handle);
            GLES20.glBufferData((int)target, (int)(buffer.capacity() * byteSize), (Buffer)buffer, (int)usage);
            GLES20.glBindBuffer((int)target, (int)0);
        }
        bufferInfo.bufferHandle = handle;
        bufferInfo.bufferType = type;
        bufferInfo.target = target;
        bufferInfo.usage = usage;
    }

    public void createBuffer(BufferInfo bufferInfo) {
        this.createBuffer(bufferInfo, bufferInfo.bufferType, bufferInfo.target, bufferInfo.usage);
    }

    public int addBuffer(BufferInfo bufferInfo, BufferType type, int target, int usage) {
        int key;
        this.createBuffer(bufferInfo, type, target, usage);
        bufferInfo.rajawaliHandle = key = this.mBuffers.size();
        this.mBuffers.add(bufferInfo);
        return key;
    }

    public int addBuffer(BufferInfo bufferInfo, BufferType type, int target) {
        return this.addBuffer(bufferInfo, type, target, bufferInfo.usage);
    }

    public void validateBuffers() {
        if (!this.mHaveCreatedBuffers) {
            this.createBuffers();
        }
        if (this.mOriginalGeometry != null) {
            this.mOriginalGeometry.validateBuffers();
            return;
        }
        int j = this.mBuffers.size();
        for (int i = 0; i < j; ++i) {
            BufferInfo info = this.mBuffers.get(i);
            if (info == null || info.bufferHandle != 0) continue;
            this.createBuffer(info);
        }
    }

    public void changeBufferUsage(BufferInfo bufferInfo, int usage) {
        GLES20.glDeleteBuffers((int)1, (int[])new int[]{bufferInfo.bufferHandle}, (int)0);
        this.createBuffer(bufferInfo, bufferInfo.bufferType, bufferInfo.target, usage);
    }

    public void changeBufferData(BufferInfo bufferInfo, Buffer newData, int index) {
        this.changeBufferData(bufferInfo, newData, index, false);
    }

    public void changeBufferData(BufferInfo bufferInfo, Buffer newData, int index, int size) {
        this.changeBufferData(bufferInfo, newData, index, size, false);
    }

    public void changeBufferData(BufferInfo bufferInfo, Buffer newData, int index, boolean resizeBuffer) {
        this.changeBufferData(bufferInfo, newData, index, newData.capacity(), resizeBuffer);
    }

    public void changeBufferData(BufferInfo bufferInfo, Buffer newData, int index, int size, boolean resizeBuffer) {
        newData.rewind();
        GLES20.glBindBuffer((int)bufferInfo.target, (int)bufferInfo.bufferHandle);
        if (resizeBuffer) {
            bufferInfo.buffer = newData;
            GLES20.glBufferData((int)bufferInfo.target, (int)(size * bufferInfo.byteSize), (Buffer)newData, (int)bufferInfo.usage);
        } else {
            GLES20.glBufferSubData((int)bufferInfo.target, (int)(index * bufferInfo.byteSize), (int)(size * bufferInfo.byteSize), (Buffer)newData);
        }
        GLES20.glBindBuffer((int)bufferInfo.target, (int)0);
    }

    public void setVertices(float[] vertices) {
        this.setVertices(vertices, false);
    }

    public void setVertices(float[] vertices, boolean override) {
        BufferInfo vertexInfo = this.mBuffers.get(0);
        if (vertexInfo.buffer == null || override) {
            if (vertexInfo.buffer != null) {
                vertexInfo.buffer.clear();
            }
            vertexInfo.buffer = ByteBuffer.allocateDirect(vertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ((FloatBuffer)vertexInfo.buffer).put(vertices);
            vertexInfo.buffer.position(0);
            this.mNumVertices = vertices.length / 3;
        } else {
            ((FloatBuffer)vertexInfo.buffer).put(vertices);
        }
    }

    public void setVertices(FloatBuffer vertices) {
        vertices.position(0);
        float[] v = new float[vertices.capacity()];
        vertices.get(v);
        this.setVertices(v);
    }

    public FloatBuffer getVertices() {
        if (this.mOriginalGeometry != null) {
            return this.mOriginalGeometry.getVertices();
        }
        return (FloatBuffer)this.mBuffers.get((int)0).buffer;
    }

    public void setNormals(float[] normals) {
        this.setNormals(normals, false);
    }

    public void setNormals(float[] normals, boolean override) {
        if (normals == null) {
            return;
        }
        BufferInfo normalInfo = this.mBuffers.get(1);
        if (normalInfo.buffer == null || override) {
            normalInfo.buffer = ByteBuffer.allocateDirect(normals.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ((FloatBuffer)normalInfo.buffer).put(normals);
            normalInfo.buffer.position(0);
        } else {
            normalInfo.buffer.position(0);
            ((FloatBuffer)normalInfo.buffer).put(normals);
            normalInfo.buffer.position(0);
        }
        this.mHasNormals = true;
    }

    public void setNormals(FloatBuffer normals) {
        normals.position(0);
        float[] n = new float[normals.capacity()];
        normals.get(n);
        this.setNormals(n);
    }

    public FloatBuffer getNormals() {
        if (this.mOriginalGeometry != null) {
            return this.mOriginalGeometry.getNormals();
        }
        return (FloatBuffer)this.mBuffers.get((int)1).buffer;
    }

    public boolean hasNormals() {
        return this.mHasNormals;
    }

    public void setIndices(int[] indices) {
        this.setIndices(indices, false);
    }

    public void setIndices(int[] indices, boolean override) {
        BufferInfo indexInfo = this.mBuffers.get(4);
        if (indexInfo.buffer == null || override) {
            indexInfo.buffer = ByteBuffer.allocateDirect(indices.length * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
            ((IntBuffer)indexInfo.buffer).put(indices).position(0);
            this.mNumIndices = indices.length;
        } else {
            ((IntBuffer)indexInfo.buffer).put(indices);
        }
    }

    public IntBuffer getIndices() {
        if (this.mBuffers.get((int)4).buffer == null && this.mOriginalGeometry != null) {
            return this.mOriginalGeometry.getIndices();
        }
        return (IntBuffer)this.mBuffers.get((int)4).buffer;
    }

    public void setTextureCoords(float[] textureCoords) {
        this.setTextureCoords(textureCoords, false);
    }

    public void setTextureCoords(float[] textureCoords, boolean override) {
        if (textureCoords == null) {
            return;
        }
        BufferInfo textureInfo = this.mBuffers.get(2);
        if (textureInfo.buffer == null || override) {
            textureInfo.buffer = ByteBuffer.allocateDirect(textureCoords.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ((FloatBuffer)textureInfo.buffer).put(textureCoords);
            textureInfo.buffer.position(0);
        } else {
            ((FloatBuffer)textureInfo.buffer).put(textureCoords);
        }
        this.mHasTextureCoordinates = true;
    }

    public FloatBuffer getTextureCoords() {
        if (this.mBuffers.get((int)2).buffer == null && this.mOriginalGeometry != null) {
            return this.mOriginalGeometry.getTextureCoords();
        }
        return (FloatBuffer)this.mBuffers.get((int)2).buffer;
    }

    public boolean hasTextureCoordinates() {
        return this.mHasTextureCoordinates;
    }

    public void setColors(int color) {
        this.setColor(Color.red((int)color), Color.green((int)color), Color.blue((int)color), Color.alpha((int)color));
    }

    public void setColors(float[] colors) {
        this.setColors(colors, false);
    }

    public void setColors(float[] colors, boolean override) {
        BufferInfo colorInfo = this.mBuffers.get(3);
        if (colorInfo.buffer == null || override) {
            colorInfo.buffer = ByteBuffer.allocateDirect(colors.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ((FloatBuffer)colorInfo.buffer).put(colors);
            colorInfo.buffer.position(0);
        } else {
            ((FloatBuffer)colorInfo.buffer).put(colors);
            colorInfo.buffer.position(0);
        }
    }

    public FloatBuffer getColors() {
        if (this.mBuffers.get((int)3).buffer == null && this.mOriginalGeometry != null) {
            return this.mOriginalGeometry.getColors();
        }
        return (FloatBuffer)this.mBuffers.get((int)3).buffer;
    }

    public int getNumIndices() {
        return this.mNumIndices;
    }

    public int getNumVertices() {
        return this.mNumVertices;
    }

    public void setNumVertices(int numVertices) {
        this.mNumVertices = numVertices;
    }

    public void setColor(float r, float g, float b, float a) {
        this.setColor(r, g, b, a, false);
    }

    public void setColor(float r, float g, float b, float a, boolean createNewBuffer) {
        BufferInfo colorInfo = this.mBuffers.get(3);
        if (colorInfo.buffer == null || colorInfo.buffer.limit() == 0) {
            colorInfo = new BufferInfo();
            colorInfo.buffer = ByteBuffer.allocateDirect(this.mNumVertices * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            createNewBuffer = true;
            this.mBuffers.add(3, colorInfo);
        }
        colorInfo.buffer.position(0);
        while (colorInfo.buffer.remaining() > 3) {
            ((FloatBuffer)colorInfo.buffer).put(r);
            ((FloatBuffer)colorInfo.buffer).put(g);
            ((FloatBuffer)colorInfo.buffer).put(b);
            ((FloatBuffer)colorInfo.buffer).put(a);
        }
        colorInfo.buffer.position(0);
        if (createNewBuffer) {
            this.createBuffer(colorInfo, BufferType.FLOAT_BUFFER, 34962);
        } else {
            GLES20.glBindBuffer((int)34962, (int)colorInfo.bufferHandle);
            GLES20.glBufferData((int)34962, (int)(colorInfo.buffer.limit() * 4), (Buffer)colorInfo.buffer, (int)35044);
        }
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.mBuffers.get((int)4).buffer != null) {
            buff.append("Geometry3D indices: ").append(this.mBuffers.get((int)4).buffer.capacity());
        }
        if (this.mBuffers.get((int)0).buffer != null) {
            buff.append(", vertices: ").append(this.mBuffers.get((int)0).buffer.capacity());
        }
        if (this.mBuffers.get((int)1).buffer != null) {
            buff.append(", normals: ").append(this.mBuffers.get((int)1).buffer.capacity());
        }
        if (this.mBuffers.get((int)2).buffer != null) {
            buff.append(", uvs: ").append(this.mBuffers.get((int)2).buffer.capacity()).append("\n");
        }
        if (this.mBuffers.get((int)3).buffer != null) {
            buff.append(", colors: ").append(this.mBuffers.get((int)3).buffer.capacity()).append("\n");
        }
        if (this.mBuffers.get(0) != null) {
            buff.append("vertex buffer handle: ").append(this.mBuffers.get((int)0).bufferHandle).append("\n");
        }
        if (this.mBuffers.get(4) != null) {
            buff.append("index buffer handle: ").append(this.mBuffers.get((int)4).bufferHandle).append("\n");
        }
        if (this.mBuffers.get(1) != null) {
            buff.append("normal buffer handle: ").append(this.mBuffers.get((int)1).bufferHandle).append("\n");
        }
        if (this.mBuffers.get(2) != null) {
            buff.append("texcoord buffer handle: ").append(this.mBuffers.get((int)2).bufferHandle).append("\n");
        }
        if (this.mBuffers.get(3) != null) {
            buff.append("color buffer handle: ").append(this.mBuffers.get((int)3).bufferHandle).append("\n");
        }
        return buff.toString();
    }

    public void destroy() {
        int[] buffers = new int[this.mBuffers.size()];
        int index = 0;
        for (BufferInfo info : this.mBuffers) {
            buffers[index++] = info.bufferHandle;
            if (info.buffer == null) continue;
            info.buffer.clear();
            info.buffer = null;
        }
        GLES20.glDeleteBuffers((int)buffers.length, (int[])buffers, (int)0);
        this.mOriginalGeometry = null;
        this.mBuffers.clear();
    }

    public boolean hasBoundingBox() {
        return this.mBoundingBox != null;
    }

    public BoundingBox getBoundingBox() {
        if (this.mBoundingBox == null) {
            this.mBoundingBox = new BoundingBox(this);
        }
        return this.mBoundingBox;
    }

    public boolean hasBoundingSphere() {
        return this.mBoundingSphere != null;
    }

    public BoundingSphere getBoundingSphere() {
        if (this.mBoundingSphere == null) {
            this.mBoundingSphere = new BoundingSphere(this);
        }
        return this.mBoundingSphere;
    }

    public BufferInfo getVertexBufferInfo() {
        return this.mBuffers.get(0);
    }

    public void setVertexBufferInfo(BufferInfo vertexBufferInfo) {
        this.mBuffers.add(0, vertexBufferInfo);
    }

    public BufferInfo getIndexBufferInfo() {
        return this.mBuffers.get(4);
    }

    public void setIndexBufferInfo(BufferInfo indexBufferInfo) {
        this.mBuffers.add(4, indexBufferInfo);
    }

    public BufferInfo getTexCoordBufferInfo() {
        return this.mBuffers.get(2);
    }

    public void setTexCoordBufferInfo(BufferInfo texCoordBufferInfo) {
        this.mBuffers.add(2, texCoordBufferInfo);
        this.mHasTextureCoordinates = true;
    }

    public BufferInfo getColorBufferInfo() {
        return this.mBuffers.get(3);
    }

    public void setColorBufferInfo(BufferInfo colorBufferInfo) {
        this.mBuffers.add(3, colorBufferInfo);
    }

    public BufferInfo getNormalBufferInfo() {
        return this.mBuffers.get(1);
    }

    public void setNormalBufferInfo(BufferInfo normalBufferInfo) {
        this.mBuffers.add(1, normalBufferInfo);
        this.mHasNormals = true;
    }

    public int getNumTriangles() {
        Buffer vertBuffer = this.mBuffers.get((int)0).buffer;
        return vertBuffer != null ? vertBuffer.limit() / 9 : 0;
    }

    public void setBuffersCreated(boolean created) {
        this.mHaveCreatedBuffers = created;
    }

    void setBoundingBox(BoundingBox boundingBox) {
        this.mBoundingBox = boundingBox;
    }

    public static enum BufferType {
        FLOAT_BUFFER,
        INT_BUFFER,
        SHORT_BUFFER,
        BYTE_BUFFER;

    }
}

