/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d;

import org.rajawali3d.WorldParameters;
import org.rajawali3d.bounds.IBoundingVolume;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.scenegraph.IGraphNode;
import org.rajawali3d.scenegraph.IGraphNodeMember;

public abstract class ATransformable3D
implements IGraphNodeMember {
    protected final Matrix4 mMMatrix = new Matrix4();
    protected final Vector3 mPosition;
    protected final Vector3 mScale;
    protected final Quaternion mOrientation;
    protected final Quaternion mTmpOrientation;
    protected final Vector3 mTempVec = new Vector3();
    protected final Vector3 mUpAxis;
    protected Vector3 mLookAt = new Vector3(0.0);
    protected boolean mLookAtValid = false;
    protected boolean mLookAtEnabled = false;
    protected boolean mIsCamera;
    protected boolean mIsModelMatrixDirty = true;
    protected boolean mInsideGraph = false;
    protected IGraphNode mGraphNode;

    public ATransformable3D() {
        this.mPosition = new Vector3();
        this.mScale = new Vector3(1.0, 1.0, 1.0);
        this.mOrientation = new Quaternion();
        this.mTmpOrientation = new Quaternion();
        this.mUpAxis = new Vector3(WorldParameters.UP_AXIS);
    }

    protected void markModelMatrixDirty() {
        this.mIsModelMatrixDirty = true;
    }

    public boolean onRecalculateModelMatrix(Matrix4 parentMatrix) {
        if (this.mIsModelMatrixDirty) {
            this.calculateModelMatrix(parentMatrix);
            if (this.mGraphNode != null) {
                this.mGraphNode.updateObject(this);
            }
            this.mIsModelMatrixDirty = false;
            return true;
        }
        return false;
    }

    public Matrix4 getModelMatrix() {
        return this.mMMatrix;
    }

    public void calculateModelMatrix(Matrix4 parentMatrix) {
        this.mMMatrix.setAll(this.mPosition, this.mScale, this.mOrientation);
        if (parentMatrix != null) {
            this.mMMatrix.leftMultiply(parentMatrix);
        }
    }

    public void setPosition(Vector3 position) {
        this.mPosition.setAll(position);
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.resetToLookAt();
        }
        this.markModelMatrixDirty();
    }

    public void setPosition(double x, double y, double z) {
        this.mPosition.setAll(x, y, z);
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.resetToLookAt();
        }
        this.markModelMatrixDirty();
    }

    public void moveForward(double units) {
        this.mTempVec.setAll(WorldParameters.FORWARD_AXIS);
        this.mTempVec.rotateBy(this.mOrientation).normalize();
        this.mTempVec.multiply(units);
        this.mPosition.add(this.mTempVec);
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.mLookAt.add(this.mTempVec);
            this.resetToLookAt();
        }
        this.markModelMatrixDirty();
    }

    public void moveRight(double units) {
        this.mTempVec.setAll(WorldParameters.RIGHT_AXIS);
        this.mTempVec.rotateBy(this.mOrientation).normalize();
        this.mTempVec.multiply(units);
        this.mPosition.add(this.mTempVec);
        if (this.mLookAtValid) {
            this.mLookAt.add(this.mTempVec);
            this.resetToLookAt();
        }
        this.markModelMatrixDirty();
    }

    public void moveUp(double units) {
        this.mTempVec.setAll(WorldParameters.UP_AXIS);
        this.mTempVec.rotateBy(this.mOrientation).normalize();
        this.mTempVec.multiply(units);
        this.mPosition.add(this.mTempVec);
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.mLookAt.add(this.mTempVec);
            this.resetToLookAt();
        }
        this.markModelMatrixDirty();
    }

    public void setX(double x) {
        this.mPosition.x = x;
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.resetToLookAt();
        }
        this.markModelMatrixDirty();
    }

    public void setY(double y) {
        this.mPosition.y = y;
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.resetToLookAt();
        }
        this.markModelMatrixDirty();
    }

    public void setZ(double z) {
        this.mPosition.z = z;
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.resetToLookAt();
        }
        this.markModelMatrixDirty();
    }

    public Vector3 getPosition() {
        return this.mPosition;
    }

    public double getX() {
        return this.mPosition.x;
    }

    public double getY() {
        return this.mPosition.y;
    }

    public double getZ() {
        return this.mPosition.z;
    }

    public ATransformable3D rotate(Quaternion quat) {
        this.mOrientation.multiply(quat);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D rotate(Vector3 axis, double angle) {
        this.mOrientation.multiply(this.mTmpOrientation.fromAngleAxis(axis, angle));
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D rotate(Vector3.Axis axis, double angle) {
        this.mOrientation.multiply(this.mTmpOrientation.fromAngleAxis(axis, angle));
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D rotate(double x, double y, double z, double angle) {
        this.mOrientation.multiply(this.mTmpOrientation.fromAngleAxis(x, y, z, angle));
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D rotate(Matrix4 matrix) {
        this.mOrientation.multiply(this.mTmpOrientation.fromMatrix(matrix));
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotation(Quaternion quat) {
        this.mOrientation.setAll(quat);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotation(Vector3 axis, double angle) {
        this.mOrientation.fromAngleAxis(axis, angle);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotation(Vector3.Axis axis, double angle) {
        this.mOrientation.fromAngleAxis(axis, angle);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotation(double x, double y, double z, double angle) {
        this.mOrientation.fromAngleAxis(x, y, z, angle);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotation(Matrix4 matrix) {
        this.mOrientation.fromMatrix(matrix);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotation(Vector3 rotation) {
        this.mOrientation.fromEuler(rotation.y, rotation.z, rotation.x);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotation(double rotX, double rotY, double rotZ) {
        this.mOrientation.fromEuler(rotY, rotZ, rotX);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotX(double rotX) {
        this.mOrientation.fromEuler(57.29577951308232 * this.mOrientation.getRotationY(), 57.29577951308232 * this.mOrientation.getRotationX(), rotX);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotY(double rotY) {
        this.mOrientation.fromEuler(rotY, 57.29577951308232 * this.mOrientation.getRotationX(), 57.29577951308232 * this.mOrientation.getRotationZ());
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setRotZ(double rotZ) {
        this.mOrientation.fromEuler(57.29577951308232 * this.mOrientation.getRotationY(), rotZ, 57.29577951308232 * this.mOrientation.getRotationZ());
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public double getRotX() {
        return this.mOrientation.getRotationX();
    }

    public double getRotY() {
        return this.mOrientation.getRotationY();
    }

    public double getRotZ() {
        return this.mOrientation.getRotationZ();
    }

    public void rotateAround(Vector3 axis, double angle) {
        this.rotateAround(axis, angle, true);
    }

    public void rotateAround(Vector3 axis, double angle, boolean append) {
        if (append) {
            this.mTmpOrientation.fromAngleAxis(axis, angle);
            this.mOrientation.multiply(this.mTmpOrientation);
        } else {
            this.mOrientation.fromAngleAxis(axis, angle);
        }
        this.markModelMatrixDirty();
    }

    public ATransformable3D setOrientation(Quaternion quat) {
        this.mOrientation.setAll(quat);
        this.mLookAtValid = false;
        this.markModelMatrixDirty();
        return this;
    }

    public Quaternion getOrientation(Quaternion quat) {
        quat.setAll(this.mOrientation);
        return quat;
    }

    public Quaternion getOrientation() {
        return this.getOrientation(this.mTmpOrientation);
    }

    public ATransformable3D setLookAt(Vector3 lookAt) {
        if (lookAt == null) {
            throw new IllegalArgumentException("As of Rajawali v0.10, you cannot set a null look target. If you want to remove the look target, use clearLookAt(boolean) instead.");
        }
        this.mLookAt.setAll(lookAt);
        this.resetToLookAt();
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setLookAt(double x, double y, double z) {
        this.mLookAt.x = x;
        this.mLookAt.y = y;
        this.mLookAt.z = z;
        this.resetToLookAt();
        this.markModelMatrixDirty();
        return this;
    }

    public void enableLookAt() {
        this.mLookAtEnabled = true;
        this.resetToLookAt();
    }

    public void disableLookAt() {
        this.mLookAtEnabled = false;
    }

    public boolean isLookAtEnabled() {
        return this.mLookAtEnabled;
    }

    public Vector3 getLookAt() {
        return this.mLookAt;
    }

    public boolean isLookAtValid() {
        return this.mLookAtValid;
    }

    public ATransformable3D resetToLookAt() {
        this.resetToLookAt(this.mUpAxis);
        return this;
    }

    public ATransformable3D resetToLookAt(Vector3 upAxis) {
        this.mTempVec.subtractAndSet(this.mLookAt, this.mPosition);
        if (this.mIsCamera) {
            this.mTempVec.inverse();
        }
        this.mOrientation.lookAt(this.mTempVec, upAxis);
        this.mLookAtValid = true;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setUpAxis(Vector3 upAxis) {
        this.mUpAxis.setAll(upAxis);
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.mOrientation.lookAt(this.mLookAt, this.mUpAxis);
            this.markModelMatrixDirty();
        }
        return this;
    }

    public ATransformable3D setUpAxis(Vector3.Axis upAxis) {
        this.mUpAxis.setAll(upAxis);
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.mOrientation.lookAt(this.mLookAt, this.mUpAxis);
            this.markModelMatrixDirty();
        }
        return this;
    }

    public ATransformable3D setUpAxis(double x, double y, double z) {
        this.mUpAxis.setAll(x, y, z);
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.mOrientation.lookAt(this.mLookAt, this.mUpAxis);
            this.markModelMatrixDirty();
        }
        return this;
    }

    public ATransformable3D resetUpAxis() {
        this.mUpAxis.setAll(Vector3.getAxisVector(Vector3.Axis.Y));
        if (this.mLookAtEnabled && this.mLookAtValid) {
            this.mOrientation.lookAt(this.mLookAt, this.mUpAxis);
            this.markModelMatrixDirty();
        }
        return this;
    }

    public ATransformable3D setScale(Vector3 scale) {
        this.mScale.setAll(scale);
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setScale(double scaleX, double scaleY, double scaleZ) {
        this.mScale.x = scaleX;
        this.mScale.y = scaleY;
        this.mScale.z = scaleZ;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setScale(double scale) {
        this.mScale.x = scale;
        this.mScale.y = scale;
        this.mScale.z = scale;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setScaleX(double scale) {
        this.mScale.x = scale;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setScaleY(double scale) {
        this.mScale.y = scale;
        this.markModelMatrixDirty();
        return this;
    }

    public ATransformable3D setScaleZ(double scale) {
        this.mScale.z = scale;
        this.markModelMatrixDirty();
        return this;
    }

    public Vector3 getScale() {
        return this.mScale;
    }

    public double getScaleX() {
        return this.mScale.x;
    }

    public double getScaleY() {
        return this.mScale.y;
    }

    public double getScaleZ() {
        return this.mScale.z;
    }

    public boolean isZeroScale() {
        return this.mScale.x == 0.0 && this.mScale.y == 0.0 && this.mScale.z == 0.0;
    }

    @Override
    public void setGraphNode(IGraphNode node, boolean inside) {
        this.mGraphNode = node;
        this.mInsideGraph = inside;
    }

    @Override
    public IGraphNode getGraphNode() {
        return this.mGraphNode;
    }

    @Override
    public boolean isInGraph() {
        return this.mInsideGraph;
    }

    @Override
    public IBoundingVolume getTransformedBoundingVolume() {
        return null;
    }

    @Override
    public Vector3 getScenePosition() {
        return this.mMMatrix.getTranslation(this.mTempVec);
    }
}

