/*
 * Decompiled with CFR 0.152.
 */
package radar.spring.auth.managementportal;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.auth.authentication.TokenValidator;
import org.radarbase.auth.authentication.TokenVerifierLoader;
import org.radarbase.auth.exception.TokenValidationException;
import org.radarbase.auth.jwks.JwkAlgorithmParser;
import org.radarbase.auth.jwks.JwkParser;
import org.radarbase.auth.jwks.JwksTokenVerifierLoader;
import org.radarbase.auth.token.RadarToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import radar.spring.auth.common.RadarAuthValidator;
import radar.spring.auth.config.ManagementPortalAuthProperties;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B+\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lradar/spring/auth/managementportal/ManagementPortalAuthValidator;", "Lradar/spring/auth/common/RadarAuthValidator;", "managementPortalProperties", "Lradar/spring/auth/config/ManagementPortalAuthProperties;", "tokenVerifiers", "", "Lorg/radarbase/auth/authentication/TokenVerifierLoader;", "tokenValidator", "Lorg/radarbase/auth/authentication/TokenValidator;", "(Lradar/spring/auth/config/ManagementPortalAuthProperties;Ljava/util/List;Lorg/radarbase/auth/authentication/TokenValidator;)V", "verify", "Lorg/radarbase/auth/token/RadarToken;", "token", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "Companion", "radar-spring-auth"})
@SourceDebugExtension(value={"SMAP\nManagementPortalAuthValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagementPortalAuthValidator.kt\nradar/spring/auth/managementportal/ManagementPortalAuthValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1549#2:64\n1620#2,3:65\n*S KotlinDebug\n*F\n+ 1 ManagementPortalAuthValidator.kt\nradar/spring/auth/managementportal/ManagementPortalAuthValidator\n*L\n23#1:64\n23#1:65,3\n*E\n"})
public final class ManagementPortalAuthValidator
implements RadarAuthValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ManagementPortalAuthProperties managementPortalProperties;
    @NotNull
    private final List<TokenVerifierLoader> tokenVerifiers;
    @NotNull
    private final TokenValidator tokenValidator;
    private static final Logger logger = LoggerFactory.getLogger(ManagementPortalAuthValidator.class);

    @JvmOverloads
    public ManagementPortalAuthValidator(@Autowired @NotNull ManagementPortalAuthProperties managementPortalProperties, @NotNull List<? extends TokenVerifierLoader> tokenVerifiers, @NotNull TokenValidator tokenValidator) {
        Intrinsics.checkNotNullParameter((Object)managementPortalProperties, (String)"managementPortalProperties");
        Intrinsics.checkNotNullParameter(tokenVerifiers, (String)"tokenVerifiers");
        Intrinsics.checkNotNullParameter((Object)tokenValidator, (String)"tokenValidator");
        this.managementPortalProperties = managementPortalProperties;
        this.tokenVerifiers = tokenVerifiers;
        this.tokenValidator = tokenValidator;
        try {
            this.tokenValidator.refresh();
            logger.debug("Refreshed Token Validator keys");
        }
        catch (Exception ex) {
            logger.error("Failed to immediately initialize token validator, will try again later: {}", (Object)ex.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ ManagementPortalAuthValidator(ManagementPortalAuthProperties managementPortalAuthProperties, List list, TokenValidator tokenValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = managementPortalAuthProperties.getPublicKeyEndpoints();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                URI uRI = (URI)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                collection.add(new JwksTokenVerifierLoader(string, managementPortalAuthProperties.getResourceName(), (JwkParser)new JwkAlgorithmParser()));
            }
            list = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)new JwksTokenVerifierLoader(managementPortalAuthProperties.getPublicKeyUrl(), managementPortalAuthProperties.getResourceName(), (JwkParser)new JwkAlgorithmParser())));
        }
        if ((n & 4) != 0) {
            tokenValidator = new TokenValidator(list, null, null, 6, null);
        }
        this(managementPortalAuthProperties, list, tokenValidator);
    }

    @Override
    @Nullable
    public RadarToken verify(@NotNull String token, @NotNull HttpServletRequest request) throws TokenValidationException {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.tokenValidator.validateBlocking(token);
    }

    @Override
    @Nullable
    public String getToken(@NotNull HttpServletRequest request) {
        return RadarAuthValidator.DefaultImpls.getToken(this, request);
    }

    @JvmOverloads
    public ManagementPortalAuthValidator(@Autowired @NotNull ManagementPortalAuthProperties managementPortalProperties, @NotNull List<? extends TokenVerifierLoader> tokenVerifiers) {
        Intrinsics.checkNotNullParameter((Object)managementPortalProperties, (String)"managementPortalProperties");
        Intrinsics.checkNotNullParameter(tokenVerifiers, (String)"tokenVerifiers");
        this(managementPortalProperties, tokenVerifiers, null, 4, null);
    }

    @JvmOverloads
    public ManagementPortalAuthValidator(@Autowired @NotNull ManagementPortalAuthProperties managementPortalProperties) {
        Intrinsics.checkNotNullParameter((Object)managementPortalProperties, (String)"managementPortalProperties");
        this(managementPortalProperties, null, null, 6, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lradar/spring/auth/managementportal/ManagementPortalAuthValidator$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "radar-spring-auth"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

