/*
 * Decompiled with CFR 0.152.
 */
package radar.spring.auth.common;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.CodeSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import radar.spring.auth.common.AuthValidator;
import radar.spring.auth.common.Authorization;
import radar.spring.auth.common.Authorized;
import radar.spring.auth.common.PermissionOn;
import radar.spring.auth.exception.AuthorizationFailedException;
import radar.spring.auth.exception.ResourceForbiddenException;

@Aspect
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001fBS\b\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\fJ4\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0015\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006 "}, d2={"Lradar/spring/auth/common/AuthAspect;", "T", "", "authValidator", "Lradar/spring/auth/common/AuthValidator;", "authorization", "Lradar/spring/auth/common/Authorization;", "projectIdParamNames", "", "", "subjectIdParamNames", "sourceIdParamNames", "(Lradar/spring/auth/common/AuthValidator;Lradar/spring/auth/common/Authorization;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getProjectIdParamNames", "()Ljava/util/Set;", "getSourceIdParamNames", "getSubjectIdParamNames", "authorize", "", "authorized", "Lradar/spring/auth/common/Authorized;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "projectId", "subjectId", "sourceId", "before", "joinPoint", "Lorg/aspectj/lang/JoinPoint;", "ensureToken", "(Ljakarta/servlet/http/HttpServletRequest;)Ljava/lang/Object;", "Companion", "radar-spring-auth"})
public class AuthAspect<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthValidator<T> authValidator;
    @NotNull
    private final Authorization<T> authorization;
    @NotNull
    private final Set<String> projectIdParamNames;
    @NotNull
    private final Set<String> subjectIdParamNames;
    @NotNull
    private final Set<String> sourceIdParamNames;
    @NotNull
    public static final String TOKEN_KEY = "radar_token";
    @NotNull
    public static final String PROJECT_ID_PARAMETER_NAME = "projectId";
    @NotNull
    public static final String SUBJECT_ID_PARAMETER_NAME = "subjectId";
    @NotNull
    public static final String SOURCE_ID_PARAMETER_NAME = "sourceId";
    private static final Logger logger = LoggerFactory.getLogger(AuthAspect.class);

    @JvmOverloads
    public AuthAspect(@NotNull AuthValidator<T> authValidator, @NotNull Authorization<T> authorization, @NotNull Set<String> projectIdParamNames, @NotNull Set<String> subjectIdParamNames, @NotNull Set<String> sourceIdParamNames) {
        Intrinsics.checkNotNullParameter(authValidator, (String)"authValidator");
        Intrinsics.checkNotNullParameter(authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter(projectIdParamNames, (String)"projectIdParamNames");
        Intrinsics.checkNotNullParameter(subjectIdParamNames, (String)"subjectIdParamNames");
        Intrinsics.checkNotNullParameter(sourceIdParamNames, (String)"sourceIdParamNames");
        this.authValidator = authValidator;
        this.authorization = authorization;
        this.projectIdParamNames = projectIdParamNames;
        this.subjectIdParamNames = subjectIdParamNames;
        this.sourceIdParamNames = sourceIdParamNames;
    }

    public /* synthetic */ AuthAspect(AuthValidator authValidator, Authorization authorization, Set set, Set set2, Set set3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = SetsKt.setOf((Object)PROJECT_ID_PARAMETER_NAME);
        }
        if ((n & 8) != 0) {
            set2 = SetsKt.setOf((Object)SUBJECT_ID_PARAMETER_NAME);
        }
        if ((n & 0x10) != 0) {
            set3 = SetsKt.setOf((Object)SOURCE_ID_PARAMETER_NAME);
        }
        this(authValidator, authorization, set, set2, set3);
    }

    @NotNull
    public final Set<String> getProjectIdParamNames() {
        return this.projectIdParamNames;
    }

    @NotNull
    public final Set<String> getSubjectIdParamNames() {
        return this.subjectIdParamNames;
    }

    @NotNull
    public final Set<String> getSourceIdParamNames() {
        return this.sourceIdParamNames;
    }

    @Before(value="@annotation(authorized) && execution(* *(..))")
    public final void before(@NotNull JoinPoint joinPoint, @NotNull Authorized authorized) {
        Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
        Intrinsics.checkNotNullParameter((Object)authorized, (String)"authorized");
        RequestAttributes reqAttr = RequestContextHolder.getRequestAttributes();
        Intrinsics.checkNotNull((Object)reqAttr, (String)"null cannot be cast to non-null type org.springframework.web.context.request.ServletRequestAttributes");
        HttpServletRequest req = ((ServletRequestAttributes)reqAttr).getRequest();
        Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        Intrinsics.checkNotNull((Object)signature, (String)"null cannot be cast to non-null type org.aspectj.lang.reflect.CodeSignature");
        CodeSignature codeSignature = (CodeSignature)signature;
        String projectId = null;
        String subjectId = null;
        String sourceId = null;
        Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
        Object[] objectArray = args;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            Object arg = objectArray[i];
            if (!Intrinsics.areEqual((Object)codeSignature.getParameterTypes()[index], String.class)) continue;
            String string = codeSignature.getParameterNames()[index];
            if (this.projectIdParamNames.contains(string)) {
                Intrinsics.checkNotNull((Object)arg, (String)"null cannot be cast to non-null type kotlin.String");
                projectId = (String)arg;
                continue;
            }
            if (this.subjectIdParamNames.contains(string)) {
                Intrinsics.checkNotNull((Object)arg, (String)"null cannot be cast to non-null type kotlin.String");
                subjectId = (String)arg;
                continue;
            }
            if (!this.sourceIdParamNames.contains(string)) continue;
            Intrinsics.checkNotNull((Object)arg, (String)"null cannot be cast to non-null type kotlin.String");
            sourceId = (String)arg;
        }
        Intrinsics.checkNotNullExpressionValue((Object)req, (String)"req");
        this.authorize(authorized, req, projectId, subjectId, sourceId);
    }

    public final void authorize(@NotNull Authorized authorized, @NotNull HttpServletRequest request, @Nullable String projectId, @Nullable String subjectId, @Nullable String sourceId) {
        Intrinsics.checkNotNullParameter((Object)authorized, (String)"authorized");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        logger.debug("Authorizing request...");
        T token = this.ensureToken(request);
        Authorization<T> authorization = this.authorization;
        String string = authorized.permission();
        String string2 = authorized.entity();
        PermissionOn permissionOn = authorized.permissionOn();
        String string3 = authorized.role();
        String[] stringArray = authorized.scopes();
        String[] stringArray2 = authorized.authorities();
        String[] stringArray3 = authorized.grantTypes();
        String[] stringArray4 = authorized.audiences();
        if (!authorization.authorize(token, string, string2, permissionOn, string3, stringArray, stringArray2, stringArray4, stringArray3, projectId, subjectId, sourceId)) {
            throw new ResourceForbiddenException("The requested resource is forbidden.", null, 2, null);
        }
        logger.debug("Setting the token in the request: {}", token);
        request.setAttribute(TOKEN_KEY, token);
    }

    private final T ensureToken(HttpServletRequest request) {
        T t;
        String tokenString = this.authValidator.getToken(request);
        if (tokenString == null) {
            logger.warn("[401] {}: No token bearer header provided in the request", (Object)request.getRequestURI());
            throw new AuthorizationFailedException("The token is missing from the request. No bearer token provided in the request", null, 2, null);
        }
        try {
            t = this.authValidator.verify(tokenString, request);
        }
        catch (Exception exc) {
            logger.warn("[401] {}: {}", (Object)request.getRequestURI(), (Object)exc.toString());
            throw new AuthorizationFailedException("Cannot verify token. It may have been rendered invalid.", exc);
        }
        T token = t;
        if (token == null) {
            logger.warn("[401] {}: Bearer token invalid", (Object)request.getRequestURI());
            throw new AuthorizationFailedException("Bearer token is not a valid JWT.", null, 2, null);
        }
        return token;
    }

    @JvmOverloads
    public AuthAspect(@NotNull AuthValidator<T> authValidator, @NotNull Authorization<T> authorization, @NotNull Set<String> projectIdParamNames, @NotNull Set<String> subjectIdParamNames) {
        Intrinsics.checkNotNullParameter(authValidator, (String)"authValidator");
        Intrinsics.checkNotNullParameter(authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter(projectIdParamNames, (String)"projectIdParamNames");
        Intrinsics.checkNotNullParameter(subjectIdParamNames, (String)"subjectIdParamNames");
        this(authValidator, authorization, projectIdParamNames, subjectIdParamNames, null, 16, null);
    }

    @JvmOverloads
    public AuthAspect(@NotNull AuthValidator<T> authValidator, @NotNull Authorization<T> authorization, @NotNull Set<String> projectIdParamNames) {
        Intrinsics.checkNotNullParameter(authValidator, (String)"authValidator");
        Intrinsics.checkNotNullParameter(authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter(projectIdParamNames, (String)"projectIdParamNames");
        this(authValidator, authorization, projectIdParamNames, null, null, 24, null);
    }

    @JvmOverloads
    public AuthAspect(@NotNull AuthValidator<T> authValidator, @NotNull Authorization<T> authorization) {
        Intrinsics.checkNotNullParameter(authValidator, (String)"authValidator");
        Intrinsics.checkNotNullParameter(authorization, (String)"authorization");
        this(authValidator, authorization, null, null, null, 28, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lradar/spring/auth/common/AuthAspect$Companion;", "", "()V", "PROJECT_ID_PARAMETER_NAME", "", "SOURCE_ID_PARAMETER_NAME", "SUBJECT_ID_PARAMETER_NAME", "TOKEN_KEY", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "radar-spring-auth"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

