/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminSleepSummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5194697211224882068L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminSleepSummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Sleep summaries are data records representing how long the user slept and the automatically classified sleep levels during that sleep event (e.g. light, deep periods) based on data generated by the user\u2019s device. Users may generate sleep data three different ways. Some older Garmin devices (e.g. first generation v\u00edvofit) allow users to manually place the device in sleep mode. Newer devices do not have this option and instead auto-detect sleep if it occurs between the user\u2019s Bed/Wake time range configured in Garmin Connect. Users may also self-report sleep information using Garmin Connect. Sleep records from the Health API are labelled to identify how the sleep data was generated (see below). This allows partners to accept/reject various methods of collecting Sleep data. Recommended usage for this field is to filter out validation types that are not desired rather than accept only certain validation types in order to prevent lost data in the future if new validation types are added, as by default Garmin Connect displays records of all possible types. Unlike Daily summaries which are associated with a given day on a midnight-to-midnight basis, Sleep summaries are associated with a user\u2019s overnight sleep range. Most will start on one calendar day and end on the next calendar day, but it is possible for two different Sleep summaries to begin on the same day if, for example, the user goes to bed after midnight, wakes up, and then goes to bed prior to midnight the next evening. The sleep summary will include REM sleep if the user\u2019s device is capable of REM sleep analysis. Users without REM-capable devices, or with REM-capable devices that have not been updated to REM-capable firmware, are limited to only deep, light, and awake sleep levels. Additionally, REM sleep will only be generated if the REM-capable devices is set as the preferred activity tracker and is actually worn during sleep. Some pulse-oximetry-enabled devices will generate SpO2 values during sleep for use in sleep analysis. If such values are generated, they are included in the sleep summary for reference.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the sleep in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The calendar date this summary would be displayed on in Garmin Connect in the local time zone of the device. The date format is \u2018yyyy-mm-dd\u2019.\",\"default\":null},{\"name\":\"startTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"duration\",\"type\":[\"null\",\"int\"],\"doc\":\"Length of the monitoring period in seconds. 86400 once a full day is complete, but less if a user syncs mid-day.\",\"default\":null},{\"name\":\"unmeasurableSleepDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Time in seconds that the sleep level of the user could not be measured. This may or may not correspond to off-wrist time.\",\"default\":null},{\"name\":\"deepSleepDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Time in seconds the user spent in deep sleep during the sleep period.\",\"default\":null},{\"name\":\"lightSleepDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Time in seconds the user spent in light sleep during the sleep period.\",\"default\":null},{\"name\":\"remSleepDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Time in seconds the user spent in REM sleep during the sleep period.\",\"default\":null},{\"name\":\"awakeDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Time in seconds the user spent awake during the sleep period.\",\"default\":null},{\"name\":\"validation\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"String that defines the validation state of the sleep data and its date range. The data could be auto-confirmed, but the sleep window could have been manually adjusted, or the sleep data itself is entirely manually entered. Possible values: MANUAL: The user entered sleep start and stop times manually through a web form. There is no device data backing up the sleep assessment. DEVICE: The user used a device with the sleep feature to manually start and stop sleep. This type still requires manual user intervention to specify sleep start and stop. AUTO_TENTATIVE: The sleep start and stop times were auto-detected by Garmin Connect using accelerometer data. However, refinements to this sleep record may come later. This could be because the user is still asleep or because the user owns multiple devices and might sync another device later for the same time period. AUTO_FINAL: The sleep start and stop times were auto-detected by Garmin Connect, and enough data has been gathered to finalize the window. This status also indicates that the user only has one device so this record can never be updated again \u2013 users that own multiple devices will never receive an AUTO_FINAL. AUTO_MANUAL: Sleep data was auto-detected by Garmin Connect, but the user is overriding the start and stop times or the user started with a manual entry and the sleep was auto-detected later. Garmin Connect stores both but will display the manual start and stop times in favor of the auto-detected times. ENHANCED_TENTATIVE: Sleep data was collected from a device capable of running an enhanced sleep analysis to detect REM sleep, but an updated sleep summary record may come later with further refinements or a greater sleep period. ENHANCED_FINAL: Sleep data was collected from a device capable of running an enhanced sleep analysis to detect REM sleep with no further updates.\",\"default\":null},{\"name\":\"overallSleepScoreValue\",\"type\":[\"null\",\"int\"],\"doc\":\"The quantitative value of the overall sleep score.\",\"default\":null},{\"name\":\"overallSleepScoreQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The sleep scores will have a qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR that is used as a qualitative description of the user\u2019s period of sleep.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminSleepSummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminSleepSummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private String date;
    private Integer startTimeOffset;
    private Integer duration;
    private Integer unmeasurableSleepDuration;
    private Integer deepSleepDuration;
    private Integer lightSleepDuration;
    private Integer remSleepDuration;
    private Integer awakeDuration;
    private String validation;
    private Integer overallSleepScoreValue;
    private String overallSleepScoreQualifier;
    private static final DatumWriter<GarminSleepSummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminSleepSummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminSleepSummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminSleepSummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminSleepSummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminSleepSummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminSleepSummary)((Object)DECODER.decode(b));
    }

    public GarminSleepSummary() {
    }

    public GarminSleepSummary(Double time, Double timeReceived, String summaryId, String date, Integer startTimeOffset, Integer duration, Integer unmeasurableSleepDuration, Integer deepSleepDuration, Integer lightSleepDuration, Integer remSleepDuration, Integer awakeDuration, String validation, Integer overallSleepScoreValue, String overallSleepScoreQualifier) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.date = date;
        this.startTimeOffset = startTimeOffset;
        this.duration = duration;
        this.unmeasurableSleepDuration = unmeasurableSleepDuration;
        this.deepSleepDuration = deepSleepDuration;
        this.lightSleepDuration = lightSleepDuration;
        this.remSleepDuration = remSleepDuration;
        this.awakeDuration = awakeDuration;
        this.validation = validation;
        this.overallSleepScoreValue = overallSleepScoreValue;
        this.overallSleepScoreQualifier = overallSleepScoreQualifier;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.date;
            }
            case 4: {
                return this.startTimeOffset;
            }
            case 5: {
                return this.duration;
            }
            case 6: {
                return this.unmeasurableSleepDuration;
            }
            case 7: {
                return this.deepSleepDuration;
            }
            case 8: {
                return this.lightSleepDuration;
            }
            case 9: {
                return this.remSleepDuration;
            }
            case 10: {
                return this.awakeDuration;
            }
            case 11: {
                return this.validation;
            }
            case 12: {
                return this.overallSleepScoreValue;
            }
            case 13: {
                return this.overallSleepScoreQualifier;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.startTimeOffset = (Integer)value$;
                break;
            }
            case 5: {
                this.duration = (Integer)value$;
                break;
            }
            case 6: {
                this.unmeasurableSleepDuration = (Integer)value$;
                break;
            }
            case 7: {
                this.deepSleepDuration = (Integer)value$;
                break;
            }
            case 8: {
                this.lightSleepDuration = (Integer)value$;
                break;
            }
            case 9: {
                this.remSleepDuration = (Integer)value$;
                break;
            }
            case 10: {
                this.awakeDuration = (Integer)value$;
                break;
            }
            case 11: {
                this.validation = value$ != null ? value$.toString() : null;
                break;
            }
            case 12: {
                this.overallSleepScoreValue = (Integer)value$;
                break;
            }
            case 13: {
                this.overallSleepScoreQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public Integer getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(Integer value) {
        this.startTimeOffset = value;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer value) {
        this.duration = value;
    }

    public Integer getUnmeasurableSleepDuration() {
        return this.unmeasurableSleepDuration;
    }

    public void setUnmeasurableSleepDuration(Integer value) {
        this.unmeasurableSleepDuration = value;
    }

    public Integer getDeepSleepDuration() {
        return this.deepSleepDuration;
    }

    public void setDeepSleepDuration(Integer value) {
        this.deepSleepDuration = value;
    }

    public Integer getLightSleepDuration() {
        return this.lightSleepDuration;
    }

    public void setLightSleepDuration(Integer value) {
        this.lightSleepDuration = value;
    }

    public Integer getRemSleepDuration() {
        return this.remSleepDuration;
    }

    public void setRemSleepDuration(Integer value) {
        this.remSleepDuration = value;
    }

    public Integer getAwakeDuration() {
        return this.awakeDuration;
    }

    public void setAwakeDuration(Integer value) {
        this.awakeDuration = value;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String value) {
        this.validation = value;
    }

    public Integer getOverallSleepScoreValue() {
        return this.overallSleepScoreValue;
    }

    public void setOverallSleepScoreValue(Integer value) {
        this.overallSleepScoreValue = value;
    }

    public String getOverallSleepScoreQualifier() {
        return this.overallSleepScoreQualifier;
    }

    public void setOverallSleepScoreQualifier(String value) {
        this.overallSleepScoreQualifier = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminSleepSummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.date == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.date);
        }
        if (this.startTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.startTimeOffset.intValue());
        }
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.duration.intValue());
        }
        if (this.unmeasurableSleepDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.unmeasurableSleepDuration.intValue());
        }
        if (this.deepSleepDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.deepSleepDuration.intValue());
        }
        if (this.lightSleepDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.lightSleepDuration.intValue());
        }
        if (this.remSleepDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.remSleepDuration.intValue());
        }
        if (this.awakeDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.awakeDuration.intValue());
        }
        if (this.validation == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.validation);
        }
        if (this.overallSleepScoreValue == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.overallSleepScoreValue.intValue());
        }
        if (this.overallSleepScoreQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.overallSleepScoreQualifier);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.date = null;
            } else {
                this.date = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.startTimeOffset = null;
            } else {
                this.startTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.unmeasurableSleepDuration = null;
            } else {
                this.unmeasurableSleepDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.deepSleepDuration = null;
            } else {
                this.deepSleepDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lightSleepDuration = null;
            } else {
                this.lightSleepDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.remSleepDuration = null;
            } else {
                this.remSleepDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.awakeDuration = null;
            } else {
                this.awakeDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.validation = null;
            } else {
                this.validation = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.overallSleepScoreValue = null;
            } else {
                this.overallSleepScoreValue = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.overallSleepScoreQualifier = null;
            } else {
                this.overallSleepScoreQualifier = in.readString();
            }
        } else {
            block16: for (int i = 0; i < 14; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block16;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block16;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block16;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.date = null;
                            continue block16;
                        }
                        this.date = in.readString();
                        continue block16;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startTimeOffset = null;
                            continue block16;
                        }
                        this.startTimeOffset = in.readInt();
                        continue block16;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block16;
                        }
                        this.duration = in.readInt();
                        continue block16;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.unmeasurableSleepDuration = null;
                            continue block16;
                        }
                        this.unmeasurableSleepDuration = in.readInt();
                        continue block16;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.deepSleepDuration = null;
                            continue block16;
                        }
                        this.deepSleepDuration = in.readInt();
                        continue block16;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lightSleepDuration = null;
                            continue block16;
                        }
                        this.lightSleepDuration = in.readInt();
                        continue block16;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.remSleepDuration = null;
                            continue block16;
                        }
                        this.remSleepDuration = in.readInt();
                        continue block16;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.awakeDuration = null;
                            continue block16;
                        }
                        this.awakeDuration = in.readInt();
                        continue block16;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.validation = null;
                            continue block16;
                        }
                        this.validation = in.readString();
                        continue block16;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.overallSleepScoreValue = null;
                            continue block16;
                        }
                        this.overallSleepScoreValue = in.readInt();
                        continue block16;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.overallSleepScoreQualifier = null;
                            continue block16;
                        }
                        this.overallSleepScoreQualifier = in.readString();
                        continue block16;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminSleepSummary>
    implements RecordBuilder<GarminSleepSummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private String date;
        private Integer startTimeOffset;
        private Integer duration;
        private Integer unmeasurableSleepDuration;
        private Integer deepSleepDuration;
        private Integer lightSleepDuration;
        private Integer remSleepDuration;
        private Integer awakeDuration;
        private String validation;
        private Integer overallSleepScoreValue;
        private String overallSleepScoreQualifier;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.duration);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.unmeasurableSleepDuration)) {
                this.unmeasurableSleepDuration = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.unmeasurableSleepDuration);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.deepSleepDuration)) {
                this.deepSleepDuration = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.deepSleepDuration);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.lightSleepDuration)) {
                this.lightSleepDuration = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.lightSleepDuration);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.remSleepDuration)) {
                this.remSleepDuration = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.remSleepDuration);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.awakeDuration)) {
                this.awakeDuration = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.awakeDuration);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.validation)) {
                this.validation = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.validation);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.overallSleepScoreValue)) {
                this.overallSleepScoreValue = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.overallSleepScoreValue);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.overallSleepScoreQualifier)) {
                this.overallSleepScoreQualifier = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.overallSleepScoreQualifier);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
        }

        private Builder(GarminSleepSummary other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.duration);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.unmeasurableSleepDuration)) {
                this.unmeasurableSleepDuration = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.unmeasurableSleepDuration);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.deepSleepDuration)) {
                this.deepSleepDuration = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.deepSleepDuration);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.lightSleepDuration)) {
                this.lightSleepDuration = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.lightSleepDuration);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.remSleepDuration)) {
                this.remSleepDuration = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.remSleepDuration);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.awakeDuration)) {
                this.awakeDuration = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.awakeDuration);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.validation)) {
                this.validation = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.validation);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.overallSleepScoreValue)) {
                this.overallSleepScoreValue = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.overallSleepScoreValue);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.overallSleepScoreQualifier)) {
                this.overallSleepScoreQualifier = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.overallSleepScoreQualifier);
                this.fieldSetFlags()[13] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[3], value);
            this.date = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public Builder setStartTimeOffset(Integer value) {
            this.validate(this.fields()[4], value);
            this.startTimeOffset = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStartTimeOffset() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStartTimeOffset() {
            this.startTimeOffset = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Builder setDuration(Integer value) {
            this.validate(this.fields()[5], value);
            this.duration = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getUnmeasurableSleepDuration() {
            return this.unmeasurableSleepDuration;
        }

        public Builder setUnmeasurableSleepDuration(Integer value) {
            this.validate(this.fields()[6], value);
            this.unmeasurableSleepDuration = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasUnmeasurableSleepDuration() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearUnmeasurableSleepDuration() {
            this.unmeasurableSleepDuration = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getDeepSleepDuration() {
            return this.deepSleepDuration;
        }

        public Builder setDeepSleepDuration(Integer value) {
            this.validate(this.fields()[7], value);
            this.deepSleepDuration = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasDeepSleepDuration() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearDeepSleepDuration() {
            this.deepSleepDuration = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getLightSleepDuration() {
            return this.lightSleepDuration;
        }

        public Builder setLightSleepDuration(Integer value) {
            this.validate(this.fields()[8], value);
            this.lightSleepDuration = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasLightSleepDuration() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearLightSleepDuration() {
            this.lightSleepDuration = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getRemSleepDuration() {
            return this.remSleepDuration;
        }

        public Builder setRemSleepDuration(Integer value) {
            this.validate(this.fields()[9], value);
            this.remSleepDuration = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasRemSleepDuration() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearRemSleepDuration() {
            this.remSleepDuration = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getAwakeDuration() {
            return this.awakeDuration;
        }

        public Builder setAwakeDuration(Integer value) {
            this.validate(this.fields()[10], value);
            this.awakeDuration = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasAwakeDuration() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearAwakeDuration() {
            this.awakeDuration = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public String getValidation() {
            return this.validation;
        }

        public Builder setValidation(String value) {
            this.validate(this.fields()[11], value);
            this.validation = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasValidation() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearValidation() {
            this.validation = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Integer getOverallSleepScoreValue() {
            return this.overallSleepScoreValue;
        }

        public Builder setOverallSleepScoreValue(Integer value) {
            this.validate(this.fields()[12], value);
            this.overallSleepScoreValue = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasOverallSleepScoreValue() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearOverallSleepScoreValue() {
            this.overallSleepScoreValue = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public String getOverallSleepScoreQualifier() {
            return this.overallSleepScoreQualifier;
        }

        public Builder setOverallSleepScoreQualifier(String value) {
            this.validate(this.fields()[13], value);
            this.overallSleepScoreQualifier = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasOverallSleepScoreQualifier() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearOverallSleepScoreQualifier() {
            this.overallSleepScoreQualifier = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public GarminSleepSummary build() {
            try {
                GarminSleepSummary record = new GarminSleepSummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.date = this.fieldSetFlags()[3] ? this.date : (String)this.defaultValue(this.fields()[3]);
                record.startTimeOffset = this.fieldSetFlags()[4] ? this.startTimeOffset : (Integer)this.defaultValue(this.fields()[4]);
                record.duration = this.fieldSetFlags()[5] ? this.duration : (Integer)this.defaultValue(this.fields()[5]);
                record.unmeasurableSleepDuration = this.fieldSetFlags()[6] ? this.unmeasurableSleepDuration : (Integer)this.defaultValue(this.fields()[6]);
                record.deepSleepDuration = this.fieldSetFlags()[7] ? this.deepSleepDuration : (Integer)this.defaultValue(this.fields()[7]);
                record.lightSleepDuration = this.fieldSetFlags()[8] ? this.lightSleepDuration : (Integer)this.defaultValue(this.fields()[8]);
                record.remSleepDuration = this.fieldSetFlags()[9] ? this.remSleepDuration : (Integer)this.defaultValue(this.fields()[9]);
                record.awakeDuration = this.fieldSetFlags()[10] ? this.awakeDuration : (Integer)this.defaultValue(this.fields()[10]);
                record.validation = this.fieldSetFlags()[11] ? this.validation : (String)this.defaultValue(this.fields()[11]);
                record.overallSleepScoreValue = this.fieldSetFlags()[12] ? this.overallSleepScoreValue : (Integer)this.defaultValue(this.fields()[12]);
                record.overallSleepScoreQualifier = this.fieldSetFlags()[13] ? this.overallSleepScoreQualifier : (String)this.defaultValue(this.fields()[13]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

