/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminHealthSnapshotSummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 382472937308094710L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminHealthSnapshotSummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"The Garmin Health Snapshot is a collection of key health-related insights recorded during a two-minute session on a compatible device. Heart rate (HR), heart rate variability (HRV), Pulse Ox, respiration, and stress are the metrics included this summary, which collectively provide you a glimpse of your overall cardiovascular status. More information about Health Snapshot can be found at https://support.garmin.com/en-US/?faq=PB1duL5p6V64IQwhNvcRK9.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The calendar date this summary would be displayed on in Garmin Connect in the local time zone of the device. The date format is \u2018yyyy-mm-dd\u2019.\",\"default\":null},{\"name\":\"startTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"rmssdHrvAverage\",\"type\":[\"null\",\"float\"],\"doc\":\"Average value of RMSSD HRV for this snapshot. RMSSD stands for the root mean square of successive differences between normal heartbeats.\",\"default\":null},{\"name\":\"sdrrHrvAverage\",\"type\":[\"null\",\"float\"],\"doc\":\"Average value of SDRR HRV for this snapshot. SDRR is the standard deviation in time between heartbeats, which is sometimes referred to as the 'RR interval'.\",\"default\":null},{\"name\":\"heartRateAverage\",\"type\":[\"null\",\"float\"],\"doc\":\"Average value of Heart Rate for this snapshot.\",\"default\":null},{\"name\":\"heartRateMin\",\"type\":[\"null\",\"float\"],\"doc\":\"Minimum value of Heart Rate for this snapshot.\",\"default\":null},{\"name\":\"heartRateMax\",\"type\":[\"null\",\"float\"],\"doc\":\"Maximum value of Heart Rate for this snapshot.\",\"default\":null},{\"name\":\"respirationAverage\",\"type\":[\"null\",\"float\"],\"doc\":\"Average value of respiration rate for this snapshot.\",\"default\":null},{\"name\":\"respirationMin\",\"type\":[\"null\",\"float\"],\"doc\":\"Minimum value of respiration rate for this snapshot.\",\"default\":null},{\"name\":\"respirationMax\",\"type\":[\"null\",\"float\"],\"doc\":\"Maximum value of respiration rate for this snapshot.\",\"default\":null},{\"name\":\"stressAverage\",\"type\":[\"null\",\"float\"],\"doc\":\"Average value of stress for this snapshot.\",\"default\":null},{\"name\":\"stressMin\",\"type\":[\"null\",\"float\"],\"doc\":\"Minimum value of stress for this snapshot.\",\"default\":null},{\"name\":\"stressMax\",\"type\":[\"null\",\"float\"],\"doc\":\"Maximum value of stress for this snapshot.\",\"default\":null},{\"name\":\"spo2Average\",\"type\":[\"null\",\"float\"],\"doc\":\"Average value of pulse ox (spo2) for this snapshot.\",\"default\":null},{\"name\":\"spo2Min\",\"type\":[\"null\",\"float\"],\"doc\":\"Minimum value of pulse ox (spo2) for this snapshot.\",\"default\":null},{\"name\":\"spo2Max\",\"type\":[\"null\",\"float\"],\"doc\":\"Maximum value of pulse ox (spo2) for this snapshot.\",\"default\":null},{\"name\":\"duration\",\"type\":[\"null\",\"int\"],\"doc\":\"The duration of the measurement period in seconds.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminHealthSnapshotSummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminHealthSnapshotSummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private String date;
    private Integer startTimeOffset;
    private Float rmssdHrvAverage;
    private Float sdrrHrvAverage;
    private Float heartRateAverage;
    private Float heartRateMin;
    private Float heartRateMax;
    private Float respirationAverage;
    private Float respirationMin;
    private Float respirationMax;
    private Float stressAverage;
    private Float stressMin;
    private Float stressMax;
    private Float spo2Average;
    private Float spo2Min;
    private Float spo2Max;
    private Integer duration;
    private static final DatumWriter<GarminHealthSnapshotSummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminHealthSnapshotSummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminHealthSnapshotSummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminHealthSnapshotSummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminHealthSnapshotSummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminHealthSnapshotSummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminHealthSnapshotSummary)((Object)DECODER.decode(b));
    }

    public GarminHealthSnapshotSummary() {
    }

    public GarminHealthSnapshotSummary(Double time, Double timeReceived, String summaryId, String date, Integer startTimeOffset, Float rmssdHrvAverage, Float sdrrHrvAverage, Float heartRateAverage, Float heartRateMin, Float heartRateMax, Float respirationAverage, Float respirationMin, Float respirationMax, Float stressAverage, Float stressMin, Float stressMax, Float spo2Average, Float spo2Min, Float spo2Max, Integer duration) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.date = date;
        this.startTimeOffset = startTimeOffset;
        this.rmssdHrvAverage = rmssdHrvAverage;
        this.sdrrHrvAverage = sdrrHrvAverage;
        this.heartRateAverage = heartRateAverage;
        this.heartRateMin = heartRateMin;
        this.heartRateMax = heartRateMax;
        this.respirationAverage = respirationAverage;
        this.respirationMin = respirationMin;
        this.respirationMax = respirationMax;
        this.stressAverage = stressAverage;
        this.stressMin = stressMin;
        this.stressMax = stressMax;
        this.spo2Average = spo2Average;
        this.spo2Min = spo2Min;
        this.spo2Max = spo2Max;
        this.duration = duration;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.date;
            }
            case 4: {
                return this.startTimeOffset;
            }
            case 5: {
                return this.rmssdHrvAverage;
            }
            case 6: {
                return this.sdrrHrvAverage;
            }
            case 7: {
                return this.heartRateAverage;
            }
            case 8: {
                return this.heartRateMin;
            }
            case 9: {
                return this.heartRateMax;
            }
            case 10: {
                return this.respirationAverage;
            }
            case 11: {
                return this.respirationMin;
            }
            case 12: {
                return this.respirationMax;
            }
            case 13: {
                return this.stressAverage;
            }
            case 14: {
                return this.stressMin;
            }
            case 15: {
                return this.stressMax;
            }
            case 16: {
                return this.spo2Average;
            }
            case 17: {
                return this.spo2Min;
            }
            case 18: {
                return this.spo2Max;
            }
            case 19: {
                return this.duration;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.startTimeOffset = (Integer)value$;
                break;
            }
            case 5: {
                this.rmssdHrvAverage = (Float)value$;
                break;
            }
            case 6: {
                this.sdrrHrvAverage = (Float)value$;
                break;
            }
            case 7: {
                this.heartRateAverage = (Float)value$;
                break;
            }
            case 8: {
                this.heartRateMin = (Float)value$;
                break;
            }
            case 9: {
                this.heartRateMax = (Float)value$;
                break;
            }
            case 10: {
                this.respirationAverage = (Float)value$;
                break;
            }
            case 11: {
                this.respirationMin = (Float)value$;
                break;
            }
            case 12: {
                this.respirationMax = (Float)value$;
                break;
            }
            case 13: {
                this.stressAverage = (Float)value$;
                break;
            }
            case 14: {
                this.stressMin = (Float)value$;
                break;
            }
            case 15: {
                this.stressMax = (Float)value$;
                break;
            }
            case 16: {
                this.spo2Average = (Float)value$;
                break;
            }
            case 17: {
                this.spo2Min = (Float)value$;
                break;
            }
            case 18: {
                this.spo2Max = (Float)value$;
                break;
            }
            case 19: {
                this.duration = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public Integer getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(Integer value) {
        this.startTimeOffset = value;
    }

    public Float getRmssdHrvAverage() {
        return this.rmssdHrvAverage;
    }

    public void setRmssdHrvAverage(Float value) {
        this.rmssdHrvAverage = value;
    }

    public Float getSdrrHrvAverage() {
        return this.sdrrHrvAverage;
    }

    public void setSdrrHrvAverage(Float value) {
        this.sdrrHrvAverage = value;
    }

    public Float getHeartRateAverage() {
        return this.heartRateAverage;
    }

    public void setHeartRateAverage(Float value) {
        this.heartRateAverage = value;
    }

    public Float getHeartRateMin() {
        return this.heartRateMin;
    }

    public void setHeartRateMin(Float value) {
        this.heartRateMin = value;
    }

    public Float getHeartRateMax() {
        return this.heartRateMax;
    }

    public void setHeartRateMax(Float value) {
        this.heartRateMax = value;
    }

    public Float getRespirationAverage() {
        return this.respirationAverage;
    }

    public void setRespirationAverage(Float value) {
        this.respirationAverage = value;
    }

    public Float getRespirationMin() {
        return this.respirationMin;
    }

    public void setRespirationMin(Float value) {
        this.respirationMin = value;
    }

    public Float getRespirationMax() {
        return this.respirationMax;
    }

    public void setRespirationMax(Float value) {
        this.respirationMax = value;
    }

    public Float getStressAverage() {
        return this.stressAverage;
    }

    public void setStressAverage(Float value) {
        this.stressAverage = value;
    }

    public Float getStressMin() {
        return this.stressMin;
    }

    public void setStressMin(Float value) {
        this.stressMin = value;
    }

    public Float getStressMax() {
        return this.stressMax;
    }

    public void setStressMax(Float value) {
        this.stressMax = value;
    }

    public Float getSpo2Average() {
        return this.spo2Average;
    }

    public void setSpo2Average(Float value) {
        this.spo2Average = value;
    }

    public Float getSpo2Min() {
        return this.spo2Min;
    }

    public void setSpo2Min(Float value) {
        this.spo2Min = value;
    }

    public Float getSpo2Max() {
        return this.spo2Max;
    }

    public void setSpo2Max(Float value) {
        this.spo2Max = value;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer value) {
        this.duration = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminHealthSnapshotSummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.date == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.date);
        }
        if (this.startTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.startTimeOffset.intValue());
        }
        if (this.rmssdHrvAverage == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.rmssdHrvAverage.floatValue());
        }
        if (this.sdrrHrvAverage == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.sdrrHrvAverage.floatValue());
        }
        if (this.heartRateAverage == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.heartRateAverage.floatValue());
        }
        if (this.heartRateMin == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.heartRateMin.floatValue());
        }
        if (this.heartRateMax == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.heartRateMax.floatValue());
        }
        if (this.respirationAverage == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.respirationAverage.floatValue());
        }
        if (this.respirationMin == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.respirationMin.floatValue());
        }
        if (this.respirationMax == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.respirationMax.floatValue());
        }
        if (this.stressAverage == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.stressAverage.floatValue());
        }
        if (this.stressMin == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.stressMin.floatValue());
        }
        if (this.stressMax == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.stressMax.floatValue());
        }
        if (this.spo2Average == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.spo2Average.floatValue());
        }
        if (this.spo2Min == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.spo2Min.floatValue());
        }
        if (this.spo2Max == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.spo2Max.floatValue());
        }
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.duration.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.date = null;
            } else {
                this.date = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.startTimeOffset = null;
            } else {
                this.startTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.rmssdHrvAverage = null;
            } else {
                this.rmssdHrvAverage = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.sdrrHrvAverage = null;
            } else {
                this.sdrrHrvAverage = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.heartRateAverage = null;
            } else {
                this.heartRateAverage = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.heartRateMin = null;
            } else {
                this.heartRateMin = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.heartRateMax = null;
            } else {
                this.heartRateMax = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.respirationAverage = null;
            } else {
                this.respirationAverage = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.respirationMin = null;
            } else {
                this.respirationMin = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.respirationMax = null;
            } else {
                this.respirationMax = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stressAverage = null;
            } else {
                this.stressAverage = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stressMin = null;
            } else {
                this.stressMin = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stressMax = null;
            } else {
                this.stressMax = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.spo2Average = null;
            } else {
                this.spo2Average = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.spo2Min = null;
            } else {
                this.spo2Min = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.spo2Max = null;
            } else {
                this.spo2Max = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = in.readInt();
            }
        } else {
            block22: for (int i = 0; i < 20; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block22;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block22;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block22;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.date = null;
                            continue block22;
                        }
                        this.date = in.readString();
                        continue block22;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startTimeOffset = null;
                            continue block22;
                        }
                        this.startTimeOffset = in.readInt();
                        continue block22;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.rmssdHrvAverage = null;
                            continue block22;
                        }
                        this.rmssdHrvAverage = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.sdrrHrvAverage = null;
                            continue block22;
                        }
                        this.sdrrHrvAverage = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.heartRateAverage = null;
                            continue block22;
                        }
                        this.heartRateAverage = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.heartRateMin = null;
                            continue block22;
                        }
                        this.heartRateMin = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.heartRateMax = null;
                            continue block22;
                        }
                        this.heartRateMax = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.respirationAverage = null;
                            continue block22;
                        }
                        this.respirationAverage = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.respirationMin = null;
                            continue block22;
                        }
                        this.respirationMin = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.respirationMax = null;
                            continue block22;
                        }
                        this.respirationMax = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stressAverage = null;
                            continue block22;
                        }
                        this.stressAverage = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stressMin = null;
                            continue block22;
                        }
                        this.stressMin = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stressMax = null;
                            continue block22;
                        }
                        this.stressMax = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.spo2Average = null;
                            continue block22;
                        }
                        this.spo2Average = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 17: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.spo2Min = null;
                            continue block22;
                        }
                        this.spo2Min = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 18: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.spo2Max = null;
                            continue block22;
                        }
                        this.spo2Max = Float.valueOf(in.readFloat());
                        continue block22;
                    }
                    case 19: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block22;
                        }
                        this.duration = in.readInt();
                        continue block22;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminHealthSnapshotSummary>
    implements RecordBuilder<GarminHealthSnapshotSummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private String date;
        private Integer startTimeOffset;
        private Float rmssdHrvAverage;
        private Float sdrrHrvAverage;
        private Float heartRateAverage;
        private Float heartRateMin;
        private Float heartRateMax;
        private Float respirationAverage;
        private Float respirationMin;
        private Float respirationMax;
        private Float stressAverage;
        private Float stressMin;
        private Float stressMax;
        private Float spo2Average;
        private Float spo2Min;
        private Float spo2Max;
        private Integer duration;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.rmssdHrvAverage)) {
                this.rmssdHrvAverage = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.rmssdHrvAverage);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.sdrrHrvAverage)) {
                this.sdrrHrvAverage = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sdrrHrvAverage);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.heartRateAverage)) {
                this.heartRateAverage = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.heartRateAverage);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.heartRateMin)) {
                this.heartRateMin = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.heartRateMin);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.heartRateMax)) {
                this.heartRateMax = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.heartRateMax);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.respirationAverage)) {
                this.respirationAverage = (Float)this.data().deepCopy(this.fields()[10].schema(), (Object)other.respirationAverage);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.respirationMin)) {
                this.respirationMin = (Float)this.data().deepCopy(this.fields()[11].schema(), (Object)other.respirationMin);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.respirationMax)) {
                this.respirationMax = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.respirationMax);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.stressAverage)) {
                this.stressAverage = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.stressAverage);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.stressMin)) {
                this.stressMin = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.stressMin);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.stressMax)) {
                this.stressMax = (Float)this.data().deepCopy(this.fields()[15].schema(), (Object)other.stressMax);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.spo2Average)) {
                this.spo2Average = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.spo2Average);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.spo2Min)) {
                this.spo2Min = (Float)this.data().deepCopy(this.fields()[17].schema(), (Object)other.spo2Min);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.spo2Max)) {
                this.spo2Max = (Float)this.data().deepCopy(this.fields()[18].schema(), (Object)other.spo2Max);
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.duration);
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
        }

        private Builder(GarminHealthSnapshotSummary other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.rmssdHrvAverage)) {
                this.rmssdHrvAverage = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.rmssdHrvAverage);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.sdrrHrvAverage)) {
                this.sdrrHrvAverage = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sdrrHrvAverage);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.heartRateAverage)) {
                this.heartRateAverage = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.heartRateAverage);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.heartRateMin)) {
                this.heartRateMin = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.heartRateMin);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.heartRateMax)) {
                this.heartRateMax = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.heartRateMax);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.respirationAverage)) {
                this.respirationAverage = (Float)this.data().deepCopy(this.fields()[10].schema(), (Object)other.respirationAverage);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.respirationMin)) {
                this.respirationMin = (Float)this.data().deepCopy(this.fields()[11].schema(), (Object)other.respirationMin);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.respirationMax)) {
                this.respirationMax = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.respirationMax);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.stressAverage)) {
                this.stressAverage = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.stressAverage);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.stressMin)) {
                this.stressMin = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.stressMin);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.stressMax)) {
                this.stressMax = (Float)this.data().deepCopy(this.fields()[15].schema(), (Object)other.stressMax);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.spo2Average)) {
                this.spo2Average = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.spo2Average);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.spo2Min)) {
                this.spo2Min = (Float)this.data().deepCopy(this.fields()[17].schema(), (Object)other.spo2Min);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.spo2Max)) {
                this.spo2Max = (Float)this.data().deepCopy(this.fields()[18].schema(), (Object)other.spo2Max);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.duration);
                this.fieldSetFlags()[19] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[3], value);
            this.date = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public Builder setStartTimeOffset(Integer value) {
            this.validate(this.fields()[4], value);
            this.startTimeOffset = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStartTimeOffset() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStartTimeOffset() {
            this.startTimeOffset = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Float getRmssdHrvAverage() {
            return this.rmssdHrvAverage;
        }

        public Builder setRmssdHrvAverage(Float value) {
            this.validate(this.fields()[5], value);
            this.rmssdHrvAverage = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasRmssdHrvAverage() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearRmssdHrvAverage() {
            this.rmssdHrvAverage = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getSdrrHrvAverage() {
            return this.sdrrHrvAverage;
        }

        public Builder setSdrrHrvAverage(Float value) {
            this.validate(this.fields()[6], value);
            this.sdrrHrvAverage = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSdrrHrvAverage() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearSdrrHrvAverage() {
            this.sdrrHrvAverage = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getHeartRateAverage() {
            return this.heartRateAverage;
        }

        public Builder setHeartRateAverage(Float value) {
            this.validate(this.fields()[7], value);
            this.heartRateAverage = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasHeartRateAverage() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearHeartRateAverage() {
            this.heartRateAverage = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getHeartRateMin() {
            return this.heartRateMin;
        }

        public Builder setHeartRateMin(Float value) {
            this.validate(this.fields()[8], value);
            this.heartRateMin = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasHeartRateMin() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearHeartRateMin() {
            this.heartRateMin = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Float getHeartRateMax() {
            return this.heartRateMax;
        }

        public Builder setHeartRateMax(Float value) {
            this.validate(this.fields()[9], value);
            this.heartRateMax = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasHeartRateMax() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearHeartRateMax() {
            this.heartRateMax = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Float getRespirationAverage() {
            return this.respirationAverage;
        }

        public Builder setRespirationAverage(Float value) {
            this.validate(this.fields()[10], value);
            this.respirationAverage = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasRespirationAverage() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearRespirationAverage() {
            this.respirationAverage = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Float getRespirationMin() {
            return this.respirationMin;
        }

        public Builder setRespirationMin(Float value) {
            this.validate(this.fields()[11], value);
            this.respirationMin = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasRespirationMin() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearRespirationMin() {
            this.respirationMin = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Float getRespirationMax() {
            return this.respirationMax;
        }

        public Builder setRespirationMax(Float value) {
            this.validate(this.fields()[12], value);
            this.respirationMax = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasRespirationMax() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearRespirationMax() {
            this.respirationMax = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Float getStressAverage() {
            return this.stressAverage;
        }

        public Builder setStressAverage(Float value) {
            this.validate(this.fields()[13], value);
            this.stressAverage = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasStressAverage() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearStressAverage() {
            this.stressAverage = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Float getStressMin() {
            return this.stressMin;
        }

        public Builder setStressMin(Float value) {
            this.validate(this.fields()[14], value);
            this.stressMin = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasStressMin() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearStressMin() {
            this.stressMin = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Float getStressMax() {
            return this.stressMax;
        }

        public Builder setStressMax(Float value) {
            this.validate(this.fields()[15], value);
            this.stressMax = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasStressMax() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearStressMax() {
            this.stressMax = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Float getSpo2Average() {
            return this.spo2Average;
        }

        public Builder setSpo2Average(Float value) {
            this.validate(this.fields()[16], value);
            this.spo2Average = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasSpo2Average() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearSpo2Average() {
            this.spo2Average = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Float getSpo2Min() {
            return this.spo2Min;
        }

        public Builder setSpo2Min(Float value) {
            this.validate(this.fields()[17], value);
            this.spo2Min = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasSpo2Min() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearSpo2Min() {
            this.spo2Min = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Float getSpo2Max() {
            return this.spo2Max;
        }

        public Builder setSpo2Max(Float value) {
            this.validate(this.fields()[18], value);
            this.spo2Max = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasSpo2Max() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearSpo2Max() {
            this.spo2Max = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Builder setDuration(Integer value) {
            this.validate(this.fields()[19], value);
            this.duration = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public GarminHealthSnapshotSummary build() {
            try {
                GarminHealthSnapshotSummary record = new GarminHealthSnapshotSummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.date = this.fieldSetFlags()[3] ? this.date : (String)this.defaultValue(this.fields()[3]);
                record.startTimeOffset = this.fieldSetFlags()[4] ? this.startTimeOffset : (Integer)this.defaultValue(this.fields()[4]);
                record.rmssdHrvAverage = this.fieldSetFlags()[5] ? this.rmssdHrvAverage : (Float)this.defaultValue(this.fields()[5]);
                record.sdrrHrvAverage = this.fieldSetFlags()[6] ? this.sdrrHrvAverage : (Float)this.defaultValue(this.fields()[6]);
                record.heartRateAverage = this.fieldSetFlags()[7] ? this.heartRateAverage : (Float)this.defaultValue(this.fields()[7]);
                record.heartRateMin = this.fieldSetFlags()[8] ? this.heartRateMin : (Float)this.defaultValue(this.fields()[8]);
                record.heartRateMax = this.fieldSetFlags()[9] ? this.heartRateMax : (Float)this.defaultValue(this.fields()[9]);
                record.respirationAverage = this.fieldSetFlags()[10] ? this.respirationAverage : (Float)this.defaultValue(this.fields()[10]);
                record.respirationMin = this.fieldSetFlags()[11] ? this.respirationMin : (Float)this.defaultValue(this.fields()[11]);
                record.respirationMax = this.fieldSetFlags()[12] ? this.respirationMax : (Float)this.defaultValue(this.fields()[12]);
                record.stressAverage = this.fieldSetFlags()[13] ? this.stressAverage : (Float)this.defaultValue(this.fields()[13]);
                record.stressMin = this.fieldSetFlags()[14] ? this.stressMin : (Float)this.defaultValue(this.fields()[14]);
                record.stressMax = this.fieldSetFlags()[15] ? this.stressMax : (Float)this.defaultValue(this.fields()[15]);
                record.spo2Average = this.fieldSetFlags()[16] ? this.spo2Average : (Float)this.defaultValue(this.fields()[16]);
                record.spo2Min = this.fieldSetFlags()[17] ? this.spo2Min : (Float)this.defaultValue(this.fields()[17]);
                record.spo2Max = this.fieldSetFlags()[18] ? this.spo2Max : (Float)this.defaultValue(this.fields()[18]);
                record.duration = this.fieldSetFlags()[19] ? this.duration : (Integer)this.defaultValue(this.fields()[19]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

