/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminEpochSummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -6216416359126527383L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminEpochSummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"The Epoch Summary contains wellness data for a specific time range. Epoch summary records contain much of the same data available in Daily summaries, but with 15-minute time-slice granularity. There is one record for each activity type monitored within an individual epoch. For example, if the user was sedentary for five minutes, walked for five minutes, and then ran for five minutes over the course of 15 minutes, three activity records would be generated for that single 15-minute epoch. The duration value would be 900 seconds for all three records, but the active time for each would be 300 seconds. A duration of less than 900 seconds indicates that the user synced data during the middle of an epoch. On the user\u2019s next sync, that epoch record will be replaced with a 900-second-duration epoch covering the entire span. As such and to accommodate users with multiple devices, it is important that new epochs always replace existing epochs that have the same startTimeInSeconds. The most recent update from the Health API will always reflect the most recent data in Garmin Connect. Epoch data is useful when attempting to construct charts showing intraday wellness data. An example of this in Garmin Connect is the Steps Details chart that graphs step count changes throughout the user\u2019s day.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the activity in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"startTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"activityType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Text description of the activity type. e.g - SEDENTARY, SLEEP, RUNNING, CYCLING, WALKING, etc.\",\"default\":null},{\"name\":\"duration\",\"type\":[\"null\",\"int\"],\"doc\":\"Length of the monitoring period in seconds. 86400 once a full day is complete, but less if a user syncs mid-day.\",\"default\":null},{\"name\":\"steps\",\"type\":[\"null\",\"int\"],\"doc\":\"Count of steps recorded during the monitoring period.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"float\"],\"doc\":\"Distance traveled in meters.\",\"default\":null},{\"name\":\"activeTime\",\"type\":[\"null\",\"int\"],\"doc\":\"Portion of the monitoring period (in seconds) in which the device wearer was active for this activity type. The sum of active times of all epochs of the same start time (and different activity types) should be equal to the duration.\",\"default\":null},{\"name\":\"activeKilocalories\",\"type\":[\"null\",\"int\"],\"doc\":\"Active kilocalories (dietary calories) burned during the monitoring period. This includes only the calories burned by the activity and not calories burned as part of the basal metabolic rate (BMR).\",\"default\":null},{\"name\":\"metabolicEquivalentOfTask\",\"type\":[\"null\",\"float\"],\"doc\":\"MET (Metabolic Equivalent of Task) value for the active time for this activity type. Metabolic Equivalent of Task (MET) is an official measure of activity intensity. Garmin\u2019s calculation of MET is an estimation based on the biometric data provided (height, weight, date of birth, gender) and improves in accuracy if heart rate data is also captured. The following linked document hosted by the US Centers for Disease Control and Prevention provides detailed information on MET and physical activity intensity: http://www.cdc.gov/nccdphp/dnpa/physical/pdf/PA_Intensity_table_2_1.pdf.\",\"default\":null},{\"name\":\"intensity\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Qualitative measure of intensity. Possible values: SEDENTARY(Little to no activity monitored. This could be due to minimal movement, sitting, resting, or sleeping.), ACTIVE(Some activity monitored. A brisk walk could achieve this intensity.), HIGHLY_ACTIVE(High activity monitored. Running or speed walking could achieve this intensity.).\",\"default\":null},{\"name\":\"meanMotionIntensity\",\"type\":[\"null\",\"float\"],\"doc\":\"The average of motion intensity scores for all minutes in this monitoring period. Motion Intensity is a numerical abstraction of low-level accelerometer data, provided for use in further analysis. This data is not exposed directly to the consumer by Garmin but is used in in the creation of other metrics. Motion Intensity is calculated at minute-level granularity as a number between 0 and 7, with 0 being absolutely still and 7 being constant, sharp motion. Unlike steps, distance, or activity type, which take net movement in to account, motion intensity will increase even if the user does not move in space. For instance, if a user were to jump up and down or fidget with a pencil they would not get credit for any distance, but their motion intensity scores for that monitoring period would increase. It is very common to see mid-range max motion intensities even for sedentary epochs as most people do not sit absolutely still.\",\"default\":null},{\"name\":\"maxMotionIntensity\",\"type\":[\"null\",\"float\"],\"doc\":\"The largest motion intensity score of any minute in this monitoring period. Motion Intensity is a numerical abstraction of low-level accelerometer data, provided for use in further analysis. This data is not exposed directly to the consumer by Garmin but is used in in the creation of other metrics. Motion Intensity is calculated at minute-level granularity as a number between 0 and 7, with 0 being absolutely still and 7 being constant, sharp motion. Unlike steps, distance, or activity type, which take net movement in to account, motion intensity will increase even if the user does not move in space. For instance, if a user were to jump up and down or fidget with a pencil they would not get credit for any distance, but their motion intensity scores for that monitoring period would increase. It is very common to see mid-range max motion intensities even for sedentary epochs as most people do not sit absolutely still.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminEpochSummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminEpochSummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private Integer startTimeOffset;
    private String activityType;
    private Integer duration;
    private Integer steps;
    private Float distance;
    private Integer activeTime;
    private Integer activeKilocalories;
    private Float metabolicEquivalentOfTask;
    private String intensity;
    private Float meanMotionIntensity;
    private Float maxMotionIntensity;
    private static final DatumWriter<GarminEpochSummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminEpochSummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminEpochSummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminEpochSummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminEpochSummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminEpochSummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminEpochSummary)((Object)DECODER.decode(b));
    }

    public GarminEpochSummary() {
    }

    public GarminEpochSummary(Double time, Double timeReceived, String summaryId, Integer startTimeOffset, String activityType, Integer duration, Integer steps, Float distance, Integer activeTime, Integer activeKilocalories, Float metabolicEquivalentOfTask, String intensity, Float meanMotionIntensity, Float maxMotionIntensity) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.startTimeOffset = startTimeOffset;
        this.activityType = activityType;
        this.duration = duration;
        this.steps = steps;
        this.distance = distance;
        this.activeTime = activeTime;
        this.activeKilocalories = activeKilocalories;
        this.metabolicEquivalentOfTask = metabolicEquivalentOfTask;
        this.intensity = intensity;
        this.meanMotionIntensity = meanMotionIntensity;
        this.maxMotionIntensity = maxMotionIntensity;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.startTimeOffset;
            }
            case 4: {
                return this.activityType;
            }
            case 5: {
                return this.duration;
            }
            case 6: {
                return this.steps;
            }
            case 7: {
                return this.distance;
            }
            case 8: {
                return this.activeTime;
            }
            case 9: {
                return this.activeKilocalories;
            }
            case 10: {
                return this.metabolicEquivalentOfTask;
            }
            case 11: {
                return this.intensity;
            }
            case 12: {
                return this.meanMotionIntensity;
            }
            case 13: {
                return this.maxMotionIntensity;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.startTimeOffset = (Integer)value$;
                break;
            }
            case 4: {
                this.activityType = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.duration = (Integer)value$;
                break;
            }
            case 6: {
                this.steps = (Integer)value$;
                break;
            }
            case 7: {
                this.distance = (Float)value$;
                break;
            }
            case 8: {
                this.activeTime = (Integer)value$;
                break;
            }
            case 9: {
                this.activeKilocalories = (Integer)value$;
                break;
            }
            case 10: {
                this.metabolicEquivalentOfTask = (Float)value$;
                break;
            }
            case 11: {
                this.intensity = value$ != null ? value$.toString() : null;
                break;
            }
            case 12: {
                this.meanMotionIntensity = (Float)value$;
                break;
            }
            case 13: {
                this.maxMotionIntensity = (Float)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public Integer getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(Integer value) {
        this.startTimeOffset = value;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String value) {
        this.activityType = value;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer value) {
        this.duration = value;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public void setSteps(Integer value) {
        this.steps = value;
    }

    public Float getDistance() {
        return this.distance;
    }

    public void setDistance(Float value) {
        this.distance = value;
    }

    public Integer getActiveTime() {
        return this.activeTime;
    }

    public void setActiveTime(Integer value) {
        this.activeTime = value;
    }

    public Integer getActiveKilocalories() {
        return this.activeKilocalories;
    }

    public void setActiveKilocalories(Integer value) {
        this.activeKilocalories = value;
    }

    public Float getMetabolicEquivalentOfTask() {
        return this.metabolicEquivalentOfTask;
    }

    public void setMetabolicEquivalentOfTask(Float value) {
        this.metabolicEquivalentOfTask = value;
    }

    public String getIntensity() {
        return this.intensity;
    }

    public void setIntensity(String value) {
        this.intensity = value;
    }

    public Float getMeanMotionIntensity() {
        return this.meanMotionIntensity;
    }

    public void setMeanMotionIntensity(Float value) {
        this.meanMotionIntensity = value;
    }

    public Float getMaxMotionIntensity() {
        return this.maxMotionIntensity;
    }

    public void setMaxMotionIntensity(Float value) {
        this.maxMotionIntensity = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminEpochSummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.startTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.startTimeOffset.intValue());
        }
        if (this.activityType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.activityType);
        }
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.duration.intValue());
        }
        if (this.steps == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.steps.intValue());
        }
        if (this.distance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.distance.floatValue());
        }
        if (this.activeTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.activeTime.intValue());
        }
        if (this.activeKilocalories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.activeKilocalories.intValue());
        }
        if (this.metabolicEquivalentOfTask == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.metabolicEquivalentOfTask.floatValue());
        }
        if (this.intensity == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.intensity);
        }
        if (this.meanMotionIntensity == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.meanMotionIntensity.floatValue());
        }
        if (this.maxMotionIntensity == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxMotionIntensity.floatValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.startTimeOffset = null;
            } else {
                this.startTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activityType = null;
            } else {
                this.activityType = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.steps = null;
            } else {
                this.steps = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.distance = null;
            } else {
                this.distance = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activeTime = null;
            } else {
                this.activeTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activeKilocalories = null;
            } else {
                this.activeKilocalories = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.metabolicEquivalentOfTask = null;
            } else {
                this.metabolicEquivalentOfTask = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.intensity = null;
            } else {
                this.intensity = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.meanMotionIntensity = null;
            } else {
                this.meanMotionIntensity = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxMotionIntensity = null;
            } else {
                this.maxMotionIntensity = Float.valueOf(in.readFloat());
            }
        } else {
            block16: for (int i = 0; i < 14; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block16;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block16;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block16;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startTimeOffset = null;
                            continue block16;
                        }
                        this.startTimeOffset = in.readInt();
                        continue block16;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activityType = null;
                            continue block16;
                        }
                        this.activityType = in.readString();
                        continue block16;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block16;
                        }
                        this.duration = in.readInt();
                        continue block16;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.steps = null;
                            continue block16;
                        }
                        this.steps = in.readInt();
                        continue block16;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.distance = null;
                            continue block16;
                        }
                        this.distance = Float.valueOf(in.readFloat());
                        continue block16;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activeTime = null;
                            continue block16;
                        }
                        this.activeTime = in.readInt();
                        continue block16;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activeKilocalories = null;
                            continue block16;
                        }
                        this.activeKilocalories = in.readInt();
                        continue block16;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.metabolicEquivalentOfTask = null;
                            continue block16;
                        }
                        this.metabolicEquivalentOfTask = Float.valueOf(in.readFloat());
                        continue block16;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.intensity = null;
                            continue block16;
                        }
                        this.intensity = in.readString();
                        continue block16;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.meanMotionIntensity = null;
                            continue block16;
                        }
                        this.meanMotionIntensity = Float.valueOf(in.readFloat());
                        continue block16;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxMotionIntensity = null;
                            continue block16;
                        }
                        this.maxMotionIntensity = Float.valueOf(in.readFloat());
                        continue block16;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminEpochSummary>
    implements RecordBuilder<GarminEpochSummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private Integer startTimeOffset;
        private String activityType;
        private Integer duration;
        private Integer steps;
        private Float distance;
        private Integer activeTime;
        private Integer activeKilocalories;
        private Float metabolicEquivalentOfTask;
        private String intensity;
        private Float meanMotionIntensity;
        private Float maxMotionIntensity;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.activityType)) {
                this.activityType = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.activityType);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.duration);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.steps);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.distance);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.activeTime)) {
                this.activeTime = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.activeTime);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.activeKilocalories)) {
                this.activeKilocalories = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.activeKilocalories);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.metabolicEquivalentOfTask)) {
                this.metabolicEquivalentOfTask = (Float)this.data().deepCopy(this.fields()[10].schema(), (Object)other.metabolicEquivalentOfTask);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.intensity)) {
                this.intensity = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.intensity);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.meanMotionIntensity)) {
                this.meanMotionIntensity = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.meanMotionIntensity);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.maxMotionIntensity)) {
                this.maxMotionIntensity = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.maxMotionIntensity);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
        }

        private Builder(GarminEpochSummary other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.activityType)) {
                this.activityType = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.activityType);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.duration);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.steps);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.distance);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.activeTime)) {
                this.activeTime = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.activeTime);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.activeKilocalories)) {
                this.activeKilocalories = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.activeKilocalories);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.metabolicEquivalentOfTask)) {
                this.metabolicEquivalentOfTask = (Float)this.data().deepCopy(this.fields()[10].schema(), (Object)other.metabolicEquivalentOfTask);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.intensity)) {
                this.intensity = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.intensity);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.meanMotionIntensity)) {
                this.meanMotionIntensity = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.meanMotionIntensity);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.maxMotionIntensity)) {
                this.maxMotionIntensity = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.maxMotionIntensity);
                this.fieldSetFlags()[13] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public Builder setStartTimeOffset(Integer value) {
            this.validate(this.fields()[3], value);
            this.startTimeOffset = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasStartTimeOffset() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearStartTimeOffset() {
            this.startTimeOffset = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getActivityType() {
            return this.activityType;
        }

        public Builder setActivityType(String value) {
            this.validate(this.fields()[4], value);
            this.activityType = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasActivityType() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearActivityType() {
            this.activityType = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Builder setDuration(Integer value) {
            this.validate(this.fields()[5], value);
            this.duration = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getSteps() {
            return this.steps;
        }

        public Builder setSteps(Integer value) {
            this.validate(this.fields()[6], value);
            this.steps = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSteps() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearSteps() {
            this.steps = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getDistance() {
            return this.distance;
        }

        public Builder setDistance(Float value) {
            this.validate(this.fields()[7], value);
            this.distance = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasDistance() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearDistance() {
            this.distance = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getActiveTime() {
            return this.activeTime;
        }

        public Builder setActiveTime(Integer value) {
            this.validate(this.fields()[8], value);
            this.activeTime = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasActiveTime() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearActiveTime() {
            this.activeTime = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getActiveKilocalories() {
            return this.activeKilocalories;
        }

        public Builder setActiveKilocalories(Integer value) {
            this.validate(this.fields()[9], value);
            this.activeKilocalories = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasActiveKilocalories() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearActiveKilocalories() {
            this.activeKilocalories = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Float getMetabolicEquivalentOfTask() {
            return this.metabolicEquivalentOfTask;
        }

        public Builder setMetabolicEquivalentOfTask(Float value) {
            this.validate(this.fields()[10], value);
            this.metabolicEquivalentOfTask = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasMetabolicEquivalentOfTask() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearMetabolicEquivalentOfTask() {
            this.metabolicEquivalentOfTask = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public String getIntensity() {
            return this.intensity;
        }

        public Builder setIntensity(String value) {
            this.validate(this.fields()[11], value);
            this.intensity = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasIntensity() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearIntensity() {
            this.intensity = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Float getMeanMotionIntensity() {
            return this.meanMotionIntensity;
        }

        public Builder setMeanMotionIntensity(Float value) {
            this.validate(this.fields()[12], value);
            this.meanMotionIntensity = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasMeanMotionIntensity() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearMeanMotionIntensity() {
            this.meanMotionIntensity = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Float getMaxMotionIntensity() {
            return this.maxMotionIntensity;
        }

        public Builder setMaxMotionIntensity(Float value) {
            this.validate(this.fields()[13], value);
            this.maxMotionIntensity = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasMaxMotionIntensity() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearMaxMotionIntensity() {
            this.maxMotionIntensity = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public GarminEpochSummary build() {
            try {
                GarminEpochSummary record = new GarminEpochSummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.startTimeOffset = this.fieldSetFlags()[3] ? this.startTimeOffset : (Integer)this.defaultValue(this.fields()[3]);
                record.activityType = this.fieldSetFlags()[4] ? this.activityType : (String)this.defaultValue(this.fields()[4]);
                record.duration = this.fieldSetFlags()[5] ? this.duration : (Integer)this.defaultValue(this.fields()[5]);
                record.steps = this.fieldSetFlags()[6] ? this.steps : (Integer)this.defaultValue(this.fields()[6]);
                record.distance = this.fieldSetFlags()[7] ? this.distance : (Float)this.defaultValue(this.fields()[7]);
                record.activeTime = this.fieldSetFlags()[8] ? this.activeTime : (Integer)this.defaultValue(this.fields()[8]);
                record.activeKilocalories = this.fieldSetFlags()[9] ? this.activeKilocalories : (Integer)this.defaultValue(this.fields()[9]);
                record.metabolicEquivalentOfTask = this.fieldSetFlags()[10] ? this.metabolicEquivalentOfTask : (Float)this.defaultValue(this.fields()[10]);
                record.intensity = this.fieldSetFlags()[11] ? this.intensity : (String)this.defaultValue(this.fields()[11]);
                record.meanMotionIntensity = this.fieldSetFlags()[12] ? this.meanMotionIntensity : (Float)this.defaultValue(this.fields()[12]);
                record.maxMotionIntensity = this.fieldSetFlags()[13] ? this.maxMotionIntensity : (Float)this.defaultValue(this.fields()[13]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

