/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminBloodPressureSummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -7550299596192982464L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminBloodPressureSummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Blood pressure summaries offer data from blood pressure readings taken using an Index BPM device or from a user\u2019s manually uploaded blood pressure data. This includes systolic, diastolic, and pulse values taken at the time of the blood pressure reading. For more information about the validation of data using the Index BPM, please visit https://www.garmin.com/en-US/bpmvalidation/.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"measurementTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"systolic\",\"type\":[\"null\",\"int\"],\"doc\":\"The systolic value of the blood pressure reading.\",\"default\":null},{\"name\":\"diastolic\",\"type\":[\"null\",\"int\"],\"doc\":\"The diastolic value of the blood pressure reading.\",\"default\":null},{\"name\":\"pulse\",\"type\":[\"null\",\"int\"],\"doc\":\"Pulse rate at the time the blood pressure reading.\",\"default\":null},{\"name\":\"sourceType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"This field is used to determine if blood pressure data was entered manually or synced from a Garmin Device. Possible values: MANUAL: The user entered blood pressure information manually through a web form. DEVICE: The user used a Garmin device to perform a blood pressure reading.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminBloodPressureSummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminBloodPressureSummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private Integer measurementTimeOffset;
    private Integer systolic;
    private Integer diastolic;
    private Integer pulse;
    private String sourceType;
    private static final DatumWriter<GarminBloodPressureSummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminBloodPressureSummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminBloodPressureSummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminBloodPressureSummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminBloodPressureSummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminBloodPressureSummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminBloodPressureSummary)((Object)DECODER.decode(b));
    }

    public GarminBloodPressureSummary() {
    }

    public GarminBloodPressureSummary(Double time, Double timeReceived, String summaryId, Integer measurementTimeOffset, Integer systolic, Integer diastolic, Integer pulse, String sourceType) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.measurementTimeOffset = measurementTimeOffset;
        this.systolic = systolic;
        this.diastolic = diastolic;
        this.pulse = pulse;
        this.sourceType = sourceType;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.measurementTimeOffset;
            }
            case 4: {
                return this.systolic;
            }
            case 5: {
                return this.diastolic;
            }
            case 6: {
                return this.pulse;
            }
            case 7: {
                return this.sourceType;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.measurementTimeOffset = (Integer)value$;
                break;
            }
            case 4: {
                this.systolic = (Integer)value$;
                break;
            }
            case 5: {
                this.diastolic = (Integer)value$;
                break;
            }
            case 6: {
                this.pulse = (Integer)value$;
                break;
            }
            case 7: {
                this.sourceType = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public Integer getMeasurementTimeOffset() {
        return this.measurementTimeOffset;
    }

    public void setMeasurementTimeOffset(Integer value) {
        this.measurementTimeOffset = value;
    }

    public Integer getSystolic() {
        return this.systolic;
    }

    public void setSystolic(Integer value) {
        this.systolic = value;
    }

    public Integer getDiastolic() {
        return this.diastolic;
    }

    public void setDiastolic(Integer value) {
        this.diastolic = value;
    }

    public Integer getPulse() {
        return this.pulse;
    }

    public void setPulse(Integer value) {
        this.pulse = value;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String value) {
        this.sourceType = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminBloodPressureSummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.measurementTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.measurementTimeOffset.intValue());
        }
        if (this.systolic == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.systolic.intValue());
        }
        if (this.diastolic == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.diastolic.intValue());
        }
        if (this.pulse == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.pulse.intValue());
        }
        if (this.sourceType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.sourceType);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.measurementTimeOffset = null;
            } else {
                this.measurementTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.systolic = null;
            } else {
                this.systolic = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.diastolic = null;
            } else {
                this.diastolic = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.pulse = null;
            } else {
                this.pulse = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.sourceType = null;
            } else {
                this.sourceType = in.readString();
            }
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block10;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block10;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block10;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.measurementTimeOffset = null;
                            continue block10;
                        }
                        this.measurementTimeOffset = in.readInt();
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.systolic = null;
                            continue block10;
                        }
                        this.systolic = in.readInt();
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.diastolic = null;
                            continue block10;
                        }
                        this.diastolic = in.readInt();
                        continue block10;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.pulse = null;
                            continue block10;
                        }
                        this.pulse = in.readInt();
                        continue block10;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.sourceType = null;
                            continue block10;
                        }
                        this.sourceType = in.readString();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminBloodPressureSummary>
    implements RecordBuilder<GarminBloodPressureSummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private Integer measurementTimeOffset;
        private Integer systolic;
        private Integer diastolic;
        private Integer pulse;
        private String sourceType;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.measurementTimeOffset)) {
                this.measurementTimeOffset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.measurementTimeOffset);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.systolic)) {
                this.systolic = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.systolic);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.diastolic)) {
                this.diastolic = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.diastolic);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.pulse)) {
                this.pulse = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.pulse);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.sourceType)) {
                this.sourceType = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.sourceType);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
        }

        private Builder(GarminBloodPressureSummary other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.measurementTimeOffset)) {
                this.measurementTimeOffset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.measurementTimeOffset);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.systolic)) {
                this.systolic = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.systolic);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.diastolic)) {
                this.diastolic = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.diastolic);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.pulse)) {
                this.pulse = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.pulse);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.sourceType)) {
                this.sourceType = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.sourceType);
                this.fieldSetFlags()[7] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getMeasurementTimeOffset() {
            return this.measurementTimeOffset;
        }

        public Builder setMeasurementTimeOffset(Integer value) {
            this.validate(this.fields()[3], value);
            this.measurementTimeOffset = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasMeasurementTimeOffset() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearMeasurementTimeOffset() {
            this.measurementTimeOffset = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getSystolic() {
            return this.systolic;
        }

        public Builder setSystolic(Integer value) {
            this.validate(this.fields()[4], value);
            this.systolic = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasSystolic() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearSystolic() {
            this.systolic = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getDiastolic() {
            return this.diastolic;
        }

        public Builder setDiastolic(Integer value) {
            this.validate(this.fields()[5], value);
            this.diastolic = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDiastolic() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDiastolic() {
            this.diastolic = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getPulse() {
            return this.pulse;
        }

        public Builder setPulse(Integer value) {
            this.validate(this.fields()[6], value);
            this.pulse = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasPulse() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearPulse() {
            this.pulse = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public Builder setSourceType(String value) {
            this.validate(this.fields()[7], value);
            this.sourceType = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasSourceType() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearSourceType() {
            this.sourceType = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public GarminBloodPressureSummary build() {
            try {
                GarminBloodPressureSummary record = new GarminBloodPressureSummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.measurementTimeOffset = this.fieldSetFlags()[3] ? this.measurementTimeOffset : (Integer)this.defaultValue(this.fields()[3]);
                record.systolic = this.fieldSetFlags()[4] ? this.systolic : (Integer)this.defaultValue(this.fields()[4]);
                record.diastolic = this.fieldSetFlags()[5] ? this.diastolic : (Integer)this.defaultValue(this.fields()[5]);
                record.pulse = this.fieldSetFlags()[6] ? this.pulse : (Integer)this.defaultValue(this.fields()[6]);
                record.sourceType = this.fieldSetFlags()[7] ? this.sourceType : (String)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

