/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminActivityDetailsSample
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5962969187235238839L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminActivityDetailsSample\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Each activity detail contains an activity summary and an optional list of samples. The samples list will be empty if the activity is manual or details are not supported by the device. Samples may be as frequent as once per second, and values should be considered valid until the next sample. In all cases, movingDurationInSeconds is less than or equal to timerDurationInSeconds is less than or equal to clockDurationInSeconds.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the sample in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time this sample was recieved by the push service in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary that this sample is associated with.\"},{\"name\":\"airTemperature\",\"type\":[\"null\",\"float\"],\"doc\":\"Air Temperature in Celcius.\",\"default\":null},{\"name\":\"heartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Heart rate in beats per minute.\",\"default\":null},{\"name\":\"speed\",\"type\":[\"null\",\"float\"],\"doc\":\"Speed in Meters Per Second.\",\"default\":null},{\"name\":\"stepsPerMinute\",\"type\":[\"null\",\"float\"],\"doc\":\"Number of steps per minute.\",\"default\":null},{\"name\":\"totalDistance\",\"type\":[\"null\",\"float\"],\"doc\":\"Total Distance in Meters.\",\"default\":null},{\"name\":\"timerDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The amount of 'timer time' in an activity.\",\"default\":null},{\"name\":\"clockDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The amount of real-world 'clock time' from the start of an activity to the end.\",\"default\":null},{\"name\":\"movingDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The amount of 'timer time' during which the athlete was moving (above a threshold speed).\",\"default\":null},{\"name\":\"power\",\"type\":[\"null\",\"float\"],\"doc\":\"The amount of power expended in watts.\",\"default\":null},{\"name\":\"bikeCadence\",\"type\":[\"null\",\"int\"],\"doc\":\"Cycling cadence in revolutions per minute.\",\"default\":null},{\"name\":\"swimCadence\",\"type\":[\"null\",\"int\"],\"doc\":\"Swim cadence in strokes per minute.\",\"default\":null},{\"name\":\"latitude\",\"type\":[\"null\",\"float\"],\"doc\":\"Latitude in decimal degrees (DD).\",\"default\":null},{\"name\":\"longitude\",\"type\":[\"null\",\"float\"],\"doc\":\"Longitude in decimal degrees (DD).\",\"default\":null},{\"name\":\"elevation\",\"type\":[\"null\",\"float\"],\"doc\":\"Elevation in meters.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminActivityDetailsSample> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminActivityDetailsSample> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private Float airTemperature;
    private Integer heartRate;
    private Float speed;
    private Float stepsPerMinute;
    private Float totalDistance;
    private Integer timerDuration;
    private Integer clockDuration;
    private Integer movingDuration;
    private Float power;
    private Integer bikeCadence;
    private Integer swimCadence;
    private Float latitude;
    private Float longitude;
    private Float elevation;
    private static final DatumWriter<GarminActivityDetailsSample> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminActivityDetailsSample> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminActivityDetailsSample> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminActivityDetailsSample> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminActivityDetailsSample> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminActivityDetailsSample fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminActivityDetailsSample)((Object)DECODER.decode(b));
    }

    public GarminActivityDetailsSample() {
    }

    public GarminActivityDetailsSample(Double time, Double timeReceived, String summaryId, Float airTemperature, Integer heartRate, Float speed, Float stepsPerMinute, Float totalDistance, Integer timerDuration, Integer clockDuration, Integer movingDuration, Float power, Integer bikeCadence, Integer swimCadence, Float latitude, Float longitude, Float elevation) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.airTemperature = airTemperature;
        this.heartRate = heartRate;
        this.speed = speed;
        this.stepsPerMinute = stepsPerMinute;
        this.totalDistance = totalDistance;
        this.timerDuration = timerDuration;
        this.clockDuration = clockDuration;
        this.movingDuration = movingDuration;
        this.power = power;
        this.bikeCadence = bikeCadence;
        this.swimCadence = swimCadence;
        this.latitude = latitude;
        this.longitude = longitude;
        this.elevation = elevation;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.airTemperature;
            }
            case 4: {
                return this.heartRate;
            }
            case 5: {
                return this.speed;
            }
            case 6: {
                return this.stepsPerMinute;
            }
            case 7: {
                return this.totalDistance;
            }
            case 8: {
                return this.timerDuration;
            }
            case 9: {
                return this.clockDuration;
            }
            case 10: {
                return this.movingDuration;
            }
            case 11: {
                return this.power;
            }
            case 12: {
                return this.bikeCadence;
            }
            case 13: {
                return this.swimCadence;
            }
            case 14: {
                return this.latitude;
            }
            case 15: {
                return this.longitude;
            }
            case 16: {
                return this.elevation;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.airTemperature = (Float)value$;
                break;
            }
            case 4: {
                this.heartRate = (Integer)value$;
                break;
            }
            case 5: {
                this.speed = (Float)value$;
                break;
            }
            case 6: {
                this.stepsPerMinute = (Float)value$;
                break;
            }
            case 7: {
                this.totalDistance = (Float)value$;
                break;
            }
            case 8: {
                this.timerDuration = (Integer)value$;
                break;
            }
            case 9: {
                this.clockDuration = (Integer)value$;
                break;
            }
            case 10: {
                this.movingDuration = (Integer)value$;
                break;
            }
            case 11: {
                this.power = (Float)value$;
                break;
            }
            case 12: {
                this.bikeCadence = (Integer)value$;
                break;
            }
            case 13: {
                this.swimCadence = (Integer)value$;
                break;
            }
            case 14: {
                this.latitude = (Float)value$;
                break;
            }
            case 15: {
                this.longitude = (Float)value$;
                break;
            }
            case 16: {
                this.elevation = (Float)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public Float getAirTemperature() {
        return this.airTemperature;
    }

    public void setAirTemperature(Float value) {
        this.airTemperature = value;
    }

    public Integer getHeartRate() {
        return this.heartRate;
    }

    public void setHeartRate(Integer value) {
        this.heartRate = value;
    }

    public Float getSpeed() {
        return this.speed;
    }

    public void setSpeed(Float value) {
        this.speed = value;
    }

    public Float getStepsPerMinute() {
        return this.stepsPerMinute;
    }

    public void setStepsPerMinute(Float value) {
        this.stepsPerMinute = value;
    }

    public Float getTotalDistance() {
        return this.totalDistance;
    }

    public void setTotalDistance(Float value) {
        this.totalDistance = value;
    }

    public Integer getTimerDuration() {
        return this.timerDuration;
    }

    public void setTimerDuration(Integer value) {
        this.timerDuration = value;
    }

    public Integer getClockDuration() {
        return this.clockDuration;
    }

    public void setClockDuration(Integer value) {
        this.clockDuration = value;
    }

    public Integer getMovingDuration() {
        return this.movingDuration;
    }

    public void setMovingDuration(Integer value) {
        this.movingDuration = value;
    }

    public Float getPower() {
        return this.power;
    }

    public void setPower(Float value) {
        this.power = value;
    }

    public Integer getBikeCadence() {
        return this.bikeCadence;
    }

    public void setBikeCadence(Integer value) {
        this.bikeCadence = value;
    }

    public Integer getSwimCadence() {
        return this.swimCadence;
    }

    public void setSwimCadence(Integer value) {
        this.swimCadence = value;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Float value) {
        this.latitude = value;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Float value) {
        this.longitude = value;
    }

    public Float getElevation() {
        return this.elevation;
    }

    public void setElevation(Float value) {
        this.elevation = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminActivityDetailsSample other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.airTemperature == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.airTemperature.floatValue());
        }
        if (this.heartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.heartRate.intValue());
        }
        if (this.speed == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.speed.floatValue());
        }
        if (this.stepsPerMinute == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.stepsPerMinute.floatValue());
        }
        if (this.totalDistance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.totalDistance.floatValue());
        }
        if (this.timerDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.timerDuration.intValue());
        }
        if (this.clockDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.clockDuration.intValue());
        }
        if (this.movingDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.movingDuration.intValue());
        }
        if (this.power == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.power.floatValue());
        }
        if (this.bikeCadence == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.bikeCadence.intValue());
        }
        if (this.swimCadence == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.swimCadence.intValue());
        }
        if (this.latitude == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.latitude.floatValue());
        }
        if (this.longitude == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.longitude.floatValue());
        }
        if (this.elevation == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.elevation.floatValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.airTemperature = null;
            } else {
                this.airTemperature = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.heartRate = null;
            } else {
                this.heartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.speed = null;
            } else {
                this.speed = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stepsPerMinute = null;
            } else {
                this.stepsPerMinute = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalDistance = null;
            } else {
                this.totalDistance = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.timerDuration = null;
            } else {
                this.timerDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.clockDuration = null;
            } else {
                this.clockDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.movingDuration = null;
            } else {
                this.movingDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.power = null;
            } else {
                this.power = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bikeCadence = null;
            } else {
                this.bikeCadence = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.swimCadence = null;
            } else {
                this.swimCadence = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.latitude = null;
            } else {
                this.latitude = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.longitude = null;
            } else {
                this.longitude = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.elevation = null;
            } else {
                this.elevation = Float.valueOf(in.readFloat());
            }
        } else {
            block19: for (int i = 0; i < 17; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block19;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block19;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block19;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.airTemperature = null;
                            continue block19;
                        }
                        this.airTemperature = Float.valueOf(in.readFloat());
                        continue block19;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.heartRate = null;
                            continue block19;
                        }
                        this.heartRate = in.readInt();
                        continue block19;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.speed = null;
                            continue block19;
                        }
                        this.speed = Float.valueOf(in.readFloat());
                        continue block19;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stepsPerMinute = null;
                            continue block19;
                        }
                        this.stepsPerMinute = Float.valueOf(in.readFloat());
                        continue block19;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalDistance = null;
                            continue block19;
                        }
                        this.totalDistance = Float.valueOf(in.readFloat());
                        continue block19;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.timerDuration = null;
                            continue block19;
                        }
                        this.timerDuration = in.readInt();
                        continue block19;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.clockDuration = null;
                            continue block19;
                        }
                        this.clockDuration = in.readInt();
                        continue block19;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.movingDuration = null;
                            continue block19;
                        }
                        this.movingDuration = in.readInt();
                        continue block19;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.power = null;
                            continue block19;
                        }
                        this.power = Float.valueOf(in.readFloat());
                        continue block19;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bikeCadence = null;
                            continue block19;
                        }
                        this.bikeCadence = in.readInt();
                        continue block19;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.swimCadence = null;
                            continue block19;
                        }
                        this.swimCadence = in.readInt();
                        continue block19;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.latitude = null;
                            continue block19;
                        }
                        this.latitude = Float.valueOf(in.readFloat());
                        continue block19;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.longitude = null;
                            continue block19;
                        }
                        this.longitude = Float.valueOf(in.readFloat());
                        continue block19;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.elevation = null;
                            continue block19;
                        }
                        this.elevation = Float.valueOf(in.readFloat());
                        continue block19;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminActivityDetailsSample>
    implements RecordBuilder<GarminActivityDetailsSample> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private Float airTemperature;
        private Integer heartRate;
        private Float speed;
        private Float stepsPerMinute;
        private Float totalDistance;
        private Integer timerDuration;
        private Integer clockDuration;
        private Integer movingDuration;
        private Float power;
        private Integer bikeCadence;
        private Integer swimCadence;
        private Float latitude;
        private Float longitude;
        private Float elevation;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.airTemperature)) {
                this.airTemperature = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.airTemperature);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.heartRate)) {
                this.heartRate = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.heartRate);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.speed)) {
                this.speed = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.speed);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.stepsPerMinute)) {
                this.stepsPerMinute = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.stepsPerMinute);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.totalDistance)) {
                this.totalDistance = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.totalDistance);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.timerDuration)) {
                this.timerDuration = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.timerDuration);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.clockDuration)) {
                this.clockDuration = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.clockDuration);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.movingDuration)) {
                this.movingDuration = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.movingDuration);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.power)) {
                this.power = (Float)this.data().deepCopy(this.fields()[11].schema(), (Object)other.power);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.bikeCadence)) {
                this.bikeCadence = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.bikeCadence);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.swimCadence)) {
                this.swimCadence = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.swimCadence);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.latitude)) {
                this.latitude = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.latitude);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.longitude)) {
                this.longitude = (Float)this.data().deepCopy(this.fields()[15].schema(), (Object)other.longitude);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.elevation)) {
                this.elevation = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.elevation);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
        }

        private Builder(GarminActivityDetailsSample other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.airTemperature)) {
                this.airTemperature = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.airTemperature);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.heartRate)) {
                this.heartRate = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.heartRate);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.speed)) {
                this.speed = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.speed);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.stepsPerMinute)) {
                this.stepsPerMinute = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.stepsPerMinute);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.totalDistance)) {
                this.totalDistance = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.totalDistance);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.timerDuration)) {
                this.timerDuration = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.timerDuration);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.clockDuration)) {
                this.clockDuration = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.clockDuration);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.movingDuration)) {
                this.movingDuration = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.movingDuration);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.power)) {
                this.power = (Float)this.data().deepCopy(this.fields()[11].schema(), (Object)other.power);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.bikeCadence)) {
                this.bikeCadence = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.bikeCadence);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.swimCadence)) {
                this.swimCadence = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.swimCadence);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.latitude)) {
                this.latitude = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.latitude);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.longitude)) {
                this.longitude = (Float)this.data().deepCopy(this.fields()[15].schema(), (Object)other.longitude);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.elevation)) {
                this.elevation = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.elevation);
                this.fieldSetFlags()[16] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Float getAirTemperature() {
            return this.airTemperature;
        }

        public Builder setAirTemperature(Float value) {
            this.validate(this.fields()[3], value);
            this.airTemperature = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasAirTemperature() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearAirTemperature() {
            this.airTemperature = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getHeartRate() {
            return this.heartRate;
        }

        public Builder setHeartRate(Integer value) {
            this.validate(this.fields()[4], value);
            this.heartRate = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasHeartRate() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearHeartRate() {
            this.heartRate = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Float getSpeed() {
            return this.speed;
        }

        public Builder setSpeed(Float value) {
            this.validate(this.fields()[5], value);
            this.speed = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasSpeed() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearSpeed() {
            this.speed = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getStepsPerMinute() {
            return this.stepsPerMinute;
        }

        public Builder setStepsPerMinute(Float value) {
            this.validate(this.fields()[6], value);
            this.stepsPerMinute = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasStepsPerMinute() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearStepsPerMinute() {
            this.stepsPerMinute = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getTotalDistance() {
            return this.totalDistance;
        }

        public Builder setTotalDistance(Float value) {
            this.validate(this.fields()[7], value);
            this.totalDistance = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasTotalDistance() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearTotalDistance() {
            this.totalDistance = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Integer getTimerDuration() {
            return this.timerDuration;
        }

        public Builder setTimerDuration(Integer value) {
            this.validate(this.fields()[8], value);
            this.timerDuration = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasTimerDuration() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearTimerDuration() {
            this.timerDuration = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getClockDuration() {
            return this.clockDuration;
        }

        public Builder setClockDuration(Integer value) {
            this.validate(this.fields()[9], value);
            this.clockDuration = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasClockDuration() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearClockDuration() {
            this.clockDuration = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getMovingDuration() {
            return this.movingDuration;
        }

        public Builder setMovingDuration(Integer value) {
            this.validate(this.fields()[10], value);
            this.movingDuration = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasMovingDuration() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearMovingDuration() {
            this.movingDuration = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Float getPower() {
            return this.power;
        }

        public Builder setPower(Float value) {
            this.validate(this.fields()[11], value);
            this.power = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasPower() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearPower() {
            this.power = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Integer getBikeCadence() {
            return this.bikeCadence;
        }

        public Builder setBikeCadence(Integer value) {
            this.validate(this.fields()[12], value);
            this.bikeCadence = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasBikeCadence() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearBikeCadence() {
            this.bikeCadence = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Integer getSwimCadence() {
            return this.swimCadence;
        }

        public Builder setSwimCadence(Integer value) {
            this.validate(this.fields()[13], value);
            this.swimCadence = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasSwimCadence() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearSwimCadence() {
            this.swimCadence = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Float getLatitude() {
            return this.latitude;
        }

        public Builder setLatitude(Float value) {
            this.validate(this.fields()[14], value);
            this.latitude = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasLatitude() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearLatitude() {
            this.latitude = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Float getLongitude() {
            return this.longitude;
        }

        public Builder setLongitude(Float value) {
            this.validate(this.fields()[15], value);
            this.longitude = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasLongitude() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearLongitude() {
            this.longitude = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Float getElevation() {
            return this.elevation;
        }

        public Builder setElevation(Float value) {
            this.validate(this.fields()[16], value);
            this.elevation = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasElevation() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearElevation() {
            this.elevation = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public GarminActivityDetailsSample build() {
            try {
                GarminActivityDetailsSample record = new GarminActivityDetailsSample();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.airTemperature = this.fieldSetFlags()[3] ? this.airTemperature : (Float)this.defaultValue(this.fields()[3]);
                record.heartRate = this.fieldSetFlags()[4] ? this.heartRate : (Integer)this.defaultValue(this.fields()[4]);
                record.speed = this.fieldSetFlags()[5] ? this.speed : (Float)this.defaultValue(this.fields()[5]);
                record.stepsPerMinute = this.fieldSetFlags()[6] ? this.stepsPerMinute : (Float)this.defaultValue(this.fields()[6]);
                record.totalDistance = this.fieldSetFlags()[7] ? this.totalDistance : (Float)this.defaultValue(this.fields()[7]);
                record.timerDuration = this.fieldSetFlags()[8] ? this.timerDuration : (Integer)this.defaultValue(this.fields()[8]);
                record.clockDuration = this.fieldSetFlags()[9] ? this.clockDuration : (Integer)this.defaultValue(this.fields()[9]);
                record.movingDuration = this.fieldSetFlags()[10] ? this.movingDuration : (Integer)this.defaultValue(this.fields()[10]);
                record.power = this.fieldSetFlags()[11] ? this.power : (Float)this.defaultValue(this.fields()[11]);
                record.bikeCadence = this.fieldSetFlags()[12] ? this.bikeCadence : (Integer)this.defaultValue(this.fields()[12]);
                record.swimCadence = this.fieldSetFlags()[13] ? this.swimCadence : (Integer)this.defaultValue(this.fields()[13]);
                record.latitude = this.fieldSetFlags()[14] ? this.latitude : (Float)this.defaultValue(this.fields()[14]);
                record.longitude = this.fieldSetFlags()[15] ? this.longitude : (Float)this.defaultValue(this.fields()[15]);
                record.elevation = this.fieldSetFlags()[16] ? this.elevation : (Float)this.defaultValue(this.fields()[16]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

