/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.weather;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.weather.LocationType;
import org.radarcns.passive.weather.WeatherCondition;

@AvroGenerated
public class LocalWeather
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5220806470102923603L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"LocalWeather\",\"namespace\":\"org.radarcns.passive.weather\",\"doc\":\"Current weather information at the location of the user.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"sunrise\",\"type\":[\"null\",\"int\"],\"doc\":\"Sunrise time of day in minutes after midnight. The difference with sunset is the minutes of daylight.\",\"default\":null},{\"name\":\"sunset\",\"type\":[\"null\",\"int\"],\"doc\":\"Sunset time of day in minutes after midnight. The difference with sunrise is the minutes of daylight.\",\"default\":null},{\"name\":\"temperature\",\"type\":[\"null\",\"float\"],\"doc\":\"Current ambient temperature (C).\",\"default\":null},{\"name\":\"pressure\",\"type\":[\"null\",\"float\"],\"doc\":\"Current atmospheric pressure on sea level (hPa).\",\"default\":null},{\"name\":\"humidity\",\"type\":[\"null\",\"float\"],\"doc\":\"Current humidity (%).\",\"default\":null},{\"name\":\"cloudiness\",\"type\":[\"null\",\"float\"],\"doc\":\"Current cloudiness (%).\",\"default\":null},{\"name\":\"precipitation\",\"type\":[\"null\",\"float\"],\"doc\":\"Rain or snow volume over last hours reported in 'percipitationPeriod' (mm).\",\"default\":null},{\"name\":\"precipitationPeriod\",\"type\":[\"null\",\"int\"],\"doc\":\"Period over which the precipitation was determined (h).\",\"default\":null},{\"name\":\"condition\",\"type\":{\"type\":\"enum\",\"name\":\"WeatherCondition\",\"doc\":\"Types of weather condition.\",\"symbols\":[\"CLEAR\",\"CLOUDY\",\"DRIZZLE\",\"RAINY\",\"SNOWY\",\"ICY\",\"FOGGY\",\"STORM\",\"THUNDER\",\"OTHER\",\"UNKNOWN\"]},\"doc\":\"Current weather condition.\",\"default\":\"UNKNOWN\"},{\"name\":\"source\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"From which source/API the weather data was retrieved.\"},{\"name\":\"locationSource\",\"type\":{\"type\":\"enum\",\"name\":\"LocationType\",\"doc\":\"How the location was determined.\",\"symbols\":[\"GPS\",\"NETWORK\",\"CITY_NAME\",\"OTHER\",\"UNKNOWN\"]},\"doc\":\"The source of the location used to get the weather details.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<LocalWeather> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<LocalWeather> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private Integer sunrise;
    private Integer sunset;
    private Float temperature;
    private Float pressure;
    private Float humidity;
    private Float cloudiness;
    private Float precipitation;
    private Integer precipitationPeriod;
    private WeatherCondition condition;
    private String source;
    private LocationType locationSource;
    private static final DatumWriter<LocalWeather> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<LocalWeather> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<LocalWeather> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<LocalWeather> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<LocalWeather> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static LocalWeather fromByteBuffer(ByteBuffer b) throws IOException {
        return (LocalWeather)((Object)DECODER.decode(b));
    }

    public LocalWeather() {
    }

    public LocalWeather(Double time, Double timeReceived, Integer sunrise, Integer sunset, Float temperature, Float pressure, Float humidity, Float cloudiness, Float precipitation, Integer precipitationPeriod, WeatherCondition condition, String source, LocationType locationSource) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.sunrise = sunrise;
        this.sunset = sunset;
        this.temperature = temperature;
        this.pressure = pressure;
        this.humidity = humidity;
        this.cloudiness = cloudiness;
        this.precipitation = precipitation;
        this.precipitationPeriod = precipitationPeriod;
        this.condition = condition;
        this.source = source;
        this.locationSource = locationSource;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.sunrise;
            }
            case 3: {
                return this.sunset;
            }
            case 4: {
                return this.temperature;
            }
            case 5: {
                return this.pressure;
            }
            case 6: {
                return this.humidity;
            }
            case 7: {
                return this.cloudiness;
            }
            case 8: {
                return this.precipitation;
            }
            case 9: {
                return this.precipitationPeriod;
            }
            case 10: {
                return this.condition;
            }
            case 11: {
                return this.source;
            }
            case 12: {
                return this.locationSource;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.sunrise = (Integer)value$;
                break;
            }
            case 3: {
                this.sunset = (Integer)value$;
                break;
            }
            case 4: {
                this.temperature = (Float)value$;
                break;
            }
            case 5: {
                this.pressure = (Float)value$;
                break;
            }
            case 6: {
                this.humidity = (Float)value$;
                break;
            }
            case 7: {
                this.cloudiness = (Float)value$;
                break;
            }
            case 8: {
                this.precipitation = (Float)value$;
                break;
            }
            case 9: {
                this.precipitationPeriod = (Integer)value$;
                break;
            }
            case 10: {
                this.condition = (WeatherCondition)((Object)value$);
                break;
            }
            case 11: {
                this.source = value$ != null ? value$.toString() : null;
                break;
            }
            case 12: {
                this.locationSource = (LocationType)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public Integer getSunrise() {
        return this.sunrise;
    }

    public void setSunrise(Integer value) {
        this.sunrise = value;
    }

    public Integer getSunset() {
        return this.sunset;
    }

    public void setSunset(Integer value) {
        this.sunset = value;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float value) {
        this.temperature = value;
    }

    public Float getPressure() {
        return this.pressure;
    }

    public void setPressure(Float value) {
        this.pressure = value;
    }

    public Float getHumidity() {
        return this.humidity;
    }

    public void setHumidity(Float value) {
        this.humidity = value;
    }

    public Float getCloudiness() {
        return this.cloudiness;
    }

    public void setCloudiness(Float value) {
        this.cloudiness = value;
    }

    public Float getPrecipitation() {
        return this.precipitation;
    }

    public void setPrecipitation(Float value) {
        this.precipitation = value;
    }

    public Integer getPrecipitationPeriod() {
        return this.precipitationPeriod;
    }

    public void setPrecipitationPeriod(Integer value) {
        this.precipitationPeriod = value;
    }

    public WeatherCondition getCondition() {
        return this.condition;
    }

    public void setCondition(WeatherCondition value) {
        this.condition = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public LocationType getLocationSource() {
        return this.locationSource;
    }

    public void setLocationSource(LocationType value) {
        this.locationSource = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(LocalWeather other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.sunrise == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.sunrise.intValue());
        }
        if (this.sunset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.sunset.intValue());
        }
        if (this.temperature == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.temperature.floatValue());
        }
        if (this.pressure == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.pressure.floatValue());
        }
        if (this.humidity == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.humidity.floatValue());
        }
        if (this.cloudiness == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.cloudiness.floatValue());
        }
        if (this.precipitation == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.precipitation.floatValue());
        }
        if (this.precipitationPeriod == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.precipitationPeriod.intValue());
        }
        out.writeEnum(this.condition.ordinal());
        out.writeString(this.source);
        out.writeEnum(this.locationSource.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.sunrise = null;
            } else {
                this.sunrise = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.sunset = null;
            } else {
                this.sunset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.temperature = null;
            } else {
                this.temperature = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.pressure = null;
            } else {
                this.pressure = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.humidity = null;
            } else {
                this.humidity = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.cloudiness = null;
            } else {
                this.cloudiness = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.precipitation = null;
            } else {
                this.precipitation = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.precipitationPeriod = null;
            } else {
                this.precipitationPeriod = in.readInt();
            }
            this.condition = WeatherCondition.values()[in.readEnum()];
            this.source = in.readString();
            this.locationSource = LocationType.values()[in.readEnum()];
        } else {
            block15: for (int i = 0; i < 13; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block15;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block15;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.sunrise = null;
                            continue block15;
                        }
                        this.sunrise = in.readInt();
                        continue block15;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.sunset = null;
                            continue block15;
                        }
                        this.sunset = in.readInt();
                        continue block15;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.temperature = null;
                            continue block15;
                        }
                        this.temperature = Float.valueOf(in.readFloat());
                        continue block15;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.pressure = null;
                            continue block15;
                        }
                        this.pressure = Float.valueOf(in.readFloat());
                        continue block15;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.humidity = null;
                            continue block15;
                        }
                        this.humidity = Float.valueOf(in.readFloat());
                        continue block15;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.cloudiness = null;
                            continue block15;
                        }
                        this.cloudiness = Float.valueOf(in.readFloat());
                        continue block15;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.precipitation = null;
                            continue block15;
                        }
                        this.precipitation = Float.valueOf(in.readFloat());
                        continue block15;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.precipitationPeriod = null;
                            continue block15;
                        }
                        this.precipitationPeriod = in.readInt();
                        continue block15;
                    }
                    case 10: {
                        this.condition = WeatherCondition.values()[in.readEnum()];
                        continue block15;
                    }
                    case 11: {
                        this.source = in.readString();
                        continue block15;
                    }
                    case 12: {
                        this.locationSource = LocationType.values()[in.readEnum()];
                        continue block15;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<LocalWeather>
    implements RecordBuilder<LocalWeather> {
        private double time;
        private double timeReceived;
        private Integer sunrise;
        private Integer sunset;
        private Float temperature;
        private Float pressure;
        private Float humidity;
        private Float cloudiness;
        private Float precipitation;
        private Integer precipitationPeriod;
        private WeatherCondition condition;
        private String source;
        private LocationType locationSource;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.sunrise)) {
                this.sunrise = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.sunrise);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sunset)) {
                this.sunset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sunset);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.temperature)) {
                this.temperature = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.temperature);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.pressure)) {
                this.pressure = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.pressure);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.humidity)) {
                this.humidity = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.humidity);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.cloudiness)) {
                this.cloudiness = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.cloudiness);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.precipitation)) {
                this.precipitation = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.precipitation);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.precipitationPeriod)) {
                this.precipitationPeriod = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.precipitationPeriod);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.condition))) {
                this.condition = (WeatherCondition)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.condition));
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.source);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)((Object)other.locationSource))) {
                this.locationSource = (LocationType)((Object)this.data().deepCopy(this.fields()[12].schema(), (Object)other.locationSource));
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
        }

        private Builder(LocalWeather other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.sunrise)) {
                this.sunrise = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.sunrise);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sunset)) {
                this.sunset = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sunset);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.temperature)) {
                this.temperature = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.temperature);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.pressure)) {
                this.pressure = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.pressure);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.humidity)) {
                this.humidity = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.humidity);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.cloudiness)) {
                this.cloudiness = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.cloudiness);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.precipitation)) {
                this.precipitation = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.precipitation);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.precipitationPeriod)) {
                this.precipitationPeriod = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.precipitationPeriod);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.condition))) {
                this.condition = (WeatherCondition)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.condition));
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.source);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)((Object)other.locationSource))) {
                this.locationSource = (LocationType)((Object)this.data().deepCopy(this.fields()[12].schema(), (Object)other.locationSource));
                this.fieldSetFlags()[12] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getSunrise() {
            return this.sunrise;
        }

        public Builder setSunrise(Integer value) {
            this.validate(this.fields()[2], value);
            this.sunrise = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSunrise() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSunrise() {
            this.sunrise = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getSunset() {
            return this.sunset;
        }

        public Builder setSunset(Integer value) {
            this.validate(this.fields()[3], value);
            this.sunset = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSunset() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSunset() {
            this.sunset = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Float getTemperature() {
            return this.temperature;
        }

        public Builder setTemperature(Float value) {
            this.validate(this.fields()[4], value);
            this.temperature = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasTemperature() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearTemperature() {
            this.temperature = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Float getPressure() {
            return this.pressure;
        }

        public Builder setPressure(Float value) {
            this.validate(this.fields()[5], value);
            this.pressure = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasPressure() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearPressure() {
            this.pressure = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getHumidity() {
            return this.humidity;
        }

        public Builder setHumidity(Float value) {
            this.validate(this.fields()[6], value);
            this.humidity = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasHumidity() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearHumidity() {
            this.humidity = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getCloudiness() {
            return this.cloudiness;
        }

        public Builder setCloudiness(Float value) {
            this.validate(this.fields()[7], value);
            this.cloudiness = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasCloudiness() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearCloudiness() {
            this.cloudiness = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getPrecipitation() {
            return this.precipitation;
        }

        public Builder setPrecipitation(Float value) {
            this.validate(this.fields()[8], value);
            this.precipitation = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasPrecipitation() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearPrecipitation() {
            this.precipitation = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getPrecipitationPeriod() {
            return this.precipitationPeriod;
        }

        public Builder setPrecipitationPeriod(Integer value) {
            this.validate(this.fields()[9], value);
            this.precipitationPeriod = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasPrecipitationPeriod() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearPrecipitationPeriod() {
            this.precipitationPeriod = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public WeatherCondition getCondition() {
            return this.condition;
        }

        public Builder setCondition(WeatherCondition value) {
            this.validate(this.fields()[10], (Object)value);
            this.condition = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasCondition() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearCondition() {
            this.condition = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String value) {
            this.validate(this.fields()[11], value);
            this.source = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasSource() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearSource() {
            this.source = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public LocationType getLocationSource() {
            return this.locationSource;
        }

        public Builder setLocationSource(LocationType value) {
            this.validate(this.fields()[12], (Object)value);
            this.locationSource = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasLocationSource() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearLocationSource() {
            this.locationSource = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public LocalWeather build() {
            try {
                LocalWeather record = new LocalWeather();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.sunrise = this.fieldSetFlags()[2] ? this.sunrise : (Integer)this.defaultValue(this.fields()[2]);
                record.sunset = this.fieldSetFlags()[3] ? this.sunset : (Integer)this.defaultValue(this.fields()[3]);
                record.temperature = this.fieldSetFlags()[4] ? this.temperature : (Float)this.defaultValue(this.fields()[4]);
                record.pressure = this.fieldSetFlags()[5] ? this.pressure : (Float)this.defaultValue(this.fields()[5]);
                record.humidity = this.fieldSetFlags()[6] ? this.humidity : (Float)this.defaultValue(this.fields()[6]);
                record.cloudiness = this.fieldSetFlags()[7] ? this.cloudiness : (Float)this.defaultValue(this.fields()[7]);
                record.precipitation = this.fieldSetFlags()[8] ? this.precipitation : (Float)this.defaultValue(this.fields()[8]);
                record.precipitationPeriod = this.fieldSetFlags()[9] ? this.precipitationPeriod : (Integer)this.defaultValue(this.fields()[9]);
                record.condition = this.fieldSetFlags()[10] ? this.condition : (WeatherCondition)((Object)this.defaultValue(this.fields()[10]));
                record.source = this.fieldSetFlags()[11] ? this.source : (String)this.defaultValue(this.fields()[11]);
                record.locationSource = this.fieldSetFlags()[12] ? this.locationSource : (LocationType)((Object)this.defaultValue(this.fields()[12]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

