/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.phone;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.phone.PhoneSmsType;

@AvroGenerated
public class PhoneSms
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -1409783856266149980L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"PhoneSms\",\"namespace\":\"org.radarcns.passive.phone\",\"doc\":\"Data from log sent and received text messages.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"target\",\"type\":[\"null\",\"bytes\"],\"doc\":\"HMAC SHA-256 one-way source/target of the SMS. This hash of a given phone number will be the same unless the app is reinstalled. If the number is unknown or anonymous, this contains null.\",\"default\":null},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"PhoneSmsType\",\"doc\":\"Direction of an SMS.\",\"symbols\":[\"INCOMING\",\"OUTGOING\",\"OTHER\",\"UNKNOWN\"]},\"doc\":\"Direction of the SMS.\",\"default\":\"UNKNOWN\"},{\"name\":\"length\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of characters in the message (null if unknown).\",\"default\":null},{\"name\":\"targetIsContact\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Sms sender is a known contact (null if unknown).\",\"default\":null},{\"name\":\"targetIsNonNumeric\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Sms sender ID is replaced by text, e.g. a company name.\",\"default\":null},{\"name\":\"targetLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Length of the target phone number, -1 if not collected.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<PhoneSms> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<PhoneSms> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private ByteBuffer target;
    private PhoneSmsType type;
    private Integer length;
    private Boolean targetIsContact;
    private Boolean targetIsNonNumeric;
    private Integer targetLength;
    private static final DatumWriter<PhoneSms> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<PhoneSms> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<PhoneSms> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<PhoneSms> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<PhoneSms> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static PhoneSms fromByteBuffer(ByteBuffer b) throws IOException {
        return (PhoneSms)((Object)DECODER.decode(b));
    }

    public PhoneSms() {
    }

    public PhoneSms(Double time, Double timeReceived, ByteBuffer target, PhoneSmsType type, Integer length, Boolean targetIsContact, Boolean targetIsNonNumeric, Integer targetLength) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.target = target;
        this.type = type;
        this.length = length;
        this.targetIsContact = targetIsContact;
        this.targetIsNonNumeric = targetIsNonNumeric;
        this.targetLength = targetLength;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.target;
            }
            case 3: {
                return this.type;
            }
            case 4: {
                return this.length;
            }
            case 5: {
                return this.targetIsContact;
            }
            case 6: {
                return this.targetIsNonNumeric;
            }
            case 7: {
                return this.targetLength;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.target = (ByteBuffer)value$;
                break;
            }
            case 3: {
                this.type = (PhoneSmsType)((Object)value$);
                break;
            }
            case 4: {
                this.length = (Integer)value$;
                break;
            }
            case 5: {
                this.targetIsContact = (Boolean)value$;
                break;
            }
            case 6: {
                this.targetIsNonNumeric = (Boolean)value$;
                break;
            }
            case 7: {
                this.targetLength = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public ByteBuffer getTarget() {
        return this.target;
    }

    public void setTarget(ByteBuffer value) {
        this.target = value;
    }

    public PhoneSmsType getType() {
        return this.type;
    }

    public void setType(PhoneSmsType value) {
        this.type = value;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer value) {
        this.length = value;
    }

    public Boolean getTargetIsContact() {
        return this.targetIsContact;
    }

    public void setTargetIsContact(Boolean value) {
        this.targetIsContact = value;
    }

    public Boolean getTargetIsNonNumeric() {
        return this.targetIsNonNumeric;
    }

    public void setTargetIsNonNumeric(Boolean value) {
        this.targetIsNonNumeric = value;
    }

    public Integer getTargetLength() {
        return this.targetLength;
    }

    public void setTargetLength(Integer value) {
        this.targetLength = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(PhoneSms other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.target == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBytes(this.target);
        }
        out.writeEnum(this.type.ordinal());
        if (this.length == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.length.intValue());
        }
        if (this.targetIsContact == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.targetIsContact.booleanValue());
        }
        if (this.targetIsNonNumeric == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.targetIsNonNumeric.booleanValue());
        }
        if (this.targetLength == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.targetLength.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.target = null;
            } else {
                this.target = in.readBytes(this.target);
            }
            this.type = PhoneSmsType.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.length = null;
            } else {
                this.length = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.targetIsContact = null;
            } else {
                this.targetIsContact = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.targetIsNonNumeric = null;
            } else {
                this.targetIsNonNumeric = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.targetLength = null;
            } else {
                this.targetLength = in.readInt();
            }
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block10;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block10;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.target = null;
                            continue block10;
                        }
                        this.target = in.readBytes(this.target);
                        continue block10;
                    }
                    case 3: {
                        this.type = PhoneSmsType.values()[in.readEnum()];
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.length = null;
                            continue block10;
                        }
                        this.length = in.readInt();
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.targetIsContact = null;
                            continue block10;
                        }
                        this.targetIsContact = in.readBoolean();
                        continue block10;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.targetIsNonNumeric = null;
                            continue block10;
                        }
                        this.targetIsNonNumeric = in.readBoolean();
                        continue block10;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.targetLength = null;
                            continue block10;
                        }
                        this.targetLength = in.readInt();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<PhoneSms>
    implements RecordBuilder<PhoneSms> {
        private double time;
        private double timeReceived;
        private ByteBuffer target;
        private PhoneSmsType type;
        private Integer length;
        private Boolean targetIsContact;
        private Boolean targetIsNonNumeric;
        private Integer targetLength;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.target)) {
                this.target = (ByteBuffer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.target);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.type))) {
                this.type = (PhoneSmsType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.type));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.length)) {
                this.length = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.length);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.targetIsContact)) {
                this.targetIsContact = (Boolean)this.data().deepCopy(this.fields()[5].schema(), (Object)other.targetIsContact);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.targetIsNonNumeric)) {
                this.targetIsNonNumeric = (Boolean)this.data().deepCopy(this.fields()[6].schema(), (Object)other.targetIsNonNumeric);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.targetLength)) {
                this.targetLength = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.targetLength);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
        }

        private Builder(PhoneSms other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.target)) {
                this.target = (ByteBuffer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.target);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.type))) {
                this.type = (PhoneSmsType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.type));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.length)) {
                this.length = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.length);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.targetIsContact)) {
                this.targetIsContact = (Boolean)this.data().deepCopy(this.fields()[5].schema(), (Object)other.targetIsContact);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.targetIsNonNumeric)) {
                this.targetIsNonNumeric = (Boolean)this.data().deepCopy(this.fields()[6].schema(), (Object)other.targetIsNonNumeric);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.targetLength)) {
                this.targetLength = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.targetLength);
                this.fieldSetFlags()[7] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public ByteBuffer getTarget() {
            return this.target;
        }

        public Builder setTarget(ByteBuffer value) {
            this.validate(this.fields()[2], value);
            this.target = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasTarget() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearTarget() {
            this.target = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public PhoneSmsType getType() {
            return this.type;
        }

        public Builder setType(PhoneSmsType value) {
            this.validate(this.fields()[3], (Object)value);
            this.type = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getLength() {
            return this.length;
        }

        public Builder setLength(Integer value) {
            this.validate(this.fields()[4], value);
            this.length = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasLength() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearLength() {
            this.length = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Boolean getTargetIsContact() {
            return this.targetIsContact;
        }

        public Builder setTargetIsContact(Boolean value) {
            this.validate(this.fields()[5], value);
            this.targetIsContact = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasTargetIsContact() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearTargetIsContact() {
            this.targetIsContact = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Boolean getTargetIsNonNumeric() {
            return this.targetIsNonNumeric;
        }

        public Builder setTargetIsNonNumeric(Boolean value) {
            this.validate(this.fields()[6], value);
            this.targetIsNonNumeric = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasTargetIsNonNumeric() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearTargetIsNonNumeric() {
            this.targetIsNonNumeric = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getTargetLength() {
            return this.targetLength;
        }

        public Builder setTargetLength(Integer value) {
            this.validate(this.fields()[7], value);
            this.targetLength = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasTargetLength() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearTargetLength() {
            this.targetLength = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public PhoneSms build() {
            try {
                PhoneSms record = new PhoneSms();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.target = this.fieldSetFlags()[2] ? this.target : (ByteBuffer)this.defaultValue(this.fields()[2]);
                record.type = this.fieldSetFlags()[3] ? this.type : (PhoneSmsType)((Object)this.defaultValue(this.fields()[3]));
                record.length = this.fieldSetFlags()[4] ? this.length : (Integer)this.defaultValue(this.fields()[4]);
                record.targetIsContact = this.fieldSetFlags()[5] ? this.targetIsContact : (Boolean)this.defaultValue(this.fields()[5]);
                record.targetIsNonNumeric = this.fieldSetFlags()[6] ? this.targetIsNonNumeric : (Boolean)this.defaultValue(this.fields()[6]);
                record.targetLength = this.fieldSetFlags()[7] ? this.targetLength : (Integer)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

