/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.phone;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.phone.PhoneCallType;

@AvroGenerated
public class PhoneCall
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 2980673473262217352L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"PhoneCall\",\"namespace\":\"org.radarcns.passive.phone\",\"doc\":\"Data from the log of received and made calls.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"duration\",\"type\":[\"null\",\"float\"],\"doc\":\"Duration of the call (s).\",\"default\":null},{\"name\":\"target\",\"type\":[\"null\",\"bytes\"],\"doc\":\"HMAC SHA-256 one-way source/target of the call. This hash of a given phone number will be the same unless the app is reinstalled. If the number is unknown or anonymous, this contains null.\",\"default\":null},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"PhoneCallType\",\"doc\":\"Type of Android call.\",\"symbols\":[\"INCOMING\",\"OUTGOING\",\"MISSED\",\"VOICEMAIL\",\"UNKNOWN\"]},\"doc\":\"Direction of phone call.\",\"default\":\"UNKNOWN\"},{\"name\":\"targetIsContact\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Call to/from a known contact, null if unknown.\",\"default\":null},{\"name\":\"targetIsNonNumeric\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Sms sender ID is replaced by text, e.g. a company name.\",\"default\":null},{\"name\":\"targetLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Length of the target phone number, -1 if not collected.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<PhoneCall> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<PhoneCall> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private Float duration;
    private ByteBuffer target;
    private PhoneCallType type;
    private Boolean targetIsContact;
    private Boolean targetIsNonNumeric;
    private Integer targetLength;
    private static final DatumWriter<PhoneCall> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<PhoneCall> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<PhoneCall> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<PhoneCall> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<PhoneCall> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static PhoneCall fromByteBuffer(ByteBuffer b) throws IOException {
        return (PhoneCall)((Object)DECODER.decode(b));
    }

    public PhoneCall() {
    }

    public PhoneCall(Double time, Double timeReceived, Float duration, ByteBuffer target, PhoneCallType type, Boolean targetIsContact, Boolean targetIsNonNumeric, Integer targetLength) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.duration = duration;
        this.target = target;
        this.type = type;
        this.targetIsContact = targetIsContact;
        this.targetIsNonNumeric = targetIsNonNumeric;
        this.targetLength = targetLength;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.duration;
            }
            case 3: {
                return this.target;
            }
            case 4: {
                return this.type;
            }
            case 5: {
                return this.targetIsContact;
            }
            case 6: {
                return this.targetIsNonNumeric;
            }
            case 7: {
                return this.targetLength;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.duration = (Float)value$;
                break;
            }
            case 3: {
                this.target = (ByteBuffer)value$;
                break;
            }
            case 4: {
                this.type = (PhoneCallType)((Object)value$);
                break;
            }
            case 5: {
                this.targetIsContact = (Boolean)value$;
                break;
            }
            case 6: {
                this.targetIsNonNumeric = (Boolean)value$;
                break;
            }
            case 7: {
                this.targetLength = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float value) {
        this.duration = value;
    }

    public ByteBuffer getTarget() {
        return this.target;
    }

    public void setTarget(ByteBuffer value) {
        this.target = value;
    }

    public PhoneCallType getType() {
        return this.type;
    }

    public void setType(PhoneCallType value) {
        this.type = value;
    }

    public Boolean getTargetIsContact() {
        return this.targetIsContact;
    }

    public void setTargetIsContact(Boolean value) {
        this.targetIsContact = value;
    }

    public Boolean getTargetIsNonNumeric() {
        return this.targetIsNonNumeric;
    }

    public void setTargetIsNonNumeric(Boolean value) {
        this.targetIsNonNumeric = value;
    }

    public Integer getTargetLength() {
        return this.targetLength;
    }

    public void setTargetLength(Integer value) {
        this.targetLength = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(PhoneCall other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.duration.floatValue());
        }
        if (this.target == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBytes(this.target);
        }
        out.writeEnum(this.type.ordinal());
        if (this.targetIsContact == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.targetIsContact.booleanValue());
        }
        if (this.targetIsNonNumeric == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.targetIsNonNumeric.booleanValue());
        }
        if (this.targetLength == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.targetLength.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.target = null;
            } else {
                this.target = in.readBytes(this.target);
            }
            this.type = PhoneCallType.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.targetIsContact = null;
            } else {
                this.targetIsContact = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.targetIsNonNumeric = null;
            } else {
                this.targetIsNonNumeric = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.targetLength = null;
            } else {
                this.targetLength = in.readInt();
            }
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block10;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block10;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block10;
                        }
                        this.duration = Float.valueOf(in.readFloat());
                        continue block10;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.target = null;
                            continue block10;
                        }
                        this.target = in.readBytes(this.target);
                        continue block10;
                    }
                    case 4: {
                        this.type = PhoneCallType.values()[in.readEnum()];
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.targetIsContact = null;
                            continue block10;
                        }
                        this.targetIsContact = in.readBoolean();
                        continue block10;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.targetIsNonNumeric = null;
                            continue block10;
                        }
                        this.targetIsNonNumeric = in.readBoolean();
                        continue block10;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.targetLength = null;
                            continue block10;
                        }
                        this.targetLength = in.readInt();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<PhoneCall>
    implements RecordBuilder<PhoneCall> {
        private double time;
        private double timeReceived;
        private Float duration;
        private ByteBuffer target;
        private PhoneCallType type;
        private Boolean targetIsContact;
        private Boolean targetIsNonNumeric;
        private Integer targetLength;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.duration)) {
                this.duration = (Float)this.data().deepCopy(this.fields()[2].schema(), (Object)other.duration);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.target)) {
                this.target = (ByteBuffer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.target);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.type))) {
                this.type = (PhoneCallType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.type));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.targetIsContact)) {
                this.targetIsContact = (Boolean)this.data().deepCopy(this.fields()[5].schema(), (Object)other.targetIsContact);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.targetIsNonNumeric)) {
                this.targetIsNonNumeric = (Boolean)this.data().deepCopy(this.fields()[6].schema(), (Object)other.targetIsNonNumeric);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.targetLength)) {
                this.targetLength = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.targetLength);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
        }

        private Builder(PhoneCall other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.duration)) {
                this.duration = (Float)this.data().deepCopy(this.fields()[2].schema(), (Object)other.duration);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.target)) {
                this.target = (ByteBuffer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.target);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.type))) {
                this.type = (PhoneCallType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.type));
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.targetIsContact)) {
                this.targetIsContact = (Boolean)this.data().deepCopy(this.fields()[5].schema(), (Object)other.targetIsContact);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.targetIsNonNumeric)) {
                this.targetIsNonNumeric = (Boolean)this.data().deepCopy(this.fields()[6].schema(), (Object)other.targetIsNonNumeric);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.targetLength)) {
                this.targetLength = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.targetLength);
                this.fieldSetFlags()[7] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Float getDuration() {
            return this.duration;
        }

        public Builder setDuration(Float value) {
            this.validate(this.fields()[2], value);
            this.duration = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public ByteBuffer getTarget() {
            return this.target;
        }

        public Builder setTarget(ByteBuffer value) {
            this.validate(this.fields()[3], value);
            this.target = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasTarget() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearTarget() {
            this.target = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public PhoneCallType getType() {
            return this.type;
        }

        public Builder setType(PhoneCallType value) {
            this.validate(this.fields()[4], (Object)value);
            this.type = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Boolean getTargetIsContact() {
            return this.targetIsContact;
        }

        public Builder setTargetIsContact(Boolean value) {
            this.validate(this.fields()[5], value);
            this.targetIsContact = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasTargetIsContact() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearTargetIsContact() {
            this.targetIsContact = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Boolean getTargetIsNonNumeric() {
            return this.targetIsNonNumeric;
        }

        public Builder setTargetIsNonNumeric(Boolean value) {
            this.validate(this.fields()[6], value);
            this.targetIsNonNumeric = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasTargetIsNonNumeric() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearTargetIsNonNumeric() {
            this.targetIsNonNumeric = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getTargetLength() {
            return this.targetLength;
        }

        public Builder setTargetLength(Integer value) {
            this.validate(this.fields()[7], value);
            this.targetLength = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasTargetLength() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearTargetLength() {
            this.targetLength = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public PhoneCall build() {
            try {
                PhoneCall record = new PhoneCall();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.duration = this.fieldSetFlags()[2] ? this.duration : (Float)this.defaultValue(this.fields()[2]);
                record.target = this.fieldSetFlags()[3] ? this.target : (ByteBuffer)this.defaultValue(this.fields()[3]);
                record.type = this.fieldSetFlags()[4] ? this.type : (PhoneCallType)((Object)this.defaultValue(this.fields()[4]));
                record.targetIsContact = this.fieldSetFlags()[5] ? this.targetIsContact : (Boolean)this.defaultValue(this.fields()[5]);
                record.targetIsNonNumeric = this.fieldSetFlags()[6] ? this.targetIsNonNumeric : (Boolean)this.defaultValue(this.fields()[6]);
                record.targetLength = this.fieldSetFlags()[7] ? this.targetLength : (Integer)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

