/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.pebble;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Pebble2BatteryLevel
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5502240440986356204L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Pebble2BatteryLevel\",\"namespace\":\"org.radarcns.passive.pebble\",\"doc\":\"Device battery level.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"batteryLevel\",\"type\":\"float\",\"doc\":\"Battery level from 0 to 1.\"},{\"name\":\"batteryIsCharging\",\"type\":\"boolean\",\"doc\":\"Whether the battery is being charged.\"},{\"name\":\"batteryIsPlugged\",\"type\":\"boolean\",\"doc\":\"Whether the battery charger cable is plugged in.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Pebble2BatteryLevel> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Pebble2BatteryLevel> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float batteryLevel;
    private boolean batteryIsCharging;
    private boolean batteryIsPlugged;
    private static final DatumWriter<Pebble2BatteryLevel> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Pebble2BatteryLevel> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<Pebble2BatteryLevel> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<Pebble2BatteryLevel> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Pebble2BatteryLevel> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Pebble2BatteryLevel fromByteBuffer(ByteBuffer b) throws IOException {
        return (Pebble2BatteryLevel)((Object)DECODER.decode(b));
    }

    public Pebble2BatteryLevel() {
    }

    public Pebble2BatteryLevel(Double time, Double timeReceived, Float batteryLevel, Boolean batteryIsCharging, Boolean batteryIsPlugged) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.batteryLevel = batteryLevel.floatValue();
        this.batteryIsCharging = batteryIsCharging;
        this.batteryIsPlugged = batteryIsPlugged;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.batteryLevel);
            }
            case 3: {
                return this.batteryIsCharging;
            }
            case 4: {
                return this.batteryIsPlugged;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.batteryLevel = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.batteryIsCharging = (Boolean)value$;
                break;
            }
            case 4: {
                this.batteryIsPlugged = (Boolean)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getBatteryLevel() {
        return this.batteryLevel;
    }

    public void setBatteryLevel(float value) {
        this.batteryLevel = value;
    }

    public boolean getBatteryIsCharging() {
        return this.batteryIsCharging;
    }

    public void setBatteryIsCharging(boolean value) {
        this.batteryIsCharging = value;
    }

    public boolean getBatteryIsPlugged() {
        return this.batteryIsPlugged;
    }

    public void setBatteryIsPlugged(boolean value) {
        this.batteryIsPlugged = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(Pebble2BatteryLevel other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.batteryLevel);
        out.writeBoolean(this.batteryIsCharging);
        out.writeBoolean(this.batteryIsPlugged);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.batteryLevel = in.readFloat();
            this.batteryIsCharging = in.readBoolean();
            this.batteryIsPlugged = in.readBoolean();
        } else {
            block7: for (int i = 0; i < 5; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block7;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block7;
                    }
                    case 2: {
                        this.batteryLevel = in.readFloat();
                        continue block7;
                    }
                    case 3: {
                        this.batteryIsCharging = in.readBoolean();
                        continue block7;
                    }
                    case 4: {
                        this.batteryIsPlugged = in.readBoolean();
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<Pebble2BatteryLevel>
    implements RecordBuilder<Pebble2BatteryLevel> {
        private double time;
        private double timeReceived;
        private float batteryLevel;
        private boolean batteryIsCharging;
        private boolean batteryIsPlugged;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.batteryLevel))) {
                this.batteryLevel = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.batteryLevel))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.batteryIsCharging)) {
                this.batteryIsCharging = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.batteryIsCharging);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.batteryIsPlugged)) {
                this.batteryIsPlugged = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.batteryIsPlugged);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
        }

        private Builder(Pebble2BatteryLevel other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.batteryLevel))) {
                this.batteryLevel = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.batteryLevel))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.batteryIsCharging)) {
                this.batteryIsCharging = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.batteryIsCharging);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.batteryIsPlugged)) {
                this.batteryIsPlugged = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.batteryIsPlugged);
                this.fieldSetFlags()[4] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getBatteryLevel() {
            return this.batteryLevel;
        }

        public Builder setBatteryLevel(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.batteryLevel = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasBatteryLevel() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearBatteryLevel() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public boolean getBatteryIsCharging() {
            return this.batteryIsCharging;
        }

        public Builder setBatteryIsCharging(boolean value) {
            this.validate(this.fields()[3], value);
            this.batteryIsCharging = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasBatteryIsCharging() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearBatteryIsCharging() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public boolean getBatteryIsPlugged() {
            return this.batteryIsPlugged;
        }

        public Builder setBatteryIsPlugged(boolean value) {
            this.validate(this.fields()[4], value);
            this.batteryIsPlugged = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasBatteryIsPlugged() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearBatteryIsPlugged() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Pebble2BatteryLevel build() {
            try {
                Pebble2BatteryLevel record = new Pebble2BatteryLevel();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.batteryLevel = this.fieldSetFlags()[2] ? this.batteryLevel : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.batteryIsCharging = this.fieldSetFlags()[3] ? this.batteryIsCharging : (Boolean)this.defaultValue(this.fields()[3]);
                record.batteryIsPlugged = this.fieldSetFlags()[4] ? this.batteryIsPlugged : (Boolean)this.defaultValue(this.fields()[4]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

