/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.google;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.google.SleepClassificationStatus;

@AvroGenerated
public class GoogleSleepSegmentEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4942994159316008538L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GoogleSleepSegmentEvent\",\"namespace\":\"org.radarcns.passive.google\",\"doc\":\"Represents the result of sleep data after the user is awake.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"The UNIX epoch time (s) for the moment when the user goes to sleep.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"endTime\",\"type\":\"double\",\"doc\":\"The UNIX epoch time (s) for the moment when the user wakes up.\"},{\"name\":\"status\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"SleepClassificationStatus\",\"doc\":\"The status of the sleep segment detection. \\nSUCCESSFUL indicates successful detection of sleep segment in the past day.\\nNOT_DETECTED indicates Sleep segment is not detected in the past day, or there isn't enough confidence that the user slept during the past day. This could happen for a variety of reasons, including the following: too much missing data, the user sleeps with the light, the user interacts with their device often, or the user's device doesn't support the sensors needed for sleep detection. \\nMISSING_DATA indicates sleep segment was detected, but there was some missing data near the detected sleep segment. This could happen for a variety of reasons, including the following: the user turned off their device, the user delayed logging into their device after a system reboot or system upgrade, or an event occurred that paused the detection.\",\"symbols\":[\"SUCCESSFUL\",\"MISSING_DATA\",\"NOT_DETECTED\",\"UNKNOWN\"]}],\"doc\":\"Status that indicates whether the system succeeded in detecting sleep.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GoogleSleepSegmentEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GoogleSleepSegmentEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private double endTime;
    private SleepClassificationStatus status;
    private static final DatumWriter<GoogleSleepSegmentEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GoogleSleepSegmentEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GoogleSleepSegmentEvent> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GoogleSleepSegmentEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GoogleSleepSegmentEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GoogleSleepSegmentEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (GoogleSleepSegmentEvent)((Object)DECODER.decode(b));
    }

    public GoogleSleepSegmentEvent() {
    }

    public GoogleSleepSegmentEvent(Double time, Double timeReceived, Double endTime, SleepClassificationStatus status) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.endTime = endTime;
        this.status = status;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.endTime;
            }
            case 3: {
                return this.status;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.endTime = (Double)value$;
                break;
            }
            case 3: {
                this.status = (SleepClassificationStatus)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double value) {
        this.endTime = value;
    }

    public SleepClassificationStatus getStatus() {
        return this.status;
    }

    public void setStatus(SleepClassificationStatus value) {
        this.status = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GoogleSleepSegmentEvent other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeDouble(this.endTime);
        if (this.status == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.status.ordinal());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.endTime = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.status = null;
            } else {
                this.status = SleepClassificationStatus.values()[in.readEnum()];
            }
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.endTime = in.readDouble();
                        continue block6;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.status = null;
                            continue block6;
                        }
                        this.status = SleepClassificationStatus.values()[in.readEnum()];
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GoogleSleepSegmentEvent>
    implements RecordBuilder<GoogleSleepSegmentEvent> {
        private double time;
        private double timeReceived;
        private double endTime;
        private SleepClassificationStatus status;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.endTime);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.status))) {
                this.status = (SleepClassificationStatus)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.status));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(GoogleSleepSegmentEvent other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.endTime)) {
                this.endTime = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.endTime);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.status))) {
                this.status = (SleepClassificationStatus)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.status));
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public double getEndTime() {
            return this.endTime;
        }

        public Builder setEndTime(double value) {
            this.validate(this.fields()[2], value);
            this.endTime = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasEndTime() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearEndTime() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public SleepClassificationStatus getStatus() {
            return this.status;
        }

        public Builder setStatus(SleepClassificationStatus value) {
            this.validate(this.fields()[3], (Object)value);
            this.status = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasStatus() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearStatus() {
            this.status = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public GoogleSleepSegmentEvent build() {
            try {
                GoogleSleepSegmentEvent record = new GoogleSleepSegmentEvent();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.endTime = this.fieldSetFlags()[2] ? this.endTime : (Double)this.defaultValue(this.fields()[2]);
                record.status = this.fieldSetFlags()[3] ? this.status : (SleepClassificationStatus)((Object)this.defaultValue(this.fields()[3]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

