/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.google;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GoogleSleepClassifyEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -881116337996399232L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GoogleSleepClassifyEvent\",\"namespace\":\"org.radarcns.passive.google\",\"doc\":\"Sleep classification event that indicates that the user is probably sleeping. Includes sleep confidence, device motion and ambient light level.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"sleepConfidence\",\"type\":\"float\",\"doc\":\"Sleep confidence value between 0-1. Higher value indicate that the user is more likely sleeping, while lower values indicate that the user is more likely awake.\"},{\"name\":\"light\",\"type\":\"int\",\"doc\":\"The brightness of the space around the device, based on the device's ambient light sensor readings. Value ranges from 1 to 6, inclusive. Higher values indicate brighter surroundings, while lower values indicate darker surroundings.\"},{\"name\":\"motion\",\"type\":\"int\",\"doc\":\"The amount of device motion, based on the device's accelerometer readings. Value ranges from 1 to 6, inclusive. Higher values indicate more movement of the device.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GoogleSleepClassifyEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GoogleSleepClassifyEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float sleepConfidence;
    private int light;
    private int motion;
    private static final DatumWriter<GoogleSleepClassifyEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GoogleSleepClassifyEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GoogleSleepClassifyEvent> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GoogleSleepClassifyEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GoogleSleepClassifyEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GoogleSleepClassifyEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (GoogleSleepClassifyEvent)((Object)DECODER.decode(b));
    }

    public GoogleSleepClassifyEvent() {
    }

    public GoogleSleepClassifyEvent(Double time, Double timeReceived, Float sleepConfidence, Integer light, Integer motion) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.sleepConfidence = sleepConfidence.floatValue();
        this.light = light;
        this.motion = motion;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.sleepConfidence);
            }
            case 3: {
                return this.light;
            }
            case 4: {
                return this.motion;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.sleepConfidence = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.light = (Integer)value$;
                break;
            }
            case 4: {
                this.motion = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getSleepConfidence() {
        return this.sleepConfidence;
    }

    public void setSleepConfidence(float value) {
        this.sleepConfidence = value;
    }

    public int getLight() {
        return this.light;
    }

    public void setLight(int value) {
        this.light = value;
    }

    public int getMotion() {
        return this.motion;
    }

    public void setMotion(int value) {
        this.motion = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GoogleSleepClassifyEvent other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.sleepConfidence);
        out.writeInt(this.light);
        out.writeInt(this.motion);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.sleepConfidence = in.readFloat();
            this.light = in.readInt();
            this.motion = in.readInt();
        } else {
            block7: for (int i = 0; i < 5; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block7;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block7;
                    }
                    case 2: {
                        this.sleepConfidence = in.readFloat();
                        continue block7;
                    }
                    case 3: {
                        this.light = in.readInt();
                        continue block7;
                    }
                    case 4: {
                        this.motion = in.readInt();
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GoogleSleepClassifyEvent>
    implements RecordBuilder<GoogleSleepClassifyEvent> {
        private double time;
        private double timeReceived;
        private float sleepConfidence;
        private int light;
        private int motion;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.sleepConfidence))) {
                this.sleepConfidence = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.sleepConfidence))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.light)) {
                this.light = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.light);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.motion)) {
                this.motion = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.motion);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
        }

        private Builder(GoogleSleepClassifyEvent other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.sleepConfidence))) {
                this.sleepConfidence = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.sleepConfidence))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.light)) {
                this.light = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.light);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.motion)) {
                this.motion = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.motion);
                this.fieldSetFlags()[4] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getSleepConfidence() {
            return this.sleepConfidence;
        }

        public Builder setSleepConfidence(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.sleepConfidence = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSleepConfidence() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSleepConfidence() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getLight() {
            return this.light;
        }

        public Builder setLight(int value) {
            this.validate(this.fields()[3], value);
            this.light = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasLight() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearLight() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public int getMotion() {
            return this.motion;
        }

        public Builder setMotion(int value) {
            this.validate(this.fields()[4], value);
            this.motion = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasMotion() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearMotion() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public GoogleSleepClassifyEvent build() {
            try {
                GoogleSleepClassifyEvent record = new GoogleSleepClassifyEvent();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.sleepConfidence = this.fieldSetFlags()[2] ? this.sleepConfidence : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.light = this.fieldSetFlags()[3] ? this.light : (Integer)this.defaultValue(this.fields()[3]);
                record.motion = this.fieldSetFlags()[4] ? this.motion : (Integer)this.defaultValue(this.fields()[4]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

