/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.google;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.google.PlacesType;

@AvroGenerated
public class GooglePlacesInfo
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -598668894396214845L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GooglePlacesInfo\",\"namespace\":\"org.radarcns.passive.google\",\"doc\":\"Information of places where the user\u2019s device is last known to be located along with an indication of the relative likelihood for each place.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"type1\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"PlacesType\",\"doc\":\"The predefined categories or tags assigned to different places based on their characteristics. These types can represent various categories such as restaurants, cafes, museums, parks, hotels, airports, hospitals, and more.\",\"symbols\":[\"ACCOUNTING\",\"ADMINISTRATIVE_AREA_LEVEL_1\",\"ADMINISTRATIVE_AREA_LEVEL_2\",\"ADMINISTRATIVE_AREA_LEVEL_3\",\"ADMINISTRATIVE_AREA_LEVEL_4\",\"ADMINISTRATIVE_AREA_LEVEL_5\",\"AIRPORT\",\"AMUSEMENT_PARK\",\"AQUARIUM\",\"ARCHIPELAGO\",\"ART_GALLERY\",\"ATM\",\"BAKERY\",\"BANK\",\"BAR\",\"BEAUTY_SALON\",\"BICYCLE_STORE\",\"BOOK_STORE\",\"BOWLING_ALLEY\",\"BUS_STATION\",\"CAFE\",\"CAMPGROUND\",\"CAR_DEALER\",\"CAR_RENTAL\",\"CAR_REPAIR\",\"CAR_WASH\",\"CASINO\",\"CEMETERY\",\"CHURCH\",\"CITY_HALL\",\"CLOTHING_STORE\",\"COLLOQUIAL_AREA\",\"CONTINENT\",\"CONVENIENCE_STORE\",\"COUNTRY\",\"COURTHOUSE\",\"DENTIST\",\"DEPARTMENT_STORE\",\"DOCTOR\",\"DRUGSTORE\",\"ELECTRICIAN\",\"ELECTRONICS_STORE\",\"EMBASSY\",\"ESTABLISHMENT\",\"FINANCE\",\"FIRE_STATION\",\"FLOOR\",\"FLORIST\",\"FOOD\",\"FUNERAL_HOME\",\"FURNITURE_STORE\",\"GAS_STATION\",\"GENERAL_CONTRACTOR\",\"GEOCODE\",\"GROCERY_OR_SUPERMARKET\",\"GYM\",\"HAIR_CARE\",\"HARDWARE_STORE\",\"HEALTH\",\"HINDU_TEMPLE\",\"HOME_GOODS_STORE\",\"HOSPITAL\",\"INSURANCE_AGENCY\",\"INTERSECTION\",\"JEWELRY_STORE\",\"LAUNDRY\",\"LAWYER\",\"LIBRARY\",\"LIGHT_RAIL_STATION\",\"LIQUOR_STORE\",\"LOCAL_GOVERNMENT_OFFICE\",\"LOCALITY\",\"LOCKSMITH\",\"LODGING\",\"MEAL_DELIVERY\",\"MEAL_TAKEAWAY\",\"MOSQUE\",\"MOVIE_RENTAL\",\"MOVIE_THEATER\",\"MOVING_COMPANY\",\"MUSEUM\",\"NATURAL_FEATURE\",\"NEIGHBORHOOD\",\"NIGHT_CLUB\",\"PAINTER\",\"PARK\",\"PARKING\",\"PET_STORE\",\"PHARMACY\",\"PHYSIOTHERAPIST\",\"PLACE_OF_WORSHIP\",\"PLUMBER\",\"PLUS_CODE\",\"POINT_OF_INTEREST\",\"POLICE\",\"POLITICAL\",\"POST_BOX\",\"POST_OFFICE\",\"POSTAL_CODE_PREFIX\",\"POSTAL_CODE_SUFFIX\",\"POSTAL_CODE\",\"POSTAL_TOWN\",\"PREMISE\",\"PRIMARY_SCHOOL\",\"REAL_ESTATE_AGENCY\",\"RESTAURANT\",\"ROOFING_CONTRACTOR\",\"ROOM\",\"ROUTE\",\"RV_PARK\",\"SCHOOL\",\"SECONDARY_SCHOOL\",\"SHOE_STORE\",\"SHOPPING_MALL\",\"SPA\",\"STADIUM\",\"STORAGE\",\"STORE\",\"STREET_ADDRESS\",\"STREET_NUMBER\",\"SUBLOCALITY_LEVEL_1\",\"SUBLOCALITY_LEVEL_2\",\"SUBLOCALITY_LEVEL_3\",\"SUBLOCALITY_LEVEL_4\",\"SUBLOCALITY_LEVEL_5\",\"SUBLOCALITY\",\"SUBPREMISE\",\"SUBWAY_STATION\",\"SUPERMARKET\",\"SYNAGOGUE\",\"TAXI_STAND\",\"TOURIST_ATTRACTION\",\"TOWN_SQUARE\",\"TRAIN_STATION\",\"TRANSIT_STATION\",\"TRAVEL_AGENCY\",\"UNIVERSITY\",\"VETERINARY_CARE\",\"ZOO\"]}],\"doc\":\"Categorizing places based on their characteristics or attributes, this field represents the first type, if any, among the retrieved place categories.\",\"default\":null},{\"name\":\"type2\",\"type\":[\"null\",\"PlacesType\"],\"doc\":\"Categorizing places based on their characteristics or attributes, this field represents the second type, if any, among the retrieved place categories.\",\"default\":null},{\"name\":\"type3\",\"type\":[\"null\",\"PlacesType\"],\"doc\":\"Categorizing places based on their characteristics or attributes, this field represents the third type, if any, among the retrieved place categories.\",\"default\":null},{\"name\":\"type4\",\"type\":[\"null\",\"PlacesType\"],\"doc\":\"Categorizing places based on their characteristics or attributes, this field represents the fourth type, if any, among the retrieved place categories.\",\"default\":null},{\"name\":\"city\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The city returned corresponds to the current location of the user's device.\",\"default\":null},{\"name\":\"state\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The state returned corresponds to the current location of the user's device.\",\"default\":null},{\"name\":\"country\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The country returned corresponds to the current location of the user's device.\",\"default\":null},{\"name\":\"placeId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A unique identifier assigned to each place in the Google Places database. It serves as a specific reference or key to a particular place entry and is used to retrieve detailed information about that place. By default, it is not retrieved to respect the user's privacy. To retrieve place IDs, Firebase parameters need to be explicitly set.\",\"default\":null},{\"name\":\"likelihood\",\"type\":\"double\",\"doc\":\"The likelihood provides a relative probability of the place being the best match within the list of returned places for a single request. A higher value means a greater probability that the place is the best match. It's value ranges between 0.0 and 1.0.\"},{\"name\":\"fromBroadcast\",\"type\":\"boolean\",\"doc\":\"Whether the data was generated as a result of a change in device location (true) or as part of a fixed scheduled intervals (false).\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GooglePlacesInfo> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GooglePlacesInfo> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private PlacesType type1;
    private PlacesType type2;
    private PlacesType type3;
    private PlacesType type4;
    private String city;
    private String state;
    private String country;
    private String placeId;
    private double likelihood;
    private boolean fromBroadcast;
    private static final DatumWriter<GooglePlacesInfo> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GooglePlacesInfo> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GooglePlacesInfo> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GooglePlacesInfo> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GooglePlacesInfo> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GooglePlacesInfo fromByteBuffer(ByteBuffer b) throws IOException {
        return (GooglePlacesInfo)((Object)DECODER.decode(b));
    }

    public GooglePlacesInfo() {
    }

    public GooglePlacesInfo(Double time, Double timeReceived, PlacesType type1, PlacesType type2, PlacesType type3, PlacesType type4, String city, String state, String country, String placeId, Double likelihood, Boolean fromBroadcast) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.type1 = type1;
        this.type2 = type2;
        this.type3 = type3;
        this.type4 = type4;
        this.city = city;
        this.state = state;
        this.country = country;
        this.placeId = placeId;
        this.likelihood = likelihood;
        this.fromBroadcast = fromBroadcast;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.type1;
            }
            case 3: {
                return this.type2;
            }
            case 4: {
                return this.type3;
            }
            case 5: {
                return this.type4;
            }
            case 6: {
                return this.city;
            }
            case 7: {
                return this.state;
            }
            case 8: {
                return this.country;
            }
            case 9: {
                return this.placeId;
            }
            case 10: {
                return this.likelihood;
            }
            case 11: {
                return this.fromBroadcast;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.type1 = (PlacesType)((Object)value$);
                break;
            }
            case 3: {
                this.type2 = (PlacesType)((Object)value$);
                break;
            }
            case 4: {
                this.type3 = (PlacesType)((Object)value$);
                break;
            }
            case 5: {
                this.type4 = (PlacesType)((Object)value$);
                break;
            }
            case 6: {
                this.city = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.state = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.country = value$ != null ? value$.toString() : null;
                break;
            }
            case 9: {
                this.placeId = value$ != null ? value$.toString() : null;
                break;
            }
            case 10: {
                this.likelihood = (Double)value$;
                break;
            }
            case 11: {
                this.fromBroadcast = (Boolean)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public PlacesType getType1() {
        return this.type1;
    }

    public void setType1(PlacesType value) {
        this.type1 = value;
    }

    public PlacesType getType2() {
        return this.type2;
    }

    public void setType2(PlacesType value) {
        this.type2 = value;
    }

    public PlacesType getType3() {
        return this.type3;
    }

    public void setType3(PlacesType value) {
        this.type3 = value;
    }

    public PlacesType getType4() {
        return this.type4;
    }

    public void setType4(PlacesType value) {
        this.type4 = value;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String value) {
        this.city = value;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String value) {
        this.state = value;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String value) {
        this.country = value;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String value) {
        this.placeId = value;
    }

    public double getLikelihood() {
        return this.likelihood;
    }

    public void setLikelihood(double value) {
        this.likelihood = value;
    }

    public boolean getFromBroadcast() {
        return this.fromBroadcast;
    }

    public void setFromBroadcast(boolean value) {
        this.fromBroadcast = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GooglePlacesInfo other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.type1 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.type1.ordinal());
        }
        if (this.type2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.type2.ordinal());
        }
        if (this.type3 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.type3.ordinal());
        }
        if (this.type4 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.type4.ordinal());
        }
        if (this.city == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.city);
        }
        if (this.state == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.state);
        }
        if (this.country == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.country);
        }
        if (this.placeId == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.placeId);
        }
        out.writeDouble(this.likelihood);
        out.writeBoolean(this.fromBroadcast);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.type1 = null;
            } else {
                this.type1 = PlacesType.values()[in.readEnum()];
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.type2 = null;
            } else {
                this.type2 = PlacesType.values()[in.readEnum()];
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.type3 = null;
            } else {
                this.type3 = PlacesType.values()[in.readEnum()];
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.type4 = null;
            } else {
                this.type4 = PlacesType.values()[in.readEnum()];
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.city = null;
            } else {
                this.city = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.state = null;
            } else {
                this.state = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.country = null;
            } else {
                this.country = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.placeId = null;
            } else {
                this.placeId = in.readString();
            }
            this.likelihood = in.readDouble();
            this.fromBroadcast = in.readBoolean();
        } else {
            block14: for (int i = 0; i < 12; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block14;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block14;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.type1 = null;
                            continue block14;
                        }
                        this.type1 = PlacesType.values()[in.readEnum()];
                        continue block14;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.type2 = null;
                            continue block14;
                        }
                        this.type2 = PlacesType.values()[in.readEnum()];
                        continue block14;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.type3 = null;
                            continue block14;
                        }
                        this.type3 = PlacesType.values()[in.readEnum()];
                        continue block14;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.type4 = null;
                            continue block14;
                        }
                        this.type4 = PlacesType.values()[in.readEnum()];
                        continue block14;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.city = null;
                            continue block14;
                        }
                        this.city = in.readString();
                        continue block14;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.state = null;
                            continue block14;
                        }
                        this.state = in.readString();
                        continue block14;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.country = null;
                            continue block14;
                        }
                        this.country = in.readString();
                        continue block14;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.placeId = null;
                            continue block14;
                        }
                        this.placeId = in.readString();
                        continue block14;
                    }
                    case 10: {
                        this.likelihood = in.readDouble();
                        continue block14;
                    }
                    case 11: {
                        this.fromBroadcast = in.readBoolean();
                        continue block14;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GooglePlacesInfo>
    implements RecordBuilder<GooglePlacesInfo> {
        private double time;
        private double timeReceived;
        private PlacesType type1;
        private PlacesType type2;
        private PlacesType type3;
        private PlacesType type4;
        private String city;
        private String state;
        private String country;
        private String placeId;
        private double likelihood;
        private boolean fromBroadcast;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.type1))) {
                this.type1 = (PlacesType)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.type1));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.type2))) {
                this.type2 = (PlacesType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.type2));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.type3))) {
                this.type3 = (PlacesType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.type3));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.type4))) {
                this.type4 = (PlacesType)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.type4));
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.city)) {
                this.city = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.city);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.state)) {
                this.state = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.state);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.country)) {
                this.country = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.country);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.placeId)) {
                this.placeId = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.placeId);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.likelihood)) {
                this.likelihood = (Double)this.data().deepCopy(this.fields()[10].schema(), (Object)other.likelihood);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.fromBroadcast)) {
                this.fromBroadcast = (Boolean)this.data().deepCopy(this.fields()[11].schema(), (Object)other.fromBroadcast);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
        }

        private Builder(GooglePlacesInfo other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.type1))) {
                this.type1 = (PlacesType)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.type1));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.type2))) {
                this.type2 = (PlacesType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.type2));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.type3))) {
                this.type3 = (PlacesType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.type3));
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.type4))) {
                this.type4 = (PlacesType)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.type4));
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.city)) {
                this.city = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.city);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.state)) {
                this.state = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.state);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.country)) {
                this.country = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.country);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.placeId)) {
                this.placeId = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.placeId);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.likelihood)) {
                this.likelihood = (Double)this.data().deepCopy(this.fields()[10].schema(), (Object)other.likelihood);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.fromBroadcast)) {
                this.fromBroadcast = (Boolean)this.data().deepCopy(this.fields()[11].schema(), (Object)other.fromBroadcast);
                this.fieldSetFlags()[11] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public PlacesType getType1() {
            return this.type1;
        }

        public Builder setType1(PlacesType value) {
            this.validate(this.fields()[2], (Object)value);
            this.type1 = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasType1() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearType1() {
            this.type1 = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public PlacesType getType2() {
            return this.type2;
        }

        public Builder setType2(PlacesType value) {
            this.validate(this.fields()[3], (Object)value);
            this.type2 = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasType2() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearType2() {
            this.type2 = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public PlacesType getType3() {
            return this.type3;
        }

        public Builder setType3(PlacesType value) {
            this.validate(this.fields()[4], (Object)value);
            this.type3 = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasType3() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearType3() {
            this.type3 = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public PlacesType getType4() {
            return this.type4;
        }

        public Builder setType4(PlacesType value) {
            this.validate(this.fields()[5], (Object)value);
            this.type4 = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasType4() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearType4() {
            this.type4 = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getCity() {
            return this.city;
        }

        public Builder setCity(String value) {
            this.validate(this.fields()[6], value);
            this.city = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasCity() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearCity() {
            this.city = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getState() {
            return this.state;
        }

        public Builder setState(String value) {
            this.validate(this.fields()[7], value);
            this.state = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasState() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearState() {
            this.state = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getCountry() {
            return this.country;
        }

        public Builder setCountry(String value) {
            this.validate(this.fields()[8], value);
            this.country = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasCountry() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearCountry() {
            this.country = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public String getPlaceId() {
            return this.placeId;
        }

        public Builder setPlaceId(String value) {
            this.validate(this.fields()[9], value);
            this.placeId = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasPlaceId() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearPlaceId() {
            this.placeId = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public double getLikelihood() {
            return this.likelihood;
        }

        public Builder setLikelihood(double value) {
            this.validate(this.fields()[10], value);
            this.likelihood = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasLikelihood() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearLikelihood() {
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public boolean getFromBroadcast() {
            return this.fromBroadcast;
        }

        public Builder setFromBroadcast(boolean value) {
            this.validate(this.fields()[11], value);
            this.fromBroadcast = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasFromBroadcast() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearFromBroadcast() {
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public GooglePlacesInfo build() {
            try {
                GooglePlacesInfo record = new GooglePlacesInfo();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.type1 = this.fieldSetFlags()[2] ? this.type1 : (PlacesType)((Object)this.defaultValue(this.fields()[2]));
                record.type2 = this.fieldSetFlags()[3] ? this.type2 : (PlacesType)((Object)this.defaultValue(this.fields()[3]));
                record.type3 = this.fieldSetFlags()[4] ? this.type3 : (PlacesType)((Object)this.defaultValue(this.fields()[4]));
                record.type4 = this.fieldSetFlags()[5] ? this.type4 : (PlacesType)((Object)this.defaultValue(this.fields()[5]));
                record.city = this.fieldSetFlags()[6] ? this.city : (String)this.defaultValue(this.fields()[6]);
                record.state = this.fieldSetFlags()[7] ? this.state : (String)this.defaultValue(this.fields()[7]);
                record.country = this.fieldSetFlags()[8] ? this.country : (String)this.defaultValue(this.fields()[8]);
                record.placeId = this.fieldSetFlags()[9] ? this.placeId : (String)this.defaultValue(this.fields()[9]);
                record.likelihood = this.fieldSetFlags()[10] ? this.likelihood : (Double)this.defaultValue(this.fields()[10]);
                record.fromBroadcast = this.fieldSetFlags()[11] ? this.fromBroadcast : (Boolean)this.defaultValue(this.fields()[11]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

