/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminGenericSteps
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 682875770683420046L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminGenericSteps\",\"namespace\":\"org.radarcns.passive.garmin\",\"doc\":\"Steps provides the data about real time steps since midnight.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Last updated time.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"stepCount\",\"type\":\"int\",\"doc\":\"Step count since midnight as calculated by Garmin device. 'Daily' values provided by the SDK are always reset at midnight of the local user-day.\"},{\"name\":\"stepGoal\",\"type\":\"int\",\"doc\":\"Step goal per day.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminGenericSteps> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminGenericSteps> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private int stepCount;
    private int stepGoal;
    private static final DatumWriter<GarminGenericSteps> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminGenericSteps> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminGenericSteps> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminGenericSteps> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminGenericSteps> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminGenericSteps fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminGenericSteps)((Object)DECODER.decode(b));
    }

    public GarminGenericSteps() {
    }

    public GarminGenericSteps(Double time, Double timeReceived, Integer stepCount, Integer stepGoal) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.stepCount = stepCount;
        this.stepGoal = stepGoal;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.stepCount;
            }
            case 3: {
                return this.stepGoal;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.stepCount = (Integer)value$;
                break;
            }
            case 3: {
                this.stepGoal = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int value) {
        this.stepCount = value;
    }

    public int getStepGoal() {
        return this.stepGoal;
    }

    public void setStepGoal(int value) {
        this.stepGoal = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminGenericSteps other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.stepCount);
        out.writeInt(this.stepGoal);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.stepCount = in.readInt();
            this.stepGoal = in.readInt();
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.stepCount = in.readInt();
                        continue block6;
                    }
                    case 3: {
                        this.stepGoal = in.readInt();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminGenericSteps>
    implements RecordBuilder<GarminGenericSteps> {
        private double time;
        private double timeReceived;
        private int stepCount;
        private int stepGoal;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.stepCount)) {
                this.stepCount = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.stepCount);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.stepGoal)) {
                this.stepGoal = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.stepGoal);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(GarminGenericSteps other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.stepCount)) {
                this.stepCount = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.stepCount);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.stepGoal)) {
                this.stepGoal = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.stepGoal);
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getStepCount() {
            return this.stepCount;
        }

        public Builder setStepCount(int value) {
            this.validate(this.fields()[2], value);
            this.stepCount = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasStepCount() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearStepCount() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getStepGoal() {
            return this.stepGoal;
        }

        public Builder setStepGoal(int value) {
            this.validate(this.fields()[3], value);
            this.stepGoal = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasStepGoal() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearStepGoal() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public GarminGenericSteps build() {
            try {
                GarminGenericSteps record = new GarminGenericSteps();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.stepCount = this.fieldSetFlags()[2] ? this.stepCount : (Integer)this.defaultValue(this.fields()[2]);
                record.stepGoal = this.fieldSetFlags()[3] ? this.stepGoal : (Integer)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

