/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.carl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class FibaroEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -167004744828113110L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FibaroEvent\",\"namespace\":\"org.radarcns.passive.carl\",\"doc\":\"An event that was registered with a Fibaro Device that captures the previous value of the last event that was registered with the same device - old and the new value - new.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), represents the time that an Event was registered.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), represents the time this record was received.\"},{\"name\":\"id\",\"type\":\"int\",\"doc\":\"Unique ID for an Event. As registered in Carl Cloud.\"},{\"name\":\"hclId\",\"type\":\"int\",\"doc\":\"Unique ID for a Event. As registered in Home Center Lite's API.\"},{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The type of the Event.\"},{\"name\":\"deviceId\",\"type\":\"int\",\"doc\":\"Unique ID of the device that registered the Event.\"},{\"name\":\"previous\",\"type\":\"double\",\"doc\":\"The previous value of a similar Event that was registered on with the same Device.\"},{\"name\":\"current\",\"type\":\"double\",\"doc\":\"The current value that was registered with the Device.\"},{\"name\":\"userId\",\"type\":\"int\",\"doc\":\"Unique ID for the user who registered the Room.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FibaroEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FibaroEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private int id;
    private int hclId;
    private String type;
    private int deviceId;
    private double previous;
    private double current;
    private int userId;
    private static final DatumWriter<FibaroEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FibaroEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FibaroEvent> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FibaroEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FibaroEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FibaroEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (FibaroEvent)((Object)DECODER.decode(b));
    }

    public FibaroEvent() {
    }

    public FibaroEvent(Double time, Double timeReceived, Integer id, Integer hclId, String type, Integer deviceId, Double previous, Double current, Integer userId) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.hclId = hclId;
        this.type = type;
        this.deviceId = deviceId;
        this.previous = previous;
        this.current = current;
        this.userId = userId;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.hclId;
            }
            case 4: {
                return this.type;
            }
            case 5: {
                return this.deviceId;
            }
            case 6: {
                return this.previous;
            }
            case 7: {
                return this.current;
            }
            case 8: {
                return this.userId;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = (Integer)value$;
                break;
            }
            case 3: {
                this.hclId = (Integer)value$;
                break;
            }
            case 4: {
                this.type = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.deviceId = (Integer)value$;
                break;
            }
            case 6: {
                this.previous = (Double)value$;
                break;
            }
            case 7: {
                this.current = (Double)value$;
                break;
            }
            case 8: {
                this.userId = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public int getHclId() {
        return this.hclId;
    }

    public void setHclId(int value) {
        this.hclId = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int value) {
        this.deviceId = value;
    }

    public double getPrevious() {
        return this.previous;
    }

    public void setPrevious(double value) {
        this.previous = value;
    }

    public double getCurrent() {
        return this.current;
    }

    public void setCurrent(double value) {
        this.current = value;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int value) {
        this.userId = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FibaroEvent other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.id);
        out.writeInt(this.hclId);
        out.writeString(this.type);
        out.writeInt(this.deviceId);
        out.writeDouble(this.previous);
        out.writeDouble(this.current);
        out.writeInt(this.userId);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.id = in.readInt();
            this.hclId = in.readInt();
            this.type = in.readString();
            this.deviceId = in.readInt();
            this.previous = in.readDouble();
            this.current = in.readDouble();
            this.userId = in.readInt();
        } else {
            block11: for (int i = 0; i < 9; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block11;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block11;
                    }
                    case 2: {
                        this.id = in.readInt();
                        continue block11;
                    }
                    case 3: {
                        this.hclId = in.readInt();
                        continue block11;
                    }
                    case 4: {
                        this.type = in.readString();
                        continue block11;
                    }
                    case 5: {
                        this.deviceId = in.readInt();
                        continue block11;
                    }
                    case 6: {
                        this.previous = in.readDouble();
                        continue block11;
                    }
                    case 7: {
                        this.current = in.readDouble();
                        continue block11;
                    }
                    case 8: {
                        this.userId = in.readInt();
                        continue block11;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FibaroEvent>
    implements RecordBuilder<FibaroEvent> {
        private double time;
        private double timeReceived;
        private int id;
        private int hclId;
        private String type;
        private int deviceId;
        private double previous;
        private double current;
        private int userId;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.hclId)) {
                this.hclId = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.hclId);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.type)) {
                this.type = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.type);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.deviceId)) {
                this.deviceId = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.deviceId);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.previous)) {
                this.previous = (Double)this.data().deepCopy(this.fields()[6].schema(), (Object)other.previous);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.current)) {
                this.current = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.current);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.userId)) {
                this.userId = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.userId);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
        }

        private Builder(FibaroEvent other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.hclId)) {
                this.hclId = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.hclId);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.type)) {
                this.type = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.type);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.deviceId)) {
                this.deviceId = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.deviceId);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.previous)) {
                this.previous = (Double)this.data().deepCopy(this.fields()[6].schema(), (Object)other.previous);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.current)) {
                this.current = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.current);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.userId)) {
                this.userId = (Integer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.userId);
                this.fieldSetFlags()[8] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getId() {
            return this.id;
        }

        public Builder setId(int value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getHclId() {
            return this.hclId;
        }

        public Builder setHclId(int value) {
            this.validate(this.fields()[3], value);
            this.hclId = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasHclId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearHclId() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String value) {
            this.validate(this.fields()[4], value);
            this.type = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public int getDeviceId() {
            return this.deviceId;
        }

        public Builder setDeviceId(int value) {
            this.validate(this.fields()[5], value);
            this.deviceId = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDeviceId() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDeviceId() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public double getPrevious() {
            return this.previous;
        }

        public Builder setPrevious(double value) {
            this.validate(this.fields()[6], value);
            this.previous = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasPrevious() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearPrevious() {
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public double getCurrent() {
            return this.current;
        }

        public Builder setCurrent(double value) {
            this.validate(this.fields()[7], value);
            this.current = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasCurrent() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearCurrent() {
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public int getUserId() {
            return this.userId;
        }

        public Builder setUserId(int value) {
            this.validate(this.fields()[8], value);
            this.userId = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasUserId() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearUserId() {
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public FibaroEvent build() {
            try {
                FibaroEvent record = new FibaroEvent();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (Integer)this.defaultValue(this.fields()[2]);
                record.hclId = this.fieldSetFlags()[3] ? this.hclId : (Integer)this.defaultValue(this.fields()[3]);
                record.type = this.fieldSetFlags()[4] ? this.type : (String)this.defaultValue(this.fields()[4]);
                record.deviceId = this.fieldSetFlags()[5] ? this.deviceId : (Integer)this.defaultValue(this.fields()[5]);
                record.previous = this.fieldSetFlags()[6] ? this.previous : (Double)this.defaultValue(this.fields()[6]);
                record.current = this.fieldSetFlags()[7] ? this.current : (Double)this.defaultValue(this.fields()[7]);
                record.userId = this.fieldSetFlags()[8] ? this.userId : (Integer)this.defaultValue(this.fields()[8]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

