/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.carl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.carl.DeviceType;

@AvroGenerated
public class FibaroDevice
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 8083304347629627536L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"FibaroDevice\",\"namespace\":\"org.radarcns.passive.carl\",\"doc\":\"A Fibaro Device, capturing multiple variables for a specific Fibaro device. More information can be found https://www.fibaro.com/.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), represents the time that an Event was registered.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), represents the time this record was received.\"},{\"name\":\"id\",\"type\":\"int\",\"doc\":\"A unique ID for a Fibaro Device. As registered in Carl Cloud.\"},{\"name\":\"hclId\",\"type\":\"int\",\"doc\":\"Unique ID for a Fibaro Device. As registered in Home Center Lite's API.\"},{\"name\":\"deviceType\",\"type\":{\"type\":\"enum\",\"name\":\"DeviceType\",\"doc\":\"PRESENSE_SENSOR: Devices that act as motion sensor, temperature sensor, seismic sensor ,light  sensor, accelerometer,DOOR_SENSOR: Devices that register if the door/windows was opened as well as heat changes, FLODD_SENSOR: Devices that registeres flood inside the house, PANIC_BUTTON: Device that when pressed alerts the system, WALLPLUG: Device that measures the electric consumption of a device connected to it.\",\"symbols\":[\"PRESENSE_SENSOR\",\"DOOR_SENSOR\",\"FLOOD_SENSOR\",\"PANIC_BUTTON\",\"WALLPLUG\"]},\"doc\":\"Type of the device (Presense, Door, Flood, Panic, Wall Plug).\"},{\"name\":\"serial\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"A serial number for a Fibaro Device.\"},{\"name\":\"make\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of a Device's Manufacturer.\",\"default\":null},{\"name\":\"model\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The model name of the Fibaro Device.\"},{\"name\":\"battery\",\"type\":\"double\",\"doc\":\"The level of Device's Battery.\"},{\"name\":\"lastSyncTime\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), represent the time of the Fibaro Device's last sync with CARL Cloud.\"},{\"name\":\"mac\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MAC Addresss of the Fibaro Device.\",\"default\":null},{\"name\":\"userId\",\"type\":\"int\",\"doc\":\"Unique ID for the user who registered the Fibaro Device.\"},{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of the Fibaro Device.\",\"default\":null},{\"name\":\"roomId\",\"type\":\"int\",\"doc\":\"Unique ID of the Room that the Fibaro Device is registered to.\"},{\"name\":\"enabled\",\"type\":\"boolean\",\"doc\":\"True if the Fibaro Device is enabled, False if it is not.\"},{\"name\":\"parentId\",\"type\":\"int\",\"doc\":\"Unique ID of the Fibaro Device where this Fibaro Instance belongs to.\"},{\"name\":\"categories\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Show the categories in which the Device belongs to.\"},{\"name\":\"configured\",\"type\":\"boolean\",\"doc\":\"True if the device is configured.\"},{\"name\":\"dead\",\"type\":\"boolean\",\"doc\":\"True if the device is not found on the network.\"},{\"name\":\"deadReason\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reason that 'dead' field was set as True.\",\"default\":null},{\"name\":\"created\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), represents the time of the Fibaro Device's first sync.\"},{\"name\":\"modified\",\"type\":\"double\",\"doc\":\"Time since the Unix Epoch (seconds), represents the time of the Fibaro Device's last modification.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<FibaroDevice> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<FibaroDevice> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private int id;
    private int hclId;
    private DeviceType deviceType;
    private String serial;
    private String make;
    private String model;
    private double battery;
    private double lastSyncTime;
    private String mac;
    private int userId;
    private String name;
    private int roomId;
    private boolean enabled;
    private int parentId;
    private String categories;
    private boolean configured;
    private boolean dead;
    private String deadReason;
    private double created;
    private double modified;
    private static final DatumWriter<FibaroDevice> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<FibaroDevice> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<FibaroDevice> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<FibaroDevice> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<FibaroDevice> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static FibaroDevice fromByteBuffer(ByteBuffer b) throws IOException {
        return (FibaroDevice)((Object)DECODER.decode(b));
    }

    public FibaroDevice() {
    }

    public FibaroDevice(Double time, Double timeReceived, Integer id, Integer hclId, DeviceType deviceType, String serial, String make, String model, Double battery, Double lastSyncTime, String mac, Integer userId, String name, Integer roomId, Boolean enabled, Integer parentId, String categories, Boolean configured, Boolean dead, String deadReason, Double created, Double modified) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.id = id;
        this.hclId = hclId;
        this.deviceType = deviceType;
        this.serial = serial;
        this.make = make;
        this.model = model;
        this.battery = battery;
        this.lastSyncTime = lastSyncTime;
        this.mac = mac;
        this.userId = userId;
        this.name = name;
        this.roomId = roomId;
        this.enabled = enabled;
        this.parentId = parentId;
        this.categories = categories;
        this.configured = configured;
        this.dead = dead;
        this.deadReason = deadReason;
        this.created = created;
        this.modified = modified;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.id;
            }
            case 3: {
                return this.hclId;
            }
            case 4: {
                return this.deviceType;
            }
            case 5: {
                return this.serial;
            }
            case 6: {
                return this.make;
            }
            case 7: {
                return this.model;
            }
            case 8: {
                return this.battery;
            }
            case 9: {
                return this.lastSyncTime;
            }
            case 10: {
                return this.mac;
            }
            case 11: {
                return this.userId;
            }
            case 12: {
                return this.name;
            }
            case 13: {
                return this.roomId;
            }
            case 14: {
                return this.enabled;
            }
            case 15: {
                return this.parentId;
            }
            case 16: {
                return this.categories;
            }
            case 17: {
                return this.configured;
            }
            case 18: {
                return this.dead;
            }
            case 19: {
                return this.deadReason;
            }
            case 20: {
                return this.created;
            }
            case 21: {
                return this.modified;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.id = (Integer)value$;
                break;
            }
            case 3: {
                this.hclId = (Integer)value$;
                break;
            }
            case 4: {
                this.deviceType = (DeviceType)((Object)value$);
                break;
            }
            case 5: {
                this.serial = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.make = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.model = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.battery = (Double)value$;
                break;
            }
            case 9: {
                this.lastSyncTime = (Double)value$;
                break;
            }
            case 10: {
                this.mac = value$ != null ? value$.toString() : null;
                break;
            }
            case 11: {
                this.userId = (Integer)value$;
                break;
            }
            case 12: {
                this.name = value$ != null ? value$.toString() : null;
                break;
            }
            case 13: {
                this.roomId = (Integer)value$;
                break;
            }
            case 14: {
                this.enabled = (Boolean)value$;
                break;
            }
            case 15: {
                this.parentId = (Integer)value$;
                break;
            }
            case 16: {
                this.categories = value$ != null ? value$.toString() : null;
                break;
            }
            case 17: {
                this.configured = (Boolean)value$;
                break;
            }
            case 18: {
                this.dead = (Boolean)value$;
                break;
            }
            case 19: {
                this.deadReason = value$ != null ? value$.toString() : null;
                break;
            }
            case 20: {
                this.created = (Double)value$;
                break;
            }
            case 21: {
                this.modified = (Double)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public int getHclId() {
        return this.hclId;
    }

    public void setHclId(int value) {
        this.hclId = value;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType value) {
        this.deviceType = value;
    }

    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String value) {
        this.serial = value;
    }

    public String getMake() {
        return this.make;
    }

    public void setMake(String value) {
        this.make = value;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String value) {
        this.model = value;
    }

    public double getBattery() {
        return this.battery;
    }

    public void setBattery(double value) {
        this.battery = value;
    }

    public double getLastSyncTime() {
        return this.lastSyncTime;
    }

    public void setLastSyncTime(double value) {
        this.lastSyncTime = value;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String value) {
        this.mac = value;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int value) {
        this.userId = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public int getRoomId() {
        return this.roomId;
    }

    public void setRoomId(int value) {
        this.roomId = value;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int value) {
        this.parentId = value;
    }

    public String getCategories() {
        return this.categories;
    }

    public void setCategories(String value) {
        this.categories = value;
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean value) {
        this.configured = value;
    }

    public boolean getDead() {
        return this.dead;
    }

    public void setDead(boolean value) {
        this.dead = value;
    }

    public String getDeadReason() {
        return this.deadReason;
    }

    public void setDeadReason(String value) {
        this.deadReason = value;
    }

    public double getCreated() {
        return this.created;
    }

    public void setCreated(double value) {
        this.created = value;
    }

    public double getModified() {
        return this.modified;
    }

    public void setModified(double value) {
        this.modified = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(FibaroDevice other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.id);
        out.writeInt(this.hclId);
        out.writeEnum(this.deviceType.ordinal());
        out.writeString(this.serial);
        if (this.make == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.make);
        }
        out.writeString(this.model);
        out.writeDouble(this.battery);
        out.writeDouble(this.lastSyncTime);
        if (this.mac == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.mac);
        }
        out.writeInt(this.userId);
        if (this.name == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.name);
        }
        out.writeInt(this.roomId);
        out.writeBoolean(this.enabled);
        out.writeInt(this.parentId);
        out.writeString(this.categories);
        out.writeBoolean(this.configured);
        out.writeBoolean(this.dead);
        if (this.deadReason == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.deadReason);
        }
        out.writeDouble(this.created);
        out.writeDouble(this.modified);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.id = in.readInt();
            this.hclId = in.readInt();
            this.deviceType = DeviceType.values()[in.readEnum()];
            this.serial = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.make = null;
            } else {
                this.make = in.readString();
            }
            this.model = in.readString();
            this.battery = in.readDouble();
            this.lastSyncTime = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.mac = null;
            } else {
                this.mac = in.readString();
            }
            this.userId = in.readInt();
            if (in.readIndex() != 1) {
                in.readNull();
                this.name = null;
            } else {
                this.name = in.readString();
            }
            this.roomId = in.readInt();
            this.enabled = in.readBoolean();
            this.parentId = in.readInt();
            this.categories = in.readString();
            this.configured = in.readBoolean();
            this.dead = in.readBoolean();
            if (in.readIndex() != 1) {
                in.readNull();
                this.deadReason = null;
            } else {
                this.deadReason = in.readString();
            }
            this.created = in.readDouble();
            this.modified = in.readDouble();
        } else {
            block24: for (int i = 0; i < 22; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block24;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block24;
                    }
                    case 2: {
                        this.id = in.readInt();
                        continue block24;
                    }
                    case 3: {
                        this.hclId = in.readInt();
                        continue block24;
                    }
                    case 4: {
                        this.deviceType = DeviceType.values()[in.readEnum()];
                        continue block24;
                    }
                    case 5: {
                        this.serial = in.readString();
                        continue block24;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.make = null;
                            continue block24;
                        }
                        this.make = in.readString();
                        continue block24;
                    }
                    case 7: {
                        this.model = in.readString();
                        continue block24;
                    }
                    case 8: {
                        this.battery = in.readDouble();
                        continue block24;
                    }
                    case 9: {
                        this.lastSyncTime = in.readDouble();
                        continue block24;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.mac = null;
                            continue block24;
                        }
                        this.mac = in.readString();
                        continue block24;
                    }
                    case 11: {
                        this.userId = in.readInt();
                        continue block24;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.name = null;
                            continue block24;
                        }
                        this.name = in.readString();
                        continue block24;
                    }
                    case 13: {
                        this.roomId = in.readInt();
                        continue block24;
                    }
                    case 14: {
                        this.enabled = in.readBoolean();
                        continue block24;
                    }
                    case 15: {
                        this.parentId = in.readInt();
                        continue block24;
                    }
                    case 16: {
                        this.categories = in.readString();
                        continue block24;
                    }
                    case 17: {
                        this.configured = in.readBoolean();
                        continue block24;
                    }
                    case 18: {
                        this.dead = in.readBoolean();
                        continue block24;
                    }
                    case 19: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.deadReason = null;
                            continue block24;
                        }
                        this.deadReason = in.readString();
                        continue block24;
                    }
                    case 20: {
                        this.created = in.readDouble();
                        continue block24;
                    }
                    case 21: {
                        this.modified = in.readDouble();
                        continue block24;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<FibaroDevice>
    implements RecordBuilder<FibaroDevice> {
        private double time;
        private double timeReceived;
        private int id;
        private int hclId;
        private DeviceType deviceType;
        private String serial;
        private String make;
        private String model;
        private double battery;
        private double lastSyncTime;
        private String mac;
        private int userId;
        private String name;
        private int roomId;
        private boolean enabled;
        private int parentId;
        private String categories;
        private boolean configured;
        private boolean dead;
        private String deadReason;
        private double created;
        private double modified;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.hclId)) {
                this.hclId = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.hclId);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.deviceType))) {
                this.deviceType = (DeviceType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.deviceType));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.serial)) {
                this.serial = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.serial);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.make)) {
                this.make = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.make);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.model)) {
                this.model = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.model);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.battery)) {
                this.battery = (Double)this.data().deepCopy(this.fields()[8].schema(), (Object)other.battery);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.lastSyncTime)) {
                this.lastSyncTime = (Double)this.data().deepCopy(this.fields()[9].schema(), (Object)other.lastSyncTime);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.mac)) {
                this.mac = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.mac);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.userId)) {
                this.userId = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.userId);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.name);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.roomId)) {
                this.roomId = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.roomId);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.enabled)) {
                this.enabled = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.enabled);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.parentId)) {
                this.parentId = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.parentId);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.categories)) {
                this.categories = (String)this.data().deepCopy(this.fields()[16].schema(), (Object)other.categories);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.configured)) {
                this.configured = (Boolean)this.data().deepCopy(this.fields()[17].schema(), (Object)other.configured);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.dead)) {
                this.dead = (Boolean)this.data().deepCopy(this.fields()[18].schema(), (Object)other.dead);
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.deadReason)) {
                this.deadReason = (String)this.data().deepCopy(this.fields()[19].schema(), (Object)other.deadReason);
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.created)) {
                this.created = (Double)this.data().deepCopy(this.fields()[20].schema(), (Object)other.created);
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.modified)) {
                this.modified = (Double)this.data().deepCopy(this.fields()[21].schema(), (Object)other.modified);
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
        }

        private Builder(FibaroDevice other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.id)) {
                this.id = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.id);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.hclId)) {
                this.hclId = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.hclId);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.deviceType))) {
                this.deviceType = (DeviceType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.deviceType));
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.serial)) {
                this.serial = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.serial);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.make)) {
                this.make = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.make);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.model)) {
                this.model = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.model);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.battery)) {
                this.battery = (Double)this.data().deepCopy(this.fields()[8].schema(), (Object)other.battery);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.lastSyncTime)) {
                this.lastSyncTime = (Double)this.data().deepCopy(this.fields()[9].schema(), (Object)other.lastSyncTime);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.mac)) {
                this.mac = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.mac);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.userId)) {
                this.userId = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.userId);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.name);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.roomId)) {
                this.roomId = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.roomId);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.enabled)) {
                this.enabled = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.enabled);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.parentId)) {
                this.parentId = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.parentId);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.categories)) {
                this.categories = (String)this.data().deepCopy(this.fields()[16].schema(), (Object)other.categories);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.configured)) {
                this.configured = (Boolean)this.data().deepCopy(this.fields()[17].schema(), (Object)other.configured);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.dead)) {
                this.dead = (Boolean)this.data().deepCopy(this.fields()[18].schema(), (Object)other.dead);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.deadReason)) {
                this.deadReason = (String)this.data().deepCopy(this.fields()[19].schema(), (Object)other.deadReason);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.created)) {
                this.created = (Double)this.data().deepCopy(this.fields()[20].schema(), (Object)other.created);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.modified)) {
                this.modified = (Double)this.data().deepCopy(this.fields()[21].schema(), (Object)other.modified);
                this.fieldSetFlags()[21] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getId() {
            return this.id;
        }

        public Builder setId(int value) {
            this.validate(this.fields()[2], value);
            this.id = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearId() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getHclId() {
            return this.hclId;
        }

        public Builder setHclId(int value) {
            this.validate(this.fields()[3], value);
            this.hclId = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasHclId() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearHclId() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public DeviceType getDeviceType() {
            return this.deviceType;
        }

        public Builder setDeviceType(DeviceType value) {
            this.validate(this.fields()[4], (Object)value);
            this.deviceType = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDeviceType() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearDeviceType() {
            this.deviceType = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getSerial() {
            return this.serial;
        }

        public Builder setSerial(String value) {
            this.validate(this.fields()[5], value);
            this.serial = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasSerial() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearSerial() {
            this.serial = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getMake() {
            return this.make;
        }

        public Builder setMake(String value) {
            this.validate(this.fields()[6], value);
            this.make = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasMake() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearMake() {
            this.make = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getModel() {
            return this.model;
        }

        public Builder setModel(String value) {
            this.validate(this.fields()[7], value);
            this.model = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasModel() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearModel() {
            this.model = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public double getBattery() {
            return this.battery;
        }

        public Builder setBattery(double value) {
            this.validate(this.fields()[8], value);
            this.battery = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasBattery() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearBattery() {
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public double getLastSyncTime() {
            return this.lastSyncTime;
        }

        public Builder setLastSyncTime(double value) {
            this.validate(this.fields()[9], value);
            this.lastSyncTime = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasLastSyncTime() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearLastSyncTime() {
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public String getMac() {
            return this.mac;
        }

        public Builder setMac(String value) {
            this.validate(this.fields()[10], value);
            this.mac = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasMac() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearMac() {
            this.mac = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public int getUserId() {
            return this.userId;
        }

        public Builder setUserId(int value) {
            this.validate(this.fields()[11], value);
            this.userId = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasUserId() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearUserId() {
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[12], value);
            this.name = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public int getRoomId() {
            return this.roomId;
        }

        public Builder setRoomId(int value) {
            this.validate(this.fields()[13], value);
            this.roomId = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasRoomId() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearRoomId() {
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public Builder setEnabled(boolean value) {
            this.validate(this.fields()[14], value);
            this.enabled = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasEnabled() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearEnabled() {
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public int getParentId() {
            return this.parentId;
        }

        public Builder setParentId(int value) {
            this.validate(this.fields()[15], value);
            this.parentId = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasParentId() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearParentId() {
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public String getCategories() {
            return this.categories;
        }

        public Builder setCategories(String value) {
            this.validate(this.fields()[16], value);
            this.categories = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasCategories() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearCategories() {
            this.categories = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public boolean getConfigured() {
            return this.configured;
        }

        public Builder setConfigured(boolean value) {
            this.validate(this.fields()[17], value);
            this.configured = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasConfigured() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearConfigured() {
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public boolean getDead() {
            return this.dead;
        }

        public Builder setDead(boolean value) {
            this.validate(this.fields()[18], value);
            this.dead = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasDead() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearDead() {
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public String getDeadReason() {
            return this.deadReason;
        }

        public Builder setDeadReason(String value) {
            this.validate(this.fields()[19], value);
            this.deadReason = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasDeadReason() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearDeadReason() {
            this.deadReason = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public double getCreated() {
            return this.created;
        }

        public Builder setCreated(double value) {
            this.validate(this.fields()[20], value);
            this.created = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasCreated() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearCreated() {
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public double getModified() {
            return this.modified;
        }

        public Builder setModified(double value) {
            this.validate(this.fields()[21], value);
            this.modified = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasModified() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearModified() {
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public FibaroDevice build() {
            try {
                FibaroDevice record = new FibaroDevice();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.id = this.fieldSetFlags()[2] ? this.id : (Integer)this.defaultValue(this.fields()[2]);
                record.hclId = this.fieldSetFlags()[3] ? this.hclId : (Integer)this.defaultValue(this.fields()[3]);
                record.deviceType = this.fieldSetFlags()[4] ? this.deviceType : (DeviceType)((Object)this.defaultValue(this.fields()[4]));
                record.serial = this.fieldSetFlags()[5] ? this.serial : (String)this.defaultValue(this.fields()[5]);
                record.make = this.fieldSetFlags()[6] ? this.make : (String)this.defaultValue(this.fields()[6]);
                record.model = this.fieldSetFlags()[7] ? this.model : (String)this.defaultValue(this.fields()[7]);
                record.battery = this.fieldSetFlags()[8] ? this.battery : (Double)this.defaultValue(this.fields()[8]);
                record.lastSyncTime = this.fieldSetFlags()[9] ? this.lastSyncTime : (Double)this.defaultValue(this.fields()[9]);
                record.mac = this.fieldSetFlags()[10] ? this.mac : (String)this.defaultValue(this.fields()[10]);
                record.userId = this.fieldSetFlags()[11] ? this.userId : (Integer)this.defaultValue(this.fields()[11]);
                record.name = this.fieldSetFlags()[12] ? this.name : (String)this.defaultValue(this.fields()[12]);
                record.roomId = this.fieldSetFlags()[13] ? this.roomId : (Integer)this.defaultValue(this.fields()[13]);
                record.enabled = this.fieldSetFlags()[14] ? this.enabled : (Boolean)this.defaultValue(this.fields()[14]);
                record.parentId = this.fieldSetFlags()[15] ? this.parentId : (Integer)this.defaultValue(this.fields()[15]);
                record.categories = this.fieldSetFlags()[16] ? this.categories : (String)this.defaultValue(this.fields()[16]);
                record.configured = this.fieldSetFlags()[17] ? this.configured : (Boolean)this.defaultValue(this.fields()[17]);
                record.dead = this.fieldSetFlags()[18] ? this.dead : (Boolean)this.defaultValue(this.fields()[18]);
                record.deadReason = this.fieldSetFlags()[19] ? this.deadReason : (String)this.defaultValue(this.fields()[19]);
                record.created = this.fieldSetFlags()[20] ? this.created : (Double)this.defaultValue(this.fields()[20]);
                record.modified = this.fieldSetFlags()[21] ? this.modified : (Double)this.defaultValue(this.fields()[21]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

