/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.canedge;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class CanEdgeObd2
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -8439193792053803774L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"CanEdgeObd2\",\"namespace\":\"org.radarcns.passive.canedge\",\"doc\":\"AVRO Schema for CAN Edge OBD2 Service 01. These are OBD2 PIDs extracted from raw CANEdge MF4 file.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"This refers to the time of the dataset.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"This is the processing time in UTC (s).\"},{\"name\":\"fuelSystemStatus\",\"type\":[\"null\",\"float\"],\"doc\":\"Fuel system status. The OBD2 name is S1_PID_03_FuelSystemStatus. Min value is 0. Max value is 65535. The unit is Encoded.\",\"default\":null},{\"name\":\"calcEngineLoad\",\"type\":[\"null\",\"float\"],\"doc\":\"Calculated engine load. The OBD2 name is S1_PID_04_CalcEngineLoad. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"engineCoolantTemp\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine coolant temperature. The OBD2 name is S1_PID_05_EngineCoolantTemp. Min value is -40. Max value is 215. The unit is degC.\",\"default\":null},{\"name\":\"shortFuelTrimBank1\",\"type\":[\"null\",\"float\"],\"doc\":\"Short term fuel trim (bank 1). The OBD2 name is S1_PID_06_ShortFuelTrimBank1. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"longFuelTrimBank1\",\"type\":[\"null\",\"float\"],\"doc\":\"Long term fuel trim (bank 1). The OBD2 name is S1_PID_07_LongFuelTrimBank1. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"shortFuelTrimBank2\",\"type\":[\"null\",\"float\"],\"doc\":\"Short term fuel trim (bank 2). The OBD2 name is S1_PID_08_ShortFuelTrimBank2. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"longFuelTrimBank2\",\"type\":[\"null\",\"float\"],\"doc\":\"Long term fuel trim (bank 2). The OBD2 name is S1_PID_09_LongFuelTrimBank2. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"fuelPressure\",\"type\":[\"null\",\"float\"],\"doc\":\"Fuel pressure (gauge pressure). The OBD2 name is S1_PID_0A_FuelPressure. Min value is 0. Max value is 765. The unit is kPa.\",\"default\":null},{\"name\":\"intakeManiAbsPress\",\"type\":[\"null\",\"float\"],\"doc\":\"Intake manifold absolute pressure. The OBD2 name is S1_PID_0B_IntakeManiAbsPress. Min value is 0. Max value is 255. The unit is kPa.\",\"default\":null},{\"name\":\"engineRpm\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine speed. The OBD2 name is S1_PID_0C_EngineRPM. Min value is 0. Max value is 16384. The unit is rpm.\",\"default\":null},{\"name\":\"vehicleSpeed\",\"type\":[\"null\",\"float\"],\"doc\":\"Vehicle Speed. The OBD2 name is S1_PID_0D_VehicleSpeed. Min value is 0. Max value is 255. The unit is km/h.\",\"default\":null},{\"name\":\"timingAdvance\",\"type\":[\"null\",\"float\"],\"doc\":\"Timing Advance. The OBD2 name is S1_PID_0E_TimingAdvance. Min value is -64. Max value is 64. The unit is deg.\",\"default\":null},{\"name\":\"intakeAirTemperature\",\"type\":[\"null\",\"float\"],\"doc\":\"Intake air temperature. The OBD2 name is S1_PID_0F_IntakeAirTemperature. Min value is -40. Max value is 215. The unit is degC.\",\"default\":null},{\"name\":\"mafAirFlowRate\",\"type\":[\"null\",\"float\"],\"doc\":\"Mass air flow sensor air flow rate. The OBD2 name is S1_PID_10_MAFAirFlowRate. Min value is 0. Max value is 655. The unit is grams/sec.\",\"default\":null},{\"name\":\"throttlePosition\",\"type\":[\"null\",\"float\"],\"doc\":\"Throttle position. The OBD2 name is S1_PID_11_ThrottlePosition. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"cmdSecAirStatus\",\"type\":[\"null\",\"float\"],\"doc\":\"Commanded secondary air status. The OBD2 name is S1_PID_12_CmdSecAirStatus. Min value is 0. Max value is 255. The unit is Encoded.\",\"default\":null},{\"name\":\"oxySensor1Volt14\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 1 (voltage). The OBD2 name is S1_PID_14_OxySensor1_Volt. Min value is 0. Max value is 1. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor1Stft\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 1 (short term fuel trim). The OBD2 name is S1_PID_14_OxySensor1_STFT. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"oxySensor2Volt14\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 2 (voltage). The OBD2 name is S1_PID_14_OxySensor2_Volt. Min value is 0. Max value is 1. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor2Stft\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 2 (short term fuel trim). The OBD2 name is S1_PID_14_OxySensor2_STFT. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"oxySensor3Volt14\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 3 (voltage). The OBD2 name is S1_PID_14_OxySensor3_Volt. Min value is 0. Max value is 1. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor3Stft\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 3 (short term fuel trim). The OBD2 name is S1_PID_14_OxySensor3_STFT. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"oxySensor4Volt14\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 4 (voltage). The OBD2 name is S1_PID_14_OxySensor4_Volt. Min value is 0. Max value is 1. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor4Stft\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 4 (short term fuel trim). The OBD2 name is S1_PID_14_OxySensor4_STFT. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"oxySensor5Volt14\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 5 (voltage). The OBD2 name is S1_PID_14_OxySensor5_Volt. Min value is 0. Max value is 1. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor5Stft\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 5 (short term fuel trim). The OBD2 name is S1_PID_14_OxySensor5_STFT. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"oxySensor6Volt14\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 6 (voltage). The OBD2 name is S1_PID_14_OxySensor6_Volt. Min value is 0. Max value is 1. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor6Stft\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 6 (short term fuel trim). The OBD2 name is S1_PID_14_OxySensor6_STFT. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"oxySensor7Volt14\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 7 (voltage). The OBD2 name is S1_PID_14_OxySensor7_Volt. Min value is 0. Max value is 1. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor7Stft\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 7 (short term fuel trim). The OBD2 name is S1_PID_14_OxySensor7_STFT. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"oxySensor8Volt14\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 8 (voltage). The OBD2 name is S1_PID_14_OxySensor8_Volt. Min value is 0. Max value is 1. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor8Stft\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 8 (short term fuel trim). The OBD2 name is S1_PID_14_OxySensor8_STFT. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"timeSinceEngStart\",\"type\":[\"null\",\"float\"],\"doc\":\"Run time since engine start. The OBD2 name is S1_PID_1F_TimeSinceEngStart. Min value is 0. Max value is 65535. The unit is seconds.\",\"default\":null},{\"name\":\"distanceMilOn\",\"type\":[\"null\",\"float\"],\"doc\":\"Distance traveled with MIL on. The OBD2 name is S1_PID_21_DistanceMILOn. Min value is 0. Max value is 65535. The unit is km.\",\"default\":null},{\"name\":\"fuelRailPres\",\"type\":[\"null\",\"float\"],\"doc\":\"Fuel rail pres. (rel. to manifold vacuum). The OBD2 name is S1_PID_22_FuelRailPres. Min value is 0. Max value is 5177. The unit is kPa.\",\"default\":null},{\"name\":\"fuelRailGaug\",\"type\":[\"null\",\"float\"],\"doc\":\"Fuel rail gauge pres. (diesel, gas inject). The OBD2 name is S1_PID_23_FuelRailGaug. Min value is 0. Max value is 655350. The unit is kPa.\",\"default\":null},{\"name\":\"oxySensor1Faer24\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 1 (air-fuel equiv. ratio). The OBD2 name is S1_PID_24_OxySensor1_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor1Volt24\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 1 (voltage). The OBD2 name is S1_PID_24_OxySensor1_Volt. Min value is 0. Max value is 2. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor2Faer25\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 2 (air-fuel equiv. ratio). The OBD2 name is S1_PID_25_OxySensor2_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"defau", new String[]{"lt\":null},{\"name\":\"oxySensor2Volt25\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 2 (voltage). The OBD2 name is S1_PID_25_OxySensor2_Volt. Min value is 0. Max value is 8. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor3Faer26\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 3 (air-fuel equiv. ratio). The OBD2 name is S1_PID_26_OxySensor3_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor3Volt26\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 3 (voltage). The OBD2 name is S1_PID_26_OxySensor3_Volt. Min value is 0. Max value is 8. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor4Faer27\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 4 (air-fuel equiv. ratio). The OBD2 name is S1_PID_27_OxySensor4_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor4Volt27\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 4 (voltage). The OBD2 name is S1_PID_27_OxySensor4_Volt. Min value is 0. Max value is 8. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor5Faer28\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 5 (air-fuel equiv. ratio). The OBD2 name is S1_PID_28_OxySensor5_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor5Volt28\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 5 (voltage). The OBD2 name is S1_PID_28_OxySensor5_Volt. Min value is 0. Max value is 8. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor6Faer29\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 6 (air-fuel equiv. ratio). The OBD2 name is S1_PID_29_OxySensor6_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor6Volt29\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 6 (voltage). The OBD2 name is S1_PID_29_OxySensor6_Volt. Min value is 0. Max value is 8. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor7Faer2A\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 7 (air-fuel equiv. ratio). The OBD2 name is S1_PID_2A_OxySensor7_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor7Volt2A\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 7 (voltage). The OBD2 name is S1_PID_2A_OxySensor7_Volt. Min value is 0. Max value is 8. The unit is volts.\",\"default\":null},{\"name\":\"oxySensor8Faer2B\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 8 (air-fuel equiv. ratio). The OBD2 name is S1_PID_2B_OxySensor8_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor8Volt2B\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 8 (voltage). The OBD2 name is S1_PID_2B_OxySensor8_Volt. Min value is 0. Max value is 8. The unit is volts.\",\"default\":null},{\"name\":\"cmdEgr\",\"type\":[\"null\",\"float\"],\"doc\":\"Commanded EGR. The OBD2 name is S1_PID_2C_CmdEGR. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"egrError\",\"type\":[\"null\",\"float\"],\"doc\":\"EGR Error. The OBD2 name is S1_PID_2D_EGRError. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"cmdEvapPurge\",\"type\":[\"null\",\"float\"],\"doc\":\"Commanded evaporative purge. The OBD2 name is S1_PID_2E_CmdEvapPurge. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"fuelTankLevel\",\"type\":[\"null\",\"float\"],\"doc\":\"Fuel tank level input. The OBD2 name is S1_PID_2F_FuelTankLevel. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"warmUpsSinceCodeClear\",\"type\":[\"null\",\"float\"],\"doc\":\"Warmups since DTCs cleared. The OBD2 name is S1_PID_30_WarmUpsSinceCodeClear. Min value is 0. Max value is 255. The unit is count.\",\"default\":null},{\"name\":\"distanceSinceCodeClear\",\"type\":[\"null\",\"float\"],\"doc\":\"Distance traveled since DTCs cleared. The OBD2 name is S1_PID_31_DistanceSinceCodeClear. Min value is 0. Max value is 65535. The unit is km.\",\"default\":null},{\"name\":\"evapSysVaporPres\",\"type\":[\"null\",\"float\"],\"doc\":\"Evap. system vapor pressure. The OBD2 name is S1_PID_32_EvapSysVaporPres. Min value is -8192. Max value is 8192. The unit is Pa.\",\"default\":null},{\"name\":\"absBaroPres\",\"type\":[\"null\",\"float\"],\"doc\":\"Absolute barometric pressure. The OBD2 name is S1_PID_33_AbsBaroPres. Min value is 0. Max value is 255. The unit is kPa.\",\"default\":null},{\"name\":\"oxySensor1Faer34\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 1 (air-fuel equiv. ratio). The OBD2 name is S1_PID_34_OxySensor1_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor1Crnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 1 (current). The OBD2 name is S1_PID_34_OxySensor1_Crnt. Min value is -128. Max value is 128. The unit is mA.\",\"default\":null},{\"name\":\"oxySensor2Faer35\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 2 (air-fuel equiv. ratio). The OBD2 name is S1_PID_35_OxySensor2_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor2Crnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 2 (current). The OBD2 name is S1_PID_35_OxySensor2_Crnt. Min value is -128. Max value is 128. The unit is mA.\",\"default\":null},{\"name\":\"oxySensor3Faer36\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 3 (air-fuel equiv. ratio). The OBD2 name is S1_PID_36_OxySensor3_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor3Crnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 3 (current). The OBD2 name is S1_PID_36_OxySensor3_Crnt. Min value is -128. Max value is 128. The unit is mA.\",\"default\":null},{\"name\":\"oxySensor4Faer37\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 4 (air-fuel equiv. ratio). The OBD2 name is S1_PID_37_OxySensor4_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor4Crnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 4 (current). The OBD2 name is S1_PID_37_OxySensor4_Crnt. Min value is -128. Max value is 128. The unit is mA.\",\"default\":null},{\"name\":\"oxySensor5Faer38\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 5 (air-fuel equiv. ratio). The OBD2 name is S1_PID_38_OxySensor5_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor5Crnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 5 (current). The OBD2 name is S1_PID_38_OxySensor5_Crnt. Min value is -128. Max value is 128. The unit is mA.\",\"default\":null},{\"name\":\"oxySensor6Faer39\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 6 (air-fuel equiv. ratio). The OBD2 name is S1_PID_39_OxySensor6_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor6Crnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 6 (current). The OBD2 name is S1_PID_39_OxySensor6_Crnt. Min value is -128. Max value is 128. The unit is mA.\",\"default\":null},{\"name\":\"oxySensor7Faer3A\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 7 (air-fuel equiv. ratio). The OBD2 name is S1_PID_3A_OxySensor7_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor7Crnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 7 (current). The OBD2 name is S1_PID_3A_OxySensor7_Crnt. Min value is -128. Max value is 128. The unit is mA.\",\"default\":null},{\"name\":\"oxySensor8Faer3B\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 8 (air-fuel equiv. ratio). The OBD2 name is S1_PID_3B_OxySensor8_FAER. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"oxySensor8Crnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Oxygen sensor 8 (current). The OBD2 name is S1_PID_3B_OxySensor8_Crnt. Min value is -128. Max value is 128. The unit is mA.\",\"default\":null},{\"name\":\"catTempBank1Sens1\",\"type\":[\"null\",\"float\"],\"doc\":\"Catalyst temperature (bank 1, sensor 1). The OBD2 name is S1_PID_3C_CatTempBank1Sens1. Min value is -40. Max value is 6514. The unit is degC.\",\"default\":null},{\"name\":\"catTempBank2Sens1\",\"type\":[\"null\",\"float\"],\"doc\":\"Catalyst temperature (bank 2, sensor 1). The OBD2 name is S1_PID_3D_CatTempBank2Sens1. Min value is -40. Max value is 6514. The unit is degC.\",\"default\":null},{\"name\":\"catTempBank1Sens2\",\"type\":[\"null\",\"float\"],\"doc\":\"Catalyst temperature (bank 1, sensor 2). The OBD2 name is S1_PID_3E_CatTempBank1Sens2. Min value is -40. Max value is 6514. The unit is degC.\",\"default\":null},{\"name\":\"catTempBank2Sens2\",\"type\":[\"null\",\"float\"],\"doc\":\"Catalyst temperature (bank", " 2, sensor 2). The OBD2 name is S1_PID_3F_CatTempBank2Sens2. Min value is -40. Max value is 6514. The unit is degC.\",\"default\":null},{\"name\":\"monStatusDriveCycle\",\"type\":[\"null\",\"float\"],\"doc\":\"Monitor status this drive cycle. The OBD2 name is S1_PID_41_MonStatusDriveCycle. Min value is 0. Max value is 4294967295. The unit is Encoded.\",\"default\":null},{\"name\":\"controlModuleVolt\",\"type\":[\"null\",\"float\"],\"doc\":\"Control module voltage. The OBD2 name is S1_PID_42_ControlModuleVolt. Min value is 0. Max value is 66. The unit is V.\",\"default\":null},{\"name\":\"absLoadValue\",\"type\":[\"null\",\"float\"],\"doc\":\"Absolute load value. The OBD2 name is S1_PID_43_AbsLoadValue. Min value is 0. Max value is 25700. The unit is %.\",\"default\":null},{\"name\":\"fuelAirCmdEquiv\",\"type\":[\"null\",\"float\"],\"doc\":\"Commanded air-fuel equiv. ratio. The OBD2 name is S1_PID_44_FuelAirCmdEquiv. Min value is 0. Max value is 2. The unit is ratio.\",\"default\":null},{\"name\":\"relThrottlePos\",\"type\":[\"null\",\"float\"],\"doc\":\"Relative throttle position. The OBD2 name is S1_PID_45_RelThrottlePos. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"ambientAirTemp\",\"type\":[\"null\",\"float\"],\"doc\":\"Ambient air temperature. The OBD2 name is S1_PID_46_AmbientAirTemp. Min value is -40. Max value is 215. The unit is degC.\",\"default\":null},{\"name\":\"absThrottlePosB\",\"type\":[\"null\",\"float\"],\"doc\":\"Absolute throttle position B. The OBD2 name is S1_PID_47_AbsThrottlePosB. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"absThrottlePosC\",\"type\":[\"null\",\"float\"],\"doc\":\"Absolute throttle position C. The OBD2 name is S1_PID_48_AbsThrottlePosC. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"absThrottlePosCd\",\"type\":[\"null\",\"float\"],\"doc\":\"Absolute throttle position D. The OBD2 name is S1_PID_49_AbsThrottlePosD. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"absThrottlePosE\",\"type\":[\"null\",\"float\"],\"doc\":\"Absolute throttle position E. The OBD2 name is S1_PID_4A_AbsThrottlePosE. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"absThrottlePosF\",\"type\":[\"null\",\"float\"],\"doc\":\"Absolute throttle position F. The OBD2 name is S1_PID_4B_AbsThrottlePosF. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"cmdThrottleAct\",\"type\":[\"null\",\"float\"],\"doc\":\"Commanded throttle actuator. The OBD2 name is S1_PID_4C_CmdThrottleAct. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"timeRunMilOn\",\"type\":[\"null\",\"float\"],\"doc\":\"Time run with MIL on. The OBD2 name is S1_PID_4D_TimeRunMILOn. Min value is 0. Max value is 65535. The unit is minutes.\",\"default\":null},{\"name\":\"timeSinceCodeClear\",\"type\":[\"null\",\"float\"],\"doc\":\"Time since DTCs cleared. The OBD2 name is S1_PID_4E_TimeSinceCodeClear. Min value is 0. Max value is 65535. The unit is minutes.\",\"default\":null},{\"name\":\"maxFaer\",\"type\":[\"null\",\"float\"],\"doc\":\"Max fuel-air equiv. ratio. The OBD2 name is S1_PID_4F_Max_FAER. Min value is 0. Max value is 255. The unit is ratio.\",\"default\":null},{\"name\":\"maxOxySensVol\",\"type\":[\"null\",\"float\"],\"doc\":\"Max oxygen sensor voltage. The OBD2 name is S1_PID_4F_Max_OxySensVol. Min value is 0. Max value is 255. The unit is V.\",\"default\":null},{\"name\":\"maxOxySensCrnt\",\"type\":[\"null\",\"float\"],\"doc\":\"Max oxygen sensor current. The OBD2 name is S1_PID_4F_Max_OxySensCrnt. Min value is 0. Max value is 255. The unit is mA.\",\"default\":null},{\"name\":\"maxIntManiAbsPres\",\"type\":[\"null\",\"float\"],\"doc\":\"Max intake manifold absolute pressure. The OBD2 name is S1_PID_4F_Max_IntManiAbsPres. Min value is 0. Max value is 2550. The unit is kPa.\",\"default\":null},{\"name\":\"maxAirFlowMaf\",\"type\":[\"null\",\"float\"],\"doc\":\"Max air flow rate from MAF sensor. The OBD2 name is S1_PID_50_Max_AirFlowMAF. Min value is 0. Max value is 2550. The unit is g/s.\",\"default\":null},{\"name\":\"fuelType\",\"type\":[\"null\",\"float\"],\"doc\":\"Fuel type. The OBD2 name is S1_PID_51_FuelType. Min value is 0. Max value is 255. The unit is Encoded.\",\"default\":null},{\"name\":\"ethanolFuelPct\",\"type\":[\"null\",\"float\"],\"doc\":\"Ethanol fuel percentage. The OBD2 name is S1_PID_52_EthanolFuelPct. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"absEvapSysVapPres\",\"type\":[\"null\",\"float\"],\"doc\":\"Absolute evap system vapor pressure. The OBD2 name is S1_PID_53_AbsEvapSysVapPres. Min value is 0. Max value is 328. The unit is kPa.\",\"default\":null},{\"name\":\"evapSysVapPres\",\"type\":[\"null\",\"float\"],\"doc\":\"Evap system vapor pressure. The OBD2 name is S1_PID_54_EvapSysVapPres. Min value is -32767. Max value is 32768. The unit is Pa.\",\"default\":null},{\"name\":\"shortSecOxyTrimBank1\",\"type\":[\"null\",\"float\"],\"doc\":\"Short term sec. oxygen trim (bank 1). The OBD2 name is S1_PID_55_ShortSecOxyTrimBank1. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"shortSecOxyTrimBank3\",\"type\":[\"null\",\"float\"],\"doc\":\"Short term sec. oxygen trim (bank 3). The OBD2 name is S1_PID_55_ShortSecOxyTrimBank3. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"longSecOxyTrimBank1\",\"type\":[\"null\",\"float\"],\"doc\":\"Long term sec. oxygen trim (bank 1). The OBD2 name is S1_PID_56_LongSecOxyTrimBank1. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"longSecOxyTrimBank3\",\"type\":[\"null\",\"float\"],\"doc\":\"Long term sec. oxygen trim (bank 3). The OBD2 name is S1_PID_56_LongSecOxyTrimBank3. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"shortSecOxyTrimBank2\",\"type\":[\"null\",\"float\"],\"doc\":\"Short term sec. oxygen trim (bank 2). The OBD2 name is S1_PID_57_ShortSecOxyTrimBank2. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"shortSecOxyTrimBank4\",\"type\":[\"null\",\"float\"],\"doc\":\"Short term sec. oxygen trim (bank 4). The OBD2 name is S1_PID_57_ShortSecOxyTrimBank4. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"longSecOxyTrimBank2\",\"type\":[\"null\",\"float\"],\"doc\":\"Long term sec. oxygen trim (bank 2). The OBD2 name is S1_PID_58_LongSecOxyTrimBank2. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"longSecOxyTrimBank4\",\"type\":[\"null\",\"float\"],\"doc\":\"Long term sec. oxygen trim (bank 4). The OBD2 name is S1_PID_58_LongSecOxyTrimBank4. Min value is -100. Max value is 99. The unit is %.\",\"default\":null},{\"name\":\"fuelRailAbsPres\",\"type\":[\"null\",\"float\"],\"doc\":\"Fuel rail absolute pressure. The OBD2 name is S1_PID_59_FuelRailAbsPres. Min value is 0. Max value is 655350. The unit is kPa.\",\"default\":null},{\"name\":\"relAccelPedalPos\",\"type\":[\"null\",\"float\"],\"doc\":\"Relative accelerator pedal position. The OBD2 name is S1_PID_5A_RelAccelPedalPos. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"hybrBatPackRemLife\",\"type\":[\"null\",\"float\"],\"doc\":\"Hybrid battery pack remaining life. The OBD2 name is S1_PID_5B_HybrBatPackRemLife. Min value is 0. Max value is 100. The unit is %.\",\"default\":null},{\"name\":\"engineOilTemp\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine oil temperature. The OBD2 name is S1_PID_5C_EngineOilTemp. Min value is -40. Max value is 215. The unit is degC.\",\"default\":null},{\"name\":\"fuelInjectionTiming\",\"type\":[\"null\",\"float\"],\"doc\":\"Fuel injection timing. The OBD2 name is S1_PID_5D_FuelInjectionTiming. Min value is -210. Max value is 302. The unit is deg.\",\"default\":null},{\"name\":\"engineFuelRate\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine fuel rate. The OBD2 name is S1_PID_5E_EngineFuelRate. Min value is 0. Max value is 3277. The unit is L/h.\",\"default\":null},{\"name\":\"emissionReq\",\"type\":[\"null\",\"float\"],\"doc\":\"Emission requirements. The OBD2 name is S1_PID_5F_EmissionReq. Min value is 0. Max value is 255. The unit is Encoded.\",\"default\":null},{\"name\":\"demandEngTorqPct\",\"type\":[\"null\",\"float\"],\"doc\":\"Demanded engine percent torque. The OBD2 name is S1_PID_61_DemandEngTorqPct. Min value is -125. Max value is 130. The unit is %.\",\"default\":null},{\"name\":\"actualEngTorqPct\",\"type\":[\"null\",\"float\"],\"doc\":\"Actual engine percent torque. The OBD2 name is S1_PID_62_ActualEngTorqPct. Min value is -125. Max value is 130. The unit is %.\",\"default\":null},{\"name\":\"engRefTorq\",\"t", "ype\":[\"null\",\"float\"],\"doc\":\"Engine reference torque. The OBD2 name is S1_PID_63_EngRefTorq. Min value is 0. Max value is 65535. The unit is Nm.\",\"default\":null},{\"name\":\"engPctTorqIdle\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine pct. torque (idle). The OBD2 name is S1_PID_64_EngPctTorq_Idle. Min value is -125. Max value is 130. The unit is %.\",\"default\":null},{\"name\":\"engPctTorqEp1\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine pct. torque (engine point 1). The OBD2 name is S1_PID_64_EngPctTorq_EP1. Min value is -125. Max value is 130. The unit is %.\",\"default\":null},{\"name\":\"engPctTorqEp2\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine pct. torque (engine point 2). The OBD2 name is S1_PID_64_EngPctTorq_EP2. Min value is -125. Max value is 130. The unit is %.\",\"default\":null},{\"name\":\"engPctTorqEp3\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine pct. torque (engine point 3). The OBD2 name is S1_PID_64_EngPctTorq_EP3. Min value is -125. Max value is 130. The unit is %.\",\"default\":null},{\"name\":\"engPctTorqEp4\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine pct. torque (engine point 4). The OBD2 name is S1_PID_64_EngPctTorq_EP4. Min value is -125. Max value is 130. The unit is %.\",\"default\":null},{\"name\":\"auxInputOutput\",\"type\":[\"null\",\"float\"],\"doc\":\"Auxiliary input/output supported. The OBD2 name is S1_PID_65_AuxInputOutput. Min value is 0. Max value is 255. The unit is Encoded.\",\"default\":null},{\"name\":\"mafSensor\",\"type\":[\"null\",\"float\"],\"doc\":\"Mass air flow sensor. The OBD2 name is S1_PID_66_MAFSensor. Min value is 0. Max value is 2048. The unit is grams/sec.\",\"default\":null},{\"name\":\"engineCoolantTemp67\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine coolant temperature. The OBD2 name is S1_PID_67_EngineCoolantTemp. Min value is -40. Max value is 215. The unit is degC.\",\"default\":null},{\"name\":\"intakeAirTempSens\",\"type\":[\"null\",\"float\"],\"doc\":\"Intake air temperature. The OBD2 name is S1_PID_68_IntakeAirTempSens. Min value is -40. Max value is 215. The unit is degC.\",\"default\":null},{\"name\":\"engineFrictionPercentTorque\",\"type\":[\"null\",\"float\"],\"doc\":\"Engine friction percent torque. The OBD2 name is S1_PID_8E_EngFrictionPctTorq. Min value is -125. Max value is 130. The unit is %.\",\"default\":null}]}"});
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<CanEdgeObd2> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<CanEdgeObd2> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private Float fuelSystemStatus;
    private Float calcEngineLoad;
    private Float engineCoolantTemp;
    private Float shortFuelTrimBank1;
    private Float longFuelTrimBank1;
    private Float shortFuelTrimBank2;
    private Float longFuelTrimBank2;
    private Float fuelPressure;
    private Float intakeManiAbsPress;
    private Float engineRpm;
    private Float vehicleSpeed;
    private Float timingAdvance;
    private Float intakeAirTemperature;
    private Float mafAirFlowRate;
    private Float throttlePosition;
    private Float cmdSecAirStatus;
    private Float oxySensor1Volt14;
    private Float oxySensor1Stft;
    private Float oxySensor2Volt14;
    private Float oxySensor2Stft;
    private Float oxySensor3Volt14;
    private Float oxySensor3Stft;
    private Float oxySensor4Volt14;
    private Float oxySensor4Stft;
    private Float oxySensor5Volt14;
    private Float oxySensor5Stft;
    private Float oxySensor6Volt14;
    private Float oxySensor6Stft;
    private Float oxySensor7Volt14;
    private Float oxySensor7Stft;
    private Float oxySensor8Volt14;
    private Float oxySensor8Stft;
    private Float timeSinceEngStart;
    private Float distanceMilOn;
    private Float fuelRailPres;
    private Float fuelRailGaug;
    private Float oxySensor1Faer24;
    private Float oxySensor1Volt24;
    private Float oxySensor2Faer25;
    private Float oxySensor2Volt25;
    private Float oxySensor3Faer26;
    private Float oxySensor3Volt26;
    private Float oxySensor4Faer27;
    private Float oxySensor4Volt27;
    private Float oxySensor5Faer28;
    private Float oxySensor5Volt28;
    private Float oxySensor6Faer29;
    private Float oxySensor6Volt29;
    private Float oxySensor7Faer2A;
    private Float oxySensor7Volt2A;
    private Float oxySensor8Faer2B;
    private Float oxySensor8Volt2B;
    private Float cmdEgr;
    private Float egrError;
    private Float cmdEvapPurge;
    private Float fuelTankLevel;
    private Float warmUpsSinceCodeClear;
    private Float distanceSinceCodeClear;
    private Float evapSysVaporPres;
    private Float absBaroPres;
    private Float oxySensor1Faer34;
    private Float oxySensor1Crnt;
    private Float oxySensor2Faer35;
    private Float oxySensor2Crnt;
    private Float oxySensor3Faer36;
    private Float oxySensor3Crnt;
    private Float oxySensor4Faer37;
    private Float oxySensor4Crnt;
    private Float oxySensor5Faer38;
    private Float oxySensor5Crnt;
    private Float oxySensor6Faer39;
    private Float oxySensor6Crnt;
    private Float oxySensor7Faer3A;
    private Float oxySensor7Crnt;
    private Float oxySensor8Faer3B;
    private Float oxySensor8Crnt;
    private Float catTempBank1Sens1;
    private Float catTempBank2Sens1;
    private Float catTempBank1Sens2;
    private Float catTempBank2Sens2;
    private Float monStatusDriveCycle;
    private Float controlModuleVolt;
    private Float absLoadValue;
    private Float fuelAirCmdEquiv;
    private Float relThrottlePos;
    private Float ambientAirTemp;
    private Float absThrottlePosB;
    private Float absThrottlePosC;
    private Float absThrottlePosCd;
    private Float absThrottlePosE;
    private Float absThrottlePosF;
    private Float cmdThrottleAct;
    private Float timeRunMilOn;
    private Float timeSinceCodeClear;
    private Float maxFaer;
    private Float maxOxySensVol;
    private Float maxOxySensCrnt;
    private Float maxIntManiAbsPres;
    private Float maxAirFlowMaf;
    private Float fuelType;
    private Float ethanolFuelPct;
    private Float absEvapSysVapPres;
    private Float evapSysVapPres;
    private Float shortSecOxyTrimBank1;
    private Float shortSecOxyTrimBank3;
    private Float longSecOxyTrimBank1;
    private Float longSecOxyTrimBank3;
    private Float shortSecOxyTrimBank2;
    private Float shortSecOxyTrimBank4;
    private Float longSecOxyTrimBank2;
    private Float longSecOxyTrimBank4;
    private Float fuelRailAbsPres;
    private Float relAccelPedalPos;
    private Float hybrBatPackRemLife;
    private Float engineOilTemp;
    private Float fuelInjectionTiming;
    private Float engineFuelRate;
    private Float emissionReq;
    private Float demandEngTorqPct;
    private Float actualEngTorqPct;
    private Float engRefTorq;
    private Float engPctTorqIdle;
    private Float engPctTorqEp1;
    private Float engPctTorqEp2;
    private Float engPctTorqEp3;
    private Float engPctTorqEp4;
    private Float auxInputOutput;
    private Float mafSensor;
    private Float engineCoolantTemp67;
    private Float intakeAirTempSens;
    private Float engineFrictionPercentTorque;
    private static final DatumWriter<CanEdgeObd2> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<CanEdgeObd2> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<CanEdgeObd2> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<CanEdgeObd2> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<CanEdgeObd2> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static CanEdgeObd2 fromByteBuffer(ByteBuffer b) throws IOException {
        return (CanEdgeObd2)((Object)DECODER.decode(b));
    }

    public CanEdgeObd2() {
    }

    public CanEdgeObd2(Double time, Double timeReceived, Float fuelSystemStatus, Float calcEngineLoad, Float engineCoolantTemp, Float shortFuelTrimBank1, Float longFuelTrimBank1, Float shortFuelTrimBank2, Float longFuelTrimBank2, Float fuelPressure, Float intakeManiAbsPress, Float engineRpm, Float vehicleSpeed, Float timingAdvance, Float intakeAirTemperature, Float mafAirFlowRate, Float throttlePosition, Float cmdSecAirStatus, Float oxySensor1Volt14, Float oxySensor1Stft, Float oxySensor2Volt14, Float oxySensor2Stft, Float oxySensor3Volt14, Float oxySensor3Stft, Float oxySensor4Volt14, Float oxySensor4Stft, Float oxySensor5Volt14, Float oxySensor5Stft, Float oxySensor6Volt14, Float oxySensor6Stft, Float oxySensor7Volt14, Float oxySensor7Stft, Float oxySensor8Volt14, Float oxySensor8Stft, Float timeSinceEngStart, Float distanceMilOn, Float fuelRailPres, Float fuelRailGaug, Float oxySensor1Faer24, Float oxySensor1Volt24, Float oxySensor2Faer25, Float oxySensor2Volt25, Float oxySensor3Faer26, Float oxySensor3Volt26, Float oxySensor4Faer27, Float oxySensor4Volt27, Float oxySensor5Faer28, Float oxySensor5Volt28, Float oxySensor6Faer29, Float oxySensor6Volt29, Float oxySensor7Faer2A, Float oxySensor7Volt2A, Float oxySensor8Faer2B, Float oxySensor8Volt2B, Float cmdEgr, Float egrError, Float cmdEvapPurge, Float fuelTankLevel, Float warmUpsSinceCodeClear, Float distanceSinceCodeClear, Float evapSysVaporPres, Float absBaroPres, Float oxySensor1Faer34, Float oxySensor1Crnt, Float oxySensor2Faer35, Float oxySensor2Crnt, Float oxySensor3Faer36, Float oxySensor3Crnt, Float oxySensor4Faer37, Float oxySensor4Crnt, Float oxySensor5Faer38, Float oxySensor5Crnt, Float oxySensor6Faer39, Float oxySensor6Crnt, Float oxySensor7Faer3A, Float oxySensor7Crnt, Float oxySensor8Faer3B, Float oxySensor8Crnt, Float catTempBank1Sens1, Float catTempBank2Sens1, Float catTempBank1Sens2, Float catTempBank2Sens2, Float monStatusDriveCycle, Float controlModuleVolt, Float absLoadValue, Float fuelAirCmdEquiv, Float relThrottlePos, Float ambientAirTemp, Float absThrottlePosB, Float absThrottlePosC, Float absThrottlePosCd, Float absThrottlePosE, Float absThrottlePosF, Float cmdThrottleAct, Float timeRunMilOn, Float timeSinceCodeClear, Float maxFaer, Float maxOxySensVol, Float maxOxySensCrnt, Float maxIntManiAbsPres, Float maxAirFlowMaf, Float fuelType, Float ethanolFuelPct, Float absEvapSysVapPres, Float evapSysVapPres, Float shortSecOxyTrimBank1, Float shortSecOxyTrimBank3, Float longSecOxyTrimBank1, Float longSecOxyTrimBank3, Float shortSecOxyTrimBank2, Float shortSecOxyTrimBank4, Float longSecOxyTrimBank2, Float longSecOxyTrimBank4, Float fuelRailAbsPres, Float relAccelPedalPos, Float hybrBatPackRemLife, Float engineOilTemp, Float fuelInjectionTiming, Float engineFuelRate, Float emissionReq, Float demandEngTorqPct, Float actualEngTorqPct, Float engRefTorq, Float engPctTorqIdle, Float engPctTorqEp1, Float engPctTorqEp2, Float engPctTorqEp3, Float engPctTorqEp4, Float auxInputOutput, Float mafSensor, Float engineCoolantTemp67, Float intakeAirTempSens, Float engineFrictionPercentTorque) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.fuelSystemStatus = fuelSystemStatus;
        this.calcEngineLoad = calcEngineLoad;
        this.engineCoolantTemp = engineCoolantTemp;
        this.shortFuelTrimBank1 = shortFuelTrimBank1;
        this.longFuelTrimBank1 = longFuelTrimBank1;
        this.shortFuelTrimBank2 = shortFuelTrimBank2;
        this.longFuelTrimBank2 = longFuelTrimBank2;
        this.fuelPressure = fuelPressure;
        this.intakeManiAbsPress = intakeManiAbsPress;
        this.engineRpm = engineRpm;
        this.vehicleSpeed = vehicleSpeed;
        this.timingAdvance = timingAdvance;
        this.intakeAirTemperature = intakeAirTemperature;
        this.mafAirFlowRate = mafAirFlowRate;
        this.throttlePosition = throttlePosition;
        this.cmdSecAirStatus = cmdSecAirStatus;
        this.oxySensor1Volt14 = oxySensor1Volt14;
        this.oxySensor1Stft = oxySensor1Stft;
        this.oxySensor2Volt14 = oxySensor2Volt14;
        this.oxySensor2Stft = oxySensor2Stft;
        this.oxySensor3Volt14 = oxySensor3Volt14;
        this.oxySensor3Stft = oxySensor3Stft;
        this.oxySensor4Volt14 = oxySensor4Volt14;
        this.oxySensor4Stft = oxySensor4Stft;
        this.oxySensor5Volt14 = oxySensor5Volt14;
        this.oxySensor5Stft = oxySensor5Stft;
        this.oxySensor6Volt14 = oxySensor6Volt14;
        this.oxySensor6Stft = oxySensor6Stft;
        this.oxySensor7Volt14 = oxySensor7Volt14;
        this.oxySensor7Stft = oxySensor7Stft;
        this.oxySensor8Volt14 = oxySensor8Volt14;
        this.oxySensor8Stft = oxySensor8Stft;
        this.timeSinceEngStart = timeSinceEngStart;
        this.distanceMilOn = distanceMilOn;
        this.fuelRailPres = fuelRailPres;
        this.fuelRailGaug = fuelRailGaug;
        this.oxySensor1Faer24 = oxySensor1Faer24;
        this.oxySensor1Volt24 = oxySensor1Volt24;
        this.oxySensor2Faer25 = oxySensor2Faer25;
        this.oxySensor2Volt25 = oxySensor2Volt25;
        this.oxySensor3Faer26 = oxySensor3Faer26;
        this.oxySensor3Volt26 = oxySensor3Volt26;
        this.oxySensor4Faer27 = oxySensor4Faer27;
        this.oxySensor4Volt27 = oxySensor4Volt27;
        this.oxySensor5Faer28 = oxySensor5Faer28;
        this.oxySensor5Volt28 = oxySensor5Volt28;
        this.oxySensor6Faer29 = oxySensor6Faer29;
        this.oxySensor6Volt29 = oxySensor6Volt29;
        this.oxySensor7Faer2A = oxySensor7Faer2A;
        this.oxySensor7Volt2A = oxySensor7Volt2A;
        this.oxySensor8Faer2B = oxySensor8Faer2B;
        this.oxySensor8Volt2B = oxySensor8Volt2B;
        this.cmdEgr = cmdEgr;
        this.egrError = egrError;
        this.cmdEvapPurge = cmdEvapPurge;
        this.fuelTankLevel = fuelTankLevel;
        this.warmUpsSinceCodeClear = warmUpsSinceCodeClear;
        this.distanceSinceCodeClear = distanceSinceCodeClear;
        this.evapSysVaporPres = evapSysVaporPres;
        this.absBaroPres = absBaroPres;
        this.oxySensor1Faer34 = oxySensor1Faer34;
        this.oxySensor1Crnt = oxySensor1Crnt;
        this.oxySensor2Faer35 = oxySensor2Faer35;
        this.oxySensor2Crnt = oxySensor2Crnt;
        this.oxySensor3Faer36 = oxySensor3Faer36;
        this.oxySensor3Crnt = oxySensor3Crnt;
        this.oxySensor4Faer37 = oxySensor4Faer37;
        this.oxySensor4Crnt = oxySensor4Crnt;
        this.oxySensor5Faer38 = oxySensor5Faer38;
        this.oxySensor5Crnt = oxySensor5Crnt;
        this.oxySensor6Faer39 = oxySensor6Faer39;
        this.oxySensor6Crnt = oxySensor6Crnt;
        this.oxySensor7Faer3A = oxySensor7Faer3A;
        this.oxySensor7Crnt = oxySensor7Crnt;
        this.oxySensor8Faer3B = oxySensor8Faer3B;
        this.oxySensor8Crnt = oxySensor8Crnt;
        this.catTempBank1Sens1 = catTempBank1Sens1;
        this.catTempBank2Sens1 = catTempBank2Sens1;
        this.catTempBank1Sens2 = catTempBank1Sens2;
        this.catTempBank2Sens2 = catTempBank2Sens2;
        this.monStatusDriveCycle = monStatusDriveCycle;
        this.controlModuleVolt = controlModuleVolt;
        this.absLoadValue = absLoadValue;
        this.fuelAirCmdEquiv = fuelAirCmdEquiv;
        this.relThrottlePos = relThrottlePos;
        this.ambientAirTemp = ambientAirTemp;
        this.absThrottlePosB = absThrottlePosB;
        this.absThrottlePosC = absThrottlePosC;
        this.absThrottlePosCd = absThrottlePosCd;
        this.absThrottlePosE = absThrottlePosE;
        this.absThrottlePosF = absThrottlePosF;
        this.cmdThrottleAct = cmdThrottleAct;
        this.timeRunMilOn = timeRunMilOn;
        this.timeSinceCodeClear = timeSinceCodeClear;
        this.maxFaer = maxFaer;
        this.maxOxySensVol = maxOxySensVol;
        this.maxOxySensCrnt = maxOxySensCrnt;
        this.maxIntManiAbsPres = maxIntManiAbsPres;
        this.maxAirFlowMaf = maxAirFlowMaf;
        this.fuelType = fuelType;
        this.ethanolFuelPct = ethanolFuelPct;
        this.absEvapSysVapPres = absEvapSysVapPres;
        this.evapSysVapPres = evapSysVapPres;
        this.shortSecOxyTrimBank1 = shortSecOxyTrimBank1;
        this.shortSecOxyTrimBank3 = shortSecOxyTrimBank3;
        this.longSecOxyTrimBank1 = longSecOxyTrimBank1;
        this.longSecOxyTrimBank3 = longSecOxyTrimBank3;
        this.shortSecOxyTrimBank2 = shortSecOxyTrimBank2;
        this.shortSecOxyTrimBank4 = shortSecOxyTrimBank4;
        this.longSecOxyTrimBank2 = longSecOxyTrimBank2;
        this.longSecOxyTrimBank4 = longSecOxyTrimBank4;
        this.fuelRailAbsPres = fuelRailAbsPres;
        this.relAccelPedalPos = relAccelPedalPos;
        this.hybrBatPackRemLife = hybrBatPackRemLife;
        this.engineOilTemp = engineOilTemp;
        this.fuelInjectionTiming = fuelInjectionTiming;
        this.engineFuelRate = engineFuelRate;
        this.emissionReq = emissionReq;
        this.demandEngTorqPct = demandEngTorqPct;
        this.actualEngTorqPct = actualEngTorqPct;
        this.engRefTorq = engRefTorq;
        this.engPctTorqIdle = engPctTorqIdle;
        this.engPctTorqEp1 = engPctTorqEp1;
        this.engPctTorqEp2 = engPctTorqEp2;
        this.engPctTorqEp3 = engPctTorqEp3;
        this.engPctTorqEp4 = engPctTorqEp4;
        this.auxInputOutput = auxInputOutput;
        this.mafSensor = mafSensor;
        this.engineCoolantTemp67 = engineCoolantTemp67;
        this.intakeAirTempSens = intakeAirTempSens;
        this.engineFrictionPercentTorque = engineFrictionPercentTorque;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.fuelSystemStatus;
            }
            case 3: {
                return this.calcEngineLoad;
            }
            case 4: {
                return this.engineCoolantTemp;
            }
            case 5: {
                return this.shortFuelTrimBank1;
            }
            case 6: {
                return this.longFuelTrimBank1;
            }
            case 7: {
                return this.shortFuelTrimBank2;
            }
            case 8: {
                return this.longFuelTrimBank2;
            }
            case 9: {
                return this.fuelPressure;
            }
            case 10: {
                return this.intakeManiAbsPress;
            }
            case 11: {
                return this.engineRpm;
            }
            case 12: {
                return this.vehicleSpeed;
            }
            case 13: {
                return this.timingAdvance;
            }
            case 14: {
                return this.intakeAirTemperature;
            }
            case 15: {
                return this.mafAirFlowRate;
            }
            case 16: {
                return this.throttlePosition;
            }
            case 17: {
                return this.cmdSecAirStatus;
            }
            case 18: {
                return this.oxySensor1Volt14;
            }
            case 19: {
                return this.oxySensor1Stft;
            }
            case 20: {
                return this.oxySensor2Volt14;
            }
            case 21: {
                return this.oxySensor2Stft;
            }
            case 22: {
                return this.oxySensor3Volt14;
            }
            case 23: {
                return this.oxySensor3Stft;
            }
            case 24: {
                return this.oxySensor4Volt14;
            }
            case 25: {
                return this.oxySensor4Stft;
            }
            case 26: {
                return this.oxySensor5Volt14;
            }
            case 27: {
                return this.oxySensor5Stft;
            }
            case 28: {
                return this.oxySensor6Volt14;
            }
            case 29: {
                return this.oxySensor6Stft;
            }
            case 30: {
                return this.oxySensor7Volt14;
            }
            case 31: {
                return this.oxySensor7Stft;
            }
            case 32: {
                return this.oxySensor8Volt14;
            }
            case 33: {
                return this.oxySensor8Stft;
            }
            case 34: {
                return this.timeSinceEngStart;
            }
            case 35: {
                return this.distanceMilOn;
            }
            case 36: {
                return this.fuelRailPres;
            }
            case 37: {
                return this.fuelRailGaug;
            }
            case 38: {
                return this.oxySensor1Faer24;
            }
            case 39: {
                return this.oxySensor1Volt24;
            }
            case 40: {
                return this.oxySensor2Faer25;
            }
            case 41: {
                return this.oxySensor2Volt25;
            }
            case 42: {
                return this.oxySensor3Faer26;
            }
            case 43: {
                return this.oxySensor3Volt26;
            }
            case 44: {
                return this.oxySensor4Faer27;
            }
            case 45: {
                return this.oxySensor4Volt27;
            }
            case 46: {
                return this.oxySensor5Faer28;
            }
            case 47: {
                return this.oxySensor5Volt28;
            }
            case 48: {
                return this.oxySensor6Faer29;
            }
            case 49: {
                return this.oxySensor6Volt29;
            }
            case 50: {
                return this.oxySensor7Faer2A;
            }
            case 51: {
                return this.oxySensor7Volt2A;
            }
            case 52: {
                return this.oxySensor8Faer2B;
            }
            case 53: {
                return this.oxySensor8Volt2B;
            }
            case 54: {
                return this.cmdEgr;
            }
            case 55: {
                return this.egrError;
            }
            case 56: {
                return this.cmdEvapPurge;
            }
            case 57: {
                return this.fuelTankLevel;
            }
            case 58: {
                return this.warmUpsSinceCodeClear;
            }
            case 59: {
                return this.distanceSinceCodeClear;
            }
            case 60: {
                return this.evapSysVaporPres;
            }
            case 61: {
                return this.absBaroPres;
            }
            case 62: {
                return this.oxySensor1Faer34;
            }
            case 63: {
                return this.oxySensor1Crnt;
            }
            case 64: {
                return this.oxySensor2Faer35;
            }
            case 65: {
                return this.oxySensor2Crnt;
            }
            case 66: {
                return this.oxySensor3Faer36;
            }
            case 67: {
                return this.oxySensor3Crnt;
            }
            case 68: {
                return this.oxySensor4Faer37;
            }
            case 69: {
                return this.oxySensor4Crnt;
            }
            case 70: {
                return this.oxySensor5Faer38;
            }
            case 71: {
                return this.oxySensor5Crnt;
            }
            case 72: {
                return this.oxySensor6Faer39;
            }
            case 73: {
                return this.oxySensor6Crnt;
            }
            case 74: {
                return this.oxySensor7Faer3A;
            }
            case 75: {
                return this.oxySensor7Crnt;
            }
            case 76: {
                return this.oxySensor8Faer3B;
            }
            case 77: {
                return this.oxySensor8Crnt;
            }
            case 78: {
                return this.catTempBank1Sens1;
            }
            case 79: {
                return this.catTempBank2Sens1;
            }
            case 80: {
                return this.catTempBank1Sens2;
            }
            case 81: {
                return this.catTempBank2Sens2;
            }
            case 82: {
                return this.monStatusDriveCycle;
            }
            case 83: {
                return this.controlModuleVolt;
            }
            case 84: {
                return this.absLoadValue;
            }
            case 85: {
                return this.fuelAirCmdEquiv;
            }
            case 86: {
                return this.relThrottlePos;
            }
            case 87: {
                return this.ambientAirTemp;
            }
            case 88: {
                return this.absThrottlePosB;
            }
            case 89: {
                return this.absThrottlePosC;
            }
            case 90: {
                return this.absThrottlePosCd;
            }
            case 91: {
                return this.absThrottlePosE;
            }
            case 92: {
                return this.absThrottlePosF;
            }
            case 93: {
                return this.cmdThrottleAct;
            }
            case 94: {
                return this.timeRunMilOn;
            }
            case 95: {
                return this.timeSinceCodeClear;
            }
            case 96: {
                return this.maxFaer;
            }
            case 97: {
                return this.maxOxySensVol;
            }
            case 98: {
                return this.maxOxySensCrnt;
            }
            case 99: {
                return this.maxIntManiAbsPres;
            }
            case 100: {
                return this.maxAirFlowMaf;
            }
            case 101: {
                return this.fuelType;
            }
            case 102: {
                return this.ethanolFuelPct;
            }
            case 103: {
                return this.absEvapSysVapPres;
            }
            case 104: {
                return this.evapSysVapPres;
            }
            case 105: {
                return this.shortSecOxyTrimBank1;
            }
            case 106: {
                return this.shortSecOxyTrimBank3;
            }
            case 107: {
                return this.longSecOxyTrimBank1;
            }
            case 108: {
                return this.longSecOxyTrimBank3;
            }
            case 109: {
                return this.shortSecOxyTrimBank2;
            }
            case 110: {
                return this.shortSecOxyTrimBank4;
            }
            case 111: {
                return this.longSecOxyTrimBank2;
            }
            case 112: {
                return this.longSecOxyTrimBank4;
            }
            case 113: {
                return this.fuelRailAbsPres;
            }
            case 114: {
                return this.relAccelPedalPos;
            }
            case 115: {
                return this.hybrBatPackRemLife;
            }
            case 116: {
                return this.engineOilTemp;
            }
            case 117: {
                return this.fuelInjectionTiming;
            }
            case 118: {
                return this.engineFuelRate;
            }
            case 119: {
                return this.emissionReq;
            }
            case 120: {
                return this.demandEngTorqPct;
            }
            case 121: {
                return this.actualEngTorqPct;
            }
            case 122: {
                return this.engRefTorq;
            }
            case 123: {
                return this.engPctTorqIdle;
            }
            case 124: {
                return this.engPctTorqEp1;
            }
            case 125: {
                return this.engPctTorqEp2;
            }
            case 126: {
                return this.engPctTorqEp3;
            }
            case 127: {
                return this.engPctTorqEp4;
            }
            case 128: {
                return this.auxInputOutput;
            }
            case 129: {
                return this.mafSensor;
            }
            case 130: {
                return this.engineCoolantTemp67;
            }
            case 131: {
                return this.intakeAirTempSens;
            }
            case 132: {
                return this.engineFrictionPercentTorque;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.fuelSystemStatus = (Float)value$;
                break;
            }
            case 3: {
                this.calcEngineLoad = (Float)value$;
                break;
            }
            case 4: {
                this.engineCoolantTemp = (Float)value$;
                break;
            }
            case 5: {
                this.shortFuelTrimBank1 = (Float)value$;
                break;
            }
            case 6: {
                this.longFuelTrimBank1 = (Float)value$;
                break;
            }
            case 7: {
                this.shortFuelTrimBank2 = (Float)value$;
                break;
            }
            case 8: {
                this.longFuelTrimBank2 = (Float)value$;
                break;
            }
            case 9: {
                this.fuelPressure = (Float)value$;
                break;
            }
            case 10: {
                this.intakeManiAbsPress = (Float)value$;
                break;
            }
            case 11: {
                this.engineRpm = (Float)value$;
                break;
            }
            case 12: {
                this.vehicleSpeed = (Float)value$;
                break;
            }
            case 13: {
                this.timingAdvance = (Float)value$;
                break;
            }
            case 14: {
                this.intakeAirTemperature = (Float)value$;
                break;
            }
            case 15: {
                this.mafAirFlowRate = (Float)value$;
                break;
            }
            case 16: {
                this.throttlePosition = (Float)value$;
                break;
            }
            case 17: {
                this.cmdSecAirStatus = (Float)value$;
                break;
            }
            case 18: {
                this.oxySensor1Volt14 = (Float)value$;
                break;
            }
            case 19: {
                this.oxySensor1Stft = (Float)value$;
                break;
            }
            case 20: {
                this.oxySensor2Volt14 = (Float)value$;
                break;
            }
            case 21: {
                this.oxySensor2Stft = (Float)value$;
                break;
            }
            case 22: {
                this.oxySensor3Volt14 = (Float)value$;
                break;
            }
            case 23: {
                this.oxySensor3Stft = (Float)value$;
                break;
            }
            case 24: {
                this.oxySensor4Volt14 = (Float)value$;
                break;
            }
            case 25: {
                this.oxySensor4Stft = (Float)value$;
                break;
            }
            case 26: {
                this.oxySensor5Volt14 = (Float)value$;
                break;
            }
            case 27: {
                this.oxySensor5Stft = (Float)value$;
                break;
            }
            case 28: {
                this.oxySensor6Volt14 = (Float)value$;
                break;
            }
            case 29: {
                this.oxySensor6Stft = (Float)value$;
                break;
            }
            case 30: {
                this.oxySensor7Volt14 = (Float)value$;
                break;
            }
            case 31: {
                this.oxySensor7Stft = (Float)value$;
                break;
            }
            case 32: {
                this.oxySensor8Volt14 = (Float)value$;
                break;
            }
            case 33: {
                this.oxySensor8Stft = (Float)value$;
                break;
            }
            case 34: {
                this.timeSinceEngStart = (Float)value$;
                break;
            }
            case 35: {
                this.distanceMilOn = (Float)value$;
                break;
            }
            case 36: {
                this.fuelRailPres = (Float)value$;
                break;
            }
            case 37: {
                this.fuelRailGaug = (Float)value$;
                break;
            }
            case 38: {
                this.oxySensor1Faer24 = (Float)value$;
                break;
            }
            case 39: {
                this.oxySensor1Volt24 = (Float)value$;
                break;
            }
            case 40: {
                this.oxySensor2Faer25 = (Float)value$;
                break;
            }
            case 41: {
                this.oxySensor2Volt25 = (Float)value$;
                break;
            }
            case 42: {
                this.oxySensor3Faer26 = (Float)value$;
                break;
            }
            case 43: {
                this.oxySensor3Volt26 = (Float)value$;
                break;
            }
            case 44: {
                this.oxySensor4Faer27 = (Float)value$;
                break;
            }
            case 45: {
                this.oxySensor4Volt27 = (Float)value$;
                break;
            }
            case 46: {
                this.oxySensor5Faer28 = (Float)value$;
                break;
            }
            case 47: {
                this.oxySensor5Volt28 = (Float)value$;
                break;
            }
            case 48: {
                this.oxySensor6Faer29 = (Float)value$;
                break;
            }
            case 49: {
                this.oxySensor6Volt29 = (Float)value$;
                break;
            }
            case 50: {
                this.oxySensor7Faer2A = (Float)value$;
                break;
            }
            case 51: {
                this.oxySensor7Volt2A = (Float)value$;
                break;
            }
            case 52: {
                this.oxySensor8Faer2B = (Float)value$;
                break;
            }
            case 53: {
                this.oxySensor8Volt2B = (Float)value$;
                break;
            }
            case 54: {
                this.cmdEgr = (Float)value$;
                break;
            }
            case 55: {
                this.egrError = (Float)value$;
                break;
            }
            case 56: {
                this.cmdEvapPurge = (Float)value$;
                break;
            }
            case 57: {
                this.fuelTankLevel = (Float)value$;
                break;
            }
            case 58: {
                this.warmUpsSinceCodeClear = (Float)value$;
                break;
            }
            case 59: {
                this.distanceSinceCodeClear = (Float)value$;
                break;
            }
            case 60: {
                this.evapSysVaporPres = (Float)value$;
                break;
            }
            case 61: {
                this.absBaroPres = (Float)value$;
                break;
            }
            case 62: {
                this.oxySensor1Faer34 = (Float)value$;
                break;
            }
            case 63: {
                this.oxySensor1Crnt = (Float)value$;
                break;
            }
            case 64: {
                this.oxySensor2Faer35 = (Float)value$;
                break;
            }
            case 65: {
                this.oxySensor2Crnt = (Float)value$;
                break;
            }
            case 66: {
                this.oxySensor3Faer36 = (Float)value$;
                break;
            }
            case 67: {
                this.oxySensor3Crnt = (Float)value$;
                break;
            }
            case 68: {
                this.oxySensor4Faer37 = (Float)value$;
                break;
            }
            case 69: {
                this.oxySensor4Crnt = (Float)value$;
                break;
            }
            case 70: {
                this.oxySensor5Faer38 = (Float)value$;
                break;
            }
            case 71: {
                this.oxySensor5Crnt = (Float)value$;
                break;
            }
            case 72: {
                this.oxySensor6Faer39 = (Float)value$;
                break;
            }
            case 73: {
                this.oxySensor6Crnt = (Float)value$;
                break;
            }
            case 74: {
                this.oxySensor7Faer3A = (Float)value$;
                break;
            }
            case 75: {
                this.oxySensor7Crnt = (Float)value$;
                break;
            }
            case 76: {
                this.oxySensor8Faer3B = (Float)value$;
                break;
            }
            case 77: {
                this.oxySensor8Crnt = (Float)value$;
                break;
            }
            case 78: {
                this.catTempBank1Sens1 = (Float)value$;
                break;
            }
            case 79: {
                this.catTempBank2Sens1 = (Float)value$;
                break;
            }
            case 80: {
                this.catTempBank1Sens2 = (Float)value$;
                break;
            }
            case 81: {
                this.catTempBank2Sens2 = (Float)value$;
                break;
            }
            case 82: {
                this.monStatusDriveCycle = (Float)value$;
                break;
            }
            case 83: {
                this.controlModuleVolt = (Float)value$;
                break;
            }
            case 84: {
                this.absLoadValue = (Float)value$;
                break;
            }
            case 85: {
                this.fuelAirCmdEquiv = (Float)value$;
                break;
            }
            case 86: {
                this.relThrottlePos = (Float)value$;
                break;
            }
            case 87: {
                this.ambientAirTemp = (Float)value$;
                break;
            }
            case 88: {
                this.absThrottlePosB = (Float)value$;
                break;
            }
            case 89: {
                this.absThrottlePosC = (Float)value$;
                break;
            }
            case 90: {
                this.absThrottlePosCd = (Float)value$;
                break;
            }
            case 91: {
                this.absThrottlePosE = (Float)value$;
                break;
            }
            case 92: {
                this.absThrottlePosF = (Float)value$;
                break;
            }
            case 93: {
                this.cmdThrottleAct = (Float)value$;
                break;
            }
            case 94: {
                this.timeRunMilOn = (Float)value$;
                break;
            }
            case 95: {
                this.timeSinceCodeClear = (Float)value$;
                break;
            }
            case 96: {
                this.maxFaer = (Float)value$;
                break;
            }
            case 97: {
                this.maxOxySensVol = (Float)value$;
                break;
            }
            case 98: {
                this.maxOxySensCrnt = (Float)value$;
                break;
            }
            case 99: {
                this.maxIntManiAbsPres = (Float)value$;
                break;
            }
            case 100: {
                this.maxAirFlowMaf = (Float)value$;
                break;
            }
            case 101: {
                this.fuelType = (Float)value$;
                break;
            }
            case 102: {
                this.ethanolFuelPct = (Float)value$;
                break;
            }
            case 103: {
                this.absEvapSysVapPres = (Float)value$;
                break;
            }
            case 104: {
                this.evapSysVapPres = (Float)value$;
                break;
            }
            case 105: {
                this.shortSecOxyTrimBank1 = (Float)value$;
                break;
            }
            case 106: {
                this.shortSecOxyTrimBank3 = (Float)value$;
                break;
            }
            case 107: {
                this.longSecOxyTrimBank1 = (Float)value$;
                break;
            }
            case 108: {
                this.longSecOxyTrimBank3 = (Float)value$;
                break;
            }
            case 109: {
                this.shortSecOxyTrimBank2 = (Float)value$;
                break;
            }
            case 110: {
                this.shortSecOxyTrimBank4 = (Float)value$;
                break;
            }
            case 111: {
                this.longSecOxyTrimBank2 = (Float)value$;
                break;
            }
            case 112: {
                this.longSecOxyTrimBank4 = (Float)value$;
                break;
            }
            case 113: {
                this.fuelRailAbsPres = (Float)value$;
                break;
            }
            case 114: {
                this.relAccelPedalPos = (Float)value$;
                break;
            }
            case 115: {
                this.hybrBatPackRemLife = (Float)value$;
                break;
            }
            case 116: {
                this.engineOilTemp = (Float)value$;
                break;
            }
            case 117: {
                this.fuelInjectionTiming = (Float)value$;
                break;
            }
            case 118: {
                this.engineFuelRate = (Float)value$;
                break;
            }
            case 119: {
                this.emissionReq = (Float)value$;
                break;
            }
            case 120: {
                this.demandEngTorqPct = (Float)value$;
                break;
            }
            case 121: {
                this.actualEngTorqPct = (Float)value$;
                break;
            }
            case 122: {
                this.engRefTorq = (Float)value$;
                break;
            }
            case 123: {
                this.engPctTorqIdle = (Float)value$;
                break;
            }
            case 124: {
                this.engPctTorqEp1 = (Float)value$;
                break;
            }
            case 125: {
                this.engPctTorqEp2 = (Float)value$;
                break;
            }
            case 126: {
                this.engPctTorqEp3 = (Float)value$;
                break;
            }
            case 127: {
                this.engPctTorqEp4 = (Float)value$;
                break;
            }
            case 128: {
                this.auxInputOutput = (Float)value$;
                break;
            }
            case 129: {
                this.mafSensor = (Float)value$;
                break;
            }
            case 130: {
                this.engineCoolantTemp67 = (Float)value$;
                break;
            }
            case 131: {
                this.intakeAirTempSens = (Float)value$;
                break;
            }
            case 132: {
                this.engineFrictionPercentTorque = (Float)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public Float getFuelSystemStatus() {
        return this.fuelSystemStatus;
    }

    public void setFuelSystemStatus(Float value) {
        this.fuelSystemStatus = value;
    }

    public Float getCalcEngineLoad() {
        return this.calcEngineLoad;
    }

    public void setCalcEngineLoad(Float value) {
        this.calcEngineLoad = value;
    }

    public Float getEngineCoolantTemp() {
        return this.engineCoolantTemp;
    }

    public void setEngineCoolantTemp(Float value) {
        this.engineCoolantTemp = value;
    }

    public Float getShortFuelTrimBank1() {
        return this.shortFuelTrimBank1;
    }

    public void setShortFuelTrimBank1(Float value) {
        this.shortFuelTrimBank1 = value;
    }

    public Float getLongFuelTrimBank1() {
        return this.longFuelTrimBank1;
    }

    public void setLongFuelTrimBank1(Float value) {
        this.longFuelTrimBank1 = value;
    }

    public Float getShortFuelTrimBank2() {
        return this.shortFuelTrimBank2;
    }

    public void setShortFuelTrimBank2(Float value) {
        this.shortFuelTrimBank2 = value;
    }

    public Float getLongFuelTrimBank2() {
        return this.longFuelTrimBank2;
    }

    public void setLongFuelTrimBank2(Float value) {
        this.longFuelTrimBank2 = value;
    }

    public Float getFuelPressure() {
        return this.fuelPressure;
    }

    public void setFuelPressure(Float value) {
        this.fuelPressure = value;
    }

    public Float getIntakeManiAbsPress() {
        return this.intakeManiAbsPress;
    }

    public void setIntakeManiAbsPress(Float value) {
        this.intakeManiAbsPress = value;
    }

    public Float getEngineRpm() {
        return this.engineRpm;
    }

    public void setEngineRpm(Float value) {
        this.engineRpm = value;
    }

    public Float getVehicleSpeed() {
        return this.vehicleSpeed;
    }

    public void setVehicleSpeed(Float value) {
        this.vehicleSpeed = value;
    }

    public Float getTimingAdvance() {
        return this.timingAdvance;
    }

    public void setTimingAdvance(Float value) {
        this.timingAdvance = value;
    }

    public Float getIntakeAirTemperature() {
        return this.intakeAirTemperature;
    }

    public void setIntakeAirTemperature(Float value) {
        this.intakeAirTemperature = value;
    }

    public Float getMafAirFlowRate() {
        return this.mafAirFlowRate;
    }

    public void setMafAirFlowRate(Float value) {
        this.mafAirFlowRate = value;
    }

    public Float getThrottlePosition() {
        return this.throttlePosition;
    }

    public void setThrottlePosition(Float value) {
        this.throttlePosition = value;
    }

    public Float getCmdSecAirStatus() {
        return this.cmdSecAirStatus;
    }

    public void setCmdSecAirStatus(Float value) {
        this.cmdSecAirStatus = value;
    }

    public Float getOxySensor1Volt14() {
        return this.oxySensor1Volt14;
    }

    public void setOxySensor1Volt14(Float value) {
        this.oxySensor1Volt14 = value;
    }

    public Float getOxySensor1Stft() {
        return this.oxySensor1Stft;
    }

    public void setOxySensor1Stft(Float value) {
        this.oxySensor1Stft = value;
    }

    public Float getOxySensor2Volt14() {
        return this.oxySensor2Volt14;
    }

    public void setOxySensor2Volt14(Float value) {
        this.oxySensor2Volt14 = value;
    }

    public Float getOxySensor2Stft() {
        return this.oxySensor2Stft;
    }

    public void setOxySensor2Stft(Float value) {
        this.oxySensor2Stft = value;
    }

    public Float getOxySensor3Volt14() {
        return this.oxySensor3Volt14;
    }

    public void setOxySensor3Volt14(Float value) {
        this.oxySensor3Volt14 = value;
    }

    public Float getOxySensor3Stft() {
        return this.oxySensor3Stft;
    }

    public void setOxySensor3Stft(Float value) {
        this.oxySensor3Stft = value;
    }

    public Float getOxySensor4Volt14() {
        return this.oxySensor4Volt14;
    }

    public void setOxySensor4Volt14(Float value) {
        this.oxySensor4Volt14 = value;
    }

    public Float getOxySensor4Stft() {
        return this.oxySensor4Stft;
    }

    public void setOxySensor4Stft(Float value) {
        this.oxySensor4Stft = value;
    }

    public Float getOxySensor5Volt14() {
        return this.oxySensor5Volt14;
    }

    public void setOxySensor5Volt14(Float value) {
        this.oxySensor5Volt14 = value;
    }

    public Float getOxySensor5Stft() {
        return this.oxySensor5Stft;
    }

    public void setOxySensor5Stft(Float value) {
        this.oxySensor5Stft = value;
    }

    public Float getOxySensor6Volt14() {
        return this.oxySensor6Volt14;
    }

    public void setOxySensor6Volt14(Float value) {
        this.oxySensor6Volt14 = value;
    }

    public Float getOxySensor6Stft() {
        return this.oxySensor6Stft;
    }

    public void setOxySensor6Stft(Float value) {
        this.oxySensor6Stft = value;
    }

    public Float getOxySensor7Volt14() {
        return this.oxySensor7Volt14;
    }

    public void setOxySensor7Volt14(Float value) {
        this.oxySensor7Volt14 = value;
    }

    public Float getOxySensor7Stft() {
        return this.oxySensor7Stft;
    }

    public void setOxySensor7Stft(Float value) {
        this.oxySensor7Stft = value;
    }

    public Float getOxySensor8Volt14() {
        return this.oxySensor8Volt14;
    }

    public void setOxySensor8Volt14(Float value) {
        this.oxySensor8Volt14 = value;
    }

    public Float getOxySensor8Stft() {
        return this.oxySensor8Stft;
    }

    public void setOxySensor8Stft(Float value) {
        this.oxySensor8Stft = value;
    }

    public Float getTimeSinceEngStart() {
        return this.timeSinceEngStart;
    }

    public void setTimeSinceEngStart(Float value) {
        this.timeSinceEngStart = value;
    }

    public Float getDistanceMilOn() {
        return this.distanceMilOn;
    }

    public void setDistanceMilOn(Float value) {
        this.distanceMilOn = value;
    }

    public Float getFuelRailPres() {
        return this.fuelRailPres;
    }

    public void setFuelRailPres(Float value) {
        this.fuelRailPres = value;
    }

    public Float getFuelRailGaug() {
        return this.fuelRailGaug;
    }

    public void setFuelRailGaug(Float value) {
        this.fuelRailGaug = value;
    }

    public Float getOxySensor1Faer24() {
        return this.oxySensor1Faer24;
    }

    public void setOxySensor1Faer24(Float value) {
        this.oxySensor1Faer24 = value;
    }

    public Float getOxySensor1Volt24() {
        return this.oxySensor1Volt24;
    }

    public void setOxySensor1Volt24(Float value) {
        this.oxySensor1Volt24 = value;
    }

    public Float getOxySensor2Faer25() {
        return this.oxySensor2Faer25;
    }

    public void setOxySensor2Faer25(Float value) {
        this.oxySensor2Faer25 = value;
    }

    public Float getOxySensor2Volt25() {
        return this.oxySensor2Volt25;
    }

    public void setOxySensor2Volt25(Float value) {
        this.oxySensor2Volt25 = value;
    }

    public Float getOxySensor3Faer26() {
        return this.oxySensor3Faer26;
    }

    public void setOxySensor3Faer26(Float value) {
        this.oxySensor3Faer26 = value;
    }

    public Float getOxySensor3Volt26() {
        return this.oxySensor3Volt26;
    }

    public void setOxySensor3Volt26(Float value) {
        this.oxySensor3Volt26 = value;
    }

    public Float getOxySensor4Faer27() {
        return this.oxySensor4Faer27;
    }

    public void setOxySensor4Faer27(Float value) {
        this.oxySensor4Faer27 = value;
    }

    public Float getOxySensor4Volt27() {
        return this.oxySensor4Volt27;
    }

    public void setOxySensor4Volt27(Float value) {
        this.oxySensor4Volt27 = value;
    }

    public Float getOxySensor5Faer28() {
        return this.oxySensor5Faer28;
    }

    public void setOxySensor5Faer28(Float value) {
        this.oxySensor5Faer28 = value;
    }

    public Float getOxySensor5Volt28() {
        return this.oxySensor5Volt28;
    }

    public void setOxySensor5Volt28(Float value) {
        this.oxySensor5Volt28 = value;
    }

    public Float getOxySensor6Faer29() {
        return this.oxySensor6Faer29;
    }

    public void setOxySensor6Faer29(Float value) {
        this.oxySensor6Faer29 = value;
    }

    public Float getOxySensor6Volt29() {
        return this.oxySensor6Volt29;
    }

    public void setOxySensor6Volt29(Float value) {
        this.oxySensor6Volt29 = value;
    }

    public Float getOxySensor7Faer2A() {
        return this.oxySensor7Faer2A;
    }

    public void setOxySensor7Faer2A(Float value) {
        this.oxySensor7Faer2A = value;
    }

    public Float getOxySensor7Volt2A() {
        return this.oxySensor7Volt2A;
    }

    public void setOxySensor7Volt2A(Float value) {
        this.oxySensor7Volt2A = value;
    }

    public Float getOxySensor8Faer2B() {
        return this.oxySensor8Faer2B;
    }

    public void setOxySensor8Faer2B(Float value) {
        this.oxySensor8Faer2B = value;
    }

    public Float getOxySensor8Volt2B() {
        return this.oxySensor8Volt2B;
    }

    public void setOxySensor8Volt2B(Float value) {
        this.oxySensor8Volt2B = value;
    }

    public Float getCmdEgr() {
        return this.cmdEgr;
    }

    public void setCmdEgr(Float value) {
        this.cmdEgr = value;
    }

    public Float getEgrError() {
        return this.egrError;
    }

    public void setEgrError(Float value) {
        this.egrError = value;
    }

    public Float getCmdEvapPurge() {
        return this.cmdEvapPurge;
    }

    public void setCmdEvapPurge(Float value) {
        this.cmdEvapPurge = value;
    }

    public Float getFuelTankLevel() {
        return this.fuelTankLevel;
    }

    public void setFuelTankLevel(Float value) {
        this.fuelTankLevel = value;
    }

    public Float getWarmUpsSinceCodeClear() {
        return this.warmUpsSinceCodeClear;
    }

    public void setWarmUpsSinceCodeClear(Float value) {
        this.warmUpsSinceCodeClear = value;
    }

    public Float getDistanceSinceCodeClear() {
        return this.distanceSinceCodeClear;
    }

    public void setDistanceSinceCodeClear(Float value) {
        this.distanceSinceCodeClear = value;
    }

    public Float getEvapSysVaporPres() {
        return this.evapSysVaporPres;
    }

    public void setEvapSysVaporPres(Float value) {
        this.evapSysVaporPres = value;
    }

    public Float getAbsBaroPres() {
        return this.absBaroPres;
    }

    public void setAbsBaroPres(Float value) {
        this.absBaroPres = value;
    }

    public Float getOxySensor1Faer34() {
        return this.oxySensor1Faer34;
    }

    public void setOxySensor1Faer34(Float value) {
        this.oxySensor1Faer34 = value;
    }

    public Float getOxySensor1Crnt() {
        return this.oxySensor1Crnt;
    }

    public void setOxySensor1Crnt(Float value) {
        this.oxySensor1Crnt = value;
    }

    public Float getOxySensor2Faer35() {
        return this.oxySensor2Faer35;
    }

    public void setOxySensor2Faer35(Float value) {
        this.oxySensor2Faer35 = value;
    }

    public Float getOxySensor2Crnt() {
        return this.oxySensor2Crnt;
    }

    public void setOxySensor2Crnt(Float value) {
        this.oxySensor2Crnt = value;
    }

    public Float getOxySensor3Faer36() {
        return this.oxySensor3Faer36;
    }

    public void setOxySensor3Faer36(Float value) {
        this.oxySensor3Faer36 = value;
    }

    public Float getOxySensor3Crnt() {
        return this.oxySensor3Crnt;
    }

    public void setOxySensor3Crnt(Float value) {
        this.oxySensor3Crnt = value;
    }

    public Float getOxySensor4Faer37() {
        return this.oxySensor4Faer37;
    }

    public void setOxySensor4Faer37(Float value) {
        this.oxySensor4Faer37 = value;
    }

    public Float getOxySensor4Crnt() {
        return this.oxySensor4Crnt;
    }

    public void setOxySensor4Crnt(Float value) {
        this.oxySensor4Crnt = value;
    }

    public Float getOxySensor5Faer38() {
        return this.oxySensor5Faer38;
    }

    public void setOxySensor5Faer38(Float value) {
        this.oxySensor5Faer38 = value;
    }

    public Float getOxySensor5Crnt() {
        return this.oxySensor5Crnt;
    }

    public void setOxySensor5Crnt(Float value) {
        this.oxySensor5Crnt = value;
    }

    public Float getOxySensor6Faer39() {
        return this.oxySensor6Faer39;
    }

    public void setOxySensor6Faer39(Float value) {
        this.oxySensor6Faer39 = value;
    }

    public Float getOxySensor6Crnt() {
        return this.oxySensor6Crnt;
    }

    public void setOxySensor6Crnt(Float value) {
        this.oxySensor6Crnt = value;
    }

    public Float getOxySensor7Faer3A() {
        return this.oxySensor7Faer3A;
    }

    public void setOxySensor7Faer3A(Float value) {
        this.oxySensor7Faer3A = value;
    }

    public Float getOxySensor7Crnt() {
        return this.oxySensor7Crnt;
    }

    public void setOxySensor7Crnt(Float value) {
        this.oxySensor7Crnt = value;
    }

    public Float getOxySensor8Faer3B() {
        return this.oxySensor8Faer3B;
    }

    public void setOxySensor8Faer3B(Float value) {
        this.oxySensor8Faer3B = value;
    }

    public Float getOxySensor8Crnt() {
        return this.oxySensor8Crnt;
    }

    public void setOxySensor8Crnt(Float value) {
        this.oxySensor8Crnt = value;
    }

    public Float getCatTempBank1Sens1() {
        return this.catTempBank1Sens1;
    }

    public void setCatTempBank1Sens1(Float value) {
        this.catTempBank1Sens1 = value;
    }

    public Float getCatTempBank2Sens1() {
        return this.catTempBank2Sens1;
    }

    public void setCatTempBank2Sens1(Float value) {
        this.catTempBank2Sens1 = value;
    }

    public Float getCatTempBank1Sens2() {
        return this.catTempBank1Sens2;
    }

    public void setCatTempBank1Sens2(Float value) {
        this.catTempBank1Sens2 = value;
    }

    public Float getCatTempBank2Sens2() {
        return this.catTempBank2Sens2;
    }

    public void setCatTempBank2Sens2(Float value) {
        this.catTempBank2Sens2 = value;
    }

    public Float getMonStatusDriveCycle() {
        return this.monStatusDriveCycle;
    }

    public void setMonStatusDriveCycle(Float value) {
        this.monStatusDriveCycle = value;
    }

    public Float getControlModuleVolt() {
        return this.controlModuleVolt;
    }

    public void setControlModuleVolt(Float value) {
        this.controlModuleVolt = value;
    }

    public Float getAbsLoadValue() {
        return this.absLoadValue;
    }

    public void setAbsLoadValue(Float value) {
        this.absLoadValue = value;
    }

    public Float getFuelAirCmdEquiv() {
        return this.fuelAirCmdEquiv;
    }

    public void setFuelAirCmdEquiv(Float value) {
        this.fuelAirCmdEquiv = value;
    }

    public Float getRelThrottlePos() {
        return this.relThrottlePos;
    }

    public void setRelThrottlePos(Float value) {
        this.relThrottlePos = value;
    }

    public Float getAmbientAirTemp() {
        return this.ambientAirTemp;
    }

    public void setAmbientAirTemp(Float value) {
        this.ambientAirTemp = value;
    }

    public Float getAbsThrottlePosB() {
        return this.absThrottlePosB;
    }

    public void setAbsThrottlePosB(Float value) {
        this.absThrottlePosB = value;
    }

    public Float getAbsThrottlePosC() {
        return this.absThrottlePosC;
    }

    public void setAbsThrottlePosC(Float value) {
        this.absThrottlePosC = value;
    }

    public Float getAbsThrottlePosCd() {
        return this.absThrottlePosCd;
    }

    public void setAbsThrottlePosCd(Float value) {
        this.absThrottlePosCd = value;
    }

    public Float getAbsThrottlePosE() {
        return this.absThrottlePosE;
    }

    public void setAbsThrottlePosE(Float value) {
        this.absThrottlePosE = value;
    }

    public Float getAbsThrottlePosF() {
        return this.absThrottlePosF;
    }

    public void setAbsThrottlePosF(Float value) {
        this.absThrottlePosF = value;
    }

    public Float getCmdThrottleAct() {
        return this.cmdThrottleAct;
    }

    public void setCmdThrottleAct(Float value) {
        this.cmdThrottleAct = value;
    }

    public Float getTimeRunMilOn() {
        return this.timeRunMilOn;
    }

    public void setTimeRunMilOn(Float value) {
        this.timeRunMilOn = value;
    }

    public Float getTimeSinceCodeClear() {
        return this.timeSinceCodeClear;
    }

    public void setTimeSinceCodeClear(Float value) {
        this.timeSinceCodeClear = value;
    }

    public Float getMaxFaer() {
        return this.maxFaer;
    }

    public void setMaxFaer(Float value) {
        this.maxFaer = value;
    }

    public Float getMaxOxySensVol() {
        return this.maxOxySensVol;
    }

    public void setMaxOxySensVol(Float value) {
        this.maxOxySensVol = value;
    }

    public Float getMaxOxySensCrnt() {
        return this.maxOxySensCrnt;
    }

    public void setMaxOxySensCrnt(Float value) {
        this.maxOxySensCrnt = value;
    }

    public Float getMaxIntManiAbsPres() {
        return this.maxIntManiAbsPres;
    }

    public void setMaxIntManiAbsPres(Float value) {
        this.maxIntManiAbsPres = value;
    }

    public Float getMaxAirFlowMaf() {
        return this.maxAirFlowMaf;
    }

    public void setMaxAirFlowMaf(Float value) {
        this.maxAirFlowMaf = value;
    }

    public Float getFuelType() {
        return this.fuelType;
    }

    public void setFuelType(Float value) {
        this.fuelType = value;
    }

    public Float getEthanolFuelPct() {
        return this.ethanolFuelPct;
    }

    public void setEthanolFuelPct(Float value) {
        this.ethanolFuelPct = value;
    }

    public Float getAbsEvapSysVapPres() {
        return this.absEvapSysVapPres;
    }

    public void setAbsEvapSysVapPres(Float value) {
        this.absEvapSysVapPres = value;
    }

    public Float getEvapSysVapPres() {
        return this.evapSysVapPres;
    }

    public void setEvapSysVapPres(Float value) {
        this.evapSysVapPres = value;
    }

    public Float getShortSecOxyTrimBank1() {
        return this.shortSecOxyTrimBank1;
    }

    public void setShortSecOxyTrimBank1(Float value) {
        this.shortSecOxyTrimBank1 = value;
    }

    public Float getShortSecOxyTrimBank3() {
        return this.shortSecOxyTrimBank3;
    }

    public void setShortSecOxyTrimBank3(Float value) {
        this.shortSecOxyTrimBank3 = value;
    }

    public Float getLongSecOxyTrimBank1() {
        return this.longSecOxyTrimBank1;
    }

    public void setLongSecOxyTrimBank1(Float value) {
        this.longSecOxyTrimBank1 = value;
    }

    public Float getLongSecOxyTrimBank3() {
        return this.longSecOxyTrimBank3;
    }

    public void setLongSecOxyTrimBank3(Float value) {
        this.longSecOxyTrimBank3 = value;
    }

    public Float getShortSecOxyTrimBank2() {
        return this.shortSecOxyTrimBank2;
    }

    public void setShortSecOxyTrimBank2(Float value) {
        this.shortSecOxyTrimBank2 = value;
    }

    public Float getShortSecOxyTrimBank4() {
        return this.shortSecOxyTrimBank4;
    }

    public void setShortSecOxyTrimBank4(Float value) {
        this.shortSecOxyTrimBank4 = value;
    }

    public Float getLongSecOxyTrimBank2() {
        return this.longSecOxyTrimBank2;
    }

    public void setLongSecOxyTrimBank2(Float value) {
        this.longSecOxyTrimBank2 = value;
    }

    public Float getLongSecOxyTrimBank4() {
        return this.longSecOxyTrimBank4;
    }

    public void setLongSecOxyTrimBank4(Float value) {
        this.longSecOxyTrimBank4 = value;
    }

    public Float getFuelRailAbsPres() {
        return this.fuelRailAbsPres;
    }

    public void setFuelRailAbsPres(Float value) {
        this.fuelRailAbsPres = value;
    }

    public Float getRelAccelPedalPos() {
        return this.relAccelPedalPos;
    }

    public void setRelAccelPedalPos(Float value) {
        this.relAccelPedalPos = value;
    }

    public Float getHybrBatPackRemLife() {
        return this.hybrBatPackRemLife;
    }

    public void setHybrBatPackRemLife(Float value) {
        this.hybrBatPackRemLife = value;
    }

    public Float getEngineOilTemp() {
        return this.engineOilTemp;
    }

    public void setEngineOilTemp(Float value) {
        this.engineOilTemp = value;
    }

    public Float getFuelInjectionTiming() {
        return this.fuelInjectionTiming;
    }

    public void setFuelInjectionTiming(Float value) {
        this.fuelInjectionTiming = value;
    }

    public Float getEngineFuelRate() {
        return this.engineFuelRate;
    }

    public void setEngineFuelRate(Float value) {
        this.engineFuelRate = value;
    }

    public Float getEmissionReq() {
        return this.emissionReq;
    }

    public void setEmissionReq(Float value) {
        this.emissionReq = value;
    }

    public Float getDemandEngTorqPct() {
        return this.demandEngTorqPct;
    }

    public void setDemandEngTorqPct(Float value) {
        this.demandEngTorqPct = value;
    }

    public Float getActualEngTorqPct() {
        return this.actualEngTorqPct;
    }

    public void setActualEngTorqPct(Float value) {
        this.actualEngTorqPct = value;
    }

    public Float getEngRefTorq() {
        return this.engRefTorq;
    }

    public void setEngRefTorq(Float value) {
        this.engRefTorq = value;
    }

    public Float getEngPctTorqIdle() {
        return this.engPctTorqIdle;
    }

    public void setEngPctTorqIdle(Float value) {
        this.engPctTorqIdle = value;
    }

    public Float getEngPctTorqEp1() {
        return this.engPctTorqEp1;
    }

    public void setEngPctTorqEp1(Float value) {
        this.engPctTorqEp1 = value;
    }

    public Float getEngPctTorqEp2() {
        return this.engPctTorqEp2;
    }

    public void setEngPctTorqEp2(Float value) {
        this.engPctTorqEp2 = value;
    }

    public Float getEngPctTorqEp3() {
        return this.engPctTorqEp3;
    }

    public void setEngPctTorqEp3(Float value) {
        this.engPctTorqEp3 = value;
    }

    public Float getEngPctTorqEp4() {
        return this.engPctTorqEp4;
    }

    public void setEngPctTorqEp4(Float value) {
        this.engPctTorqEp4 = value;
    }

    public Float getAuxInputOutput() {
        return this.auxInputOutput;
    }

    public void setAuxInputOutput(Float value) {
        this.auxInputOutput = value;
    }

    public Float getMafSensor() {
        return this.mafSensor;
    }

    public void setMafSensor(Float value) {
        this.mafSensor = value;
    }

    public Float getEngineCoolantTemp67() {
        return this.engineCoolantTemp67;
    }

    public void setEngineCoolantTemp67(Float value) {
        this.engineCoolantTemp67 = value;
    }

    public Float getIntakeAirTempSens() {
        return this.intakeAirTempSens;
    }

    public void setIntakeAirTempSens(Float value) {
        this.intakeAirTempSens = value;
    }

    public Float getEngineFrictionPercentTorque() {
        return this.engineFrictionPercentTorque;
    }

    public void setEngineFrictionPercentTorque(Float value) {
        this.engineFrictionPercentTorque = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(CanEdgeObd2 other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.fuelSystemStatus == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelSystemStatus.floatValue());
        }
        if (this.calcEngineLoad == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.calcEngineLoad.floatValue());
        }
        if (this.engineCoolantTemp == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engineCoolantTemp.floatValue());
        }
        if (this.shortFuelTrimBank1 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.shortFuelTrimBank1.floatValue());
        }
        if (this.longFuelTrimBank1 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.longFuelTrimBank1.floatValue());
        }
        if (this.shortFuelTrimBank2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.shortFuelTrimBank2.floatValue());
        }
        if (this.longFuelTrimBank2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.longFuelTrimBank2.floatValue());
        }
        if (this.fuelPressure == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelPressure.floatValue());
        }
        if (this.intakeManiAbsPress == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.intakeManiAbsPress.floatValue());
        }
        if (this.engineRpm == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engineRpm.floatValue());
        }
        if (this.vehicleSpeed == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.vehicleSpeed.floatValue());
        }
        if (this.timingAdvance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.timingAdvance.floatValue());
        }
        if (this.intakeAirTemperature == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.intakeAirTemperature.floatValue());
        }
        if (this.mafAirFlowRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.mafAirFlowRate.floatValue());
        }
        if (this.throttlePosition == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.throttlePosition.floatValue());
        }
        if (this.cmdSecAirStatus == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.cmdSecAirStatus.floatValue());
        }
        if (this.oxySensor1Volt14 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor1Volt14.floatValue());
        }
        if (this.oxySensor1Stft == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor1Stft.floatValue());
        }
        if (this.oxySensor2Volt14 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor2Volt14.floatValue());
        }
        if (this.oxySensor2Stft == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor2Stft.floatValue());
        }
        if (this.oxySensor3Volt14 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor3Volt14.floatValue());
        }
        if (this.oxySensor3Stft == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor3Stft.floatValue());
        }
        if (this.oxySensor4Volt14 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor4Volt14.floatValue());
        }
        if (this.oxySensor4Stft == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor4Stft.floatValue());
        }
        if (this.oxySensor5Volt14 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor5Volt14.floatValue());
        }
        if (this.oxySensor5Stft == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor5Stft.floatValue());
        }
        if (this.oxySensor6Volt14 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor6Volt14.floatValue());
        }
        if (this.oxySensor6Stft == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor6Stft.floatValue());
        }
        if (this.oxySensor7Volt14 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor7Volt14.floatValue());
        }
        if (this.oxySensor7Stft == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor7Stft.floatValue());
        }
        if (this.oxySensor8Volt14 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor8Volt14.floatValue());
        }
        if (this.oxySensor8Stft == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor8Stft.floatValue());
        }
        if (this.timeSinceEngStart == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.timeSinceEngStart.floatValue());
        }
        if (this.distanceMilOn == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.distanceMilOn.floatValue());
        }
        if (this.fuelRailPres == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelRailPres.floatValue());
        }
        if (this.fuelRailGaug == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelRailGaug.floatValue());
        }
        if (this.oxySensor1Faer24 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor1Faer24.floatValue());
        }
        if (this.oxySensor1Volt24 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor1Volt24.floatValue());
        }
        if (this.oxySensor2Faer25 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor2Faer25.floatValue());
        }
        if (this.oxySensor2Volt25 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor2Volt25.floatValue());
        }
        if (this.oxySensor3Faer26 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor3Faer26.floatValue());
        }
        if (this.oxySensor3Volt26 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor3Volt26.floatValue());
        }
        if (this.oxySensor4Faer27 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor4Faer27.floatValue());
        }
        if (this.oxySensor4Volt27 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor4Volt27.floatValue());
        }
        if (this.oxySensor5Faer28 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor5Faer28.floatValue());
        }
        if (this.oxySensor5Volt28 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor5Volt28.floatValue());
        }
        if (this.oxySensor6Faer29 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor6Faer29.floatValue());
        }
        if (this.oxySensor6Volt29 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor6Volt29.floatValue());
        }
        if (this.oxySensor7Faer2A == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor7Faer2A.floatValue());
        }
        if (this.oxySensor7Volt2A == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor7Volt2A.floatValue());
        }
        if (this.oxySensor8Faer2B == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor8Faer2B.floatValue());
        }
        if (this.oxySensor8Volt2B == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor8Volt2B.floatValue());
        }
        if (this.cmdEgr == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.cmdEgr.floatValue());
        }
        if (this.egrError == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.egrError.floatValue());
        }
        if (this.cmdEvapPurge == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.cmdEvapPurge.floatValue());
        }
        if (this.fuelTankLevel == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelTankLevel.floatValue());
        }
        if (this.warmUpsSinceCodeClear == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.warmUpsSinceCodeClear.floatValue());
        }
        if (this.distanceSinceCodeClear == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.distanceSinceCodeClear.floatValue());
        }
        if (this.evapSysVaporPres == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.evapSysVaporPres.floatValue());
        }
        if (this.absBaroPres == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.absBaroPres.floatValue());
        }
        if (this.oxySensor1Faer34 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor1Faer34.floatValue());
        }
        if (this.oxySensor1Crnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor1Crnt.floatValue());
        }
        if (this.oxySensor2Faer35 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor2Faer35.floatValue());
        }
        if (this.oxySensor2Crnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor2Crnt.floatValue());
        }
        if (this.oxySensor3Faer36 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor3Faer36.floatValue());
        }
        if (this.oxySensor3Crnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor3Crnt.floatValue());
        }
        if (this.oxySensor4Faer37 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor4Faer37.floatValue());
        }
        if (this.oxySensor4Crnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor4Crnt.floatValue());
        }
        if (this.oxySensor5Faer38 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor5Faer38.floatValue());
        }
        if (this.oxySensor5Crnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor5Crnt.floatValue());
        }
        if (this.oxySensor6Faer39 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor6Faer39.floatValue());
        }
        if (this.oxySensor6Crnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor6Crnt.floatValue());
        }
        if (this.oxySensor7Faer3A == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor7Faer3A.floatValue());
        }
        if (this.oxySensor7Crnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor7Crnt.floatValue());
        }
        if (this.oxySensor8Faer3B == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor8Faer3B.floatValue());
        }
        if (this.oxySensor8Crnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.oxySensor8Crnt.floatValue());
        }
        if (this.catTempBank1Sens1 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.catTempBank1Sens1.floatValue());
        }
        if (this.catTempBank2Sens1 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.catTempBank2Sens1.floatValue());
        }
        if (this.catTempBank1Sens2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.catTempBank1Sens2.floatValue());
        }
        if (this.catTempBank2Sens2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.catTempBank2Sens2.floatValue());
        }
        if (this.monStatusDriveCycle == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.monStatusDriveCycle.floatValue());
        }
        if (this.controlModuleVolt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.controlModuleVolt.floatValue());
        }
        if (this.absLoadValue == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.absLoadValue.floatValue());
        }
        if (this.fuelAirCmdEquiv == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelAirCmdEquiv.floatValue());
        }
        if (this.relThrottlePos == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.relThrottlePos.floatValue());
        }
        if (this.ambientAirTemp == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.ambientAirTemp.floatValue());
        }
        if (this.absThrottlePosB == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.absThrottlePosB.floatValue());
        }
        if (this.absThrottlePosC == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.absThrottlePosC.floatValue());
        }
        if (this.absThrottlePosCd == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.absThrottlePosCd.floatValue());
        }
        if (this.absThrottlePosE == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.absThrottlePosE.floatValue());
        }
        if (this.absThrottlePosF == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.absThrottlePosF.floatValue());
        }
        if (this.cmdThrottleAct == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.cmdThrottleAct.floatValue());
        }
        if (this.timeRunMilOn == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.timeRunMilOn.floatValue());
        }
        if (this.timeSinceCodeClear == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.timeSinceCodeClear.floatValue());
        }
        if (this.maxFaer == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxFaer.floatValue());
        }
        if (this.maxOxySensVol == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxOxySensVol.floatValue());
        }
        if (this.maxOxySensCrnt == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxOxySensCrnt.floatValue());
        }
        if (this.maxIntManiAbsPres == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxIntManiAbsPres.floatValue());
        }
        if (this.maxAirFlowMaf == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.maxAirFlowMaf.floatValue());
        }
        if (this.fuelType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelType.floatValue());
        }
        if (this.ethanolFuelPct == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.ethanolFuelPct.floatValue());
        }
        if (this.absEvapSysVapPres == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.absEvapSysVapPres.floatValue());
        }
        if (this.evapSysVapPres == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.evapSysVapPres.floatValue());
        }
        if (this.shortSecOxyTrimBank1 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.shortSecOxyTrimBank1.floatValue());
        }
        if (this.shortSecOxyTrimBank3 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.shortSecOxyTrimBank3.floatValue());
        }
        if (this.longSecOxyTrimBank1 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.longSecOxyTrimBank1.floatValue());
        }
        if (this.longSecOxyTrimBank3 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.longSecOxyTrimBank3.floatValue());
        }
        if (this.shortSecOxyTrimBank2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.shortSecOxyTrimBank2.floatValue());
        }
        if (this.shortSecOxyTrimBank4 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.shortSecOxyTrimBank4.floatValue());
        }
        if (this.longSecOxyTrimBank2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.longSecOxyTrimBank2.floatValue());
        }
        if (this.longSecOxyTrimBank4 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.longSecOxyTrimBank4.floatValue());
        }
        if (this.fuelRailAbsPres == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelRailAbsPres.floatValue());
        }
        if (this.relAccelPedalPos == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.relAccelPedalPos.floatValue());
        }
        if (this.hybrBatPackRemLife == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.hybrBatPackRemLife.floatValue());
        }
        if (this.engineOilTemp == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engineOilTemp.floatValue());
        }
        if (this.fuelInjectionTiming == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.fuelInjectionTiming.floatValue());
        }
        if (this.engineFuelRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engineFuelRate.floatValue());
        }
        if (this.emissionReq == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.emissionReq.floatValue());
        }
        if (this.demandEngTorqPct == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.demandEngTorqPct.floatValue());
        }
        if (this.actualEngTorqPct == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.actualEngTorqPct.floatValue());
        }
        if (this.engRefTorq == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engRefTorq.floatValue());
        }
        if (this.engPctTorqIdle == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engPctTorqIdle.floatValue());
        }
        if (this.engPctTorqEp1 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engPctTorqEp1.floatValue());
        }
        if (this.engPctTorqEp2 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engPctTorqEp2.floatValue());
        }
        if (this.engPctTorqEp3 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engPctTorqEp3.floatValue());
        }
        if (this.engPctTorqEp4 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engPctTorqEp4.floatValue());
        }
        if (this.auxInputOutput == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.auxInputOutput.floatValue());
        }
        if (this.mafSensor == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.mafSensor.floatValue());
        }
        if (this.engineCoolantTemp67 == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engineCoolantTemp67.floatValue());
        }
        if (this.intakeAirTempSens == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.intakeAirTempSens.floatValue());
        }
        if (this.engineFrictionPercentTorque == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.engineFrictionPercentTorque.floatValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelSystemStatus = null;
            } else {
                this.fuelSystemStatus = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.calcEngineLoad = null;
            } else {
                this.calcEngineLoad = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engineCoolantTemp = null;
            } else {
                this.engineCoolantTemp = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.shortFuelTrimBank1 = null;
            } else {
                this.shortFuelTrimBank1 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.longFuelTrimBank1 = null;
            } else {
                this.longFuelTrimBank1 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.shortFuelTrimBank2 = null;
            } else {
                this.shortFuelTrimBank2 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.longFuelTrimBank2 = null;
            } else {
                this.longFuelTrimBank2 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelPressure = null;
            } else {
                this.fuelPressure = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.intakeManiAbsPress = null;
            } else {
                this.intakeManiAbsPress = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engineRpm = null;
            } else {
                this.engineRpm = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.vehicleSpeed = null;
            } else {
                this.vehicleSpeed = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.timingAdvance = null;
            } else {
                this.timingAdvance = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.intakeAirTemperature = null;
            } else {
                this.intakeAirTemperature = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.mafAirFlowRate = null;
            } else {
                this.mafAirFlowRate = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.throttlePosition = null;
            } else {
                this.throttlePosition = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.cmdSecAirStatus = null;
            } else {
                this.cmdSecAirStatus = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor1Volt14 = null;
            } else {
                this.oxySensor1Volt14 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor1Stft = null;
            } else {
                this.oxySensor1Stft = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor2Volt14 = null;
            } else {
                this.oxySensor2Volt14 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor2Stft = null;
            } else {
                this.oxySensor2Stft = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor3Volt14 = null;
            } else {
                this.oxySensor3Volt14 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor3Stft = null;
            } else {
                this.oxySensor3Stft = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor4Volt14 = null;
            } else {
                this.oxySensor4Volt14 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor4Stft = null;
            } else {
                this.oxySensor4Stft = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor5Volt14 = null;
            } else {
                this.oxySensor5Volt14 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor5Stft = null;
            } else {
                this.oxySensor5Stft = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor6Volt14 = null;
            } else {
                this.oxySensor6Volt14 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor6Stft = null;
            } else {
                this.oxySensor6Stft = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor7Volt14 = null;
            } else {
                this.oxySensor7Volt14 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor7Stft = null;
            } else {
                this.oxySensor7Stft = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor8Volt14 = null;
            } else {
                this.oxySensor8Volt14 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor8Stft = null;
            } else {
                this.oxySensor8Stft = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.timeSinceEngStart = null;
            } else {
                this.timeSinceEngStart = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.distanceMilOn = null;
            } else {
                this.distanceMilOn = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelRailPres = null;
            } else {
                this.fuelRailPres = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelRailGaug = null;
            } else {
                this.fuelRailGaug = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor1Faer24 = null;
            } else {
                this.oxySensor1Faer24 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor1Volt24 = null;
            } else {
                this.oxySensor1Volt24 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor2Faer25 = null;
            } else {
                this.oxySensor2Faer25 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor2Volt25 = null;
            } else {
                this.oxySensor2Volt25 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor3Faer26 = null;
            } else {
                this.oxySensor3Faer26 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor3Volt26 = null;
            } else {
                this.oxySensor3Volt26 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor4Faer27 = null;
            } else {
                this.oxySensor4Faer27 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor4Volt27 = null;
            } else {
                this.oxySensor4Volt27 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor5Faer28 = null;
            } else {
                this.oxySensor5Faer28 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor5Volt28 = null;
            } else {
                this.oxySensor5Volt28 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor6Faer29 = null;
            } else {
                this.oxySensor6Faer29 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor6Volt29 = null;
            } else {
                this.oxySensor6Volt29 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor7Faer2A = null;
            } else {
                this.oxySensor7Faer2A = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor7Volt2A = null;
            } else {
                this.oxySensor7Volt2A = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor8Faer2B = null;
            } else {
                this.oxySensor8Faer2B = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor8Volt2B = null;
            } else {
                this.oxySensor8Volt2B = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.cmdEgr = null;
            } else {
                this.cmdEgr = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.egrError = null;
            } else {
                this.egrError = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.cmdEvapPurge = null;
            } else {
                this.cmdEvapPurge = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelTankLevel = null;
            } else {
                this.fuelTankLevel = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.warmUpsSinceCodeClear = null;
            } else {
                this.warmUpsSinceCodeClear = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.distanceSinceCodeClear = null;
            } else {
                this.distanceSinceCodeClear = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.evapSysVaporPres = null;
            } else {
                this.evapSysVaporPres = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.absBaroPres = null;
            } else {
                this.absBaroPres = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor1Faer34 = null;
            } else {
                this.oxySensor1Faer34 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor1Crnt = null;
            } else {
                this.oxySensor1Crnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor2Faer35 = null;
            } else {
                this.oxySensor2Faer35 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor2Crnt = null;
            } else {
                this.oxySensor2Crnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor3Faer36 = null;
            } else {
                this.oxySensor3Faer36 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor3Crnt = null;
            } else {
                this.oxySensor3Crnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor4Faer37 = null;
            } else {
                this.oxySensor4Faer37 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor4Crnt = null;
            } else {
                this.oxySensor4Crnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor5Faer38 = null;
            } else {
                this.oxySensor5Faer38 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor5Crnt = null;
            } else {
                this.oxySensor5Crnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor6Faer39 = null;
            } else {
                this.oxySensor6Faer39 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor6Crnt = null;
            } else {
                this.oxySensor6Crnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor7Faer3A = null;
            } else {
                this.oxySensor7Faer3A = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor7Crnt = null;
            } else {
                this.oxySensor7Crnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor8Faer3B = null;
            } else {
                this.oxySensor8Faer3B = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.oxySensor8Crnt = null;
            } else {
                this.oxySensor8Crnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.catTempBank1Sens1 = null;
            } else {
                this.catTempBank1Sens1 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.catTempBank2Sens1 = null;
            } else {
                this.catTempBank2Sens1 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.catTempBank1Sens2 = null;
            } else {
                this.catTempBank1Sens2 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.catTempBank2Sens2 = null;
            } else {
                this.catTempBank2Sens2 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.monStatusDriveCycle = null;
            } else {
                this.monStatusDriveCycle = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.controlModuleVolt = null;
            } else {
                this.controlModuleVolt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.absLoadValue = null;
            } else {
                this.absLoadValue = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelAirCmdEquiv = null;
            } else {
                this.fuelAirCmdEquiv = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.relThrottlePos = null;
            } else {
                this.relThrottlePos = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.ambientAirTemp = null;
            } else {
                this.ambientAirTemp = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.absThrottlePosB = null;
            } else {
                this.absThrottlePosB = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.absThrottlePosC = null;
            } else {
                this.absThrottlePosC = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.absThrottlePosCd = null;
            } else {
                this.absThrottlePosCd = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.absThrottlePosE = null;
            } else {
                this.absThrottlePosE = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.absThrottlePosF = null;
            } else {
                this.absThrottlePosF = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.cmdThrottleAct = null;
            } else {
                this.cmdThrottleAct = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.timeRunMilOn = null;
            } else {
                this.timeRunMilOn = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.timeSinceCodeClear = null;
            } else {
                this.timeSinceCodeClear = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxFaer = null;
            } else {
                this.maxFaer = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxOxySensVol = null;
            } else {
                this.maxOxySensVol = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxOxySensCrnt = null;
            } else {
                this.maxOxySensCrnt = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxIntManiAbsPres = null;
            } else {
                this.maxIntManiAbsPres = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxAirFlowMaf = null;
            } else {
                this.maxAirFlowMaf = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelType = null;
            } else {
                this.fuelType = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.ethanolFuelPct = null;
            } else {
                this.ethanolFuelPct = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.absEvapSysVapPres = null;
            } else {
                this.absEvapSysVapPres = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.evapSysVapPres = null;
            } else {
                this.evapSysVapPres = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.shortSecOxyTrimBank1 = null;
            } else {
                this.shortSecOxyTrimBank1 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.shortSecOxyTrimBank3 = null;
            } else {
                this.shortSecOxyTrimBank3 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.longSecOxyTrimBank1 = null;
            } else {
                this.longSecOxyTrimBank1 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.longSecOxyTrimBank3 = null;
            } else {
                this.longSecOxyTrimBank3 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.shortSecOxyTrimBank2 = null;
            } else {
                this.shortSecOxyTrimBank2 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.shortSecOxyTrimBank4 = null;
            } else {
                this.shortSecOxyTrimBank4 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.longSecOxyTrimBank2 = null;
            } else {
                this.longSecOxyTrimBank2 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.longSecOxyTrimBank4 = null;
            } else {
                this.longSecOxyTrimBank4 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelRailAbsPres = null;
            } else {
                this.fuelRailAbsPres = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.relAccelPedalPos = null;
            } else {
                this.relAccelPedalPos = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.hybrBatPackRemLife = null;
            } else {
                this.hybrBatPackRemLife = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engineOilTemp = null;
            } else {
                this.engineOilTemp = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fuelInjectionTiming = null;
            } else {
                this.fuelInjectionTiming = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engineFuelRate = null;
            } else {
                this.engineFuelRate = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.emissionReq = null;
            } else {
                this.emissionReq = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.demandEngTorqPct = null;
            } else {
                this.demandEngTorqPct = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.actualEngTorqPct = null;
            } else {
                this.actualEngTorqPct = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engRefTorq = null;
            } else {
                this.engRefTorq = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engPctTorqIdle = null;
            } else {
                this.engPctTorqIdle = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engPctTorqEp1 = null;
            } else {
                this.engPctTorqEp1 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engPctTorqEp2 = null;
            } else {
                this.engPctTorqEp2 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engPctTorqEp3 = null;
            } else {
                this.engPctTorqEp3 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engPctTorqEp4 = null;
            } else {
                this.engPctTorqEp4 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.auxInputOutput = null;
            } else {
                this.auxInputOutput = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.mafSensor = null;
            } else {
                this.mafSensor = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engineCoolantTemp67 = null;
            } else {
                this.engineCoolantTemp67 = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.intakeAirTempSens = null;
            } else {
                this.intakeAirTempSens = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.engineFrictionPercentTorque = null;
            } else {
                this.engineFrictionPercentTorque = Float.valueOf(in.readFloat());
            }
        } else {
            block135: for (int i = 0; i < 133; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block135;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block135;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelSystemStatus = null;
                            continue block135;
                        }
                        this.fuelSystemStatus = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.calcEngineLoad = null;
                            continue block135;
                        }
                        this.calcEngineLoad = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engineCoolantTemp = null;
                            continue block135;
                        }
                        this.engineCoolantTemp = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.shortFuelTrimBank1 = null;
                            continue block135;
                        }
                        this.shortFuelTrimBank1 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.longFuelTrimBank1 = null;
                            continue block135;
                        }
                        this.longFuelTrimBank1 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.shortFuelTrimBank2 = null;
                            continue block135;
                        }
                        this.shortFuelTrimBank2 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.longFuelTrimBank2 = null;
                            continue block135;
                        }
                        this.longFuelTrimBank2 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelPressure = null;
                            continue block135;
                        }
                        this.fuelPressure = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.intakeManiAbsPress = null;
                            continue block135;
                        }
                        this.intakeManiAbsPress = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engineRpm = null;
                            continue block135;
                        }
                        this.engineRpm = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.vehicleSpeed = null;
                            continue block135;
                        }
                        this.vehicleSpeed = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.timingAdvance = null;
                            continue block135;
                        }
                        this.timingAdvance = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.intakeAirTemperature = null;
                            continue block135;
                        }
                        this.intakeAirTemperature = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.mafAirFlowRate = null;
                            continue block135;
                        }
                        this.mafAirFlowRate = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.throttlePosition = null;
                            continue block135;
                        }
                        this.throttlePosition = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 17: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.cmdSecAirStatus = null;
                            continue block135;
                        }
                        this.cmdSecAirStatus = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 18: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor1Volt14 = null;
                            continue block135;
                        }
                        this.oxySensor1Volt14 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 19: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor1Stft = null;
                            continue block135;
                        }
                        this.oxySensor1Stft = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 20: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor2Volt14 = null;
                            continue block135;
                        }
                        this.oxySensor2Volt14 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 21: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor2Stft = null;
                            continue block135;
                        }
                        this.oxySensor2Stft = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 22: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor3Volt14 = null;
                            continue block135;
                        }
                        this.oxySensor3Volt14 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 23: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor3Stft = null;
                            continue block135;
                        }
                        this.oxySensor3Stft = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 24: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor4Volt14 = null;
                            continue block135;
                        }
                        this.oxySensor4Volt14 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 25: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor4Stft = null;
                            continue block135;
                        }
                        this.oxySensor4Stft = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 26: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor5Volt14 = null;
                            continue block135;
                        }
                        this.oxySensor5Volt14 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 27: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor5Stft = null;
                            continue block135;
                        }
                        this.oxySensor5Stft = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 28: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor6Volt14 = null;
                            continue block135;
                        }
                        this.oxySensor6Volt14 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 29: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor6Stft = null;
                            continue block135;
                        }
                        this.oxySensor6Stft = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 30: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor7Volt14 = null;
                            continue block135;
                        }
                        this.oxySensor7Volt14 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 31: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor7Stft = null;
                            continue block135;
                        }
                        this.oxySensor7Stft = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 32: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor8Volt14 = null;
                            continue block135;
                        }
                        this.oxySensor8Volt14 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 33: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor8Stft = null;
                            continue block135;
                        }
                        this.oxySensor8Stft = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 34: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.timeSinceEngStart = null;
                            continue block135;
                        }
                        this.timeSinceEngStart = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 35: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.distanceMilOn = null;
                            continue block135;
                        }
                        this.distanceMilOn = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 36: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelRailPres = null;
                            continue block135;
                        }
                        this.fuelRailPres = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 37: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelRailGaug = null;
                            continue block135;
                        }
                        this.fuelRailGaug = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 38: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor1Faer24 = null;
                            continue block135;
                        }
                        this.oxySensor1Faer24 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 39: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor1Volt24 = null;
                            continue block135;
                        }
                        this.oxySensor1Volt24 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 40: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor2Faer25 = null;
                            continue block135;
                        }
                        this.oxySensor2Faer25 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 41: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor2Volt25 = null;
                            continue block135;
                        }
                        this.oxySensor2Volt25 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 42: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor3Faer26 = null;
                            continue block135;
                        }
                        this.oxySensor3Faer26 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 43: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor3Volt26 = null;
                            continue block135;
                        }
                        this.oxySensor3Volt26 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 44: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor4Faer27 = null;
                            continue block135;
                        }
                        this.oxySensor4Faer27 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 45: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor4Volt27 = null;
                            continue block135;
                        }
                        this.oxySensor4Volt27 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 46: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor5Faer28 = null;
                            continue block135;
                        }
                        this.oxySensor5Faer28 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 47: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor5Volt28 = null;
                            continue block135;
                        }
                        this.oxySensor5Volt28 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 48: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor6Faer29 = null;
                            continue block135;
                        }
                        this.oxySensor6Faer29 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 49: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor6Volt29 = null;
                            continue block135;
                        }
                        this.oxySensor6Volt29 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 50: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor7Faer2A = null;
                            continue block135;
                        }
                        this.oxySensor7Faer2A = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 51: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor7Volt2A = null;
                            continue block135;
                        }
                        this.oxySensor7Volt2A = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 52: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor8Faer2B = null;
                            continue block135;
                        }
                        this.oxySensor8Faer2B = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 53: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor8Volt2B = null;
                            continue block135;
                        }
                        this.oxySensor8Volt2B = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 54: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.cmdEgr = null;
                            continue block135;
                        }
                        this.cmdEgr = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 55: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.egrError = null;
                            continue block135;
                        }
                        this.egrError = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 56: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.cmdEvapPurge = null;
                            continue block135;
                        }
                        this.cmdEvapPurge = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 57: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelTankLevel = null;
                            continue block135;
                        }
                        this.fuelTankLevel = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 58: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.warmUpsSinceCodeClear = null;
                            continue block135;
                        }
                        this.warmUpsSinceCodeClear = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 59: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.distanceSinceCodeClear = null;
                            continue block135;
                        }
                        this.distanceSinceCodeClear = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 60: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.evapSysVaporPres = null;
                            continue block135;
                        }
                        this.evapSysVaporPres = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 61: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.absBaroPres = null;
                            continue block135;
                        }
                        this.absBaroPres = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 62: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor1Faer34 = null;
                            continue block135;
                        }
                        this.oxySensor1Faer34 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 63: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor1Crnt = null;
                            continue block135;
                        }
                        this.oxySensor1Crnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 64: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor2Faer35 = null;
                            continue block135;
                        }
                        this.oxySensor2Faer35 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 65: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor2Crnt = null;
                            continue block135;
                        }
                        this.oxySensor2Crnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 66: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor3Faer36 = null;
                            continue block135;
                        }
                        this.oxySensor3Faer36 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 67: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor3Crnt = null;
                            continue block135;
                        }
                        this.oxySensor3Crnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 68: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor4Faer37 = null;
                            continue block135;
                        }
                        this.oxySensor4Faer37 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 69: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor4Crnt = null;
                            continue block135;
                        }
                        this.oxySensor4Crnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 70: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor5Faer38 = null;
                            continue block135;
                        }
                        this.oxySensor5Faer38 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 71: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor5Crnt = null;
                            continue block135;
                        }
                        this.oxySensor5Crnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 72: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor6Faer39 = null;
                            continue block135;
                        }
                        this.oxySensor6Faer39 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 73: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor6Crnt = null;
                            continue block135;
                        }
                        this.oxySensor6Crnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 74: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor7Faer3A = null;
                            continue block135;
                        }
                        this.oxySensor7Faer3A = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 75: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor7Crnt = null;
                            continue block135;
                        }
                        this.oxySensor7Crnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 76: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor8Faer3B = null;
                            continue block135;
                        }
                        this.oxySensor8Faer3B = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 77: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.oxySensor8Crnt = null;
                            continue block135;
                        }
                        this.oxySensor8Crnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 78: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.catTempBank1Sens1 = null;
                            continue block135;
                        }
                        this.catTempBank1Sens1 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 79: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.catTempBank2Sens1 = null;
                            continue block135;
                        }
                        this.catTempBank2Sens1 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 80: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.catTempBank1Sens2 = null;
                            continue block135;
                        }
                        this.catTempBank1Sens2 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 81: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.catTempBank2Sens2 = null;
                            continue block135;
                        }
                        this.catTempBank2Sens2 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 82: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.monStatusDriveCycle = null;
                            continue block135;
                        }
                        this.monStatusDriveCycle = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 83: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.controlModuleVolt = null;
                            continue block135;
                        }
                        this.controlModuleVolt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 84: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.absLoadValue = null;
                            continue block135;
                        }
                        this.absLoadValue = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 85: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelAirCmdEquiv = null;
                            continue block135;
                        }
                        this.fuelAirCmdEquiv = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 86: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.relThrottlePos = null;
                            continue block135;
                        }
                        this.relThrottlePos = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 87: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.ambientAirTemp = null;
                            continue block135;
                        }
                        this.ambientAirTemp = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 88: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.absThrottlePosB = null;
                            continue block135;
                        }
                        this.absThrottlePosB = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 89: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.absThrottlePosC = null;
                            continue block135;
                        }
                        this.absThrottlePosC = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 90: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.absThrottlePosCd = null;
                            continue block135;
                        }
                        this.absThrottlePosCd = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 91: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.absThrottlePosE = null;
                            continue block135;
                        }
                        this.absThrottlePosE = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 92: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.absThrottlePosF = null;
                            continue block135;
                        }
                        this.absThrottlePosF = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 93: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.cmdThrottleAct = null;
                            continue block135;
                        }
                        this.cmdThrottleAct = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 94: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.timeRunMilOn = null;
                            continue block135;
                        }
                        this.timeRunMilOn = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 95: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.timeSinceCodeClear = null;
                            continue block135;
                        }
                        this.timeSinceCodeClear = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 96: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxFaer = null;
                            continue block135;
                        }
                        this.maxFaer = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 97: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxOxySensVol = null;
                            continue block135;
                        }
                        this.maxOxySensVol = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 98: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxOxySensCrnt = null;
                            continue block135;
                        }
                        this.maxOxySensCrnt = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 99: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxIntManiAbsPres = null;
                            continue block135;
                        }
                        this.maxIntManiAbsPres = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 100: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxAirFlowMaf = null;
                            continue block135;
                        }
                        this.maxAirFlowMaf = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 101: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelType = null;
                            continue block135;
                        }
                        this.fuelType = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 102: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.ethanolFuelPct = null;
                            continue block135;
                        }
                        this.ethanolFuelPct = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 103: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.absEvapSysVapPres = null;
                            continue block135;
                        }
                        this.absEvapSysVapPres = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 104: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.evapSysVapPres = null;
                            continue block135;
                        }
                        this.evapSysVapPres = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 105: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.shortSecOxyTrimBank1 = null;
                            continue block135;
                        }
                        this.shortSecOxyTrimBank1 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 106: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.shortSecOxyTrimBank3 = null;
                            continue block135;
                        }
                        this.shortSecOxyTrimBank3 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 107: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.longSecOxyTrimBank1 = null;
                            continue block135;
                        }
                        this.longSecOxyTrimBank1 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 108: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.longSecOxyTrimBank3 = null;
                            continue block135;
                        }
                        this.longSecOxyTrimBank3 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 109: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.shortSecOxyTrimBank2 = null;
                            continue block135;
                        }
                        this.shortSecOxyTrimBank2 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 110: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.shortSecOxyTrimBank4 = null;
                            continue block135;
                        }
                        this.shortSecOxyTrimBank4 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 111: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.longSecOxyTrimBank2 = null;
                            continue block135;
                        }
                        this.longSecOxyTrimBank2 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 112: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.longSecOxyTrimBank4 = null;
                            continue block135;
                        }
                        this.longSecOxyTrimBank4 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 113: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelRailAbsPres = null;
                            continue block135;
                        }
                        this.fuelRailAbsPres = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 114: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.relAccelPedalPos = null;
                            continue block135;
                        }
                        this.relAccelPedalPos = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 115: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.hybrBatPackRemLife = null;
                            continue block135;
                        }
                        this.hybrBatPackRemLife = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 116: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engineOilTemp = null;
                            continue block135;
                        }
                        this.engineOilTemp = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 117: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fuelInjectionTiming = null;
                            continue block135;
                        }
                        this.fuelInjectionTiming = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 118: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engineFuelRate = null;
                            continue block135;
                        }
                        this.engineFuelRate = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 119: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.emissionReq = null;
                            continue block135;
                        }
                        this.emissionReq = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 120: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.demandEngTorqPct = null;
                            continue block135;
                        }
                        this.demandEngTorqPct = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 121: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.actualEngTorqPct = null;
                            continue block135;
                        }
                        this.actualEngTorqPct = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 122: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engRefTorq = null;
                            continue block135;
                        }
                        this.engRefTorq = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 123: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engPctTorqIdle = null;
                            continue block135;
                        }
                        this.engPctTorqIdle = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 124: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engPctTorqEp1 = null;
                            continue block135;
                        }
                        this.engPctTorqEp1 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 125: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engPctTorqEp2 = null;
                            continue block135;
                        }
                        this.engPctTorqEp2 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 126: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engPctTorqEp3 = null;
                            continue block135;
                        }
                        this.engPctTorqEp3 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 127: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engPctTorqEp4 = null;
                            continue block135;
                        }
                        this.engPctTorqEp4 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 128: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.auxInputOutput = null;
                            continue block135;
                        }
                        this.auxInputOutput = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 129: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.mafSensor = null;
                            continue block135;
                        }
                        this.mafSensor = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 130: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engineCoolantTemp67 = null;
                            continue block135;
                        }
                        this.engineCoolantTemp67 = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 131: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.intakeAirTempSens = null;
                            continue block135;
                        }
                        this.intakeAirTempSens = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    case 132: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.engineFrictionPercentTorque = null;
                            continue block135;
                        }
                        this.engineFrictionPercentTorque = Float.valueOf(in.readFloat());
                        continue block135;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<CanEdgeObd2>
    implements RecordBuilder<CanEdgeObd2> {
        private double time;
        private double timeReceived;
        private Float fuelSystemStatus;
        private Float calcEngineLoad;
        private Float engineCoolantTemp;
        private Float shortFuelTrimBank1;
        private Float longFuelTrimBank1;
        private Float shortFuelTrimBank2;
        private Float longFuelTrimBank2;
        private Float fuelPressure;
        private Float intakeManiAbsPress;
        private Float engineRpm;
        private Float vehicleSpeed;
        private Float timingAdvance;
        private Float intakeAirTemperature;
        private Float mafAirFlowRate;
        private Float throttlePosition;
        private Float cmdSecAirStatus;
        private Float oxySensor1Volt14;
        private Float oxySensor1Stft;
        private Float oxySensor2Volt14;
        private Float oxySensor2Stft;
        private Float oxySensor3Volt14;
        private Float oxySensor3Stft;
        private Float oxySensor4Volt14;
        private Float oxySensor4Stft;
        private Float oxySensor5Volt14;
        private Float oxySensor5Stft;
        private Float oxySensor6Volt14;
        private Float oxySensor6Stft;
        private Float oxySensor7Volt14;
        private Float oxySensor7Stft;
        private Float oxySensor8Volt14;
        private Float oxySensor8Stft;
        private Float timeSinceEngStart;
        private Float distanceMilOn;
        private Float fuelRailPres;
        private Float fuelRailGaug;
        private Float oxySensor1Faer24;
        private Float oxySensor1Volt24;
        private Float oxySensor2Faer25;
        private Float oxySensor2Volt25;
        private Float oxySensor3Faer26;
        private Float oxySensor3Volt26;
        private Float oxySensor4Faer27;
        private Float oxySensor4Volt27;
        private Float oxySensor5Faer28;
        private Float oxySensor5Volt28;
        private Float oxySensor6Faer29;
        private Float oxySensor6Volt29;
        private Float oxySensor7Faer2A;
        private Float oxySensor7Volt2A;
        private Float oxySensor8Faer2B;
        private Float oxySensor8Volt2B;
        private Float cmdEgr;
        private Float egrError;
        private Float cmdEvapPurge;
        private Float fuelTankLevel;
        private Float warmUpsSinceCodeClear;
        private Float distanceSinceCodeClear;
        private Float evapSysVaporPres;
        private Float absBaroPres;
        private Float oxySensor1Faer34;
        private Float oxySensor1Crnt;
        private Float oxySensor2Faer35;
        private Float oxySensor2Crnt;
        private Float oxySensor3Faer36;
        private Float oxySensor3Crnt;
        private Float oxySensor4Faer37;
        private Float oxySensor4Crnt;
        private Float oxySensor5Faer38;
        private Float oxySensor5Crnt;
        private Float oxySensor6Faer39;
        private Float oxySensor6Crnt;
        private Float oxySensor7Faer3A;
        private Float oxySensor7Crnt;
        private Float oxySensor8Faer3B;
        private Float oxySensor8Crnt;
        private Float catTempBank1Sens1;
        private Float catTempBank2Sens1;
        private Float catTempBank1Sens2;
        private Float catTempBank2Sens2;
        private Float monStatusDriveCycle;
        private Float controlModuleVolt;
        private Float absLoadValue;
        private Float fuelAirCmdEquiv;
        private Float relThrottlePos;
        private Float ambientAirTemp;
        private Float absThrottlePosB;
        private Float absThrottlePosC;
        private Float absThrottlePosCd;
        private Float absThrottlePosE;
        private Float absThrottlePosF;
        private Float cmdThrottleAct;
        private Float timeRunMilOn;
        private Float timeSinceCodeClear;
        private Float maxFaer;
        private Float maxOxySensVol;
        private Float maxOxySensCrnt;
        private Float maxIntManiAbsPres;
        private Float maxAirFlowMaf;
        private Float fuelType;
        private Float ethanolFuelPct;
        private Float absEvapSysVapPres;
        private Float evapSysVapPres;
        private Float shortSecOxyTrimBank1;
        private Float shortSecOxyTrimBank3;
        private Float longSecOxyTrimBank1;
        private Float longSecOxyTrimBank3;
        private Float shortSecOxyTrimBank2;
        private Float shortSecOxyTrimBank4;
        private Float longSecOxyTrimBank2;
        private Float longSecOxyTrimBank4;
        private Float fuelRailAbsPres;
        private Float relAccelPedalPos;
        private Float hybrBatPackRemLife;
        private Float engineOilTemp;
        private Float fuelInjectionTiming;
        private Float engineFuelRate;
        private Float emissionReq;
        private Float demandEngTorqPct;
        private Float actualEngTorqPct;
        private Float engRefTorq;
        private Float engPctTorqIdle;
        private Float engPctTorqEp1;
        private Float engPctTorqEp2;
        private Float engPctTorqEp3;
        private Float engPctTorqEp4;
        private Float auxInputOutput;
        private Float mafSensor;
        private Float engineCoolantTemp67;
        private Float intakeAirTempSens;
        private Float engineFrictionPercentTorque;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.fuelSystemStatus)) {
                this.fuelSystemStatus = (Float)this.data().deepCopy(this.fields()[2].schema(), (Object)other.fuelSystemStatus);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.calcEngineLoad)) {
                this.calcEngineLoad = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.calcEngineLoad);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.engineCoolantTemp)) {
                this.engineCoolantTemp = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.engineCoolantTemp);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.shortFuelTrimBank1)) {
                this.shortFuelTrimBank1 = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.shortFuelTrimBank1);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.longFuelTrimBank1)) {
                this.longFuelTrimBank1 = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.longFuelTrimBank1);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.shortFuelTrimBank2)) {
                this.shortFuelTrimBank2 = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.shortFuelTrimBank2);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.longFuelTrimBank2)) {
                this.longFuelTrimBank2 = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.longFuelTrimBank2);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.fuelPressure)) {
                this.fuelPressure = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.fuelPressure);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.intakeManiAbsPress)) {
                this.intakeManiAbsPress = (Float)this.data().deepCopy(this.fields()[10].schema(), (Object)other.intakeManiAbsPress);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.engineRpm)) {
                this.engineRpm = (Float)this.data().deepCopy(this.fields()[11].schema(), (Object)other.engineRpm);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.vehicleSpeed)) {
                this.vehicleSpeed = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.vehicleSpeed);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.timingAdvance)) {
                this.timingAdvance = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.timingAdvance);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.intakeAirTemperature)) {
                this.intakeAirTemperature = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.intakeAirTemperature);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.mafAirFlowRate)) {
                this.mafAirFlowRate = (Float)this.data().deepCopy(this.fields()[15].schema(), (Object)other.mafAirFlowRate);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.throttlePosition)) {
                this.throttlePosition = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.throttlePosition);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.cmdSecAirStatus)) {
                this.cmdSecAirStatus = (Float)this.data().deepCopy(this.fields()[17].schema(), (Object)other.cmdSecAirStatus);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.oxySensor1Volt14)) {
                this.oxySensor1Volt14 = (Float)this.data().deepCopy(this.fields()[18].schema(), (Object)other.oxySensor1Volt14);
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.oxySensor1Stft)) {
                this.oxySensor1Stft = (Float)this.data().deepCopy(this.fields()[19].schema(), (Object)other.oxySensor1Stft);
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.oxySensor2Volt14)) {
                this.oxySensor2Volt14 = (Float)this.data().deepCopy(this.fields()[20].schema(), (Object)other.oxySensor2Volt14);
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.oxySensor2Stft)) {
                this.oxySensor2Stft = (Float)this.data().deepCopy(this.fields()[21].schema(), (Object)other.oxySensor2Stft);
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.oxySensor3Volt14)) {
                this.oxySensor3Volt14 = (Float)this.data().deepCopy(this.fields()[22].schema(), (Object)other.oxySensor3Volt14);
                this.fieldSetFlags()[22] = other.fieldSetFlags()[22];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.oxySensor3Stft)) {
                this.oxySensor3Stft = (Float)this.data().deepCopy(this.fields()[23].schema(), (Object)other.oxySensor3Stft);
                this.fieldSetFlags()[23] = other.fieldSetFlags()[23];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.oxySensor4Volt14)) {
                this.oxySensor4Volt14 = (Float)this.data().deepCopy(this.fields()[24].schema(), (Object)other.oxySensor4Volt14);
                this.fieldSetFlags()[24] = other.fieldSetFlags()[24];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.oxySensor4Stft)) {
                this.oxySensor4Stft = (Float)this.data().deepCopy(this.fields()[25].schema(), (Object)other.oxySensor4Stft);
                this.fieldSetFlags()[25] = other.fieldSetFlags()[25];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.oxySensor5Volt14)) {
                this.oxySensor5Volt14 = (Float)this.data().deepCopy(this.fields()[26].schema(), (Object)other.oxySensor5Volt14);
                this.fieldSetFlags()[26] = other.fieldSetFlags()[26];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.oxySensor5Stft)) {
                this.oxySensor5Stft = (Float)this.data().deepCopy(this.fields()[27].schema(), (Object)other.oxySensor5Stft);
                this.fieldSetFlags()[27] = other.fieldSetFlags()[27];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.oxySensor6Volt14)) {
                this.oxySensor6Volt14 = (Float)this.data().deepCopy(this.fields()[28].schema(), (Object)other.oxySensor6Volt14);
                this.fieldSetFlags()[28] = other.fieldSetFlags()[28];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.oxySensor6Stft)) {
                this.oxySensor6Stft = (Float)this.data().deepCopy(this.fields()[29].schema(), (Object)other.oxySensor6Stft);
                this.fieldSetFlags()[29] = other.fieldSetFlags()[29];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.oxySensor7Volt14)) {
                this.oxySensor7Volt14 = (Float)this.data().deepCopy(this.fields()[30].schema(), (Object)other.oxySensor7Volt14);
                this.fieldSetFlags()[30] = other.fieldSetFlags()[30];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.oxySensor7Stft)) {
                this.oxySensor7Stft = (Float)this.data().deepCopy(this.fields()[31].schema(), (Object)other.oxySensor7Stft);
                this.fieldSetFlags()[31] = other.fieldSetFlags()[31];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)other.oxySensor8Volt14)) {
                this.oxySensor8Volt14 = (Float)this.data().deepCopy(this.fields()[32].schema(), (Object)other.oxySensor8Volt14);
                this.fieldSetFlags()[32] = other.fieldSetFlags()[32];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)other.oxySensor8Stft)) {
                this.oxySensor8Stft = (Float)this.data().deepCopy(this.fields()[33].schema(), (Object)other.oxySensor8Stft);
                this.fieldSetFlags()[33] = other.fieldSetFlags()[33];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)other.timeSinceEngStart)) {
                this.timeSinceEngStart = (Float)this.data().deepCopy(this.fields()[34].schema(), (Object)other.timeSinceEngStart);
                this.fieldSetFlags()[34] = other.fieldSetFlags()[34];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)other.distanceMilOn)) {
                this.distanceMilOn = (Float)this.data().deepCopy(this.fields()[35].schema(), (Object)other.distanceMilOn);
                this.fieldSetFlags()[35] = other.fieldSetFlags()[35];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[36], (Object)other.fuelRailPres)) {
                this.fuelRailPres = (Float)this.data().deepCopy(this.fields()[36].schema(), (Object)other.fuelRailPres);
                this.fieldSetFlags()[36] = other.fieldSetFlags()[36];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[37], (Object)other.fuelRailGaug)) {
                this.fuelRailGaug = (Float)this.data().deepCopy(this.fields()[37].schema(), (Object)other.fuelRailGaug);
                this.fieldSetFlags()[37] = other.fieldSetFlags()[37];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[38], (Object)other.oxySensor1Faer24)) {
                this.oxySensor1Faer24 = (Float)this.data().deepCopy(this.fields()[38].schema(), (Object)other.oxySensor1Faer24);
                this.fieldSetFlags()[38] = other.fieldSetFlags()[38];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[39], (Object)other.oxySensor1Volt24)) {
                this.oxySensor1Volt24 = (Float)this.data().deepCopy(this.fields()[39].schema(), (Object)other.oxySensor1Volt24);
                this.fieldSetFlags()[39] = other.fieldSetFlags()[39];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[40], (Object)other.oxySensor2Faer25)) {
                this.oxySensor2Faer25 = (Float)this.data().deepCopy(this.fields()[40].schema(), (Object)other.oxySensor2Faer25);
                this.fieldSetFlags()[40] = other.fieldSetFlags()[40];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[41], (Object)other.oxySensor2Volt25)) {
                this.oxySensor2Volt25 = (Float)this.data().deepCopy(this.fields()[41].schema(), (Object)other.oxySensor2Volt25);
                this.fieldSetFlags()[41] = other.fieldSetFlags()[41];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[42], (Object)other.oxySensor3Faer26)) {
                this.oxySensor3Faer26 = (Float)this.data().deepCopy(this.fields()[42].schema(), (Object)other.oxySensor3Faer26);
                this.fieldSetFlags()[42] = other.fieldSetFlags()[42];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[43], (Object)other.oxySensor3Volt26)) {
                this.oxySensor3Volt26 = (Float)this.data().deepCopy(this.fields()[43].schema(), (Object)other.oxySensor3Volt26);
                this.fieldSetFlags()[43] = other.fieldSetFlags()[43];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[44], (Object)other.oxySensor4Faer27)) {
                this.oxySensor4Faer27 = (Float)this.data().deepCopy(this.fields()[44].schema(), (Object)other.oxySensor4Faer27);
                this.fieldSetFlags()[44] = other.fieldSetFlags()[44];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[45], (Object)other.oxySensor4Volt27)) {
                this.oxySensor4Volt27 = (Float)this.data().deepCopy(this.fields()[45].schema(), (Object)other.oxySensor4Volt27);
                this.fieldSetFlags()[45] = other.fieldSetFlags()[45];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[46], (Object)other.oxySensor5Faer28)) {
                this.oxySensor5Faer28 = (Float)this.data().deepCopy(this.fields()[46].schema(), (Object)other.oxySensor5Faer28);
                this.fieldSetFlags()[46] = other.fieldSetFlags()[46];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[47], (Object)other.oxySensor5Volt28)) {
                this.oxySensor5Volt28 = (Float)this.data().deepCopy(this.fields()[47].schema(), (Object)other.oxySensor5Volt28);
                this.fieldSetFlags()[47] = other.fieldSetFlags()[47];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[48], (Object)other.oxySensor6Faer29)) {
                this.oxySensor6Faer29 = (Float)this.data().deepCopy(this.fields()[48].schema(), (Object)other.oxySensor6Faer29);
                this.fieldSetFlags()[48] = other.fieldSetFlags()[48];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[49], (Object)other.oxySensor6Volt29)) {
                this.oxySensor6Volt29 = (Float)this.data().deepCopy(this.fields()[49].schema(), (Object)other.oxySensor6Volt29);
                this.fieldSetFlags()[49] = other.fieldSetFlags()[49];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[50], (Object)other.oxySensor7Faer2A)) {
                this.oxySensor7Faer2A = (Float)this.data().deepCopy(this.fields()[50].schema(), (Object)other.oxySensor7Faer2A);
                this.fieldSetFlags()[50] = other.fieldSetFlags()[50];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[51], (Object)other.oxySensor7Volt2A)) {
                this.oxySensor7Volt2A = (Float)this.data().deepCopy(this.fields()[51].schema(), (Object)other.oxySensor7Volt2A);
                this.fieldSetFlags()[51] = other.fieldSetFlags()[51];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[52], (Object)other.oxySensor8Faer2B)) {
                this.oxySensor8Faer2B = (Float)this.data().deepCopy(this.fields()[52].schema(), (Object)other.oxySensor8Faer2B);
                this.fieldSetFlags()[52] = other.fieldSetFlags()[52];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[53], (Object)other.oxySensor8Volt2B)) {
                this.oxySensor8Volt2B = (Float)this.data().deepCopy(this.fields()[53].schema(), (Object)other.oxySensor8Volt2B);
                this.fieldSetFlags()[53] = other.fieldSetFlags()[53];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[54], (Object)other.cmdEgr)) {
                this.cmdEgr = (Float)this.data().deepCopy(this.fields()[54].schema(), (Object)other.cmdEgr);
                this.fieldSetFlags()[54] = other.fieldSetFlags()[54];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[55], (Object)other.egrError)) {
                this.egrError = (Float)this.data().deepCopy(this.fields()[55].schema(), (Object)other.egrError);
                this.fieldSetFlags()[55] = other.fieldSetFlags()[55];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[56], (Object)other.cmdEvapPurge)) {
                this.cmdEvapPurge = (Float)this.data().deepCopy(this.fields()[56].schema(), (Object)other.cmdEvapPurge);
                this.fieldSetFlags()[56] = other.fieldSetFlags()[56];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[57], (Object)other.fuelTankLevel)) {
                this.fuelTankLevel = (Float)this.data().deepCopy(this.fields()[57].schema(), (Object)other.fuelTankLevel);
                this.fieldSetFlags()[57] = other.fieldSetFlags()[57];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[58], (Object)other.warmUpsSinceCodeClear)) {
                this.warmUpsSinceCodeClear = (Float)this.data().deepCopy(this.fields()[58].schema(), (Object)other.warmUpsSinceCodeClear);
                this.fieldSetFlags()[58] = other.fieldSetFlags()[58];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[59], (Object)other.distanceSinceCodeClear)) {
                this.distanceSinceCodeClear = (Float)this.data().deepCopy(this.fields()[59].schema(), (Object)other.distanceSinceCodeClear);
                this.fieldSetFlags()[59] = other.fieldSetFlags()[59];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[60], (Object)other.evapSysVaporPres)) {
                this.evapSysVaporPres = (Float)this.data().deepCopy(this.fields()[60].schema(), (Object)other.evapSysVaporPres);
                this.fieldSetFlags()[60] = other.fieldSetFlags()[60];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[61], (Object)other.absBaroPres)) {
                this.absBaroPres = (Float)this.data().deepCopy(this.fields()[61].schema(), (Object)other.absBaroPres);
                this.fieldSetFlags()[61] = other.fieldSetFlags()[61];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[62], (Object)other.oxySensor1Faer34)) {
                this.oxySensor1Faer34 = (Float)this.data().deepCopy(this.fields()[62].schema(), (Object)other.oxySensor1Faer34);
                this.fieldSetFlags()[62] = other.fieldSetFlags()[62];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[63], (Object)other.oxySensor1Crnt)) {
                this.oxySensor1Crnt = (Float)this.data().deepCopy(this.fields()[63].schema(), (Object)other.oxySensor1Crnt);
                this.fieldSetFlags()[63] = other.fieldSetFlags()[63];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[64], (Object)other.oxySensor2Faer35)) {
                this.oxySensor2Faer35 = (Float)this.data().deepCopy(this.fields()[64].schema(), (Object)other.oxySensor2Faer35);
                this.fieldSetFlags()[64] = other.fieldSetFlags()[64];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[65], (Object)other.oxySensor2Crnt)) {
                this.oxySensor2Crnt = (Float)this.data().deepCopy(this.fields()[65].schema(), (Object)other.oxySensor2Crnt);
                this.fieldSetFlags()[65] = other.fieldSetFlags()[65];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[66], (Object)other.oxySensor3Faer36)) {
                this.oxySensor3Faer36 = (Float)this.data().deepCopy(this.fields()[66].schema(), (Object)other.oxySensor3Faer36);
                this.fieldSetFlags()[66] = other.fieldSetFlags()[66];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[67], (Object)other.oxySensor3Crnt)) {
                this.oxySensor3Crnt = (Float)this.data().deepCopy(this.fields()[67].schema(), (Object)other.oxySensor3Crnt);
                this.fieldSetFlags()[67] = other.fieldSetFlags()[67];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[68], (Object)other.oxySensor4Faer37)) {
                this.oxySensor4Faer37 = (Float)this.data().deepCopy(this.fields()[68].schema(), (Object)other.oxySensor4Faer37);
                this.fieldSetFlags()[68] = other.fieldSetFlags()[68];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[69], (Object)other.oxySensor4Crnt)) {
                this.oxySensor4Crnt = (Float)this.data().deepCopy(this.fields()[69].schema(), (Object)other.oxySensor4Crnt);
                this.fieldSetFlags()[69] = other.fieldSetFlags()[69];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[70], (Object)other.oxySensor5Faer38)) {
                this.oxySensor5Faer38 = (Float)this.data().deepCopy(this.fields()[70].schema(), (Object)other.oxySensor5Faer38);
                this.fieldSetFlags()[70] = other.fieldSetFlags()[70];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[71], (Object)other.oxySensor5Crnt)) {
                this.oxySensor5Crnt = (Float)this.data().deepCopy(this.fields()[71].schema(), (Object)other.oxySensor5Crnt);
                this.fieldSetFlags()[71] = other.fieldSetFlags()[71];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[72], (Object)other.oxySensor6Faer39)) {
                this.oxySensor6Faer39 = (Float)this.data().deepCopy(this.fields()[72].schema(), (Object)other.oxySensor6Faer39);
                this.fieldSetFlags()[72] = other.fieldSetFlags()[72];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[73], (Object)other.oxySensor6Crnt)) {
                this.oxySensor6Crnt = (Float)this.data().deepCopy(this.fields()[73].schema(), (Object)other.oxySensor6Crnt);
                this.fieldSetFlags()[73] = other.fieldSetFlags()[73];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[74], (Object)other.oxySensor7Faer3A)) {
                this.oxySensor7Faer3A = (Float)this.data().deepCopy(this.fields()[74].schema(), (Object)other.oxySensor7Faer3A);
                this.fieldSetFlags()[74] = other.fieldSetFlags()[74];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[75], (Object)other.oxySensor7Crnt)) {
                this.oxySensor7Crnt = (Float)this.data().deepCopy(this.fields()[75].schema(), (Object)other.oxySensor7Crnt);
                this.fieldSetFlags()[75] = other.fieldSetFlags()[75];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[76], (Object)other.oxySensor8Faer3B)) {
                this.oxySensor8Faer3B = (Float)this.data().deepCopy(this.fields()[76].schema(), (Object)other.oxySensor8Faer3B);
                this.fieldSetFlags()[76] = other.fieldSetFlags()[76];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[77], (Object)other.oxySensor8Crnt)) {
                this.oxySensor8Crnt = (Float)this.data().deepCopy(this.fields()[77].schema(), (Object)other.oxySensor8Crnt);
                this.fieldSetFlags()[77] = other.fieldSetFlags()[77];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[78], (Object)other.catTempBank1Sens1)) {
                this.catTempBank1Sens1 = (Float)this.data().deepCopy(this.fields()[78].schema(), (Object)other.catTempBank1Sens1);
                this.fieldSetFlags()[78] = other.fieldSetFlags()[78];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[79], (Object)other.catTempBank2Sens1)) {
                this.catTempBank2Sens1 = (Float)this.data().deepCopy(this.fields()[79].schema(), (Object)other.catTempBank2Sens1);
                this.fieldSetFlags()[79] = other.fieldSetFlags()[79];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[80], (Object)other.catTempBank1Sens2)) {
                this.catTempBank1Sens2 = (Float)this.data().deepCopy(this.fields()[80].schema(), (Object)other.catTempBank1Sens2);
                this.fieldSetFlags()[80] = other.fieldSetFlags()[80];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[81], (Object)other.catTempBank2Sens2)) {
                this.catTempBank2Sens2 = (Float)this.data().deepCopy(this.fields()[81].schema(), (Object)other.catTempBank2Sens2);
                this.fieldSetFlags()[81] = other.fieldSetFlags()[81];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[82], (Object)other.monStatusDriveCycle)) {
                this.monStatusDriveCycle = (Float)this.data().deepCopy(this.fields()[82].schema(), (Object)other.monStatusDriveCycle);
                this.fieldSetFlags()[82] = other.fieldSetFlags()[82];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[83], (Object)other.controlModuleVolt)) {
                this.controlModuleVolt = (Float)this.data().deepCopy(this.fields()[83].schema(), (Object)other.controlModuleVolt);
                this.fieldSetFlags()[83] = other.fieldSetFlags()[83];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[84], (Object)other.absLoadValue)) {
                this.absLoadValue = (Float)this.data().deepCopy(this.fields()[84].schema(), (Object)other.absLoadValue);
                this.fieldSetFlags()[84] = other.fieldSetFlags()[84];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[85], (Object)other.fuelAirCmdEquiv)) {
                this.fuelAirCmdEquiv = (Float)this.data().deepCopy(this.fields()[85].schema(), (Object)other.fuelAirCmdEquiv);
                this.fieldSetFlags()[85] = other.fieldSetFlags()[85];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[86], (Object)other.relThrottlePos)) {
                this.relThrottlePos = (Float)this.data().deepCopy(this.fields()[86].schema(), (Object)other.relThrottlePos);
                this.fieldSetFlags()[86] = other.fieldSetFlags()[86];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[87], (Object)other.ambientAirTemp)) {
                this.ambientAirTemp = (Float)this.data().deepCopy(this.fields()[87].schema(), (Object)other.ambientAirTemp);
                this.fieldSetFlags()[87] = other.fieldSetFlags()[87];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[88], (Object)other.absThrottlePosB)) {
                this.absThrottlePosB = (Float)this.data().deepCopy(this.fields()[88].schema(), (Object)other.absThrottlePosB);
                this.fieldSetFlags()[88] = other.fieldSetFlags()[88];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[89], (Object)other.absThrottlePosC)) {
                this.absThrottlePosC = (Float)this.data().deepCopy(this.fields()[89].schema(), (Object)other.absThrottlePosC);
                this.fieldSetFlags()[89] = other.fieldSetFlags()[89];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[90], (Object)other.absThrottlePosCd)) {
                this.absThrottlePosCd = (Float)this.data().deepCopy(this.fields()[90].schema(), (Object)other.absThrottlePosCd);
                this.fieldSetFlags()[90] = other.fieldSetFlags()[90];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[91], (Object)other.absThrottlePosE)) {
                this.absThrottlePosE = (Float)this.data().deepCopy(this.fields()[91].schema(), (Object)other.absThrottlePosE);
                this.fieldSetFlags()[91] = other.fieldSetFlags()[91];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[92], (Object)other.absThrottlePosF)) {
                this.absThrottlePosF = (Float)this.data().deepCopy(this.fields()[92].schema(), (Object)other.absThrottlePosF);
                this.fieldSetFlags()[92] = other.fieldSetFlags()[92];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[93], (Object)other.cmdThrottleAct)) {
                this.cmdThrottleAct = (Float)this.data().deepCopy(this.fields()[93].schema(), (Object)other.cmdThrottleAct);
                this.fieldSetFlags()[93] = other.fieldSetFlags()[93];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[94], (Object)other.timeRunMilOn)) {
                this.timeRunMilOn = (Float)this.data().deepCopy(this.fields()[94].schema(), (Object)other.timeRunMilOn);
                this.fieldSetFlags()[94] = other.fieldSetFlags()[94];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[95], (Object)other.timeSinceCodeClear)) {
                this.timeSinceCodeClear = (Float)this.data().deepCopy(this.fields()[95].schema(), (Object)other.timeSinceCodeClear);
                this.fieldSetFlags()[95] = other.fieldSetFlags()[95];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[96], (Object)other.maxFaer)) {
                this.maxFaer = (Float)this.data().deepCopy(this.fields()[96].schema(), (Object)other.maxFaer);
                this.fieldSetFlags()[96] = other.fieldSetFlags()[96];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[97], (Object)other.maxOxySensVol)) {
                this.maxOxySensVol = (Float)this.data().deepCopy(this.fields()[97].schema(), (Object)other.maxOxySensVol);
                this.fieldSetFlags()[97] = other.fieldSetFlags()[97];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[98], (Object)other.maxOxySensCrnt)) {
                this.maxOxySensCrnt = (Float)this.data().deepCopy(this.fields()[98].schema(), (Object)other.maxOxySensCrnt);
                this.fieldSetFlags()[98] = other.fieldSetFlags()[98];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[99], (Object)other.maxIntManiAbsPres)) {
                this.maxIntManiAbsPres = (Float)this.data().deepCopy(this.fields()[99].schema(), (Object)other.maxIntManiAbsPres);
                this.fieldSetFlags()[99] = other.fieldSetFlags()[99];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[100], (Object)other.maxAirFlowMaf)) {
                this.maxAirFlowMaf = (Float)this.data().deepCopy(this.fields()[100].schema(), (Object)other.maxAirFlowMaf);
                this.fieldSetFlags()[100] = other.fieldSetFlags()[100];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[101], (Object)other.fuelType)) {
                this.fuelType = (Float)this.data().deepCopy(this.fields()[101].schema(), (Object)other.fuelType);
                this.fieldSetFlags()[101] = other.fieldSetFlags()[101];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[102], (Object)other.ethanolFuelPct)) {
                this.ethanolFuelPct = (Float)this.data().deepCopy(this.fields()[102].schema(), (Object)other.ethanolFuelPct);
                this.fieldSetFlags()[102] = other.fieldSetFlags()[102];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[103], (Object)other.absEvapSysVapPres)) {
                this.absEvapSysVapPres = (Float)this.data().deepCopy(this.fields()[103].schema(), (Object)other.absEvapSysVapPres);
                this.fieldSetFlags()[103] = other.fieldSetFlags()[103];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[104], (Object)other.evapSysVapPres)) {
                this.evapSysVapPres = (Float)this.data().deepCopy(this.fields()[104].schema(), (Object)other.evapSysVapPres);
                this.fieldSetFlags()[104] = other.fieldSetFlags()[104];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[105], (Object)other.shortSecOxyTrimBank1)) {
                this.shortSecOxyTrimBank1 = (Float)this.data().deepCopy(this.fields()[105].schema(), (Object)other.shortSecOxyTrimBank1);
                this.fieldSetFlags()[105] = other.fieldSetFlags()[105];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[106], (Object)other.shortSecOxyTrimBank3)) {
                this.shortSecOxyTrimBank3 = (Float)this.data().deepCopy(this.fields()[106].schema(), (Object)other.shortSecOxyTrimBank3);
                this.fieldSetFlags()[106] = other.fieldSetFlags()[106];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[107], (Object)other.longSecOxyTrimBank1)) {
                this.longSecOxyTrimBank1 = (Float)this.data().deepCopy(this.fields()[107].schema(), (Object)other.longSecOxyTrimBank1);
                this.fieldSetFlags()[107] = other.fieldSetFlags()[107];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[108], (Object)other.longSecOxyTrimBank3)) {
                this.longSecOxyTrimBank3 = (Float)this.data().deepCopy(this.fields()[108].schema(), (Object)other.longSecOxyTrimBank3);
                this.fieldSetFlags()[108] = other.fieldSetFlags()[108];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[109], (Object)other.shortSecOxyTrimBank2)) {
                this.shortSecOxyTrimBank2 = (Float)this.data().deepCopy(this.fields()[109].schema(), (Object)other.shortSecOxyTrimBank2);
                this.fieldSetFlags()[109] = other.fieldSetFlags()[109];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[110], (Object)other.shortSecOxyTrimBank4)) {
                this.shortSecOxyTrimBank4 = (Float)this.data().deepCopy(this.fields()[110].schema(), (Object)other.shortSecOxyTrimBank4);
                this.fieldSetFlags()[110] = other.fieldSetFlags()[110];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[111], (Object)other.longSecOxyTrimBank2)) {
                this.longSecOxyTrimBank2 = (Float)this.data().deepCopy(this.fields()[111].schema(), (Object)other.longSecOxyTrimBank2);
                this.fieldSetFlags()[111] = other.fieldSetFlags()[111];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[112], (Object)other.longSecOxyTrimBank4)) {
                this.longSecOxyTrimBank4 = (Float)this.data().deepCopy(this.fields()[112].schema(), (Object)other.longSecOxyTrimBank4);
                this.fieldSetFlags()[112] = other.fieldSetFlags()[112];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[113], (Object)other.fuelRailAbsPres)) {
                this.fuelRailAbsPres = (Float)this.data().deepCopy(this.fields()[113].schema(), (Object)other.fuelRailAbsPres);
                this.fieldSetFlags()[113] = other.fieldSetFlags()[113];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[114], (Object)other.relAccelPedalPos)) {
                this.relAccelPedalPos = (Float)this.data().deepCopy(this.fields()[114].schema(), (Object)other.relAccelPedalPos);
                this.fieldSetFlags()[114] = other.fieldSetFlags()[114];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[115], (Object)other.hybrBatPackRemLife)) {
                this.hybrBatPackRemLife = (Float)this.data().deepCopy(this.fields()[115].schema(), (Object)other.hybrBatPackRemLife);
                this.fieldSetFlags()[115] = other.fieldSetFlags()[115];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[116], (Object)other.engineOilTemp)) {
                this.engineOilTemp = (Float)this.data().deepCopy(this.fields()[116].schema(), (Object)other.engineOilTemp);
                this.fieldSetFlags()[116] = other.fieldSetFlags()[116];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[117], (Object)other.fuelInjectionTiming)) {
                this.fuelInjectionTiming = (Float)this.data().deepCopy(this.fields()[117].schema(), (Object)other.fuelInjectionTiming);
                this.fieldSetFlags()[117] = other.fieldSetFlags()[117];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[118], (Object)other.engineFuelRate)) {
                this.engineFuelRate = (Float)this.data().deepCopy(this.fields()[118].schema(), (Object)other.engineFuelRate);
                this.fieldSetFlags()[118] = other.fieldSetFlags()[118];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[119], (Object)other.emissionReq)) {
                this.emissionReq = (Float)this.data().deepCopy(this.fields()[119].schema(), (Object)other.emissionReq);
                this.fieldSetFlags()[119] = other.fieldSetFlags()[119];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[120], (Object)other.demandEngTorqPct)) {
                this.demandEngTorqPct = (Float)this.data().deepCopy(this.fields()[120].schema(), (Object)other.demandEngTorqPct);
                this.fieldSetFlags()[120] = other.fieldSetFlags()[120];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[121], (Object)other.actualEngTorqPct)) {
                this.actualEngTorqPct = (Float)this.data().deepCopy(this.fields()[121].schema(), (Object)other.actualEngTorqPct);
                this.fieldSetFlags()[121] = other.fieldSetFlags()[121];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[122], (Object)other.engRefTorq)) {
                this.engRefTorq = (Float)this.data().deepCopy(this.fields()[122].schema(), (Object)other.engRefTorq);
                this.fieldSetFlags()[122] = other.fieldSetFlags()[122];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[123], (Object)other.engPctTorqIdle)) {
                this.engPctTorqIdle = (Float)this.data().deepCopy(this.fields()[123].schema(), (Object)other.engPctTorqIdle);
                this.fieldSetFlags()[123] = other.fieldSetFlags()[123];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[124], (Object)other.engPctTorqEp1)) {
                this.engPctTorqEp1 = (Float)this.data().deepCopy(this.fields()[124].schema(), (Object)other.engPctTorqEp1);
                this.fieldSetFlags()[124] = other.fieldSetFlags()[124];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[125], (Object)other.engPctTorqEp2)) {
                this.engPctTorqEp2 = (Float)this.data().deepCopy(this.fields()[125].schema(), (Object)other.engPctTorqEp2);
                this.fieldSetFlags()[125] = other.fieldSetFlags()[125];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[126], (Object)other.engPctTorqEp3)) {
                this.engPctTorqEp3 = (Float)this.data().deepCopy(this.fields()[126].schema(), (Object)other.engPctTorqEp3);
                this.fieldSetFlags()[126] = other.fieldSetFlags()[126];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[127], (Object)other.engPctTorqEp4)) {
                this.engPctTorqEp4 = (Float)this.data().deepCopy(this.fields()[127].schema(), (Object)other.engPctTorqEp4);
                this.fieldSetFlags()[127] = other.fieldSetFlags()[127];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[128], (Object)other.auxInputOutput)) {
                this.auxInputOutput = (Float)this.data().deepCopy(this.fields()[128].schema(), (Object)other.auxInputOutput);
                this.fieldSetFlags()[128] = other.fieldSetFlags()[128];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[129], (Object)other.mafSensor)) {
                this.mafSensor = (Float)this.data().deepCopy(this.fields()[129].schema(), (Object)other.mafSensor);
                this.fieldSetFlags()[129] = other.fieldSetFlags()[129];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[130], (Object)other.engineCoolantTemp67)) {
                this.engineCoolantTemp67 = (Float)this.data().deepCopy(this.fields()[130].schema(), (Object)other.engineCoolantTemp67);
                this.fieldSetFlags()[130] = other.fieldSetFlags()[130];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[131], (Object)other.intakeAirTempSens)) {
                this.intakeAirTempSens = (Float)this.data().deepCopy(this.fields()[131].schema(), (Object)other.intakeAirTempSens);
                this.fieldSetFlags()[131] = other.fieldSetFlags()[131];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[132], (Object)other.engineFrictionPercentTorque)) {
                this.engineFrictionPercentTorque = (Float)this.data().deepCopy(this.fields()[132].schema(), (Object)other.engineFrictionPercentTorque);
                this.fieldSetFlags()[132] = other.fieldSetFlags()[132];
            }
        }

        private Builder(CanEdgeObd2 other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.fuelSystemStatus)) {
                this.fuelSystemStatus = (Float)this.data().deepCopy(this.fields()[2].schema(), (Object)other.fuelSystemStatus);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.calcEngineLoad)) {
                this.calcEngineLoad = (Float)this.data().deepCopy(this.fields()[3].schema(), (Object)other.calcEngineLoad);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.engineCoolantTemp)) {
                this.engineCoolantTemp = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.engineCoolantTemp);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.shortFuelTrimBank1)) {
                this.shortFuelTrimBank1 = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.shortFuelTrimBank1);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.longFuelTrimBank1)) {
                this.longFuelTrimBank1 = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.longFuelTrimBank1);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.shortFuelTrimBank2)) {
                this.shortFuelTrimBank2 = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.shortFuelTrimBank2);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.longFuelTrimBank2)) {
                this.longFuelTrimBank2 = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.longFuelTrimBank2);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.fuelPressure)) {
                this.fuelPressure = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.fuelPressure);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.intakeManiAbsPress)) {
                this.intakeManiAbsPress = (Float)this.data().deepCopy(this.fields()[10].schema(), (Object)other.intakeManiAbsPress);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.engineRpm)) {
                this.engineRpm = (Float)this.data().deepCopy(this.fields()[11].schema(), (Object)other.engineRpm);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.vehicleSpeed)) {
                this.vehicleSpeed = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.vehicleSpeed);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.timingAdvance)) {
                this.timingAdvance = (Float)this.data().deepCopy(this.fields()[13].schema(), (Object)other.timingAdvance);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.intakeAirTemperature)) {
                this.intakeAirTemperature = (Float)this.data().deepCopy(this.fields()[14].schema(), (Object)other.intakeAirTemperature);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.mafAirFlowRate)) {
                this.mafAirFlowRate = (Float)this.data().deepCopy(this.fields()[15].schema(), (Object)other.mafAirFlowRate);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.throttlePosition)) {
                this.throttlePosition = (Float)this.data().deepCopy(this.fields()[16].schema(), (Object)other.throttlePosition);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.cmdSecAirStatus)) {
                this.cmdSecAirStatus = (Float)this.data().deepCopy(this.fields()[17].schema(), (Object)other.cmdSecAirStatus);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.oxySensor1Volt14)) {
                this.oxySensor1Volt14 = (Float)this.data().deepCopy(this.fields()[18].schema(), (Object)other.oxySensor1Volt14);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.oxySensor1Stft)) {
                this.oxySensor1Stft = (Float)this.data().deepCopy(this.fields()[19].schema(), (Object)other.oxySensor1Stft);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.oxySensor2Volt14)) {
                this.oxySensor2Volt14 = (Float)this.data().deepCopy(this.fields()[20].schema(), (Object)other.oxySensor2Volt14);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.oxySensor2Stft)) {
                this.oxySensor2Stft = (Float)this.data().deepCopy(this.fields()[21].schema(), (Object)other.oxySensor2Stft);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.oxySensor3Volt14)) {
                this.oxySensor3Volt14 = (Float)this.data().deepCopy(this.fields()[22].schema(), (Object)other.oxySensor3Volt14);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.oxySensor3Stft)) {
                this.oxySensor3Stft = (Float)this.data().deepCopy(this.fields()[23].schema(), (Object)other.oxySensor3Stft);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.oxySensor4Volt14)) {
                this.oxySensor4Volt14 = (Float)this.data().deepCopy(this.fields()[24].schema(), (Object)other.oxySensor4Volt14);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.oxySensor4Stft)) {
                this.oxySensor4Stft = (Float)this.data().deepCopy(this.fields()[25].schema(), (Object)other.oxySensor4Stft);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.oxySensor5Volt14)) {
                this.oxySensor5Volt14 = (Float)this.data().deepCopy(this.fields()[26].schema(), (Object)other.oxySensor5Volt14);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.oxySensor5Stft)) {
                this.oxySensor5Stft = (Float)this.data().deepCopy(this.fields()[27].schema(), (Object)other.oxySensor5Stft);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.oxySensor6Volt14)) {
                this.oxySensor6Volt14 = (Float)this.data().deepCopy(this.fields()[28].schema(), (Object)other.oxySensor6Volt14);
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.oxySensor6Stft)) {
                this.oxySensor6Stft = (Float)this.data().deepCopy(this.fields()[29].schema(), (Object)other.oxySensor6Stft);
                this.fieldSetFlags()[29] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.oxySensor7Volt14)) {
                this.oxySensor7Volt14 = (Float)this.data().deepCopy(this.fields()[30].schema(), (Object)other.oxySensor7Volt14);
                this.fieldSetFlags()[30] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.oxySensor7Stft)) {
                this.oxySensor7Stft = (Float)this.data().deepCopy(this.fields()[31].schema(), (Object)other.oxySensor7Stft);
                this.fieldSetFlags()[31] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)other.oxySensor8Volt14)) {
                this.oxySensor8Volt14 = (Float)this.data().deepCopy(this.fields()[32].schema(), (Object)other.oxySensor8Volt14);
                this.fieldSetFlags()[32] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)other.oxySensor8Stft)) {
                this.oxySensor8Stft = (Float)this.data().deepCopy(this.fields()[33].schema(), (Object)other.oxySensor8Stft);
                this.fieldSetFlags()[33] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[34], (Object)other.timeSinceEngStart)) {
                this.timeSinceEngStart = (Float)this.data().deepCopy(this.fields()[34].schema(), (Object)other.timeSinceEngStart);
                this.fieldSetFlags()[34] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[35], (Object)other.distanceMilOn)) {
                this.distanceMilOn = (Float)this.data().deepCopy(this.fields()[35].schema(), (Object)other.distanceMilOn);
                this.fieldSetFlags()[35] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[36], (Object)other.fuelRailPres)) {
                this.fuelRailPres = (Float)this.data().deepCopy(this.fields()[36].schema(), (Object)other.fuelRailPres);
                this.fieldSetFlags()[36] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[37], (Object)other.fuelRailGaug)) {
                this.fuelRailGaug = (Float)this.data().deepCopy(this.fields()[37].schema(), (Object)other.fuelRailGaug);
                this.fieldSetFlags()[37] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[38], (Object)other.oxySensor1Faer24)) {
                this.oxySensor1Faer24 = (Float)this.data().deepCopy(this.fields()[38].schema(), (Object)other.oxySensor1Faer24);
                this.fieldSetFlags()[38] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[39], (Object)other.oxySensor1Volt24)) {
                this.oxySensor1Volt24 = (Float)this.data().deepCopy(this.fields()[39].schema(), (Object)other.oxySensor1Volt24);
                this.fieldSetFlags()[39] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[40], (Object)other.oxySensor2Faer25)) {
                this.oxySensor2Faer25 = (Float)this.data().deepCopy(this.fields()[40].schema(), (Object)other.oxySensor2Faer25);
                this.fieldSetFlags()[40] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[41], (Object)other.oxySensor2Volt25)) {
                this.oxySensor2Volt25 = (Float)this.data().deepCopy(this.fields()[41].schema(), (Object)other.oxySensor2Volt25);
                this.fieldSetFlags()[41] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[42], (Object)other.oxySensor3Faer26)) {
                this.oxySensor3Faer26 = (Float)this.data().deepCopy(this.fields()[42].schema(), (Object)other.oxySensor3Faer26);
                this.fieldSetFlags()[42] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[43], (Object)other.oxySensor3Volt26)) {
                this.oxySensor3Volt26 = (Float)this.data().deepCopy(this.fields()[43].schema(), (Object)other.oxySensor3Volt26);
                this.fieldSetFlags()[43] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[44], (Object)other.oxySensor4Faer27)) {
                this.oxySensor4Faer27 = (Float)this.data().deepCopy(this.fields()[44].schema(), (Object)other.oxySensor4Faer27);
                this.fieldSetFlags()[44] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[45], (Object)other.oxySensor4Volt27)) {
                this.oxySensor4Volt27 = (Float)this.data().deepCopy(this.fields()[45].schema(), (Object)other.oxySensor4Volt27);
                this.fieldSetFlags()[45] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[46], (Object)other.oxySensor5Faer28)) {
                this.oxySensor5Faer28 = (Float)this.data().deepCopy(this.fields()[46].schema(), (Object)other.oxySensor5Faer28);
                this.fieldSetFlags()[46] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[47], (Object)other.oxySensor5Volt28)) {
                this.oxySensor5Volt28 = (Float)this.data().deepCopy(this.fields()[47].schema(), (Object)other.oxySensor5Volt28);
                this.fieldSetFlags()[47] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[48], (Object)other.oxySensor6Faer29)) {
                this.oxySensor6Faer29 = (Float)this.data().deepCopy(this.fields()[48].schema(), (Object)other.oxySensor6Faer29);
                this.fieldSetFlags()[48] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[49], (Object)other.oxySensor6Volt29)) {
                this.oxySensor6Volt29 = (Float)this.data().deepCopy(this.fields()[49].schema(), (Object)other.oxySensor6Volt29);
                this.fieldSetFlags()[49] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[50], (Object)other.oxySensor7Faer2A)) {
                this.oxySensor7Faer2A = (Float)this.data().deepCopy(this.fields()[50].schema(), (Object)other.oxySensor7Faer2A);
                this.fieldSetFlags()[50] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[51], (Object)other.oxySensor7Volt2A)) {
                this.oxySensor7Volt2A = (Float)this.data().deepCopy(this.fields()[51].schema(), (Object)other.oxySensor7Volt2A);
                this.fieldSetFlags()[51] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[52], (Object)other.oxySensor8Faer2B)) {
                this.oxySensor8Faer2B = (Float)this.data().deepCopy(this.fields()[52].schema(), (Object)other.oxySensor8Faer2B);
                this.fieldSetFlags()[52] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[53], (Object)other.oxySensor8Volt2B)) {
                this.oxySensor8Volt2B = (Float)this.data().deepCopy(this.fields()[53].schema(), (Object)other.oxySensor8Volt2B);
                this.fieldSetFlags()[53] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[54], (Object)other.cmdEgr)) {
                this.cmdEgr = (Float)this.data().deepCopy(this.fields()[54].schema(), (Object)other.cmdEgr);
                this.fieldSetFlags()[54] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[55], (Object)other.egrError)) {
                this.egrError = (Float)this.data().deepCopy(this.fields()[55].schema(), (Object)other.egrError);
                this.fieldSetFlags()[55] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[56], (Object)other.cmdEvapPurge)) {
                this.cmdEvapPurge = (Float)this.data().deepCopy(this.fields()[56].schema(), (Object)other.cmdEvapPurge);
                this.fieldSetFlags()[56] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[57], (Object)other.fuelTankLevel)) {
                this.fuelTankLevel = (Float)this.data().deepCopy(this.fields()[57].schema(), (Object)other.fuelTankLevel);
                this.fieldSetFlags()[57] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[58], (Object)other.warmUpsSinceCodeClear)) {
                this.warmUpsSinceCodeClear = (Float)this.data().deepCopy(this.fields()[58].schema(), (Object)other.warmUpsSinceCodeClear);
                this.fieldSetFlags()[58] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[59], (Object)other.distanceSinceCodeClear)) {
                this.distanceSinceCodeClear = (Float)this.data().deepCopy(this.fields()[59].schema(), (Object)other.distanceSinceCodeClear);
                this.fieldSetFlags()[59] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[60], (Object)other.evapSysVaporPres)) {
                this.evapSysVaporPres = (Float)this.data().deepCopy(this.fields()[60].schema(), (Object)other.evapSysVaporPres);
                this.fieldSetFlags()[60] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[61], (Object)other.absBaroPres)) {
                this.absBaroPres = (Float)this.data().deepCopy(this.fields()[61].schema(), (Object)other.absBaroPres);
                this.fieldSetFlags()[61] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[62], (Object)other.oxySensor1Faer34)) {
                this.oxySensor1Faer34 = (Float)this.data().deepCopy(this.fields()[62].schema(), (Object)other.oxySensor1Faer34);
                this.fieldSetFlags()[62] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[63], (Object)other.oxySensor1Crnt)) {
                this.oxySensor1Crnt = (Float)this.data().deepCopy(this.fields()[63].schema(), (Object)other.oxySensor1Crnt);
                this.fieldSetFlags()[63] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[64], (Object)other.oxySensor2Faer35)) {
                this.oxySensor2Faer35 = (Float)this.data().deepCopy(this.fields()[64].schema(), (Object)other.oxySensor2Faer35);
                this.fieldSetFlags()[64] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[65], (Object)other.oxySensor2Crnt)) {
                this.oxySensor2Crnt = (Float)this.data().deepCopy(this.fields()[65].schema(), (Object)other.oxySensor2Crnt);
                this.fieldSetFlags()[65] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[66], (Object)other.oxySensor3Faer36)) {
                this.oxySensor3Faer36 = (Float)this.data().deepCopy(this.fields()[66].schema(), (Object)other.oxySensor3Faer36);
                this.fieldSetFlags()[66] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[67], (Object)other.oxySensor3Crnt)) {
                this.oxySensor3Crnt = (Float)this.data().deepCopy(this.fields()[67].schema(), (Object)other.oxySensor3Crnt);
                this.fieldSetFlags()[67] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[68], (Object)other.oxySensor4Faer37)) {
                this.oxySensor4Faer37 = (Float)this.data().deepCopy(this.fields()[68].schema(), (Object)other.oxySensor4Faer37);
                this.fieldSetFlags()[68] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[69], (Object)other.oxySensor4Crnt)) {
                this.oxySensor4Crnt = (Float)this.data().deepCopy(this.fields()[69].schema(), (Object)other.oxySensor4Crnt);
                this.fieldSetFlags()[69] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[70], (Object)other.oxySensor5Faer38)) {
                this.oxySensor5Faer38 = (Float)this.data().deepCopy(this.fields()[70].schema(), (Object)other.oxySensor5Faer38);
                this.fieldSetFlags()[70] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[71], (Object)other.oxySensor5Crnt)) {
                this.oxySensor5Crnt = (Float)this.data().deepCopy(this.fields()[71].schema(), (Object)other.oxySensor5Crnt);
                this.fieldSetFlags()[71] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[72], (Object)other.oxySensor6Faer39)) {
                this.oxySensor6Faer39 = (Float)this.data().deepCopy(this.fields()[72].schema(), (Object)other.oxySensor6Faer39);
                this.fieldSetFlags()[72] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[73], (Object)other.oxySensor6Crnt)) {
                this.oxySensor6Crnt = (Float)this.data().deepCopy(this.fields()[73].schema(), (Object)other.oxySensor6Crnt);
                this.fieldSetFlags()[73] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[74], (Object)other.oxySensor7Faer3A)) {
                this.oxySensor7Faer3A = (Float)this.data().deepCopy(this.fields()[74].schema(), (Object)other.oxySensor7Faer3A);
                this.fieldSetFlags()[74] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[75], (Object)other.oxySensor7Crnt)) {
                this.oxySensor7Crnt = (Float)this.data().deepCopy(this.fields()[75].schema(), (Object)other.oxySensor7Crnt);
                this.fieldSetFlags()[75] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[76], (Object)other.oxySensor8Faer3B)) {
                this.oxySensor8Faer3B = (Float)this.data().deepCopy(this.fields()[76].schema(), (Object)other.oxySensor8Faer3B);
                this.fieldSetFlags()[76] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[77], (Object)other.oxySensor8Crnt)) {
                this.oxySensor8Crnt = (Float)this.data().deepCopy(this.fields()[77].schema(), (Object)other.oxySensor8Crnt);
                this.fieldSetFlags()[77] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[78], (Object)other.catTempBank1Sens1)) {
                this.catTempBank1Sens1 = (Float)this.data().deepCopy(this.fields()[78].schema(), (Object)other.catTempBank1Sens1);
                this.fieldSetFlags()[78] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[79], (Object)other.catTempBank2Sens1)) {
                this.catTempBank2Sens1 = (Float)this.data().deepCopy(this.fields()[79].schema(), (Object)other.catTempBank2Sens1);
                this.fieldSetFlags()[79] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[80], (Object)other.catTempBank1Sens2)) {
                this.catTempBank1Sens2 = (Float)this.data().deepCopy(this.fields()[80].schema(), (Object)other.catTempBank1Sens2);
                this.fieldSetFlags()[80] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[81], (Object)other.catTempBank2Sens2)) {
                this.catTempBank2Sens2 = (Float)this.data().deepCopy(this.fields()[81].schema(), (Object)other.catTempBank2Sens2);
                this.fieldSetFlags()[81] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[82], (Object)other.monStatusDriveCycle)) {
                this.monStatusDriveCycle = (Float)this.data().deepCopy(this.fields()[82].schema(), (Object)other.monStatusDriveCycle);
                this.fieldSetFlags()[82] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[83], (Object)other.controlModuleVolt)) {
                this.controlModuleVolt = (Float)this.data().deepCopy(this.fields()[83].schema(), (Object)other.controlModuleVolt);
                this.fieldSetFlags()[83] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[84], (Object)other.absLoadValue)) {
                this.absLoadValue = (Float)this.data().deepCopy(this.fields()[84].schema(), (Object)other.absLoadValue);
                this.fieldSetFlags()[84] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[85], (Object)other.fuelAirCmdEquiv)) {
                this.fuelAirCmdEquiv = (Float)this.data().deepCopy(this.fields()[85].schema(), (Object)other.fuelAirCmdEquiv);
                this.fieldSetFlags()[85] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[86], (Object)other.relThrottlePos)) {
                this.relThrottlePos = (Float)this.data().deepCopy(this.fields()[86].schema(), (Object)other.relThrottlePos);
                this.fieldSetFlags()[86] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[87], (Object)other.ambientAirTemp)) {
                this.ambientAirTemp = (Float)this.data().deepCopy(this.fields()[87].schema(), (Object)other.ambientAirTemp);
                this.fieldSetFlags()[87] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[88], (Object)other.absThrottlePosB)) {
                this.absThrottlePosB = (Float)this.data().deepCopy(this.fields()[88].schema(), (Object)other.absThrottlePosB);
                this.fieldSetFlags()[88] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[89], (Object)other.absThrottlePosC)) {
                this.absThrottlePosC = (Float)this.data().deepCopy(this.fields()[89].schema(), (Object)other.absThrottlePosC);
                this.fieldSetFlags()[89] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[90], (Object)other.absThrottlePosCd)) {
                this.absThrottlePosCd = (Float)this.data().deepCopy(this.fields()[90].schema(), (Object)other.absThrottlePosCd);
                this.fieldSetFlags()[90] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[91], (Object)other.absThrottlePosE)) {
                this.absThrottlePosE = (Float)this.data().deepCopy(this.fields()[91].schema(), (Object)other.absThrottlePosE);
                this.fieldSetFlags()[91] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[92], (Object)other.absThrottlePosF)) {
                this.absThrottlePosF = (Float)this.data().deepCopy(this.fields()[92].schema(), (Object)other.absThrottlePosF);
                this.fieldSetFlags()[92] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[93], (Object)other.cmdThrottleAct)) {
                this.cmdThrottleAct = (Float)this.data().deepCopy(this.fields()[93].schema(), (Object)other.cmdThrottleAct);
                this.fieldSetFlags()[93] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[94], (Object)other.timeRunMilOn)) {
                this.timeRunMilOn = (Float)this.data().deepCopy(this.fields()[94].schema(), (Object)other.timeRunMilOn);
                this.fieldSetFlags()[94] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[95], (Object)other.timeSinceCodeClear)) {
                this.timeSinceCodeClear = (Float)this.data().deepCopy(this.fields()[95].schema(), (Object)other.timeSinceCodeClear);
                this.fieldSetFlags()[95] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[96], (Object)other.maxFaer)) {
                this.maxFaer = (Float)this.data().deepCopy(this.fields()[96].schema(), (Object)other.maxFaer);
                this.fieldSetFlags()[96] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[97], (Object)other.maxOxySensVol)) {
                this.maxOxySensVol = (Float)this.data().deepCopy(this.fields()[97].schema(), (Object)other.maxOxySensVol);
                this.fieldSetFlags()[97] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[98], (Object)other.maxOxySensCrnt)) {
                this.maxOxySensCrnt = (Float)this.data().deepCopy(this.fields()[98].schema(), (Object)other.maxOxySensCrnt);
                this.fieldSetFlags()[98] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[99], (Object)other.maxIntManiAbsPres)) {
                this.maxIntManiAbsPres = (Float)this.data().deepCopy(this.fields()[99].schema(), (Object)other.maxIntManiAbsPres);
                this.fieldSetFlags()[99] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[100], (Object)other.maxAirFlowMaf)) {
                this.maxAirFlowMaf = (Float)this.data().deepCopy(this.fields()[100].schema(), (Object)other.maxAirFlowMaf);
                this.fieldSetFlags()[100] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[101], (Object)other.fuelType)) {
                this.fuelType = (Float)this.data().deepCopy(this.fields()[101].schema(), (Object)other.fuelType);
                this.fieldSetFlags()[101] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[102], (Object)other.ethanolFuelPct)) {
                this.ethanolFuelPct = (Float)this.data().deepCopy(this.fields()[102].schema(), (Object)other.ethanolFuelPct);
                this.fieldSetFlags()[102] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[103], (Object)other.absEvapSysVapPres)) {
                this.absEvapSysVapPres = (Float)this.data().deepCopy(this.fields()[103].schema(), (Object)other.absEvapSysVapPres);
                this.fieldSetFlags()[103] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[104], (Object)other.evapSysVapPres)) {
                this.evapSysVapPres = (Float)this.data().deepCopy(this.fields()[104].schema(), (Object)other.evapSysVapPres);
                this.fieldSetFlags()[104] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[105], (Object)other.shortSecOxyTrimBank1)) {
                this.shortSecOxyTrimBank1 = (Float)this.data().deepCopy(this.fields()[105].schema(), (Object)other.shortSecOxyTrimBank1);
                this.fieldSetFlags()[105] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[106], (Object)other.shortSecOxyTrimBank3)) {
                this.shortSecOxyTrimBank3 = (Float)this.data().deepCopy(this.fields()[106].schema(), (Object)other.shortSecOxyTrimBank3);
                this.fieldSetFlags()[106] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[107], (Object)other.longSecOxyTrimBank1)) {
                this.longSecOxyTrimBank1 = (Float)this.data().deepCopy(this.fields()[107].schema(), (Object)other.longSecOxyTrimBank1);
                this.fieldSetFlags()[107] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[108], (Object)other.longSecOxyTrimBank3)) {
                this.longSecOxyTrimBank3 = (Float)this.data().deepCopy(this.fields()[108].schema(), (Object)other.longSecOxyTrimBank3);
                this.fieldSetFlags()[108] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[109], (Object)other.shortSecOxyTrimBank2)) {
                this.shortSecOxyTrimBank2 = (Float)this.data().deepCopy(this.fields()[109].schema(), (Object)other.shortSecOxyTrimBank2);
                this.fieldSetFlags()[109] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[110], (Object)other.shortSecOxyTrimBank4)) {
                this.shortSecOxyTrimBank4 = (Float)this.data().deepCopy(this.fields()[110].schema(), (Object)other.shortSecOxyTrimBank4);
                this.fieldSetFlags()[110] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[111], (Object)other.longSecOxyTrimBank2)) {
                this.longSecOxyTrimBank2 = (Float)this.data().deepCopy(this.fields()[111].schema(), (Object)other.longSecOxyTrimBank2);
                this.fieldSetFlags()[111] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[112], (Object)other.longSecOxyTrimBank4)) {
                this.longSecOxyTrimBank4 = (Float)this.data().deepCopy(this.fields()[112].schema(), (Object)other.longSecOxyTrimBank4);
                this.fieldSetFlags()[112] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[113], (Object)other.fuelRailAbsPres)) {
                this.fuelRailAbsPres = (Float)this.data().deepCopy(this.fields()[113].schema(), (Object)other.fuelRailAbsPres);
                this.fieldSetFlags()[113] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[114], (Object)other.relAccelPedalPos)) {
                this.relAccelPedalPos = (Float)this.data().deepCopy(this.fields()[114].schema(), (Object)other.relAccelPedalPos);
                this.fieldSetFlags()[114] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[115], (Object)other.hybrBatPackRemLife)) {
                this.hybrBatPackRemLife = (Float)this.data().deepCopy(this.fields()[115].schema(), (Object)other.hybrBatPackRemLife);
                this.fieldSetFlags()[115] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[116], (Object)other.engineOilTemp)) {
                this.engineOilTemp = (Float)this.data().deepCopy(this.fields()[116].schema(), (Object)other.engineOilTemp);
                this.fieldSetFlags()[116] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[117], (Object)other.fuelInjectionTiming)) {
                this.fuelInjectionTiming = (Float)this.data().deepCopy(this.fields()[117].schema(), (Object)other.fuelInjectionTiming);
                this.fieldSetFlags()[117] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[118], (Object)other.engineFuelRate)) {
                this.engineFuelRate = (Float)this.data().deepCopy(this.fields()[118].schema(), (Object)other.engineFuelRate);
                this.fieldSetFlags()[118] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[119], (Object)other.emissionReq)) {
                this.emissionReq = (Float)this.data().deepCopy(this.fields()[119].schema(), (Object)other.emissionReq);
                this.fieldSetFlags()[119] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[120], (Object)other.demandEngTorqPct)) {
                this.demandEngTorqPct = (Float)this.data().deepCopy(this.fields()[120].schema(), (Object)other.demandEngTorqPct);
                this.fieldSetFlags()[120] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[121], (Object)other.actualEngTorqPct)) {
                this.actualEngTorqPct = (Float)this.data().deepCopy(this.fields()[121].schema(), (Object)other.actualEngTorqPct);
                this.fieldSetFlags()[121] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[122], (Object)other.engRefTorq)) {
                this.engRefTorq = (Float)this.data().deepCopy(this.fields()[122].schema(), (Object)other.engRefTorq);
                this.fieldSetFlags()[122] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[123], (Object)other.engPctTorqIdle)) {
                this.engPctTorqIdle = (Float)this.data().deepCopy(this.fields()[123].schema(), (Object)other.engPctTorqIdle);
                this.fieldSetFlags()[123] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[124], (Object)other.engPctTorqEp1)) {
                this.engPctTorqEp1 = (Float)this.data().deepCopy(this.fields()[124].schema(), (Object)other.engPctTorqEp1);
                this.fieldSetFlags()[124] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[125], (Object)other.engPctTorqEp2)) {
                this.engPctTorqEp2 = (Float)this.data().deepCopy(this.fields()[125].schema(), (Object)other.engPctTorqEp2);
                this.fieldSetFlags()[125] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[126], (Object)other.engPctTorqEp3)) {
                this.engPctTorqEp3 = (Float)this.data().deepCopy(this.fields()[126].schema(), (Object)other.engPctTorqEp3);
                this.fieldSetFlags()[126] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[127], (Object)other.engPctTorqEp4)) {
                this.engPctTorqEp4 = (Float)this.data().deepCopy(this.fields()[127].schema(), (Object)other.engPctTorqEp4);
                this.fieldSetFlags()[127] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[128], (Object)other.auxInputOutput)) {
                this.auxInputOutput = (Float)this.data().deepCopy(this.fields()[128].schema(), (Object)other.auxInputOutput);
                this.fieldSetFlags()[128] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[129], (Object)other.mafSensor)) {
                this.mafSensor = (Float)this.data().deepCopy(this.fields()[129].schema(), (Object)other.mafSensor);
                this.fieldSetFlags()[129] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[130], (Object)other.engineCoolantTemp67)) {
                this.engineCoolantTemp67 = (Float)this.data().deepCopy(this.fields()[130].schema(), (Object)other.engineCoolantTemp67);
                this.fieldSetFlags()[130] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[131], (Object)other.intakeAirTempSens)) {
                this.intakeAirTempSens = (Float)this.data().deepCopy(this.fields()[131].schema(), (Object)other.intakeAirTempSens);
                this.fieldSetFlags()[131] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[132], (Object)other.engineFrictionPercentTorque)) {
                this.engineFrictionPercentTorque = (Float)this.data().deepCopy(this.fields()[132].schema(), (Object)other.engineFrictionPercentTorque);
                this.fieldSetFlags()[132] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Float getFuelSystemStatus() {
            return this.fuelSystemStatus;
        }

        public Builder setFuelSystemStatus(Float value) {
            this.validate(this.fields()[2], value);
            this.fuelSystemStatus = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFuelSystemStatus() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFuelSystemStatus() {
            this.fuelSystemStatus = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Float getCalcEngineLoad() {
            return this.calcEngineLoad;
        }

        public Builder setCalcEngineLoad(Float value) {
            this.validate(this.fields()[3], value);
            this.calcEngineLoad = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasCalcEngineLoad() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearCalcEngineLoad() {
            this.calcEngineLoad = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Float getEngineCoolantTemp() {
            return this.engineCoolantTemp;
        }

        public Builder setEngineCoolantTemp(Float value) {
            this.validate(this.fields()[4], value);
            this.engineCoolantTemp = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasEngineCoolantTemp() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearEngineCoolantTemp() {
            this.engineCoolantTemp = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Float getShortFuelTrimBank1() {
            return this.shortFuelTrimBank1;
        }

        public Builder setShortFuelTrimBank1(Float value) {
            this.validate(this.fields()[5], value);
            this.shortFuelTrimBank1 = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasShortFuelTrimBank1() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearShortFuelTrimBank1() {
            this.shortFuelTrimBank1 = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getLongFuelTrimBank1() {
            return this.longFuelTrimBank1;
        }

        public Builder setLongFuelTrimBank1(Float value) {
            this.validate(this.fields()[6], value);
            this.longFuelTrimBank1 = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasLongFuelTrimBank1() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearLongFuelTrimBank1() {
            this.longFuelTrimBank1 = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getShortFuelTrimBank2() {
            return this.shortFuelTrimBank2;
        }

        public Builder setShortFuelTrimBank2(Float value) {
            this.validate(this.fields()[7], value);
            this.shortFuelTrimBank2 = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasShortFuelTrimBank2() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearShortFuelTrimBank2() {
            this.shortFuelTrimBank2 = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getLongFuelTrimBank2() {
            return this.longFuelTrimBank2;
        }

        public Builder setLongFuelTrimBank2(Float value) {
            this.validate(this.fields()[8], value);
            this.longFuelTrimBank2 = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasLongFuelTrimBank2() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearLongFuelTrimBank2() {
            this.longFuelTrimBank2 = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Float getFuelPressure() {
            return this.fuelPressure;
        }

        public Builder setFuelPressure(Float value) {
            this.validate(this.fields()[9], value);
            this.fuelPressure = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasFuelPressure() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearFuelPressure() {
            this.fuelPressure = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Float getIntakeManiAbsPress() {
            return this.intakeManiAbsPress;
        }

        public Builder setIntakeManiAbsPress(Float value) {
            this.validate(this.fields()[10], value);
            this.intakeManiAbsPress = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasIntakeManiAbsPress() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearIntakeManiAbsPress() {
            this.intakeManiAbsPress = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Float getEngineRpm() {
            return this.engineRpm;
        }

        public Builder setEngineRpm(Float value) {
            this.validate(this.fields()[11], value);
            this.engineRpm = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasEngineRpm() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearEngineRpm() {
            this.engineRpm = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Float getVehicleSpeed() {
            return this.vehicleSpeed;
        }

        public Builder setVehicleSpeed(Float value) {
            this.validate(this.fields()[12], value);
            this.vehicleSpeed = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasVehicleSpeed() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearVehicleSpeed() {
            this.vehicleSpeed = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Float getTimingAdvance() {
            return this.timingAdvance;
        }

        public Builder setTimingAdvance(Float value) {
            this.validate(this.fields()[13], value);
            this.timingAdvance = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasTimingAdvance() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearTimingAdvance() {
            this.timingAdvance = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Float getIntakeAirTemperature() {
            return this.intakeAirTemperature;
        }

        public Builder setIntakeAirTemperature(Float value) {
            this.validate(this.fields()[14], value);
            this.intakeAirTemperature = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasIntakeAirTemperature() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearIntakeAirTemperature() {
            this.intakeAirTemperature = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Float getMafAirFlowRate() {
            return this.mafAirFlowRate;
        }

        public Builder setMafAirFlowRate(Float value) {
            this.validate(this.fields()[15], value);
            this.mafAirFlowRate = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasMafAirFlowRate() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearMafAirFlowRate() {
            this.mafAirFlowRate = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Float getThrottlePosition() {
            return this.throttlePosition;
        }

        public Builder setThrottlePosition(Float value) {
            this.validate(this.fields()[16], value);
            this.throttlePosition = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasThrottlePosition() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearThrottlePosition() {
            this.throttlePosition = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Float getCmdSecAirStatus() {
            return this.cmdSecAirStatus;
        }

        public Builder setCmdSecAirStatus(Float value) {
            this.validate(this.fields()[17], value);
            this.cmdSecAirStatus = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasCmdSecAirStatus() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearCmdSecAirStatus() {
            this.cmdSecAirStatus = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Float getOxySensor1Volt14() {
            return this.oxySensor1Volt14;
        }

        public Builder setOxySensor1Volt14(Float value) {
            this.validate(this.fields()[18], value);
            this.oxySensor1Volt14 = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasOxySensor1Volt14() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearOxySensor1Volt14() {
            this.oxySensor1Volt14 = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Float getOxySensor1Stft() {
            return this.oxySensor1Stft;
        }

        public Builder setOxySensor1Stft(Float value) {
            this.validate(this.fields()[19], value);
            this.oxySensor1Stft = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasOxySensor1Stft() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearOxySensor1Stft() {
            this.oxySensor1Stft = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Float getOxySensor2Volt14() {
            return this.oxySensor2Volt14;
        }

        public Builder setOxySensor2Volt14(Float value) {
            this.validate(this.fields()[20], value);
            this.oxySensor2Volt14 = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasOxySensor2Volt14() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearOxySensor2Volt14() {
            this.oxySensor2Volt14 = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Float getOxySensor2Stft() {
            return this.oxySensor2Stft;
        }

        public Builder setOxySensor2Stft(Float value) {
            this.validate(this.fields()[21], value);
            this.oxySensor2Stft = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasOxySensor2Stft() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearOxySensor2Stft() {
            this.oxySensor2Stft = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Float getOxySensor3Volt14() {
            return this.oxySensor3Volt14;
        }

        public Builder setOxySensor3Volt14(Float value) {
            this.validate(this.fields()[22], value);
            this.oxySensor3Volt14 = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasOxySensor3Volt14() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearOxySensor3Volt14() {
            this.oxySensor3Volt14 = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public Float getOxySensor3Stft() {
            return this.oxySensor3Stft;
        }

        public Builder setOxySensor3Stft(Float value) {
            this.validate(this.fields()[23], value);
            this.oxySensor3Stft = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasOxySensor3Stft() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearOxySensor3Stft() {
            this.oxySensor3Stft = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public Float getOxySensor4Volt14() {
            return this.oxySensor4Volt14;
        }

        public Builder setOxySensor4Volt14(Float value) {
            this.validate(this.fields()[24], value);
            this.oxySensor4Volt14 = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasOxySensor4Volt14() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearOxySensor4Volt14() {
            this.oxySensor4Volt14 = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public Float getOxySensor4Stft() {
            return this.oxySensor4Stft;
        }

        public Builder setOxySensor4Stft(Float value) {
            this.validate(this.fields()[25], value);
            this.oxySensor4Stft = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasOxySensor4Stft() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearOxySensor4Stft() {
            this.oxySensor4Stft = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public Float getOxySensor5Volt14() {
            return this.oxySensor5Volt14;
        }

        public Builder setOxySensor5Volt14(Float value) {
            this.validate(this.fields()[26], value);
            this.oxySensor5Volt14 = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasOxySensor5Volt14() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearOxySensor5Volt14() {
            this.oxySensor5Volt14 = null;
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public Float getOxySensor5Stft() {
            return this.oxySensor5Stft;
        }

        public Builder setOxySensor5Stft(Float value) {
            this.validate(this.fields()[27], value);
            this.oxySensor5Stft = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasOxySensor5Stft() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearOxySensor5Stft() {
            this.oxySensor5Stft = null;
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public Float getOxySensor6Volt14() {
            return this.oxySensor6Volt14;
        }

        public Builder setOxySensor6Volt14(Float value) {
            this.validate(this.fields()[28], value);
            this.oxySensor6Volt14 = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasOxySensor6Volt14() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearOxySensor6Volt14() {
            this.oxySensor6Volt14 = null;
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public Float getOxySensor6Stft() {
            return this.oxySensor6Stft;
        }

        public Builder setOxySensor6Stft(Float value) {
            this.validate(this.fields()[29], value);
            this.oxySensor6Stft = value;
            this.fieldSetFlags()[29] = true;
            return this;
        }

        public boolean hasOxySensor6Stft() {
            return this.fieldSetFlags()[29];
        }

        public Builder clearOxySensor6Stft() {
            this.oxySensor6Stft = null;
            this.fieldSetFlags()[29] = false;
            return this;
        }

        public Float getOxySensor7Volt14() {
            return this.oxySensor7Volt14;
        }

        public Builder setOxySensor7Volt14(Float value) {
            this.validate(this.fields()[30], value);
            this.oxySensor7Volt14 = value;
            this.fieldSetFlags()[30] = true;
            return this;
        }

        public boolean hasOxySensor7Volt14() {
            return this.fieldSetFlags()[30];
        }

        public Builder clearOxySensor7Volt14() {
            this.oxySensor7Volt14 = null;
            this.fieldSetFlags()[30] = false;
            return this;
        }

        public Float getOxySensor7Stft() {
            return this.oxySensor7Stft;
        }

        public Builder setOxySensor7Stft(Float value) {
            this.validate(this.fields()[31], value);
            this.oxySensor7Stft = value;
            this.fieldSetFlags()[31] = true;
            return this;
        }

        public boolean hasOxySensor7Stft() {
            return this.fieldSetFlags()[31];
        }

        public Builder clearOxySensor7Stft() {
            this.oxySensor7Stft = null;
            this.fieldSetFlags()[31] = false;
            return this;
        }

        public Float getOxySensor8Volt14() {
            return this.oxySensor8Volt14;
        }

        public Builder setOxySensor8Volt14(Float value) {
            this.validate(this.fields()[32], value);
            this.oxySensor8Volt14 = value;
            this.fieldSetFlags()[32] = true;
            return this;
        }

        public boolean hasOxySensor8Volt14() {
            return this.fieldSetFlags()[32];
        }

        public Builder clearOxySensor8Volt14() {
            this.oxySensor8Volt14 = null;
            this.fieldSetFlags()[32] = false;
            return this;
        }

        public Float getOxySensor8Stft() {
            return this.oxySensor8Stft;
        }

        public Builder setOxySensor8Stft(Float value) {
            this.validate(this.fields()[33], value);
            this.oxySensor8Stft = value;
            this.fieldSetFlags()[33] = true;
            return this;
        }

        public boolean hasOxySensor8Stft() {
            return this.fieldSetFlags()[33];
        }

        public Builder clearOxySensor8Stft() {
            this.oxySensor8Stft = null;
            this.fieldSetFlags()[33] = false;
            return this;
        }

        public Float getTimeSinceEngStart() {
            return this.timeSinceEngStart;
        }

        public Builder setTimeSinceEngStart(Float value) {
            this.validate(this.fields()[34], value);
            this.timeSinceEngStart = value;
            this.fieldSetFlags()[34] = true;
            return this;
        }

        public boolean hasTimeSinceEngStart() {
            return this.fieldSetFlags()[34];
        }

        public Builder clearTimeSinceEngStart() {
            this.timeSinceEngStart = null;
            this.fieldSetFlags()[34] = false;
            return this;
        }

        public Float getDistanceMilOn() {
            return this.distanceMilOn;
        }

        public Builder setDistanceMilOn(Float value) {
            this.validate(this.fields()[35], value);
            this.distanceMilOn = value;
            this.fieldSetFlags()[35] = true;
            return this;
        }

        public boolean hasDistanceMilOn() {
            return this.fieldSetFlags()[35];
        }

        public Builder clearDistanceMilOn() {
            this.distanceMilOn = null;
            this.fieldSetFlags()[35] = false;
            return this;
        }

        public Float getFuelRailPres() {
            return this.fuelRailPres;
        }

        public Builder setFuelRailPres(Float value) {
            this.validate(this.fields()[36], value);
            this.fuelRailPres = value;
            this.fieldSetFlags()[36] = true;
            return this;
        }

        public boolean hasFuelRailPres() {
            return this.fieldSetFlags()[36];
        }

        public Builder clearFuelRailPres() {
            this.fuelRailPres = null;
            this.fieldSetFlags()[36] = false;
            return this;
        }

        public Float getFuelRailGaug() {
            return this.fuelRailGaug;
        }

        public Builder setFuelRailGaug(Float value) {
            this.validate(this.fields()[37], value);
            this.fuelRailGaug = value;
            this.fieldSetFlags()[37] = true;
            return this;
        }

        public boolean hasFuelRailGaug() {
            return this.fieldSetFlags()[37];
        }

        public Builder clearFuelRailGaug() {
            this.fuelRailGaug = null;
            this.fieldSetFlags()[37] = false;
            return this;
        }

        public Float getOxySensor1Faer24() {
            return this.oxySensor1Faer24;
        }

        public Builder setOxySensor1Faer24(Float value) {
            this.validate(this.fields()[38], value);
            this.oxySensor1Faer24 = value;
            this.fieldSetFlags()[38] = true;
            return this;
        }

        public boolean hasOxySensor1Faer24() {
            return this.fieldSetFlags()[38];
        }

        public Builder clearOxySensor1Faer24() {
            this.oxySensor1Faer24 = null;
            this.fieldSetFlags()[38] = false;
            return this;
        }

        public Float getOxySensor1Volt24() {
            return this.oxySensor1Volt24;
        }

        public Builder setOxySensor1Volt24(Float value) {
            this.validate(this.fields()[39], value);
            this.oxySensor1Volt24 = value;
            this.fieldSetFlags()[39] = true;
            return this;
        }

        public boolean hasOxySensor1Volt24() {
            return this.fieldSetFlags()[39];
        }

        public Builder clearOxySensor1Volt24() {
            this.oxySensor1Volt24 = null;
            this.fieldSetFlags()[39] = false;
            return this;
        }

        public Float getOxySensor2Faer25() {
            return this.oxySensor2Faer25;
        }

        public Builder setOxySensor2Faer25(Float value) {
            this.validate(this.fields()[40], value);
            this.oxySensor2Faer25 = value;
            this.fieldSetFlags()[40] = true;
            return this;
        }

        public boolean hasOxySensor2Faer25() {
            return this.fieldSetFlags()[40];
        }

        public Builder clearOxySensor2Faer25() {
            this.oxySensor2Faer25 = null;
            this.fieldSetFlags()[40] = false;
            return this;
        }

        public Float getOxySensor2Volt25() {
            return this.oxySensor2Volt25;
        }

        public Builder setOxySensor2Volt25(Float value) {
            this.validate(this.fields()[41], value);
            this.oxySensor2Volt25 = value;
            this.fieldSetFlags()[41] = true;
            return this;
        }

        public boolean hasOxySensor2Volt25() {
            return this.fieldSetFlags()[41];
        }

        public Builder clearOxySensor2Volt25() {
            this.oxySensor2Volt25 = null;
            this.fieldSetFlags()[41] = false;
            return this;
        }

        public Float getOxySensor3Faer26() {
            return this.oxySensor3Faer26;
        }

        public Builder setOxySensor3Faer26(Float value) {
            this.validate(this.fields()[42], value);
            this.oxySensor3Faer26 = value;
            this.fieldSetFlags()[42] = true;
            return this;
        }

        public boolean hasOxySensor3Faer26() {
            return this.fieldSetFlags()[42];
        }

        public Builder clearOxySensor3Faer26() {
            this.oxySensor3Faer26 = null;
            this.fieldSetFlags()[42] = false;
            return this;
        }

        public Float getOxySensor3Volt26() {
            return this.oxySensor3Volt26;
        }

        public Builder setOxySensor3Volt26(Float value) {
            this.validate(this.fields()[43], value);
            this.oxySensor3Volt26 = value;
            this.fieldSetFlags()[43] = true;
            return this;
        }

        public boolean hasOxySensor3Volt26() {
            return this.fieldSetFlags()[43];
        }

        public Builder clearOxySensor3Volt26() {
            this.oxySensor3Volt26 = null;
            this.fieldSetFlags()[43] = false;
            return this;
        }

        public Float getOxySensor4Faer27() {
            return this.oxySensor4Faer27;
        }

        public Builder setOxySensor4Faer27(Float value) {
            this.validate(this.fields()[44], value);
            this.oxySensor4Faer27 = value;
            this.fieldSetFlags()[44] = true;
            return this;
        }

        public boolean hasOxySensor4Faer27() {
            return this.fieldSetFlags()[44];
        }

        public Builder clearOxySensor4Faer27() {
            this.oxySensor4Faer27 = null;
            this.fieldSetFlags()[44] = false;
            return this;
        }

        public Float getOxySensor4Volt27() {
            return this.oxySensor4Volt27;
        }

        public Builder setOxySensor4Volt27(Float value) {
            this.validate(this.fields()[45], value);
            this.oxySensor4Volt27 = value;
            this.fieldSetFlags()[45] = true;
            return this;
        }

        public boolean hasOxySensor4Volt27() {
            return this.fieldSetFlags()[45];
        }

        public Builder clearOxySensor4Volt27() {
            this.oxySensor4Volt27 = null;
            this.fieldSetFlags()[45] = false;
            return this;
        }

        public Float getOxySensor5Faer28() {
            return this.oxySensor5Faer28;
        }

        public Builder setOxySensor5Faer28(Float value) {
            this.validate(this.fields()[46], value);
            this.oxySensor5Faer28 = value;
            this.fieldSetFlags()[46] = true;
            return this;
        }

        public boolean hasOxySensor5Faer28() {
            return this.fieldSetFlags()[46];
        }

        public Builder clearOxySensor5Faer28() {
            this.oxySensor5Faer28 = null;
            this.fieldSetFlags()[46] = false;
            return this;
        }

        public Float getOxySensor5Volt28() {
            return this.oxySensor5Volt28;
        }

        public Builder setOxySensor5Volt28(Float value) {
            this.validate(this.fields()[47], value);
            this.oxySensor5Volt28 = value;
            this.fieldSetFlags()[47] = true;
            return this;
        }

        public boolean hasOxySensor5Volt28() {
            return this.fieldSetFlags()[47];
        }

        public Builder clearOxySensor5Volt28() {
            this.oxySensor5Volt28 = null;
            this.fieldSetFlags()[47] = false;
            return this;
        }

        public Float getOxySensor6Faer29() {
            return this.oxySensor6Faer29;
        }

        public Builder setOxySensor6Faer29(Float value) {
            this.validate(this.fields()[48], value);
            this.oxySensor6Faer29 = value;
            this.fieldSetFlags()[48] = true;
            return this;
        }

        public boolean hasOxySensor6Faer29() {
            return this.fieldSetFlags()[48];
        }

        public Builder clearOxySensor6Faer29() {
            this.oxySensor6Faer29 = null;
            this.fieldSetFlags()[48] = false;
            return this;
        }

        public Float getOxySensor6Volt29() {
            return this.oxySensor6Volt29;
        }

        public Builder setOxySensor6Volt29(Float value) {
            this.validate(this.fields()[49], value);
            this.oxySensor6Volt29 = value;
            this.fieldSetFlags()[49] = true;
            return this;
        }

        public boolean hasOxySensor6Volt29() {
            return this.fieldSetFlags()[49];
        }

        public Builder clearOxySensor6Volt29() {
            this.oxySensor6Volt29 = null;
            this.fieldSetFlags()[49] = false;
            return this;
        }

        public Float getOxySensor7Faer2A() {
            return this.oxySensor7Faer2A;
        }

        public Builder setOxySensor7Faer2A(Float value) {
            this.validate(this.fields()[50], value);
            this.oxySensor7Faer2A = value;
            this.fieldSetFlags()[50] = true;
            return this;
        }

        public boolean hasOxySensor7Faer2A() {
            return this.fieldSetFlags()[50];
        }

        public Builder clearOxySensor7Faer2A() {
            this.oxySensor7Faer2A = null;
            this.fieldSetFlags()[50] = false;
            return this;
        }

        public Float getOxySensor7Volt2A() {
            return this.oxySensor7Volt2A;
        }

        public Builder setOxySensor7Volt2A(Float value) {
            this.validate(this.fields()[51], value);
            this.oxySensor7Volt2A = value;
            this.fieldSetFlags()[51] = true;
            return this;
        }

        public boolean hasOxySensor7Volt2A() {
            return this.fieldSetFlags()[51];
        }

        public Builder clearOxySensor7Volt2A() {
            this.oxySensor7Volt2A = null;
            this.fieldSetFlags()[51] = false;
            return this;
        }

        public Float getOxySensor8Faer2B() {
            return this.oxySensor8Faer2B;
        }

        public Builder setOxySensor8Faer2B(Float value) {
            this.validate(this.fields()[52], value);
            this.oxySensor8Faer2B = value;
            this.fieldSetFlags()[52] = true;
            return this;
        }

        public boolean hasOxySensor8Faer2B() {
            return this.fieldSetFlags()[52];
        }

        public Builder clearOxySensor8Faer2B() {
            this.oxySensor8Faer2B = null;
            this.fieldSetFlags()[52] = false;
            return this;
        }

        public Float getOxySensor8Volt2B() {
            return this.oxySensor8Volt2B;
        }

        public Builder setOxySensor8Volt2B(Float value) {
            this.validate(this.fields()[53], value);
            this.oxySensor8Volt2B = value;
            this.fieldSetFlags()[53] = true;
            return this;
        }

        public boolean hasOxySensor8Volt2B() {
            return this.fieldSetFlags()[53];
        }

        public Builder clearOxySensor8Volt2B() {
            this.oxySensor8Volt2B = null;
            this.fieldSetFlags()[53] = false;
            return this;
        }

        public Float getCmdEgr() {
            return this.cmdEgr;
        }

        public Builder setCmdEgr(Float value) {
            this.validate(this.fields()[54], value);
            this.cmdEgr = value;
            this.fieldSetFlags()[54] = true;
            return this;
        }

        public boolean hasCmdEgr() {
            return this.fieldSetFlags()[54];
        }

        public Builder clearCmdEgr() {
            this.cmdEgr = null;
            this.fieldSetFlags()[54] = false;
            return this;
        }

        public Float getEgrError() {
            return this.egrError;
        }

        public Builder setEgrError(Float value) {
            this.validate(this.fields()[55], value);
            this.egrError = value;
            this.fieldSetFlags()[55] = true;
            return this;
        }

        public boolean hasEgrError() {
            return this.fieldSetFlags()[55];
        }

        public Builder clearEgrError() {
            this.egrError = null;
            this.fieldSetFlags()[55] = false;
            return this;
        }

        public Float getCmdEvapPurge() {
            return this.cmdEvapPurge;
        }

        public Builder setCmdEvapPurge(Float value) {
            this.validate(this.fields()[56], value);
            this.cmdEvapPurge = value;
            this.fieldSetFlags()[56] = true;
            return this;
        }

        public boolean hasCmdEvapPurge() {
            return this.fieldSetFlags()[56];
        }

        public Builder clearCmdEvapPurge() {
            this.cmdEvapPurge = null;
            this.fieldSetFlags()[56] = false;
            return this;
        }

        public Float getFuelTankLevel() {
            return this.fuelTankLevel;
        }

        public Builder setFuelTankLevel(Float value) {
            this.validate(this.fields()[57], value);
            this.fuelTankLevel = value;
            this.fieldSetFlags()[57] = true;
            return this;
        }

        public boolean hasFuelTankLevel() {
            return this.fieldSetFlags()[57];
        }

        public Builder clearFuelTankLevel() {
            this.fuelTankLevel = null;
            this.fieldSetFlags()[57] = false;
            return this;
        }

        public Float getWarmUpsSinceCodeClear() {
            return this.warmUpsSinceCodeClear;
        }

        public Builder setWarmUpsSinceCodeClear(Float value) {
            this.validate(this.fields()[58], value);
            this.warmUpsSinceCodeClear = value;
            this.fieldSetFlags()[58] = true;
            return this;
        }

        public boolean hasWarmUpsSinceCodeClear() {
            return this.fieldSetFlags()[58];
        }

        public Builder clearWarmUpsSinceCodeClear() {
            this.warmUpsSinceCodeClear = null;
            this.fieldSetFlags()[58] = false;
            return this;
        }

        public Float getDistanceSinceCodeClear() {
            return this.distanceSinceCodeClear;
        }

        public Builder setDistanceSinceCodeClear(Float value) {
            this.validate(this.fields()[59], value);
            this.distanceSinceCodeClear = value;
            this.fieldSetFlags()[59] = true;
            return this;
        }

        public boolean hasDistanceSinceCodeClear() {
            return this.fieldSetFlags()[59];
        }

        public Builder clearDistanceSinceCodeClear() {
            this.distanceSinceCodeClear = null;
            this.fieldSetFlags()[59] = false;
            return this;
        }

        public Float getEvapSysVaporPres() {
            return this.evapSysVaporPres;
        }

        public Builder setEvapSysVaporPres(Float value) {
            this.validate(this.fields()[60], value);
            this.evapSysVaporPres = value;
            this.fieldSetFlags()[60] = true;
            return this;
        }

        public boolean hasEvapSysVaporPres() {
            return this.fieldSetFlags()[60];
        }

        public Builder clearEvapSysVaporPres() {
            this.evapSysVaporPres = null;
            this.fieldSetFlags()[60] = false;
            return this;
        }

        public Float getAbsBaroPres() {
            return this.absBaroPres;
        }

        public Builder setAbsBaroPres(Float value) {
            this.validate(this.fields()[61], value);
            this.absBaroPres = value;
            this.fieldSetFlags()[61] = true;
            return this;
        }

        public boolean hasAbsBaroPres() {
            return this.fieldSetFlags()[61];
        }

        public Builder clearAbsBaroPres() {
            this.absBaroPres = null;
            this.fieldSetFlags()[61] = false;
            return this;
        }

        public Float getOxySensor1Faer34() {
            return this.oxySensor1Faer34;
        }

        public Builder setOxySensor1Faer34(Float value) {
            this.validate(this.fields()[62], value);
            this.oxySensor1Faer34 = value;
            this.fieldSetFlags()[62] = true;
            return this;
        }

        public boolean hasOxySensor1Faer34() {
            return this.fieldSetFlags()[62];
        }

        public Builder clearOxySensor1Faer34() {
            this.oxySensor1Faer34 = null;
            this.fieldSetFlags()[62] = false;
            return this;
        }

        public Float getOxySensor1Crnt() {
            return this.oxySensor1Crnt;
        }

        public Builder setOxySensor1Crnt(Float value) {
            this.validate(this.fields()[63], value);
            this.oxySensor1Crnt = value;
            this.fieldSetFlags()[63] = true;
            return this;
        }

        public boolean hasOxySensor1Crnt() {
            return this.fieldSetFlags()[63];
        }

        public Builder clearOxySensor1Crnt() {
            this.oxySensor1Crnt = null;
            this.fieldSetFlags()[63] = false;
            return this;
        }

        public Float getOxySensor2Faer35() {
            return this.oxySensor2Faer35;
        }

        public Builder setOxySensor2Faer35(Float value) {
            this.validate(this.fields()[64], value);
            this.oxySensor2Faer35 = value;
            this.fieldSetFlags()[64] = true;
            return this;
        }

        public boolean hasOxySensor2Faer35() {
            return this.fieldSetFlags()[64];
        }

        public Builder clearOxySensor2Faer35() {
            this.oxySensor2Faer35 = null;
            this.fieldSetFlags()[64] = false;
            return this;
        }

        public Float getOxySensor2Crnt() {
            return this.oxySensor2Crnt;
        }

        public Builder setOxySensor2Crnt(Float value) {
            this.validate(this.fields()[65], value);
            this.oxySensor2Crnt = value;
            this.fieldSetFlags()[65] = true;
            return this;
        }

        public boolean hasOxySensor2Crnt() {
            return this.fieldSetFlags()[65];
        }

        public Builder clearOxySensor2Crnt() {
            this.oxySensor2Crnt = null;
            this.fieldSetFlags()[65] = false;
            return this;
        }

        public Float getOxySensor3Faer36() {
            return this.oxySensor3Faer36;
        }

        public Builder setOxySensor3Faer36(Float value) {
            this.validate(this.fields()[66], value);
            this.oxySensor3Faer36 = value;
            this.fieldSetFlags()[66] = true;
            return this;
        }

        public boolean hasOxySensor3Faer36() {
            return this.fieldSetFlags()[66];
        }

        public Builder clearOxySensor3Faer36() {
            this.oxySensor3Faer36 = null;
            this.fieldSetFlags()[66] = false;
            return this;
        }

        public Float getOxySensor3Crnt() {
            return this.oxySensor3Crnt;
        }

        public Builder setOxySensor3Crnt(Float value) {
            this.validate(this.fields()[67], value);
            this.oxySensor3Crnt = value;
            this.fieldSetFlags()[67] = true;
            return this;
        }

        public boolean hasOxySensor3Crnt() {
            return this.fieldSetFlags()[67];
        }

        public Builder clearOxySensor3Crnt() {
            this.oxySensor3Crnt = null;
            this.fieldSetFlags()[67] = false;
            return this;
        }

        public Float getOxySensor4Faer37() {
            return this.oxySensor4Faer37;
        }

        public Builder setOxySensor4Faer37(Float value) {
            this.validate(this.fields()[68], value);
            this.oxySensor4Faer37 = value;
            this.fieldSetFlags()[68] = true;
            return this;
        }

        public boolean hasOxySensor4Faer37() {
            return this.fieldSetFlags()[68];
        }

        public Builder clearOxySensor4Faer37() {
            this.oxySensor4Faer37 = null;
            this.fieldSetFlags()[68] = false;
            return this;
        }

        public Float getOxySensor4Crnt() {
            return this.oxySensor4Crnt;
        }

        public Builder setOxySensor4Crnt(Float value) {
            this.validate(this.fields()[69], value);
            this.oxySensor4Crnt = value;
            this.fieldSetFlags()[69] = true;
            return this;
        }

        public boolean hasOxySensor4Crnt() {
            return this.fieldSetFlags()[69];
        }

        public Builder clearOxySensor4Crnt() {
            this.oxySensor4Crnt = null;
            this.fieldSetFlags()[69] = false;
            return this;
        }

        public Float getOxySensor5Faer38() {
            return this.oxySensor5Faer38;
        }

        public Builder setOxySensor5Faer38(Float value) {
            this.validate(this.fields()[70], value);
            this.oxySensor5Faer38 = value;
            this.fieldSetFlags()[70] = true;
            return this;
        }

        public boolean hasOxySensor5Faer38() {
            return this.fieldSetFlags()[70];
        }

        public Builder clearOxySensor5Faer38() {
            this.oxySensor5Faer38 = null;
            this.fieldSetFlags()[70] = false;
            return this;
        }

        public Float getOxySensor5Crnt() {
            return this.oxySensor5Crnt;
        }

        public Builder setOxySensor5Crnt(Float value) {
            this.validate(this.fields()[71], value);
            this.oxySensor5Crnt = value;
            this.fieldSetFlags()[71] = true;
            return this;
        }

        public boolean hasOxySensor5Crnt() {
            return this.fieldSetFlags()[71];
        }

        public Builder clearOxySensor5Crnt() {
            this.oxySensor5Crnt = null;
            this.fieldSetFlags()[71] = false;
            return this;
        }

        public Float getOxySensor6Faer39() {
            return this.oxySensor6Faer39;
        }

        public Builder setOxySensor6Faer39(Float value) {
            this.validate(this.fields()[72], value);
            this.oxySensor6Faer39 = value;
            this.fieldSetFlags()[72] = true;
            return this;
        }

        public boolean hasOxySensor6Faer39() {
            return this.fieldSetFlags()[72];
        }

        public Builder clearOxySensor6Faer39() {
            this.oxySensor6Faer39 = null;
            this.fieldSetFlags()[72] = false;
            return this;
        }

        public Float getOxySensor6Crnt() {
            return this.oxySensor6Crnt;
        }

        public Builder setOxySensor6Crnt(Float value) {
            this.validate(this.fields()[73], value);
            this.oxySensor6Crnt = value;
            this.fieldSetFlags()[73] = true;
            return this;
        }

        public boolean hasOxySensor6Crnt() {
            return this.fieldSetFlags()[73];
        }

        public Builder clearOxySensor6Crnt() {
            this.oxySensor6Crnt = null;
            this.fieldSetFlags()[73] = false;
            return this;
        }

        public Float getOxySensor7Faer3A() {
            return this.oxySensor7Faer3A;
        }

        public Builder setOxySensor7Faer3A(Float value) {
            this.validate(this.fields()[74], value);
            this.oxySensor7Faer3A = value;
            this.fieldSetFlags()[74] = true;
            return this;
        }

        public boolean hasOxySensor7Faer3A() {
            return this.fieldSetFlags()[74];
        }

        public Builder clearOxySensor7Faer3A() {
            this.oxySensor7Faer3A = null;
            this.fieldSetFlags()[74] = false;
            return this;
        }

        public Float getOxySensor7Crnt() {
            return this.oxySensor7Crnt;
        }

        public Builder setOxySensor7Crnt(Float value) {
            this.validate(this.fields()[75], value);
            this.oxySensor7Crnt = value;
            this.fieldSetFlags()[75] = true;
            return this;
        }

        public boolean hasOxySensor7Crnt() {
            return this.fieldSetFlags()[75];
        }

        public Builder clearOxySensor7Crnt() {
            this.oxySensor7Crnt = null;
            this.fieldSetFlags()[75] = false;
            return this;
        }

        public Float getOxySensor8Faer3B() {
            return this.oxySensor8Faer3B;
        }

        public Builder setOxySensor8Faer3B(Float value) {
            this.validate(this.fields()[76], value);
            this.oxySensor8Faer3B = value;
            this.fieldSetFlags()[76] = true;
            return this;
        }

        public boolean hasOxySensor8Faer3B() {
            return this.fieldSetFlags()[76];
        }

        public Builder clearOxySensor8Faer3B() {
            this.oxySensor8Faer3B = null;
            this.fieldSetFlags()[76] = false;
            return this;
        }

        public Float getOxySensor8Crnt() {
            return this.oxySensor8Crnt;
        }

        public Builder setOxySensor8Crnt(Float value) {
            this.validate(this.fields()[77], value);
            this.oxySensor8Crnt = value;
            this.fieldSetFlags()[77] = true;
            return this;
        }

        public boolean hasOxySensor8Crnt() {
            return this.fieldSetFlags()[77];
        }

        public Builder clearOxySensor8Crnt() {
            this.oxySensor8Crnt = null;
            this.fieldSetFlags()[77] = false;
            return this;
        }

        public Float getCatTempBank1Sens1() {
            return this.catTempBank1Sens1;
        }

        public Builder setCatTempBank1Sens1(Float value) {
            this.validate(this.fields()[78], value);
            this.catTempBank1Sens1 = value;
            this.fieldSetFlags()[78] = true;
            return this;
        }

        public boolean hasCatTempBank1Sens1() {
            return this.fieldSetFlags()[78];
        }

        public Builder clearCatTempBank1Sens1() {
            this.catTempBank1Sens1 = null;
            this.fieldSetFlags()[78] = false;
            return this;
        }

        public Float getCatTempBank2Sens1() {
            return this.catTempBank2Sens1;
        }

        public Builder setCatTempBank2Sens1(Float value) {
            this.validate(this.fields()[79], value);
            this.catTempBank2Sens1 = value;
            this.fieldSetFlags()[79] = true;
            return this;
        }

        public boolean hasCatTempBank2Sens1() {
            return this.fieldSetFlags()[79];
        }

        public Builder clearCatTempBank2Sens1() {
            this.catTempBank2Sens1 = null;
            this.fieldSetFlags()[79] = false;
            return this;
        }

        public Float getCatTempBank1Sens2() {
            return this.catTempBank1Sens2;
        }

        public Builder setCatTempBank1Sens2(Float value) {
            this.validate(this.fields()[80], value);
            this.catTempBank1Sens2 = value;
            this.fieldSetFlags()[80] = true;
            return this;
        }

        public boolean hasCatTempBank1Sens2() {
            return this.fieldSetFlags()[80];
        }

        public Builder clearCatTempBank1Sens2() {
            this.catTempBank1Sens2 = null;
            this.fieldSetFlags()[80] = false;
            return this;
        }

        public Float getCatTempBank2Sens2() {
            return this.catTempBank2Sens2;
        }

        public Builder setCatTempBank2Sens2(Float value) {
            this.validate(this.fields()[81], value);
            this.catTempBank2Sens2 = value;
            this.fieldSetFlags()[81] = true;
            return this;
        }

        public boolean hasCatTempBank2Sens2() {
            return this.fieldSetFlags()[81];
        }

        public Builder clearCatTempBank2Sens2() {
            this.catTempBank2Sens2 = null;
            this.fieldSetFlags()[81] = false;
            return this;
        }

        public Float getMonStatusDriveCycle() {
            return this.monStatusDriveCycle;
        }

        public Builder setMonStatusDriveCycle(Float value) {
            this.validate(this.fields()[82], value);
            this.monStatusDriveCycle = value;
            this.fieldSetFlags()[82] = true;
            return this;
        }

        public boolean hasMonStatusDriveCycle() {
            return this.fieldSetFlags()[82];
        }

        public Builder clearMonStatusDriveCycle() {
            this.monStatusDriveCycle = null;
            this.fieldSetFlags()[82] = false;
            return this;
        }

        public Float getControlModuleVolt() {
            return this.controlModuleVolt;
        }

        public Builder setControlModuleVolt(Float value) {
            this.validate(this.fields()[83], value);
            this.controlModuleVolt = value;
            this.fieldSetFlags()[83] = true;
            return this;
        }

        public boolean hasControlModuleVolt() {
            return this.fieldSetFlags()[83];
        }

        public Builder clearControlModuleVolt() {
            this.controlModuleVolt = null;
            this.fieldSetFlags()[83] = false;
            return this;
        }

        public Float getAbsLoadValue() {
            return this.absLoadValue;
        }

        public Builder setAbsLoadValue(Float value) {
            this.validate(this.fields()[84], value);
            this.absLoadValue = value;
            this.fieldSetFlags()[84] = true;
            return this;
        }

        public boolean hasAbsLoadValue() {
            return this.fieldSetFlags()[84];
        }

        public Builder clearAbsLoadValue() {
            this.absLoadValue = null;
            this.fieldSetFlags()[84] = false;
            return this;
        }

        public Float getFuelAirCmdEquiv() {
            return this.fuelAirCmdEquiv;
        }

        public Builder setFuelAirCmdEquiv(Float value) {
            this.validate(this.fields()[85], value);
            this.fuelAirCmdEquiv = value;
            this.fieldSetFlags()[85] = true;
            return this;
        }

        public boolean hasFuelAirCmdEquiv() {
            return this.fieldSetFlags()[85];
        }

        public Builder clearFuelAirCmdEquiv() {
            this.fuelAirCmdEquiv = null;
            this.fieldSetFlags()[85] = false;
            return this;
        }

        public Float getRelThrottlePos() {
            return this.relThrottlePos;
        }

        public Builder setRelThrottlePos(Float value) {
            this.validate(this.fields()[86], value);
            this.relThrottlePos = value;
            this.fieldSetFlags()[86] = true;
            return this;
        }

        public boolean hasRelThrottlePos() {
            return this.fieldSetFlags()[86];
        }

        public Builder clearRelThrottlePos() {
            this.relThrottlePos = null;
            this.fieldSetFlags()[86] = false;
            return this;
        }

        public Float getAmbientAirTemp() {
            return this.ambientAirTemp;
        }

        public Builder setAmbientAirTemp(Float value) {
            this.validate(this.fields()[87], value);
            this.ambientAirTemp = value;
            this.fieldSetFlags()[87] = true;
            return this;
        }

        public boolean hasAmbientAirTemp() {
            return this.fieldSetFlags()[87];
        }

        public Builder clearAmbientAirTemp() {
            this.ambientAirTemp = null;
            this.fieldSetFlags()[87] = false;
            return this;
        }

        public Float getAbsThrottlePosB() {
            return this.absThrottlePosB;
        }

        public Builder setAbsThrottlePosB(Float value) {
            this.validate(this.fields()[88], value);
            this.absThrottlePosB = value;
            this.fieldSetFlags()[88] = true;
            return this;
        }

        public boolean hasAbsThrottlePosB() {
            return this.fieldSetFlags()[88];
        }

        public Builder clearAbsThrottlePosB() {
            this.absThrottlePosB = null;
            this.fieldSetFlags()[88] = false;
            return this;
        }

        public Float getAbsThrottlePosC() {
            return this.absThrottlePosC;
        }

        public Builder setAbsThrottlePosC(Float value) {
            this.validate(this.fields()[89], value);
            this.absThrottlePosC = value;
            this.fieldSetFlags()[89] = true;
            return this;
        }

        public boolean hasAbsThrottlePosC() {
            return this.fieldSetFlags()[89];
        }

        public Builder clearAbsThrottlePosC() {
            this.absThrottlePosC = null;
            this.fieldSetFlags()[89] = false;
            return this;
        }

        public Float getAbsThrottlePosCd() {
            return this.absThrottlePosCd;
        }

        public Builder setAbsThrottlePosCd(Float value) {
            this.validate(this.fields()[90], value);
            this.absThrottlePosCd = value;
            this.fieldSetFlags()[90] = true;
            return this;
        }

        public boolean hasAbsThrottlePosCd() {
            return this.fieldSetFlags()[90];
        }

        public Builder clearAbsThrottlePosCd() {
            this.absThrottlePosCd = null;
            this.fieldSetFlags()[90] = false;
            return this;
        }

        public Float getAbsThrottlePosE() {
            return this.absThrottlePosE;
        }

        public Builder setAbsThrottlePosE(Float value) {
            this.validate(this.fields()[91], value);
            this.absThrottlePosE = value;
            this.fieldSetFlags()[91] = true;
            return this;
        }

        public boolean hasAbsThrottlePosE() {
            return this.fieldSetFlags()[91];
        }

        public Builder clearAbsThrottlePosE() {
            this.absThrottlePosE = null;
            this.fieldSetFlags()[91] = false;
            return this;
        }

        public Float getAbsThrottlePosF() {
            return this.absThrottlePosF;
        }

        public Builder setAbsThrottlePosF(Float value) {
            this.validate(this.fields()[92], value);
            this.absThrottlePosF = value;
            this.fieldSetFlags()[92] = true;
            return this;
        }

        public boolean hasAbsThrottlePosF() {
            return this.fieldSetFlags()[92];
        }

        public Builder clearAbsThrottlePosF() {
            this.absThrottlePosF = null;
            this.fieldSetFlags()[92] = false;
            return this;
        }

        public Float getCmdThrottleAct() {
            return this.cmdThrottleAct;
        }

        public Builder setCmdThrottleAct(Float value) {
            this.validate(this.fields()[93], value);
            this.cmdThrottleAct = value;
            this.fieldSetFlags()[93] = true;
            return this;
        }

        public boolean hasCmdThrottleAct() {
            return this.fieldSetFlags()[93];
        }

        public Builder clearCmdThrottleAct() {
            this.cmdThrottleAct = null;
            this.fieldSetFlags()[93] = false;
            return this;
        }

        public Float getTimeRunMilOn() {
            return this.timeRunMilOn;
        }

        public Builder setTimeRunMilOn(Float value) {
            this.validate(this.fields()[94], value);
            this.timeRunMilOn = value;
            this.fieldSetFlags()[94] = true;
            return this;
        }

        public boolean hasTimeRunMilOn() {
            return this.fieldSetFlags()[94];
        }

        public Builder clearTimeRunMilOn() {
            this.timeRunMilOn = null;
            this.fieldSetFlags()[94] = false;
            return this;
        }

        public Float getTimeSinceCodeClear() {
            return this.timeSinceCodeClear;
        }

        public Builder setTimeSinceCodeClear(Float value) {
            this.validate(this.fields()[95], value);
            this.timeSinceCodeClear = value;
            this.fieldSetFlags()[95] = true;
            return this;
        }

        public boolean hasTimeSinceCodeClear() {
            return this.fieldSetFlags()[95];
        }

        public Builder clearTimeSinceCodeClear() {
            this.timeSinceCodeClear = null;
            this.fieldSetFlags()[95] = false;
            return this;
        }

        public Float getMaxFaer() {
            return this.maxFaer;
        }

        public Builder setMaxFaer(Float value) {
            this.validate(this.fields()[96], value);
            this.maxFaer = value;
            this.fieldSetFlags()[96] = true;
            return this;
        }

        public boolean hasMaxFaer() {
            return this.fieldSetFlags()[96];
        }

        public Builder clearMaxFaer() {
            this.maxFaer = null;
            this.fieldSetFlags()[96] = false;
            return this;
        }

        public Float getMaxOxySensVol() {
            return this.maxOxySensVol;
        }

        public Builder setMaxOxySensVol(Float value) {
            this.validate(this.fields()[97], value);
            this.maxOxySensVol = value;
            this.fieldSetFlags()[97] = true;
            return this;
        }

        public boolean hasMaxOxySensVol() {
            return this.fieldSetFlags()[97];
        }

        public Builder clearMaxOxySensVol() {
            this.maxOxySensVol = null;
            this.fieldSetFlags()[97] = false;
            return this;
        }

        public Float getMaxOxySensCrnt() {
            return this.maxOxySensCrnt;
        }

        public Builder setMaxOxySensCrnt(Float value) {
            this.validate(this.fields()[98], value);
            this.maxOxySensCrnt = value;
            this.fieldSetFlags()[98] = true;
            return this;
        }

        public boolean hasMaxOxySensCrnt() {
            return this.fieldSetFlags()[98];
        }

        public Builder clearMaxOxySensCrnt() {
            this.maxOxySensCrnt = null;
            this.fieldSetFlags()[98] = false;
            return this;
        }

        public Float getMaxIntManiAbsPres() {
            return this.maxIntManiAbsPres;
        }

        public Builder setMaxIntManiAbsPres(Float value) {
            this.validate(this.fields()[99], value);
            this.maxIntManiAbsPres = value;
            this.fieldSetFlags()[99] = true;
            return this;
        }

        public boolean hasMaxIntManiAbsPres() {
            return this.fieldSetFlags()[99];
        }

        public Builder clearMaxIntManiAbsPres() {
            this.maxIntManiAbsPres = null;
            this.fieldSetFlags()[99] = false;
            return this;
        }

        public Float getMaxAirFlowMaf() {
            return this.maxAirFlowMaf;
        }

        public Builder setMaxAirFlowMaf(Float value) {
            this.validate(this.fields()[100], value);
            this.maxAirFlowMaf = value;
            this.fieldSetFlags()[100] = true;
            return this;
        }

        public boolean hasMaxAirFlowMaf() {
            return this.fieldSetFlags()[100];
        }

        public Builder clearMaxAirFlowMaf() {
            this.maxAirFlowMaf = null;
            this.fieldSetFlags()[100] = false;
            return this;
        }

        public Float getFuelType() {
            return this.fuelType;
        }

        public Builder setFuelType(Float value) {
            this.validate(this.fields()[101], value);
            this.fuelType = value;
            this.fieldSetFlags()[101] = true;
            return this;
        }

        public boolean hasFuelType() {
            return this.fieldSetFlags()[101];
        }

        public Builder clearFuelType() {
            this.fuelType = null;
            this.fieldSetFlags()[101] = false;
            return this;
        }

        public Float getEthanolFuelPct() {
            return this.ethanolFuelPct;
        }

        public Builder setEthanolFuelPct(Float value) {
            this.validate(this.fields()[102], value);
            this.ethanolFuelPct = value;
            this.fieldSetFlags()[102] = true;
            return this;
        }

        public boolean hasEthanolFuelPct() {
            return this.fieldSetFlags()[102];
        }

        public Builder clearEthanolFuelPct() {
            this.ethanolFuelPct = null;
            this.fieldSetFlags()[102] = false;
            return this;
        }

        public Float getAbsEvapSysVapPres() {
            return this.absEvapSysVapPres;
        }

        public Builder setAbsEvapSysVapPres(Float value) {
            this.validate(this.fields()[103], value);
            this.absEvapSysVapPres = value;
            this.fieldSetFlags()[103] = true;
            return this;
        }

        public boolean hasAbsEvapSysVapPres() {
            return this.fieldSetFlags()[103];
        }

        public Builder clearAbsEvapSysVapPres() {
            this.absEvapSysVapPres = null;
            this.fieldSetFlags()[103] = false;
            return this;
        }

        public Float getEvapSysVapPres() {
            return this.evapSysVapPres;
        }

        public Builder setEvapSysVapPres(Float value) {
            this.validate(this.fields()[104], value);
            this.evapSysVapPres = value;
            this.fieldSetFlags()[104] = true;
            return this;
        }

        public boolean hasEvapSysVapPres() {
            return this.fieldSetFlags()[104];
        }

        public Builder clearEvapSysVapPres() {
            this.evapSysVapPres = null;
            this.fieldSetFlags()[104] = false;
            return this;
        }

        public Float getShortSecOxyTrimBank1() {
            return this.shortSecOxyTrimBank1;
        }

        public Builder setShortSecOxyTrimBank1(Float value) {
            this.validate(this.fields()[105], value);
            this.shortSecOxyTrimBank1 = value;
            this.fieldSetFlags()[105] = true;
            return this;
        }

        public boolean hasShortSecOxyTrimBank1() {
            return this.fieldSetFlags()[105];
        }

        public Builder clearShortSecOxyTrimBank1() {
            this.shortSecOxyTrimBank1 = null;
            this.fieldSetFlags()[105] = false;
            return this;
        }

        public Float getShortSecOxyTrimBank3() {
            return this.shortSecOxyTrimBank3;
        }

        public Builder setShortSecOxyTrimBank3(Float value) {
            this.validate(this.fields()[106], value);
            this.shortSecOxyTrimBank3 = value;
            this.fieldSetFlags()[106] = true;
            return this;
        }

        public boolean hasShortSecOxyTrimBank3() {
            return this.fieldSetFlags()[106];
        }

        public Builder clearShortSecOxyTrimBank3() {
            this.shortSecOxyTrimBank3 = null;
            this.fieldSetFlags()[106] = false;
            return this;
        }

        public Float getLongSecOxyTrimBank1() {
            return this.longSecOxyTrimBank1;
        }

        public Builder setLongSecOxyTrimBank1(Float value) {
            this.validate(this.fields()[107], value);
            this.longSecOxyTrimBank1 = value;
            this.fieldSetFlags()[107] = true;
            return this;
        }

        public boolean hasLongSecOxyTrimBank1() {
            return this.fieldSetFlags()[107];
        }

        public Builder clearLongSecOxyTrimBank1() {
            this.longSecOxyTrimBank1 = null;
            this.fieldSetFlags()[107] = false;
            return this;
        }

        public Float getLongSecOxyTrimBank3() {
            return this.longSecOxyTrimBank3;
        }

        public Builder setLongSecOxyTrimBank3(Float value) {
            this.validate(this.fields()[108], value);
            this.longSecOxyTrimBank3 = value;
            this.fieldSetFlags()[108] = true;
            return this;
        }

        public boolean hasLongSecOxyTrimBank3() {
            return this.fieldSetFlags()[108];
        }

        public Builder clearLongSecOxyTrimBank3() {
            this.longSecOxyTrimBank3 = null;
            this.fieldSetFlags()[108] = false;
            return this;
        }

        public Float getShortSecOxyTrimBank2() {
            return this.shortSecOxyTrimBank2;
        }

        public Builder setShortSecOxyTrimBank2(Float value) {
            this.validate(this.fields()[109], value);
            this.shortSecOxyTrimBank2 = value;
            this.fieldSetFlags()[109] = true;
            return this;
        }

        public boolean hasShortSecOxyTrimBank2() {
            return this.fieldSetFlags()[109];
        }

        public Builder clearShortSecOxyTrimBank2() {
            this.shortSecOxyTrimBank2 = null;
            this.fieldSetFlags()[109] = false;
            return this;
        }

        public Float getShortSecOxyTrimBank4() {
            return this.shortSecOxyTrimBank4;
        }

        public Builder setShortSecOxyTrimBank4(Float value) {
            this.validate(this.fields()[110], value);
            this.shortSecOxyTrimBank4 = value;
            this.fieldSetFlags()[110] = true;
            return this;
        }

        public boolean hasShortSecOxyTrimBank4() {
            return this.fieldSetFlags()[110];
        }

        public Builder clearShortSecOxyTrimBank4() {
            this.shortSecOxyTrimBank4 = null;
            this.fieldSetFlags()[110] = false;
            return this;
        }

        public Float getLongSecOxyTrimBank2() {
            return this.longSecOxyTrimBank2;
        }

        public Builder setLongSecOxyTrimBank2(Float value) {
            this.validate(this.fields()[111], value);
            this.longSecOxyTrimBank2 = value;
            this.fieldSetFlags()[111] = true;
            return this;
        }

        public boolean hasLongSecOxyTrimBank2() {
            return this.fieldSetFlags()[111];
        }

        public Builder clearLongSecOxyTrimBank2() {
            this.longSecOxyTrimBank2 = null;
            this.fieldSetFlags()[111] = false;
            return this;
        }

        public Float getLongSecOxyTrimBank4() {
            return this.longSecOxyTrimBank4;
        }

        public Builder setLongSecOxyTrimBank4(Float value) {
            this.validate(this.fields()[112], value);
            this.longSecOxyTrimBank4 = value;
            this.fieldSetFlags()[112] = true;
            return this;
        }

        public boolean hasLongSecOxyTrimBank4() {
            return this.fieldSetFlags()[112];
        }

        public Builder clearLongSecOxyTrimBank4() {
            this.longSecOxyTrimBank4 = null;
            this.fieldSetFlags()[112] = false;
            return this;
        }

        public Float getFuelRailAbsPres() {
            return this.fuelRailAbsPres;
        }

        public Builder setFuelRailAbsPres(Float value) {
            this.validate(this.fields()[113], value);
            this.fuelRailAbsPres = value;
            this.fieldSetFlags()[113] = true;
            return this;
        }

        public boolean hasFuelRailAbsPres() {
            return this.fieldSetFlags()[113];
        }

        public Builder clearFuelRailAbsPres() {
            this.fuelRailAbsPres = null;
            this.fieldSetFlags()[113] = false;
            return this;
        }

        public Float getRelAccelPedalPos() {
            return this.relAccelPedalPos;
        }

        public Builder setRelAccelPedalPos(Float value) {
            this.validate(this.fields()[114], value);
            this.relAccelPedalPos = value;
            this.fieldSetFlags()[114] = true;
            return this;
        }

        public boolean hasRelAccelPedalPos() {
            return this.fieldSetFlags()[114];
        }

        public Builder clearRelAccelPedalPos() {
            this.relAccelPedalPos = null;
            this.fieldSetFlags()[114] = false;
            return this;
        }

        public Float getHybrBatPackRemLife() {
            return this.hybrBatPackRemLife;
        }

        public Builder setHybrBatPackRemLife(Float value) {
            this.validate(this.fields()[115], value);
            this.hybrBatPackRemLife = value;
            this.fieldSetFlags()[115] = true;
            return this;
        }

        public boolean hasHybrBatPackRemLife() {
            return this.fieldSetFlags()[115];
        }

        public Builder clearHybrBatPackRemLife() {
            this.hybrBatPackRemLife = null;
            this.fieldSetFlags()[115] = false;
            return this;
        }

        public Float getEngineOilTemp() {
            return this.engineOilTemp;
        }

        public Builder setEngineOilTemp(Float value) {
            this.validate(this.fields()[116], value);
            this.engineOilTemp = value;
            this.fieldSetFlags()[116] = true;
            return this;
        }

        public boolean hasEngineOilTemp() {
            return this.fieldSetFlags()[116];
        }

        public Builder clearEngineOilTemp() {
            this.engineOilTemp = null;
            this.fieldSetFlags()[116] = false;
            return this;
        }

        public Float getFuelInjectionTiming() {
            return this.fuelInjectionTiming;
        }

        public Builder setFuelInjectionTiming(Float value) {
            this.validate(this.fields()[117], value);
            this.fuelInjectionTiming = value;
            this.fieldSetFlags()[117] = true;
            return this;
        }

        public boolean hasFuelInjectionTiming() {
            return this.fieldSetFlags()[117];
        }

        public Builder clearFuelInjectionTiming() {
            this.fuelInjectionTiming = null;
            this.fieldSetFlags()[117] = false;
            return this;
        }

        public Float getEngineFuelRate() {
            return this.engineFuelRate;
        }

        public Builder setEngineFuelRate(Float value) {
            this.validate(this.fields()[118], value);
            this.engineFuelRate = value;
            this.fieldSetFlags()[118] = true;
            return this;
        }

        public boolean hasEngineFuelRate() {
            return this.fieldSetFlags()[118];
        }

        public Builder clearEngineFuelRate() {
            this.engineFuelRate = null;
            this.fieldSetFlags()[118] = false;
            return this;
        }

        public Float getEmissionReq() {
            return this.emissionReq;
        }

        public Builder setEmissionReq(Float value) {
            this.validate(this.fields()[119], value);
            this.emissionReq = value;
            this.fieldSetFlags()[119] = true;
            return this;
        }

        public boolean hasEmissionReq() {
            return this.fieldSetFlags()[119];
        }

        public Builder clearEmissionReq() {
            this.emissionReq = null;
            this.fieldSetFlags()[119] = false;
            return this;
        }

        public Float getDemandEngTorqPct() {
            return this.demandEngTorqPct;
        }

        public Builder setDemandEngTorqPct(Float value) {
            this.validate(this.fields()[120], value);
            this.demandEngTorqPct = value;
            this.fieldSetFlags()[120] = true;
            return this;
        }

        public boolean hasDemandEngTorqPct() {
            return this.fieldSetFlags()[120];
        }

        public Builder clearDemandEngTorqPct() {
            this.demandEngTorqPct = null;
            this.fieldSetFlags()[120] = false;
            return this;
        }

        public Float getActualEngTorqPct() {
            return this.actualEngTorqPct;
        }

        public Builder setActualEngTorqPct(Float value) {
            this.validate(this.fields()[121], value);
            this.actualEngTorqPct = value;
            this.fieldSetFlags()[121] = true;
            return this;
        }

        public boolean hasActualEngTorqPct() {
            return this.fieldSetFlags()[121];
        }

        public Builder clearActualEngTorqPct() {
            this.actualEngTorqPct = null;
            this.fieldSetFlags()[121] = false;
            return this;
        }

        public Float getEngRefTorq() {
            return this.engRefTorq;
        }

        public Builder setEngRefTorq(Float value) {
            this.validate(this.fields()[122], value);
            this.engRefTorq = value;
            this.fieldSetFlags()[122] = true;
            return this;
        }

        public boolean hasEngRefTorq() {
            return this.fieldSetFlags()[122];
        }

        public Builder clearEngRefTorq() {
            this.engRefTorq = null;
            this.fieldSetFlags()[122] = false;
            return this;
        }

        public Float getEngPctTorqIdle() {
            return this.engPctTorqIdle;
        }

        public Builder setEngPctTorqIdle(Float value) {
            this.validate(this.fields()[123], value);
            this.engPctTorqIdle = value;
            this.fieldSetFlags()[123] = true;
            return this;
        }

        public boolean hasEngPctTorqIdle() {
            return this.fieldSetFlags()[123];
        }

        public Builder clearEngPctTorqIdle() {
            this.engPctTorqIdle = null;
            this.fieldSetFlags()[123] = false;
            return this;
        }

        public Float getEngPctTorqEp1() {
            return this.engPctTorqEp1;
        }

        public Builder setEngPctTorqEp1(Float value) {
            this.validate(this.fields()[124], value);
            this.engPctTorqEp1 = value;
            this.fieldSetFlags()[124] = true;
            return this;
        }

        public boolean hasEngPctTorqEp1() {
            return this.fieldSetFlags()[124];
        }

        public Builder clearEngPctTorqEp1() {
            this.engPctTorqEp1 = null;
            this.fieldSetFlags()[124] = false;
            return this;
        }

        public Float getEngPctTorqEp2() {
            return this.engPctTorqEp2;
        }

        public Builder setEngPctTorqEp2(Float value) {
            this.validate(this.fields()[125], value);
            this.engPctTorqEp2 = value;
            this.fieldSetFlags()[125] = true;
            return this;
        }

        public boolean hasEngPctTorqEp2() {
            return this.fieldSetFlags()[125];
        }

        public Builder clearEngPctTorqEp2() {
            this.engPctTorqEp2 = null;
            this.fieldSetFlags()[125] = false;
            return this;
        }

        public Float getEngPctTorqEp3() {
            return this.engPctTorqEp3;
        }

        public Builder setEngPctTorqEp3(Float value) {
            this.validate(this.fields()[126], value);
            this.engPctTorqEp3 = value;
            this.fieldSetFlags()[126] = true;
            return this;
        }

        public boolean hasEngPctTorqEp3() {
            return this.fieldSetFlags()[126];
        }

        public Builder clearEngPctTorqEp3() {
            this.engPctTorqEp3 = null;
            this.fieldSetFlags()[126] = false;
            return this;
        }

        public Float getEngPctTorqEp4() {
            return this.engPctTorqEp4;
        }

        public Builder setEngPctTorqEp4(Float value) {
            this.validate(this.fields()[127], value);
            this.engPctTorqEp4 = value;
            this.fieldSetFlags()[127] = true;
            return this;
        }

        public boolean hasEngPctTorqEp4() {
            return this.fieldSetFlags()[127];
        }

        public Builder clearEngPctTorqEp4() {
            this.engPctTorqEp4 = null;
            this.fieldSetFlags()[127] = false;
            return this;
        }

        public Float getAuxInputOutput() {
            return this.auxInputOutput;
        }

        public Builder setAuxInputOutput(Float value) {
            this.validate(this.fields()[128], value);
            this.auxInputOutput = value;
            this.fieldSetFlags()[128] = true;
            return this;
        }

        public boolean hasAuxInputOutput() {
            return this.fieldSetFlags()[128];
        }

        public Builder clearAuxInputOutput() {
            this.auxInputOutput = null;
            this.fieldSetFlags()[128] = false;
            return this;
        }

        public Float getMafSensor() {
            return this.mafSensor;
        }

        public Builder setMafSensor(Float value) {
            this.validate(this.fields()[129], value);
            this.mafSensor = value;
            this.fieldSetFlags()[129] = true;
            return this;
        }

        public boolean hasMafSensor() {
            return this.fieldSetFlags()[129];
        }

        public Builder clearMafSensor() {
            this.mafSensor = null;
            this.fieldSetFlags()[129] = false;
            return this;
        }

        public Float getEngineCoolantTemp67() {
            return this.engineCoolantTemp67;
        }

        public Builder setEngineCoolantTemp67(Float value) {
            this.validate(this.fields()[130], value);
            this.engineCoolantTemp67 = value;
            this.fieldSetFlags()[130] = true;
            return this;
        }

        public boolean hasEngineCoolantTemp67() {
            return this.fieldSetFlags()[130];
        }

        public Builder clearEngineCoolantTemp67() {
            this.engineCoolantTemp67 = null;
            this.fieldSetFlags()[130] = false;
            return this;
        }

        public Float getIntakeAirTempSens() {
            return this.intakeAirTempSens;
        }

        public Builder setIntakeAirTempSens(Float value) {
            this.validate(this.fields()[131], value);
            this.intakeAirTempSens = value;
            this.fieldSetFlags()[131] = true;
            return this;
        }

        public boolean hasIntakeAirTempSens() {
            return this.fieldSetFlags()[131];
        }

        public Builder clearIntakeAirTempSens() {
            this.intakeAirTempSens = null;
            this.fieldSetFlags()[131] = false;
            return this;
        }

        public Float getEngineFrictionPercentTorque() {
            return this.engineFrictionPercentTorque;
        }

        public Builder setEngineFrictionPercentTorque(Float value) {
            this.validate(this.fields()[132], value);
            this.engineFrictionPercentTorque = value;
            this.fieldSetFlags()[132] = true;
            return this;
        }

        public boolean hasEngineFrictionPercentTorque() {
            return this.fieldSetFlags()[132];
        }

        public Builder clearEngineFrictionPercentTorque() {
            this.engineFrictionPercentTorque = null;
            this.fieldSetFlags()[132] = false;
            return this;
        }

        public CanEdgeObd2 build() {
            try {
                CanEdgeObd2 record = new CanEdgeObd2();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.fuelSystemStatus = this.fieldSetFlags()[2] ? this.fuelSystemStatus : (Float)this.defaultValue(this.fields()[2]);
                record.calcEngineLoad = this.fieldSetFlags()[3] ? this.calcEngineLoad : (Float)this.defaultValue(this.fields()[3]);
                record.engineCoolantTemp = this.fieldSetFlags()[4] ? this.engineCoolantTemp : (Float)this.defaultValue(this.fields()[4]);
                record.shortFuelTrimBank1 = this.fieldSetFlags()[5] ? this.shortFuelTrimBank1 : (Float)this.defaultValue(this.fields()[5]);
                record.longFuelTrimBank1 = this.fieldSetFlags()[6] ? this.longFuelTrimBank1 : (Float)this.defaultValue(this.fields()[6]);
                record.shortFuelTrimBank2 = this.fieldSetFlags()[7] ? this.shortFuelTrimBank2 : (Float)this.defaultValue(this.fields()[7]);
                record.longFuelTrimBank2 = this.fieldSetFlags()[8] ? this.longFuelTrimBank2 : (Float)this.defaultValue(this.fields()[8]);
                record.fuelPressure = this.fieldSetFlags()[9] ? this.fuelPressure : (Float)this.defaultValue(this.fields()[9]);
                record.intakeManiAbsPress = this.fieldSetFlags()[10] ? this.intakeManiAbsPress : (Float)this.defaultValue(this.fields()[10]);
                record.engineRpm = this.fieldSetFlags()[11] ? this.engineRpm : (Float)this.defaultValue(this.fields()[11]);
                record.vehicleSpeed = this.fieldSetFlags()[12] ? this.vehicleSpeed : (Float)this.defaultValue(this.fields()[12]);
                record.timingAdvance = this.fieldSetFlags()[13] ? this.timingAdvance : (Float)this.defaultValue(this.fields()[13]);
                record.intakeAirTemperature = this.fieldSetFlags()[14] ? this.intakeAirTemperature : (Float)this.defaultValue(this.fields()[14]);
                record.mafAirFlowRate = this.fieldSetFlags()[15] ? this.mafAirFlowRate : (Float)this.defaultValue(this.fields()[15]);
                record.throttlePosition = this.fieldSetFlags()[16] ? this.throttlePosition : (Float)this.defaultValue(this.fields()[16]);
                record.cmdSecAirStatus = this.fieldSetFlags()[17] ? this.cmdSecAirStatus : (Float)this.defaultValue(this.fields()[17]);
                record.oxySensor1Volt14 = this.fieldSetFlags()[18] ? this.oxySensor1Volt14 : (Float)this.defaultValue(this.fields()[18]);
                record.oxySensor1Stft = this.fieldSetFlags()[19] ? this.oxySensor1Stft : (Float)this.defaultValue(this.fields()[19]);
                record.oxySensor2Volt14 = this.fieldSetFlags()[20] ? this.oxySensor2Volt14 : (Float)this.defaultValue(this.fields()[20]);
                record.oxySensor2Stft = this.fieldSetFlags()[21] ? this.oxySensor2Stft : (Float)this.defaultValue(this.fields()[21]);
                record.oxySensor3Volt14 = this.fieldSetFlags()[22] ? this.oxySensor3Volt14 : (Float)this.defaultValue(this.fields()[22]);
                record.oxySensor3Stft = this.fieldSetFlags()[23] ? this.oxySensor3Stft : (Float)this.defaultValue(this.fields()[23]);
                record.oxySensor4Volt14 = this.fieldSetFlags()[24] ? this.oxySensor4Volt14 : (Float)this.defaultValue(this.fields()[24]);
                record.oxySensor4Stft = this.fieldSetFlags()[25] ? this.oxySensor4Stft : (Float)this.defaultValue(this.fields()[25]);
                record.oxySensor5Volt14 = this.fieldSetFlags()[26] ? this.oxySensor5Volt14 : (Float)this.defaultValue(this.fields()[26]);
                record.oxySensor5Stft = this.fieldSetFlags()[27] ? this.oxySensor5Stft : (Float)this.defaultValue(this.fields()[27]);
                record.oxySensor6Volt14 = this.fieldSetFlags()[28] ? this.oxySensor6Volt14 : (Float)this.defaultValue(this.fields()[28]);
                record.oxySensor6Stft = this.fieldSetFlags()[29] ? this.oxySensor6Stft : (Float)this.defaultValue(this.fields()[29]);
                record.oxySensor7Volt14 = this.fieldSetFlags()[30] ? this.oxySensor7Volt14 : (Float)this.defaultValue(this.fields()[30]);
                record.oxySensor7Stft = this.fieldSetFlags()[31] ? this.oxySensor7Stft : (Float)this.defaultValue(this.fields()[31]);
                record.oxySensor8Volt14 = this.fieldSetFlags()[32] ? this.oxySensor8Volt14 : (Float)this.defaultValue(this.fields()[32]);
                record.oxySensor8Stft = this.fieldSetFlags()[33] ? this.oxySensor8Stft : (Float)this.defaultValue(this.fields()[33]);
                record.timeSinceEngStart = this.fieldSetFlags()[34] ? this.timeSinceEngStart : (Float)this.defaultValue(this.fields()[34]);
                record.distanceMilOn = this.fieldSetFlags()[35] ? this.distanceMilOn : (Float)this.defaultValue(this.fields()[35]);
                record.fuelRailPres = this.fieldSetFlags()[36] ? this.fuelRailPres : (Float)this.defaultValue(this.fields()[36]);
                record.fuelRailGaug = this.fieldSetFlags()[37] ? this.fuelRailGaug : (Float)this.defaultValue(this.fields()[37]);
                record.oxySensor1Faer24 = this.fieldSetFlags()[38] ? this.oxySensor1Faer24 : (Float)this.defaultValue(this.fields()[38]);
                record.oxySensor1Volt24 = this.fieldSetFlags()[39] ? this.oxySensor1Volt24 : (Float)this.defaultValue(this.fields()[39]);
                record.oxySensor2Faer25 = this.fieldSetFlags()[40] ? this.oxySensor2Faer25 : (Float)this.defaultValue(this.fields()[40]);
                record.oxySensor2Volt25 = this.fieldSetFlags()[41] ? this.oxySensor2Volt25 : (Float)this.defaultValue(this.fields()[41]);
                record.oxySensor3Faer26 = this.fieldSetFlags()[42] ? this.oxySensor3Faer26 : (Float)this.defaultValue(this.fields()[42]);
                record.oxySensor3Volt26 = this.fieldSetFlags()[43] ? this.oxySensor3Volt26 : (Float)this.defaultValue(this.fields()[43]);
                record.oxySensor4Faer27 = this.fieldSetFlags()[44] ? this.oxySensor4Faer27 : (Float)this.defaultValue(this.fields()[44]);
                record.oxySensor4Volt27 = this.fieldSetFlags()[45] ? this.oxySensor4Volt27 : (Float)this.defaultValue(this.fields()[45]);
                record.oxySensor5Faer28 = this.fieldSetFlags()[46] ? this.oxySensor5Faer28 : (Float)this.defaultValue(this.fields()[46]);
                record.oxySensor5Volt28 = this.fieldSetFlags()[47] ? this.oxySensor5Volt28 : (Float)this.defaultValue(this.fields()[47]);
                record.oxySensor6Faer29 = this.fieldSetFlags()[48] ? this.oxySensor6Faer29 : (Float)this.defaultValue(this.fields()[48]);
                record.oxySensor6Volt29 = this.fieldSetFlags()[49] ? this.oxySensor6Volt29 : (Float)this.defaultValue(this.fields()[49]);
                record.oxySensor7Faer2A = this.fieldSetFlags()[50] ? this.oxySensor7Faer2A : (Float)this.defaultValue(this.fields()[50]);
                record.oxySensor7Volt2A = this.fieldSetFlags()[51] ? this.oxySensor7Volt2A : (Float)this.defaultValue(this.fields()[51]);
                record.oxySensor8Faer2B = this.fieldSetFlags()[52] ? this.oxySensor8Faer2B : (Float)this.defaultValue(this.fields()[52]);
                record.oxySensor8Volt2B = this.fieldSetFlags()[53] ? this.oxySensor8Volt2B : (Float)this.defaultValue(this.fields()[53]);
                record.cmdEgr = this.fieldSetFlags()[54] ? this.cmdEgr : (Float)this.defaultValue(this.fields()[54]);
                record.egrError = this.fieldSetFlags()[55] ? this.egrError : (Float)this.defaultValue(this.fields()[55]);
                record.cmdEvapPurge = this.fieldSetFlags()[56] ? this.cmdEvapPurge : (Float)this.defaultValue(this.fields()[56]);
                record.fuelTankLevel = this.fieldSetFlags()[57] ? this.fuelTankLevel : (Float)this.defaultValue(this.fields()[57]);
                record.warmUpsSinceCodeClear = this.fieldSetFlags()[58] ? this.warmUpsSinceCodeClear : (Float)this.defaultValue(this.fields()[58]);
                record.distanceSinceCodeClear = this.fieldSetFlags()[59] ? this.distanceSinceCodeClear : (Float)this.defaultValue(this.fields()[59]);
                record.evapSysVaporPres = this.fieldSetFlags()[60] ? this.evapSysVaporPres : (Float)this.defaultValue(this.fields()[60]);
                record.absBaroPres = this.fieldSetFlags()[61] ? this.absBaroPres : (Float)this.defaultValue(this.fields()[61]);
                record.oxySensor1Faer34 = this.fieldSetFlags()[62] ? this.oxySensor1Faer34 : (Float)this.defaultValue(this.fields()[62]);
                record.oxySensor1Crnt = this.fieldSetFlags()[63] ? this.oxySensor1Crnt : (Float)this.defaultValue(this.fields()[63]);
                record.oxySensor2Faer35 = this.fieldSetFlags()[64] ? this.oxySensor2Faer35 : (Float)this.defaultValue(this.fields()[64]);
                record.oxySensor2Crnt = this.fieldSetFlags()[65] ? this.oxySensor2Crnt : (Float)this.defaultValue(this.fields()[65]);
                record.oxySensor3Faer36 = this.fieldSetFlags()[66] ? this.oxySensor3Faer36 : (Float)this.defaultValue(this.fields()[66]);
                record.oxySensor3Crnt = this.fieldSetFlags()[67] ? this.oxySensor3Crnt : (Float)this.defaultValue(this.fields()[67]);
                record.oxySensor4Faer37 = this.fieldSetFlags()[68] ? this.oxySensor4Faer37 : (Float)this.defaultValue(this.fields()[68]);
                record.oxySensor4Crnt = this.fieldSetFlags()[69] ? this.oxySensor4Crnt : (Float)this.defaultValue(this.fields()[69]);
                record.oxySensor5Faer38 = this.fieldSetFlags()[70] ? this.oxySensor5Faer38 : (Float)this.defaultValue(this.fields()[70]);
                record.oxySensor5Crnt = this.fieldSetFlags()[71] ? this.oxySensor5Crnt : (Float)this.defaultValue(this.fields()[71]);
                record.oxySensor6Faer39 = this.fieldSetFlags()[72] ? this.oxySensor6Faer39 : (Float)this.defaultValue(this.fields()[72]);
                record.oxySensor6Crnt = this.fieldSetFlags()[73] ? this.oxySensor6Crnt : (Float)this.defaultValue(this.fields()[73]);
                record.oxySensor7Faer3A = this.fieldSetFlags()[74] ? this.oxySensor7Faer3A : (Float)this.defaultValue(this.fields()[74]);
                record.oxySensor7Crnt = this.fieldSetFlags()[75] ? this.oxySensor7Crnt : (Float)this.defaultValue(this.fields()[75]);
                record.oxySensor8Faer3B = this.fieldSetFlags()[76] ? this.oxySensor8Faer3B : (Float)this.defaultValue(this.fields()[76]);
                record.oxySensor8Crnt = this.fieldSetFlags()[77] ? this.oxySensor8Crnt : (Float)this.defaultValue(this.fields()[77]);
                record.catTempBank1Sens1 = this.fieldSetFlags()[78] ? this.catTempBank1Sens1 : (Float)this.defaultValue(this.fields()[78]);
                record.catTempBank2Sens1 = this.fieldSetFlags()[79] ? this.catTempBank2Sens1 : (Float)this.defaultValue(this.fields()[79]);
                record.catTempBank1Sens2 = this.fieldSetFlags()[80] ? this.catTempBank1Sens2 : (Float)this.defaultValue(this.fields()[80]);
                record.catTempBank2Sens2 = this.fieldSetFlags()[81] ? this.catTempBank2Sens2 : (Float)this.defaultValue(this.fields()[81]);
                record.monStatusDriveCycle = this.fieldSetFlags()[82] ? this.monStatusDriveCycle : (Float)this.defaultValue(this.fields()[82]);
                record.controlModuleVolt = this.fieldSetFlags()[83] ? this.controlModuleVolt : (Float)this.defaultValue(this.fields()[83]);
                record.absLoadValue = this.fieldSetFlags()[84] ? this.absLoadValue : (Float)this.defaultValue(this.fields()[84]);
                record.fuelAirCmdEquiv = this.fieldSetFlags()[85] ? this.fuelAirCmdEquiv : (Float)this.defaultValue(this.fields()[85]);
                record.relThrottlePos = this.fieldSetFlags()[86] ? this.relThrottlePos : (Float)this.defaultValue(this.fields()[86]);
                record.ambientAirTemp = this.fieldSetFlags()[87] ? this.ambientAirTemp : (Float)this.defaultValue(this.fields()[87]);
                record.absThrottlePosB = this.fieldSetFlags()[88] ? this.absThrottlePosB : (Float)this.defaultValue(this.fields()[88]);
                record.absThrottlePosC = this.fieldSetFlags()[89] ? this.absThrottlePosC : (Float)this.defaultValue(this.fields()[89]);
                record.absThrottlePosCd = this.fieldSetFlags()[90] ? this.absThrottlePosCd : (Float)this.defaultValue(this.fields()[90]);
                record.absThrottlePosE = this.fieldSetFlags()[91] ? this.absThrottlePosE : (Float)this.defaultValue(this.fields()[91]);
                record.absThrottlePosF = this.fieldSetFlags()[92] ? this.absThrottlePosF : (Float)this.defaultValue(this.fields()[92]);
                record.cmdThrottleAct = this.fieldSetFlags()[93] ? this.cmdThrottleAct : (Float)this.defaultValue(this.fields()[93]);
                record.timeRunMilOn = this.fieldSetFlags()[94] ? this.timeRunMilOn : (Float)this.defaultValue(this.fields()[94]);
                record.timeSinceCodeClear = this.fieldSetFlags()[95] ? this.timeSinceCodeClear : (Float)this.defaultValue(this.fields()[95]);
                record.maxFaer = this.fieldSetFlags()[96] ? this.maxFaer : (Float)this.defaultValue(this.fields()[96]);
                record.maxOxySensVol = this.fieldSetFlags()[97] ? this.maxOxySensVol : (Float)this.defaultValue(this.fields()[97]);
                record.maxOxySensCrnt = this.fieldSetFlags()[98] ? this.maxOxySensCrnt : (Float)this.defaultValue(this.fields()[98]);
                record.maxIntManiAbsPres = this.fieldSetFlags()[99] ? this.maxIntManiAbsPres : (Float)this.defaultValue(this.fields()[99]);
                record.maxAirFlowMaf = this.fieldSetFlags()[100] ? this.maxAirFlowMaf : (Float)this.defaultValue(this.fields()[100]);
                record.fuelType = this.fieldSetFlags()[101] ? this.fuelType : (Float)this.defaultValue(this.fields()[101]);
                record.ethanolFuelPct = this.fieldSetFlags()[102] ? this.ethanolFuelPct : (Float)this.defaultValue(this.fields()[102]);
                record.absEvapSysVapPres = this.fieldSetFlags()[103] ? this.absEvapSysVapPres : (Float)this.defaultValue(this.fields()[103]);
                record.evapSysVapPres = this.fieldSetFlags()[104] ? this.evapSysVapPres : (Float)this.defaultValue(this.fields()[104]);
                record.shortSecOxyTrimBank1 = this.fieldSetFlags()[105] ? this.shortSecOxyTrimBank1 : (Float)this.defaultValue(this.fields()[105]);
                record.shortSecOxyTrimBank3 = this.fieldSetFlags()[106] ? this.shortSecOxyTrimBank3 : (Float)this.defaultValue(this.fields()[106]);
                record.longSecOxyTrimBank1 = this.fieldSetFlags()[107] ? this.longSecOxyTrimBank1 : (Float)this.defaultValue(this.fields()[107]);
                record.longSecOxyTrimBank3 = this.fieldSetFlags()[108] ? this.longSecOxyTrimBank3 : (Float)this.defaultValue(this.fields()[108]);
                record.shortSecOxyTrimBank2 = this.fieldSetFlags()[109] ? this.shortSecOxyTrimBank2 : (Float)this.defaultValue(this.fields()[109]);
                record.shortSecOxyTrimBank4 = this.fieldSetFlags()[110] ? this.shortSecOxyTrimBank4 : (Float)this.defaultValue(this.fields()[110]);
                record.longSecOxyTrimBank2 = this.fieldSetFlags()[111] ? this.longSecOxyTrimBank2 : (Float)this.defaultValue(this.fields()[111]);
                record.longSecOxyTrimBank4 = this.fieldSetFlags()[112] ? this.longSecOxyTrimBank4 : (Float)this.defaultValue(this.fields()[112]);
                record.fuelRailAbsPres = this.fieldSetFlags()[113] ? this.fuelRailAbsPres : (Float)this.defaultValue(this.fields()[113]);
                record.relAccelPedalPos = this.fieldSetFlags()[114] ? this.relAccelPedalPos : (Float)this.defaultValue(this.fields()[114]);
                record.hybrBatPackRemLife = this.fieldSetFlags()[115] ? this.hybrBatPackRemLife : (Float)this.defaultValue(this.fields()[115]);
                record.engineOilTemp = this.fieldSetFlags()[116] ? this.engineOilTemp : (Float)this.defaultValue(this.fields()[116]);
                record.fuelInjectionTiming = this.fieldSetFlags()[117] ? this.fuelInjectionTiming : (Float)this.defaultValue(this.fields()[117]);
                record.engineFuelRate = this.fieldSetFlags()[118] ? this.engineFuelRate : (Float)this.defaultValue(this.fields()[118]);
                record.emissionReq = this.fieldSetFlags()[119] ? this.emissionReq : (Float)this.defaultValue(this.fields()[119]);
                record.demandEngTorqPct = this.fieldSetFlags()[120] ? this.demandEngTorqPct : (Float)this.defaultValue(this.fields()[120]);
                record.actualEngTorqPct = this.fieldSetFlags()[121] ? this.actualEngTorqPct : (Float)this.defaultValue(this.fields()[121]);
                record.engRefTorq = this.fieldSetFlags()[122] ? this.engRefTorq : (Float)this.defaultValue(this.fields()[122]);
                record.engPctTorqIdle = this.fieldSetFlags()[123] ? this.engPctTorqIdle : (Float)this.defaultValue(this.fields()[123]);
                record.engPctTorqEp1 = this.fieldSetFlags()[124] ? this.engPctTorqEp1 : (Float)this.defaultValue(this.fields()[124]);
                record.engPctTorqEp2 = this.fieldSetFlags()[125] ? this.engPctTorqEp2 : (Float)this.defaultValue(this.fields()[125]);
                record.engPctTorqEp3 = this.fieldSetFlags()[126] ? this.engPctTorqEp3 : (Float)this.defaultValue(this.fields()[126]);
                record.engPctTorqEp4 = this.fieldSetFlags()[127] ? this.engPctTorqEp4 : (Float)this.defaultValue(this.fields()[127]);
                record.auxInputOutput = this.fieldSetFlags()[128] ? this.auxInputOutput : (Float)this.defaultValue(this.fields()[128]);
                record.mafSensor = this.fieldSetFlags()[129] ? this.mafSensor : (Float)this.defaultValue(this.fields()[129]);
                record.engineCoolantTemp67 = this.fieldSetFlags()[130] ? this.engineCoolantTemp67 : (Float)this.defaultValue(this.fields()[130]);
                record.intakeAirTempSens = this.fieldSetFlags()[131] ? this.intakeAirTempSens : (Float)this.defaultValue(this.fields()[131]);
                record.engineFrictionPercentTorque = this.fieldSetFlags()[132] ? this.engineFrictionPercentTorque : (Float)this.defaultValue(this.fields()[132]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

